"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_java_cdk_infrastructure_base_project_1 = require("./generated-java-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedJavaCdkInfrastructureProject extends generated_java_cdk_infrastructure_base_project_1.GeneratedJavaCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
        this.buildGenerateMockDataCommand = () => {
            return (0, utils_1.buildInvokeMockDataGeneratorCommand)({
                specPath: this.options.specPath,
                // Write the mocks to the resources directory
                outputSubDir: "src/main/resources",
                ...this.options.mockDataOptions,
            });
        };
        this.options = options;
        if (!this.options.mockDataOptions?.disable) {
            this.generateTask.exec(this.buildGenerateMockDataCommand());
        }
        this.openapiGeneratorIgnore.addPatterns(`!${this.srcDir}/MockIntegrations.java`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.JAVA_CDK_INFRASTRUCTURE,
            srcDir: this.srcDir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-infrastructure-package": this.packageName,
                "x-runtime-package": this.options.generatedJavaTypes.packageName,
                // Enable mock integration generation by default
                "x-enable-mock-integrations": !this.options.mockDataOptions?.disable,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaCdkInfrastructureProject = GeneratedJavaCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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