"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_python_cdk_infrastructure_base_project_1 = require("./generated-python-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedPythonCdkInfrastructureProject extends generated_python_cdk_infrastructure_base_project_1.GeneratedPythonCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
        this.buildGenerateMockDataCommand = () => {
            return (0, utils_1.buildInvokeMockDataGeneratorCommand)({
                specPath: this.options.specPath,
                ...this.options.mockDataOptions,
            });
        };
        this.options = options;
        if (!this.options.mockDataOptions?.disable) {
            this.generateTask.exec(this.buildGenerateMockDataCommand());
        }
        this.openapiGeneratorIgnore.addPatterns(`!${this.moduleName}/mock_integrations.py`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python-nextgen",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.PYTHON_CDK_INFRASTRUCTURE,
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-module-name": this.options.generatedPythonTypes.moduleName,
                // Spec path relative to the source directory
                "x-relative-spec-path": path.join("..", this.options.specPath),
                // Enable mock integration generation by default
                "x-enable-mock-integrations": !this.options.mockDataOptions?.disable,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedPythonCdkInfrastructureProject = GeneratedPythonCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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