"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptAsyncCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_typescript_cdk_infrastructure_base_project_1 = require("./generated-typescript-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedTypescriptAsyncCdkInfrastructureProject extends generated_typescript_cdk_infrastructure_base_project_1.GeneratedTypescriptCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.TYPESCRIPT_ASYNC_CDK_INFRASTRUCTURE,
            srcDir: this.srcdir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-package-name": this.options.generatedTypescriptTypes.package.packageName,
                // Spec path relative to the source directory
                "x-relative-spec-path": path.join("..", this.packagedSpecPath),
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedTypescriptAsyncCdkInfrastructureProject = GeneratedTypescriptAsyncCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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