import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedWithOpenApiGeneratorOptions } from "../../types";
import { OpenApiGeneratorIgnoreFile } from "../components/open-api-generator-ignore-file";
import { GenerationOptions } from "../components/utils";
/**
 * Configuration for a generated typescript library
 */
export interface GeneratedTypescriptLibraryProjectOptions extends TypeScriptProjectOptions, GeneratedWithOpenApiGeneratorOptions, CodeGenerationSourceOptions {
    /**
     * Whether this project is parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
/**
 * Typescript generated library project
 */
export declare abstract class GeneratedTypescriptLibraryProject extends TypeScriptProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedTypescriptLibraryProjectOptions;
    protected readonly openapiGeneratorIgnore: OpenApiGeneratorIgnoreFile;
    constructor(options: GeneratedTypescriptLibraryProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
