"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptReactQueryHooksLibrary = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const javascript_1 = require("projen/lib/javascript");
const generated_typescript_library_project_1 = require("./generated-typescript-library-project");
const languages_1 = require("../../languages");
const open_api_generator_handlebars_ignore_file_1 = require("../components/open-api-generator-handlebars-ignore-file");
/**
 * Typescript project containing generated react-query hooks
 */
class TypescriptReactQueryHooksLibrary extends generated_typescript_library_project_1.GeneratedTypescriptLibraryProject {
    constructor(options) {
        super({
            ...options,
            tsconfig: options.tsconfig ?? {
                compilerOptions: {
                    jsx: javascript_1.TypeScriptJsxMode.REACT,
                },
            },
        });
        // Add dependencies on react-query and react
        this.addDeps("@tanstack/react-query@^4"); // Pin at 4 for now - requires generated code updates to upgrade to 5
        this.addDevDeps("react", "@types/react");
        this.addPeerDeps("react");
        // Ignore the hooks, since they're generated with the handlebars templating engine
        const hooksPattern = "**/*Hooks.ts";
        this.openapiGeneratorIgnore.addPatterns(hooksPattern);
        // The hooks are generated using the handlebars templating engine, so we include a handlebars ignore file
        const handlebarsIgnore = new open_api_generator_handlebars_ignore_file_1.OpenApiGeneratorHandlebarsIgnoreFile(this);
        handlebarsIgnore.addPatterns(`!${hooksPattern}`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            generatorDirectory: languages_1.Library.TYPESCRIPT_REACT_QUERY_HOOKS,
            additionalProperties: {
                npmName: this.package.packageName,
                typescriptThreePlus: "true",
                useSingleParameter: "true",
                supportsES6: "true",
            },
            srcDir: this.srcdir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
        };
    }
}
exports.TypescriptReactQueryHooksLibrary = TypescriptReactQueryHooksLibrary;
//# sourceMappingURL=data:application/json;base64,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