"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptWebsocketHooksLibrary = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const javascript_1 = require("projen/lib/javascript");
const generated_typescript_library_project_1 = require("./generated-typescript-library-project");
const languages_1 = require("../../languages");
const open_api_generator_ignore_file_1 = require("../components/open-api-generator-ignore-file");
/**
 * Typescript project containing generated websocket hooks
 */
class TypescriptWebsocketHooksLibrary extends generated_typescript_library_project_1.GeneratedTypescriptLibraryProject {
    constructor(options) {
        super({
            ...options,
            tsconfig: options.tsconfig ?? {
                compilerOptions: {
                    jsx: javascript_1.TypeScriptJsxMode.REACT,
                },
            },
        });
        this.options = options;
        this.addDevDeps("react", "@types/react");
        this.addPeerDeps("react");
        this.openapiGeneratorIgnore.addPatterns(
        // Ignore all but relevant hooks files
        ...open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile.ALL_FILES_PATTERNS, `!${this.srcdir}/index.ts`, `!${this.srcdir}/hooks/*`, `!${this.srcdir}/hooks/**/*`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            generatorDirectory: languages_1.WebSocketLibrary.TYPESCRIPT_WEBSOCKET_HOOKS,
            additionalProperties: {
                npmName: this.package.packageName,
                typescriptThreePlus: "true",
                useSingleParameter: "true",
                supportsES6: "true",
            },
            srcDir: this.srcdir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-websocket-client-package-name": this.options.clientPackageName,
            },
        };
    }
}
exports.TypescriptWebsocketHooksLibrary = TypescriptWebsocketHooksLibrary;
//# sourceMappingURL=data:application/json;base64,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