"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_java_runtime_base_project_1 = require("./generated-java-runtime-base-project");
const languages_1 = require("../../languages");
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
class GeneratedJavaRuntimeProject extends generated_java_runtime_base_project_1.GeneratedJavaRuntimeBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: languages_1.Language.JAVA,
            additionalProperties: {
                useSingleRequestParameter: "true",
                groupId: this.pom.groupId,
                artifactId: this.pom.artifactId,
                artifactVersion: this.pom.version,
                invokerPackage: this.packageName,
                apiPackage: `${this.packageName}.api`,
                modelPackage: `${this.packageName}.model`,
                hideGenerationTimestamp: "true",
                additionalModelTypeAnnotations: [
                    "@lombok.AllArgsConstructor",
                    // Regular lombok builder is not used since an abstract base schema class is also annotated
                    "@lombok.experimental.SuperBuilder",
                ].join("\\ "),
            },
            srcDir: path.join("src", "main", "java", ...this.packageName.split(".")),
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaRuntimeProject = GeneratedJavaRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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