"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptAsyncRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_typescript_runtime_base_project_1 = require("./generated-typescript-runtime-base-project");
const utils_1 = require("../components/utils");
/**
 * Typescript project containing types generated using OpenAPI Generator CLI
 */
class GeneratedTypescriptAsyncRuntimeProject extends generated_typescript_runtime_base_project_1.GeneratedTypescriptRuntimeBaseProject {
    constructor(options) {
        super(options);
        this.addDeps("@aws-sdk/client-apigatewaymanagementapi");
        this.openapiGeneratorIgnore.addPatterns(
        // Skip generating http clients
        `${this.srcdir}/apis/**/*`, `${this.srcdir}/apis/*`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "typescript-fetch",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.TYPESCRIPT_ASYNC_RUNTIME,
            additionalProperties: {
                npmName: this.package.packageName,
                typescriptThreePlus: "true",
                useSingleParameter: "true",
                supportsES6: "true",
            },
            srcDir: this.srcdir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
        };
    }
}
exports.GeneratedTypescriptAsyncRuntimeProject = GeneratedTypescriptAsyncRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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