import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedWithOpenApiGeneratorOptions } from "../../types";
import { OpenApiGeneratorIgnoreFile } from "../components/open-api-generator-ignore-file";
import { GenerationOptions } from "../components/utils";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptRuntimeBaseProjectOptions extends TypeScriptProjectOptions, GeneratedWithOpenApiGeneratorOptions, CodeGenerationSourceOptions {
    /**
     * Whether this project is parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
/**
 * Typescript project containing types generated using OpenAPI Generator CLI
 */
export declare abstract class GeneratedTypescriptRuntimeBaseProject extends TypeScriptProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedTypescriptRuntimeBaseProjectOptions;
    protected readonly openapiGeneratorIgnore: OpenApiGeneratorIgnoreFile;
    constructor(options: GeneratedTypescriptRuntimeBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
