"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketDocumentationFormat = exports.DocumentationFormat = exports.WebSocketLibrary = exports.Library = exports.PythonVersion = exports.JavaVersion = exports.NodeVersion = exports.Language = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for runtimes and infrastructure
 */
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["JAVA"] = "java";
})(Language || (exports.Language = Language = {}));
/**
 * Versions of node
 */
var NodeVersion;
(function (NodeVersion) {
    NodeVersion["NODE_18"] = "NODE_18";
    NodeVersion["NODE_20"] = "NODE_20";
})(NodeVersion || (exports.NodeVersion = NodeVersion = {}));
/**
 * Versions of java
 */
var JavaVersion;
(function (JavaVersion) {
    JavaVersion["JAVA_8"] = "JAVA_8";
    JavaVersion["JAVA_11"] = "JAVA_11";
    JavaVersion["JAVA_17"] = "JAVA_17";
    JavaVersion["JAVA_21"] = "JAVA_21";
})(JavaVersion || (exports.JavaVersion = JavaVersion = {}));
/**
 * Versions of python
 */
var PythonVersion;
(function (PythonVersion) {
    PythonVersion["PYTHON_3_11"] = "PYTHON_3_11";
    PythonVersion["PYTHON_3_12"] = "PYTHON_3_12";
})(PythonVersion || (exports.PythonVersion = PythonVersion = {}));
/**
 * Supported libraries for code generation
 */
var Library;
(function (Library) {
    Library["TYPESCRIPT_REACT_QUERY_HOOKS"] = "typescript-react-query-hooks";
})(Library || (exports.Library = Library = {}));
var WebSocketLibrary;
(function (WebSocketLibrary) {
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_CLIENT"] = "typescript-websocket-client";
    WebSocketLibrary["TYPESCRIPT_WEBSOCKET_HOOKS"] = "typescript-websocket-hooks";
})(WebSocketLibrary || (exports.WebSocketLibrary = WebSocketLibrary = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * OpenAPI Generator 'html2' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md
     */
    DocumentationFormat["HTML2"] = "html2";
    /**
     * OpenAPI Generator 'markdown' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * OpenAPI Generator 'plantuml' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat || (exports.DocumentationFormat = DocumentationFormat = {}));
/**
 * Formats for WebSocket documentation generation
 */
var WebSocketDocumentationFormat;
(function (WebSocketDocumentationFormat) {
    /**
     * HTML Documentation generated by AsyncAPI's HTML Template
     * @see https://github.com/asyncapi/html-template
     */
    WebSocketDocumentationFormat["HTML"] = "html_asyncapi";
    /**
     * Markdown Documentation generated by AsyncAPI's Markdown Template
     * @see https://github.com/asyncapi/markdown-template
     */
    WebSocketDocumentationFormat["MARKDOWN"] = "markdown_asyncapi";
})(WebSocketDocumentationFormat || (exports.WebSocketDocumentationFormat = WebSocketDocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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