"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiAsyncDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_project_definition_1 = require("./open-api-project-definition");
/**
 * The OpenAPI Spec
 */
class OpenApiAsyncDefinition extends open_api_project_definition_1.OpenApiProjectDefinition {
    constructor(project, options) {
        super(project, options);
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create a sample OpenAPI spec yaml if not defined
        new projen_1.SampleFile(project, this.openApiSpecificationPath, {
            contents: `openapi: 3.0.3
info:
  version: 1.0.0
  title: ${options.openApiOptions.title}
paths:
  /SubscribeToNotifications:
    post:
      operationId: subscribeToNotifications${firstHandlerLanguage
                ? `
      x-handler:
        language: ${firstHandlerLanguage}`
                : ""}
      x-async:
        direction: client_to_server
        collection: notifications
      requestBody:
        content:
          application/json:
            schema:
              $ref: '#/components/schemas/SubscribeToNotificationsRequestContent'
      responses:
        200:
          description: Successful response
  /SendNotification:
    post:
      operationId: sendNotification${firstHandlerLanguage
                ? `
      x-handler:
        language: ${firstHandlerLanguage}`
                : ""}
      x-async:
        direction: server_to_client
        collection: notifications
      requestBody:
        content:
          application/json:
            schema:
              $ref: '#/components/schemas/SendNotificationRequestContent'
      responses:
        200:
          description: Successful response
components:
  schemas:
    SubscribeToNotificationsRequestContent:
      type: object
      properties:
        topic:
          type: string
      required:
        - topic
    SendNotificationRequestContent:
      type: object
      properties:
        topic:
          type: string
        title:
          type: string
        message:
          type: string
      required:
        - topic
        - title
        - message
`,
        });
    }
}
exports.OpenApiAsyncDefinition = OpenApiAsyncDefinition;
_a = JSII_RTTI_SYMBOL_1;
OpenApiAsyncDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiAsyncDefinition", version: "0.23.39" };
//# sourceMappingURL=data:application/json;base64,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