"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SampleExecutable = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * A sample file that is executable
 */
class SampleExecutable extends projen_1.SampleFile {
    constructor(project, filePath, options) {
        super(project, filePath, options);
        this.fullFilePath = path.join(this.project.outdir, filePath);
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        if (fs.existsSync(this.fullFilePath)) {
            return;
        }
        super.synthesize();
        fs.chmodSync(this.fullFilePath, (0, util_1.getFilePermissions)({
            executable: true,
            readonly: false,
        }));
    }
}
exports.SampleExecutable = SampleExecutable;
//# sourceMappingURL=data:application/json;base64,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