"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const smithy_sample_code_1 = require("./components/smithy-sample-code");
const smithy_project_definition_1 = require("./smithy-project-definition");
/**
 * Creates a project which transforms a Smithy model to OpenAPI
 */
class SmithyDefinition extends smithy_project_definition_1.SmithyProjectDefinition {
    constructor(project, options) {
        super(project, options);
        const { namespace: serviceNamespace, serviceName } = options.smithyOptions.serviceName;
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create the default smithy model
        new smithy_sample_code_1.SmithySampleCode(project, {
            modelDir: this.modelDir,
            serviceName,
            serviceNamespace,
            firstHandlerLanguage,
        });
    }
}
exports.SmithyDefinition = SmithyDefinition;
_a = JSII_RTTI_SYMBOL_1;
SmithyDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.SmithyDefinition", version: "0.23.39" };
//# sourceMappingURL=data:application/json;base64,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