"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeSafeApiModelProjectBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../codegen/components/type-safe-api-command-environment");
const utils_1 = require("../codegen/components/utils");
const types_1 = require("../types");
class TypeSafeApiModelProjectBase extends projen_1.Project {
    constructor(options) {
        super(options);
        /**
         * Name of the final bundled OpenAPI specification
         */
        this.parsedSpecFile = ".api.json";
        this.addApiDefinition = ({ modelLanguage, modelOptions, handlerLanguages, }) => {
            if (modelLanguage === types_1.ModelLanguage.SMITHY) {
                if (!modelOptions.smithy) {
                    throw new Error(`modelOptions.smithy is required when selected model language is ${types_1.ModelLanguage.SMITHY}`);
                }
                const smithyOptions = modelOptions.smithy;
                const smithy = this.addSmithyApiDefinition(smithyOptions, handlerLanguages);
                return {
                    specPath: smithy.openApiSpecificationPath,
                    smithyJsonModelPath: smithy.smithyJsonModelPath,
                };
            }
            else if (modelLanguage === types_1.ModelLanguage.OPENAPI) {
                if (!modelOptions.openapi) {
                    throw new Error(`modelOptions.openapi is required when selected model language is ${types_1.ModelLanguage.OPENAPI}`);
                }
                const openApiOptions = modelOptions.openapi;
                const openapi = this.addOpenApiDefinition(openApiOptions, handlerLanguages);
                return { specPath: openapi.openApiSpecificationPath };
            }
            else {
                throw new Error(`Unknown model language ${modelLanguage}`);
            }
        };
        this.addParseAndBundleTask = (openApiSpecificationPath, smithyJsonModelPath) => {
            this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.PARSE_OPENAPI_SPEC, `--spec-path ${openApiSpecificationPath} --output-path ${this.parsedSpecFile}${smithyJsonModelPath
                ? ` --smithy-json-path ${smithyJsonModelPath}`
                : ""}`));
            this.addGitIgnore(this.parsedSpecFile);
        };
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        // Add the API definition
        const { specPath, smithyJsonModelPath } = this.addApiDefinition(options);
        this.apiName =
            options.modelOptions.smithy?.serviceName.serviceName ??
                options.modelOptions.openapi?.title;
        // Parse and bundle the openapi specification
        this.addParseAndBundleTask(specPath, smithyJsonModelPath);
        // Run the generate task as part of build
        this.compileTask.spawn(this.generateTask);
    }
}
exports.TypeSafeApiModelProjectBase = TypeSafeApiModelProjectBase;
_a = JSII_RTTI_SYMBOL_1;
TypeSafeApiModelProjectBase[_a] = { fqn: "@aws/pdk.type_safe_api.TypeSafeApiModelProjectBase", version: "0.23.39" };
//# sourceMappingURL=data:application/json;base64,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