import * as apigateway from 'aws-cdk-lib/aws-apigateway';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as logs from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { SecretKey } from './secret-key';
export interface RecaptchaAuthorizerProps {
    /**
     * The minimum score threshold to allow by this authorizer
     *
     * @default 0.5
     */
    readonly scoreThreshold?: number;
    /**
     * The actions to be allowed by this authorizer
     */
    readonly allowedActions: string[];
    /**
     * The reCaptcha API secret key
     */
    readonly reCaptchaSecretKey: SecretKey;
    /**
     * The number of days log events are kept in CloudWatch Logs. When updating this property, unsetting it doesn't
     * remove the log retention policy. To remove the retention policy, set the value to `INFINITE`.
     *
     * @default logs.RetentionDays.INFINITE
     */
    readonly logRetention?: logs.RetentionDays;
    /**
     * Enable AWS X-Ray Tracing for Lambda Function.
     *
     * @default Tracing.Disabled
     */
    readonly tracing?: lambda.Tracing;
}
/**
 * Request-based lambda authorizer that authorizes requests using Google's reCaptcha API
 *
 * @resource AWS::ApiGateway::Authorizer
 */
export declare class RecaptchaAuthorizer extends apigateway.Authorizer implements apigateway.IAuthorizer {
    private authorizer;
    /**
     * The authorization type of this authorizer.
     */
    readonly authorizationType?: apigateway.AuthorizationType;
    constructor(scope: Construct, id: string, props: RecaptchaAuthorizerProps);
    /**
     * The authorizer ID.
     * @attribute
     */
    get authorizerId(): string;
    /**
     * Attaches this authorizer to a specific REST API.
     * @internal
     * @returns {void}
     * @param {RestApi} restApi the rest API to attach this authorizer to
     */
    _attachToApi(restApi: apigateway.RestApi): void;
}
