"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecaptchaAuthorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigateway = require("aws-cdk-lib/aws-apigateway");
const lambdaNodeJS = require("aws-cdk-lib/aws-lambda-nodejs");
const MIN_SCORE_THRESHOLD = 0.0;
const MAX_SCORE_THRESHOLD = 1.0;
const DEFAULT_SCORE_THRESHOLD = 0.5;
/**
 * Request-based lambda authorizer that authorizes requests using Google's reCaptcha API
 *
 * @resource AWS::ApiGateway::Authorizer
 */
class RecaptchaAuthorizer extends apigateway.Authorizer {
    constructor(scope, id, props) {
        super(scope, id);
        const scoreThreshold = props.scoreThreshold ?? DEFAULT_SCORE_THRESHOLD;
        if (scoreThreshold < MIN_SCORE_THRESHOLD || scoreThreshold > MAX_SCORE_THRESHOLD) {
            throw new Error('scoreThreshold must be between 0.0 and 1.0');
        }
        const handler = new lambdaNodeJS.NodejsFunction(this, 'function', {
            bundling: {
                minify: true
            },
            environment: {
                ALLOWED_ACTIONS: JSON.stringify(props.allowedActions),
                SCORE_THRESHOLD: scoreThreshold.toString(),
                SECRET_KEY_TYPE: props.reCaptchaSecretKey.secretKeyType,
                ...props.reCaptchaSecretKey.environment
            },
            logRetention: props.logRetention,
            tracing: props.tracing
        });
        if (props.reCaptchaSecretKey.grantRead) {
            props.reCaptchaSecretKey.grantRead(handler);
        }
        this.authorizer = new apigateway.RequestAuthorizer(this, 'Authorizer', {
            handler,
            identitySources: [apigateway.IdentitySource.header('X-reCAPTCHA-Token')]
        });
        this.authorizationType = this.authorizer.authorizationType;
    }
    /**
     * The authorizer ID.
     * @attribute
     */
    get authorizerId() {
        return this.authorizer.authorizerId;
    }
    /**
     * Attaches this authorizer to a specific REST API.
     * @internal
     * @returns {void}
     * @param {RestApi} restApi the rest API to attach this authorizer to
     */
    _attachToApi(restApi) {
        // eslint-disable-next-line @typescript-eslint/ban-ts-comment
        // @ts-ignore
        // eslint-disable-next-line no-underscore-dangle
        this.authorizer._attachToApi(restApi);
    }
}
exports.RecaptchaAuthorizer = RecaptchaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
RecaptchaAuthorizer[_a] = { fqn: "cdk-recaptcha-authorizer.RecaptchaAuthorizer", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVjYXB0Y2hhLWF1dGhvcml6ZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZWNhcHRjaGEtYXV0aG9yaXplci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHlEQUF5RDtBQUV6RCw4REFBOEQ7QUF5QzlELE1BQU0sbUJBQW1CLEdBQUcsR0FBRyxDQUFDO0FBQ2hDLE1BQU0sbUJBQW1CLEdBQUcsR0FBRyxDQUFDO0FBQ2hDLE1BQU0sdUJBQXVCLEdBQUcsR0FBRyxDQUFDO0FBRXBDOzs7O0dBSUc7QUFDSCxNQUFhLG1CQUFvQixTQUFRLFVBQVUsQ0FBQyxVQUFVO0lBUzFELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDckUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxJQUFJLHVCQUF1QixDQUFDO1FBRXZFLElBQUksY0FBYyxHQUFHLG1CQUFtQixJQUFJLGNBQWMsR0FBRyxtQkFBbUIsRUFBRTtZQUM5RSxNQUFNLElBQUksS0FBSyxDQUFDLDRDQUE0QyxDQUFDLENBQUM7U0FDakU7UUFFRCxNQUFNLE9BQU8sR0FBRyxJQUFJLFlBQVksQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM5RCxRQUFRLEVBQUU7Z0JBQ04sTUFBTSxFQUFFLElBQUk7YUFDZjtZQUNELFdBQVcsRUFBRTtnQkFDVCxlQUFlLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO2dCQUNyRCxlQUFlLEVBQUUsY0FBYyxDQUFDLFFBQVEsRUFBRTtnQkFDMUMsZUFBZSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhO2dCQUN2RCxHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXO2FBQzFDO1lBQ0QsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztTQUN6QixDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLEVBQUU7WUFDcEMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQztTQUMvQztRQUVELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxVQUFVLENBQUMsaUJBQWlCLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtZQUNuRSxPQUFPO1lBQ1AsZUFBZSxFQUFFLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQyxNQUFNLENBQUMsbUJBQW1CLENBQUMsQ0FBQztTQUMzRSxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztJQUMvRCxDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsSUFBSSxZQUFZO1FBQ1osT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxZQUFZLENBQUMsT0FBMkI7UUFDM0MsNkRBQTZEO1FBQzdELGFBQWE7UUFDYixnREFBZ0Q7UUFDaEQsSUFBSSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDMUMsQ0FBQzs7QUE5REwsa0RBZ0VDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXBpZ2F0ZXdheSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBsYW1iZGFOb2RlSlMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYS1ub2RlanMnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbG9ncyc7XG5pbXBvcnQge0NvbnN0cnVjdH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQge1NlY3JldEtleX0gZnJvbSAnLi9zZWNyZXQta2V5JztcblxuZXhwb3J0IGludGVyZmFjZSBSZWNhcHRjaGFBdXRob3JpemVyUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogVGhlIG1pbmltdW0gc2NvcmUgdGhyZXNob2xkIHRvIGFsbG93IGJ5IHRoaXMgYXV0aG9yaXplclxuICAgICAqXG4gICAgICogQGRlZmF1bHQgMC41XG4gICAgICovXG4gICAgcmVhZG9ubHkgc2NvcmVUaHJlc2hvbGQ/OiBudW1iZXJcblxuICAgIC8qKlxuICAgICAqIFRoZSBhY3Rpb25zIHRvIGJlIGFsbG93ZWQgYnkgdGhpcyBhdXRob3JpemVyXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWxsb3dlZEFjdGlvbnM6IHN0cmluZ1tdXG5cbiAgICAvKipcbiAgICAgKiBUaGUgcmVDYXB0Y2hhIEFQSSBzZWNyZXQga2V5XG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVDYXB0Y2hhU2VjcmV0S2V5OiBTZWNyZXRLZXlcblxuICAgIC8qKlxuICAgICAqIFRoZSBudW1iZXIgb2YgZGF5cyBsb2cgZXZlbnRzIGFyZSBrZXB0IGluIENsb3VkV2F0Y2ggTG9ncy4gV2hlbiB1cGRhdGluZyB0aGlzIHByb3BlcnR5LCB1bnNldHRpbmcgaXQgZG9lc24ndFxuICAgICAqIHJlbW92ZSB0aGUgbG9nIHJldGVudGlvbiBwb2xpY3kuIFRvIHJlbW92ZSB0aGUgcmV0ZW50aW9uIHBvbGljeSwgc2V0IHRoZSB2YWx1ZSB0byBgSU5GSU5JVEVgLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgbG9ncy5SZXRlbnRpb25EYXlzLklORklOSVRFXG4gICAgICovXG4gICAgcmVhZG9ubHkgbG9nUmV0ZW50aW9uPzogbG9ncy5SZXRlbnRpb25EYXlzO1xuXG4gICAgLyoqXG4gICAgICogRW5hYmxlIEFXUyBYLVJheSBUcmFjaW5nIGZvciBMYW1iZGEgRnVuY3Rpb24uXG4gICAgICpcbiAgICAgKiBAZGVmYXVsdCBUcmFjaW5nLkRpc2FibGVkXG4gICAgICovXG4gICAgcmVhZG9ubHkgdHJhY2luZz86IGxhbWJkYS5UcmFjaW5nO1xuXG59XG5cbmNvbnN0IE1JTl9TQ09SRV9USFJFU0hPTEQgPSAwLjA7XG5jb25zdCBNQVhfU0NPUkVfVEhSRVNIT0xEID0gMS4wO1xuY29uc3QgREVGQVVMVF9TQ09SRV9USFJFU0hPTEQgPSAwLjU7XG5cbi8qKlxuICogUmVxdWVzdC1iYXNlZCBsYW1iZGEgYXV0aG9yaXplciB0aGF0IGF1dGhvcml6ZXMgcmVxdWVzdHMgdXNpbmcgR29vZ2xlJ3MgcmVDYXB0Y2hhIEFQSVxuICpcbiAqIEByZXNvdXJjZSBBV1M6OkFwaUdhdGV3YXk6OkF1dGhvcml6ZXJcbiAqL1xuZXhwb3J0IGNsYXNzIFJlY2FwdGNoYUF1dGhvcml6ZXIgZXh0ZW5kcyBhcGlnYXRld2F5LkF1dGhvcml6ZXIgaW1wbGVtZW50cyBhcGlnYXRld2F5LklBdXRob3JpemVyIHtcblxuICAgIHByaXZhdGUgYXV0aG9yaXplcjogYXBpZ2F0ZXdheS5SZXF1ZXN0QXV0aG9yaXplcjtcblxuICAgIC8qKlxuICAgICAqIFRoZSBhdXRob3JpemF0aW9uIHR5cGUgb2YgdGhpcyBhdXRob3JpemVyLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF1dGhvcml6YXRpb25UeXBlPzogYXBpZ2F0ZXdheS5BdXRob3JpemF0aW9uVHlwZTtcblxuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBSZWNhcHRjaGFBdXRob3JpemVyUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgICAgICBjb25zdCBzY29yZVRocmVzaG9sZCA9IHByb3BzLnNjb3JlVGhyZXNob2xkID8/IERFRkFVTFRfU0NPUkVfVEhSRVNIT0xEO1xuXG4gICAgICAgIGlmIChzY29yZVRocmVzaG9sZCA8IE1JTl9TQ09SRV9USFJFU0hPTEQgfHwgc2NvcmVUaHJlc2hvbGQgPiBNQVhfU0NPUkVfVEhSRVNIT0xEKSB7XG4gICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ3Njb3JlVGhyZXNob2xkIG11c3QgYmUgYmV0d2VlbiAwLjAgYW5kIDEuMCcpO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgaGFuZGxlciA9IG5ldyBsYW1iZGFOb2RlSlMuTm9kZWpzRnVuY3Rpb24odGhpcywgJ2Z1bmN0aW9uJywge1xuICAgICAgICAgICAgYnVuZGxpbmc6IHtcbiAgICAgICAgICAgICAgICBtaW5pZnk6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICAgICAgICAgIEFMTE9XRURfQUNUSU9OUzogSlNPTi5zdHJpbmdpZnkocHJvcHMuYWxsb3dlZEFjdGlvbnMpLFxuICAgICAgICAgICAgICAgIFNDT1JFX1RIUkVTSE9MRDogc2NvcmVUaHJlc2hvbGQudG9TdHJpbmcoKSxcbiAgICAgICAgICAgICAgICBTRUNSRVRfS0VZX1RZUEU6IHByb3BzLnJlQ2FwdGNoYVNlY3JldEtleS5zZWNyZXRLZXlUeXBlLFxuICAgICAgICAgICAgICAgIC4uLnByb3BzLnJlQ2FwdGNoYVNlY3JldEtleS5lbnZpcm9ubWVudFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIGxvZ1JldGVudGlvbjogcHJvcHMubG9nUmV0ZW50aW9uLFxuICAgICAgICAgICAgdHJhY2luZzogcHJvcHMudHJhY2luZ1xuICAgICAgICB9KTtcblxuICAgICAgICBpZiAocHJvcHMucmVDYXB0Y2hhU2VjcmV0S2V5LmdyYW50UmVhZCkge1xuICAgICAgICAgICAgcHJvcHMucmVDYXB0Y2hhU2VjcmV0S2V5LmdyYW50UmVhZChoYW5kbGVyKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMuYXV0aG9yaXplciA9IG5ldyBhcGlnYXRld2F5LlJlcXVlc3RBdXRob3JpemVyKHRoaXMsICdBdXRob3JpemVyJywge1xuICAgICAgICAgICAgaGFuZGxlcixcbiAgICAgICAgICAgIGlkZW50aXR5U291cmNlczogW2FwaWdhdGV3YXkuSWRlbnRpdHlTb3VyY2UuaGVhZGVyKCdYLXJlQ0FQVENIQS1Ub2tlbicpXVxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5hdXRob3JpemF0aW9uVHlwZSA9IHRoaXMuYXV0aG9yaXplci5hdXRob3JpemF0aW9uVHlwZTtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgYXV0aG9yaXplciBJRC5cbiAgICAgKiBAYXR0cmlidXRlXG4gICAgICovXG4gICAgZ2V0IGF1dGhvcml6ZXJJZCgpOiBzdHJpbmcge1xuICAgICAgICByZXR1cm4gdGhpcy5hdXRob3JpemVyLmF1dGhvcml6ZXJJZDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBBdHRhY2hlcyB0aGlzIGF1dGhvcml6ZXIgdG8gYSBzcGVjaWZpYyBSRVNUIEFQSS5cbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKiBAcmV0dXJucyB7dm9pZH1cbiAgICAgKiBAcGFyYW0ge1Jlc3RBcGl9IHJlc3RBcGkgdGhlIHJlc3QgQVBJIHRvIGF0dGFjaCB0aGlzIGF1dGhvcml6ZXIgdG9cbiAgICAgKi9cbiAgICBwdWJsaWMgX2F0dGFjaFRvQXBpKHJlc3RBcGk6IGFwaWdhdGV3YXkuUmVzdEFwaSk6IHZvaWQge1xuICAgICAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L2Jhbi10cy1jb21tZW50XG4gICAgICAgIC8vIEB0cy1pZ25vcmVcbiAgICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXVuZGVyc2NvcmUtZGFuZ2xlXG4gICAgICAgIHRoaXMuYXV0aG9yaXplci5fYXR0YWNoVG9BcGkocmVzdEFwaSk7XG4gICAgfVxuXG59XG4iXX0=