"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.lookup = void 0;
const path = require("path");
const futils = require("./file-utils");
let cfnTypeToL1Mapping;
/**
 * Returns the fully-qualified name
 * (that is, including the NPM package name)
 * of a class that corresponds to this CloudFormation type,
 * or undefined if the given type was not found.
 *
 * For example, lookup("AWS::S3::Bucket")
 * returns "@aws-cdk/aws-s3.CfnBucket".
 */
function lookup(cfnType) {
    if (!cfnTypeToL1Mapping) {
        cfnTypeToL1Mapping = loadCfnTypeToL1Mapping();
    }
    return cfnTypeToL1Mapping[cfnType];
}
exports.lookup = lookup;
function loadCfnTypeToL1Mapping() {
    return futils.readJsonSync(path.join(__dirname, '..', 'cfn-types-2-classes.json'));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2ZuLXR5cGUtdG8tbDEtbWFwcGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNmbi10eXBlLXRvLWwxLW1hcHBpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLHVDQUF1QztBQUV2QyxJQUFJLGtCQUE4QyxDQUFDO0FBRW5EOzs7Ozs7OztHQVFHO0FBQ0gsU0FBZ0IsTUFBTSxDQUFDLE9BQWU7SUFDcEMsSUFBSSxDQUFDLGtCQUFrQixFQUFFO1FBQ3ZCLGtCQUFrQixHQUFHLHNCQUFzQixFQUFFLENBQUM7S0FDL0M7SUFFRCxPQUFPLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ3JDLENBQUM7QUFORCx3QkFNQztBQUVELFNBQVMsc0JBQXNCO0lBQzdCLE9BQU8sTUFBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUUsMEJBQTBCLENBQUMsQ0FBQyxDQUFDO0FBQ3JGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgZnV0aWxzIGZyb20gJy4vZmlsZS11dGlscyc7XG5cbmxldCBjZm5UeXBlVG9MMU1hcHBpbmc6IHsgW3R5cGU6IHN0cmluZ106IHN0cmluZyB9O1xuXG4vKipcbiAqIFJldHVybnMgdGhlIGZ1bGx5LXF1YWxpZmllZCBuYW1lXG4gKiAodGhhdCBpcywgaW5jbHVkaW5nIHRoZSBOUE0gcGFja2FnZSBuYW1lKVxuICogb2YgYSBjbGFzcyB0aGF0IGNvcnJlc3BvbmRzIHRvIHRoaXMgQ2xvdWRGb3JtYXRpb24gdHlwZSxcbiAqIG9yIHVuZGVmaW5lZCBpZiB0aGUgZ2l2ZW4gdHlwZSB3YXMgbm90IGZvdW5kLlxuICpcbiAqIEZvciBleGFtcGxlLCBsb29rdXAoXCJBV1M6OlMzOjpCdWNrZXRcIilcbiAqIHJldHVybnMgXCJAYXdzLWNkay9hd3MtczMuQ2ZuQnVja2V0XCIuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBsb29rdXAoY2ZuVHlwZTogc3RyaW5nKTogc3RyaW5nIHwgdW5kZWZpbmVkIHtcbiAgaWYgKCFjZm5UeXBlVG9MMU1hcHBpbmcpIHtcbiAgICBjZm5UeXBlVG9MMU1hcHBpbmcgPSBsb2FkQ2ZuVHlwZVRvTDFNYXBwaW5nKCk7XG4gIH1cblxuICByZXR1cm4gY2ZuVHlwZVRvTDFNYXBwaW5nW2NmblR5cGVdO1xufVxuXG5mdW5jdGlvbiBsb2FkQ2ZuVHlwZVRvTDFNYXBwaW5nKCk6IGFueSB7XG4gIHJldHVybiBmdXRpbHMucmVhZEpzb25TeW5jKHBhdGguam9pbihfX2Rpcm5hbWUsICcuLicsICdjZm4tdHlwZXMtMi1jbGFzc2VzLmpzb24nKSk7XG59XG4iXX0=