"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readYamlSync = exports.readJsonSync = void 0;
const fs = require("fs");
const yaml_cfn = require("./private/yaml-cfn");
function readJsonSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return JSON.parse(fileContents.toString());
}
exports.readJsonSync = readJsonSync;
function readYamlSync(filePath) {
    const fileContents = fs.readFileSync(filePath);
    return yaml_cfn.deserialize(fileContents.toString());
}
exports.readYamlSync = readYamlSync;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS11dGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZpbGUtdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEseUJBQXlCO0FBQ3pCLCtDQUErQztBQUUvQyxTQUFnQixZQUFZLENBQUMsUUFBZ0I7SUFDM0MsTUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMvQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7QUFDN0MsQ0FBQztBQUhELG9DQUdDO0FBRUQsU0FBZ0IsWUFBWSxDQUFDLFFBQWdCO0lBQzNDLE1BQU0sWUFBWSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDL0MsT0FBTyxRQUFRLENBQUMsV0FBVyxDQUFDLFlBQVksQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO0FBQ3ZELENBQUM7QUFIRCxvQ0FHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHlhbWxfY2ZuIGZyb20gJy4vcHJpdmF0ZS95YW1sLWNmbic7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWFkSnNvblN5bmMoZmlsZVBhdGg6IHN0cmluZyk6IGFueSB7XG4gIGNvbnN0IGZpbGVDb250ZW50cyA9IGZzLnJlYWRGaWxlU3luYyhmaWxlUGF0aCk7XG4gIHJldHVybiBKU09OLnBhcnNlKGZpbGVDb250ZW50cy50b1N0cmluZygpKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHJlYWRZYW1sU3luYyhmaWxlUGF0aDogc3RyaW5nKTogYW55IHtcbiAgY29uc3QgZmlsZUNvbnRlbnRzID0gZnMucmVhZEZpbGVTeW5jKGZpbGVQYXRoKTtcbiAgcmV0dXJuIHlhbWxfY2ZuLmRlc2VyaWFsaXplKGZpbGVDb250ZW50cy50b1N0cmluZygpKTtcbn1cbiJdfQ==