"""Test validator."""

import json
import unittest
from aind_metadata_validator.metadata_validator import validate_metadata
from aind_metadata_validator.utils import MetadataState


class ValidatorTest(unittest.TestCase):
    """Validator tests."""

    def setUp(self):
        """Set up the tests"""
        with open("./tests/resources/metadata.json") as f:
            self.data = json.load(f)

    def test_validator(self):
        """Test the main validator"""
        results = validate_metadata(self.data)
        expected = {
            "_id": "4ceba2a9-ecb0-458e-b874-9923762d7725",
            "metadata": 1,
            "data_description": 1,
            "acquisition": -2,
            "procedures": 2,
            "subject": 1,
            "instrument": -2,
            "processing": 1,
            "rig": 1,
            "session": 1,
            "quality_control": 2,
            "data_description.data_level": 1,
            "data_description.data_summary": 2,
            "data_description.funding_source": 1,
            "data_description.group": 2,
            "data_description.institution": 2,
            "data_description.investigators": 2,
            "data_description.modality": 2,
            "data_description.name": 2,
            "data_description.project_name": 2,
            "data_description.related_data": 2,
            "data_description.restrictions": 2,
            "data_description.subject_id": 2,
            "acquisition.protocol_id": -2,
            "acquisition.experimenter_full_name": -2,
            "acquisition.specimen_id": -2,
            "acquisition.subject_id": -2,
            "acquisition.instrument_id": -2,
            "acquisition.calibrations": -2,
            "acquisition.maintenance": -2,
            "acquisition.session_start_time": -2,
            "acquisition.session_end_time": -2,
            "acquisition.session_type": -2,
            "acquisition.tiles": -2,
            "acquisition.axes": -2,
            "acquisition.chamber_immersion": -2,
            "acquisition.sample_immersion": -2,
            "acquisition.active_objectives": -2,
            "acquisition.local_storage_directory": -2,
            "acquisition.external_storage_directory": -2,
            "acquisition.processing_steps": -2,
            "acquisition.software": -2,
            "acquisition.notes": -2,
            "procedures.notes": 2,
            "procedures.specimen_procedures": 2,
            "procedures.subject_id": 2,
            "procedures.subject_procedures": 2,
            "subject.background_strain": 2,
            "subject.date_of_birth": 1,
            "subject.genotype": 2,
            "subject.housing": 2,
            "subject.notes": 2,
            "subject.restrictions": 2,
            "subject.rrid": 2,
            "subject.sex": 2,
            "subject.source": -1,
            "subject.species": 1,
            "subject.subject_id": 2,
            "subject.wellness_reports": 1,
            "instrument.instrument_id": -2,
            "instrument.modification_date": -2,
            "instrument.instrument_type": -2,
            "instrument.manufacturer": -2,
            "instrument.temperature_control": -2,
            "instrument.humidity_control": -2,
            "instrument.optical_tables": -2,
            "instrument.enclosure": -2,
            "instrument.objectives": -2,
            "instrument.detectors": -2,
            "instrument.light_sources": -2,
            "instrument.lenses": -2,
            "instrument.fluorescence_filters": -2,
            "instrument.motorized_stages": -2,
            "instrument.scanning_stages": -2,
            "instrument.additional_devices": -2,
            "instrument.calibration_date": -2,
            "instrument.calibration_data": -2,
            "instrument.com_ports": -2,
            "instrument.daqs": -2,
            "instrument.notes": -2,
            "rig.additional_devices": 2,
            "rig.calibrations": 2,
            "rig.cameras": 1,
            "rig.ccf_coordinate_transform": 2,
            "rig.daqs": 2,
            "rig.detectors": 1,
            "rig.digital_micromirror_devices": 2,
            "rig.enclosure": 2,
            "rig.ephys_assemblies": 2,
            "rig.fiber_assemblies": 2,
            "rig.filters": 2,
            "rig.laser_assemblies": 2,
            "rig.lenses": 2,
            "rig.light_sources": 2,
            "rig.modalities": 1,
            "rig.modification_date": 1,
            "rig.mouse_platform": 2,
            "rig.notes": 2,
            "rig.objectives": 2,
            "rig.origin": 2,
            "rig.patch_cords": 2,
            "rig.pockels_cells": 2,
            "rig.polygonal_scanners": 2,
            "rig.rig_axes": 1,
            "rig.rig_id": 2,
            "rig.stick_microscopes": 2,
            "rig.stimulus_devices": 2,
            "session.active_mouse_platform": -1,
            "session.animal_weight_post": 2,
            "session.animal_weight_prior": 2,
            "session.calibrations": 2,
            "session.data_streams": 1,
            "session.experimenter_full_name": 2,
            "session.iacuc_protocol": 2,
            "session.maintenance": 2,
            "session.mouse_platform_name": 2,
            "session.notes": 2,
            "session.protocol_id": 2,
            "session.reward_consumed_total": 1,
            "session.reward_consumed_unit": 2,
            "session.reward_delivery": 2,
            "session.rig_id": 2,
            "session.session_end_time": 1,
            "session.session_start_time": 1,
            "session.session_type": 2,
            "session.stimulus_epochs": 2,
            "session.subject_id": 2,
            "session.weight_unit": 2,
            "quality_control.evaluations": 2,
            "quality_control.notes": 2,
        }

        for field in results:
            self.assertEqual(results[field], expected[field])


if __name__ == "__main__":
    unittest.main()
