# Stubs for pyspark.mllib.stat._statistics (Python 3.5)
#

from typing import List, Optional, overload, Union
from typing_extensions import Literal

from numpy import ndarray  # type: ignore[import]

from pyspark.mllib.common import JavaModelWrapper
from pyspark.mllib.linalg import Vector, Matrix
from pyspark.mllib.regression import LabeledPoint
from pyspark.mllib.stat.test import ChiSqTestResult, KolmogorovSmirnovTestResult
from pyspark.rdd import RDD

CorrelationMethod = Union[Literal["spearman"], Literal["pearson"]]

class MultivariateStatisticalSummary(JavaModelWrapper):
    def mean(self) -> ndarray: ...
    def variance(self) -> ndarray: ...
    def count(self) -> int: ...
    def numNonzeros(self) -> ndarray: ...
    def max(self) -> ndarray: ...
    def min(self) -> ndarray: ...
    def normL1(self) -> ndarray: ...
    def normL2(self) -> ndarray: ...

class Statistics:
    @staticmethod
    def colStats(rdd: RDD[Vector]) -> MultivariateStatisticalSummary: ...
    @overload
    @staticmethod
    def corr(
        x: RDD[Vector], *, method: Optional[CorrelationMethod] = ...
    ) -> Matrix: ...
    @overload
    @staticmethod
    def corr(
        x: RDD[float], y: RDD[float], method: Optional[CorrelationMethod] = ...
    ) -> float: ...
    @overload
    @staticmethod
    def chiSqTest(observed: Matrix) -> ChiSqTestResult: ...
    @overload
    @staticmethod
    def chiSqTest(
        observed: Vector, expected: Optional[Vector] = ...
    ) -> ChiSqTestResult: ...
    @overload
    @staticmethod
    def chiSqTest(observed: RDD[LabeledPoint]) -> List[ChiSqTestResult]: ...
    @staticmethod
    def kolmogorovSmirnovTest(
        data, distName: Literal["norm"] = ..., *params: float
    ) -> KolmogorovSmirnovTestResult: ...
