"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconfig.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Config extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconfig.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'config';
        this.accessLevelList = {
            Read: [
                'BatchGetAggregateResourceConfig',
                'BatchGetResourceConfig',
                'DeliverConfigSnapshot',
                'DescribeAggregateComplianceByConfigRules',
                'DescribeAggregateComplianceByConformancePacks',
                'DescribeComplianceByConfigRule',
                'DescribeComplianceByResource',
                'DescribeConfigRuleEvaluationStatus',
                'DescribeConfigurationAggregatorSourcesStatus',
                'DescribeConfigurationRecorderStatus',
                'DescribeConformancePackCompliance',
                'DescribeConformancePackStatus',
                'DescribeDeliveryChannelStatus',
                'DescribeOrganizationConfigRuleStatuses',
                'DescribeOrganizationConformancePackStatuses',
                'DescribeRemediationExecutionStatus',
                'GetAggregateComplianceDetailsByConfigRule',
                'GetAggregateConfigRuleComplianceSummary',
                'GetAggregateConformancePackComplianceSummary',
                'GetAggregateDiscoveredResourceCounts',
                'GetAggregateResourceConfig',
                'GetComplianceDetailsByConfigRule',
                'GetComplianceDetailsByResource',
                'GetComplianceSummaryByConfigRule',
                'GetComplianceSummaryByResourceType',
                'GetConformancePackComplianceDetails',
                'GetConformancePackComplianceSummary',
                'GetDiscoveredResourceCounts',
                'GetOrganizationConfigRuleDetailedStatus',
                'GetOrganizationConformancePackDetailedStatus',
                'GetResourceConfigHistory',
                'GetStoredQuery',
                'ListTagsForResource',
                'SelectAggregateResourceConfig',
                'SelectResourceConfig'
            ],
            Write: [
                'DeleteAggregationAuthorization',
                'DeleteConfigRule',
                'DeleteConfigurationAggregator',
                'DeleteConfigurationRecorder',
                'DeleteConformancePack',
                'DeleteDeliveryChannel',
                'DeleteEvaluationResults',
                'DeleteOrganizationConfigRule',
                'DeleteOrganizationConformancePack',
                'DeletePendingAggregationRequest',
                'DeleteRemediationConfiguration',
                'DeleteRemediationExceptions',
                'DeleteResourceConfig',
                'DeleteRetentionConfiguration',
                'DeleteStoredQuery',
                'PutAggregationAuthorization',
                'PutConfigRule',
                'PutConfigurationAggregator',
                'PutConfigurationRecorder',
                'PutConformancePack',
                'PutDeliveryChannel',
                'PutEvaluations',
                'PutExternalEvaluation',
                'PutOrganizationConfigRule',
                'PutOrganizationConformancePack',
                'PutRemediationConfigurations',
                'PutRemediationExceptions',
                'PutResourceConfig',
                'PutRetentionConfiguration',
                'PutStoredQuery',
                'StartConfigRulesEvaluation',
                'StartConfigurationRecorder',
                'StartRemediationExecution',
                'StopConfigurationRecorder'
            ],
            List: [
                'DescribeAggregationAuthorizations',
                'DescribeConfigRules',
                'DescribeConfigurationAggregators',
                'DescribeConfigurationRecorders',
                'DescribeConformancePacks',
                'DescribeDeliveryChannels',
                'DescribeOrganizationConfigRules',
                'DescribeOrganizationConformancePacks',
                'DescribePendingAggregationRequests',
                'DescribeRemediationConfigurations',
                'DescribeRemediationExceptions',
                'DescribeRetentionConfigurations',
                'ListAggregateDiscoveredResources',
                'ListDiscoveredResources',
                'ListStoredQueries'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to return the current configuration items for resources that are present in your AWS Config aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetAggregateResourceConfig.html
     */
    toBatchGetAggregateResourceConfig() {
        return this.to('BatchGetAggregateResourceConfig');
    }
    /**
     * Grants permission to return the current configuration for one or more requested resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetResourceConfig.html
     */
    toBatchGetResourceConfig() {
        return this.to('BatchGetResourceConfig');
    }
    /**
     * Grants permission to delete the authorization granted to the specified configuration aggregator account in a specified region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteAggregationAuthorization.html
     */
    toDeleteAggregationAuthorization() {
        return this.to('DeleteAggregationAuthorization');
    }
    /**
     * Grants permission to delete the specified AWS Config rule and all of its evaluation results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigRule.html
     */
    toDeleteConfigRule() {
        return this.to('DeleteConfigRule');
    }
    /**
     * Grants permission to delete the specified configuration aggregator and the aggregated data associated with the aggregator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationAggregator.html
     */
    toDeleteConfigurationAggregator() {
        return this.to('DeleteConfigurationAggregator');
    }
    /**
     * Grants permission to delete the configuration recorder
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html
     */
    toDeleteConfigurationRecorder() {
        return this.to('DeleteConfigurationRecorder');
    }
    /**
     * Grants permission to delete the specified conformance pack and all the AWS Config rules and all evaluation results within that conformance pack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConformancePack.html
     */
    toDeleteConformancePack() {
        return this.to('DeleteConformancePack');
    }
    /**
     * Grants permission to delete the delivery channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html
     */
    toDeleteDeliveryChannel() {
        return this.to('DeleteDeliveryChannel');
    }
    /**
     * Grants permission to delete the evaluation results for the specified Config rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteEvaluationResults.html
     */
    toDeleteEvaluationResults() {
        return this.to('DeleteEvaluationResults');
    }
    /**
     * Grants permission to delete the specified organization config rule and all of its evaluation results from all member accounts in that organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConfigRule.html
     */
    toDeleteOrganizationConfigRule() {
        return this.to('DeleteOrganizationConfigRule');
    }
    /**
     * Grants permission to delete the specified organization conformance pack and all of its evaluation results from all member accounts in that organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConformancePack.html
     */
    toDeleteOrganizationConformancePack() {
        return this.to('DeleteOrganizationConformancePack');
    }
    /**
     * Grants permission to delete pending authorization requests for a specified aggregator account in a specified region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeletePendingAggregationRequest.html
     */
    toDeletePendingAggregationRequest() {
        return this.to('DeletePendingAggregationRequest');
    }
    /**
     * Grants permission to delete the remediation configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationConfiguration.html
     */
    toDeleteRemediationConfiguration() {
        return this.to('DeleteRemediationConfiguration');
    }
    /**
     * Grants permission to delete one or more remediation exceptions for specific resource keys for a specific AWS Config Rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationExceptions.html
     */
    toDeleteRemediationExceptions() {
        return this.to('DeleteRemediationExceptions');
    }
    /**
     * Grants permission to record the configuration state for a custom resource that has been deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteResourceConfig.html
     */
    toDeleteResourceConfig() {
        return this.to('DeleteResourceConfig');
    }
    /**
     * Grants permission to delete the retention configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRetentionConfiguration.html
     */
    toDeleteRetentionConfiguration() {
        return this.to('DeleteRetentionConfiguration');
    }
    /**
     * Grants permission to delete the stored query for an AWS account in an AWS Region
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteStoredQuery.html
     */
    toDeleteStoredQuery() {
        return this.to('DeleteStoredQuery');
    }
    /**
     * Grants permission to schedule delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeliverConfigSnapshot.html
     */
    toDeliverConfigSnapshot() {
        return this.to('DeliverConfigSnapshot');
    }
    /**
     * Grants permission to return a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregateComplianceByConfigRules.html
     */
    toDescribeAggregateComplianceByConfigRules() {
        return this.to('DescribeAggregateComplianceByConfigRules');
    }
    /**
     * Grants permission to return a list of compliant and noncompliant conformance packs along with count of compliant, non-compliant and total rules within each conformance pack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregateComplianceByConformancePacks.html
     */
    toDescribeAggregateComplianceByConformancePacks() {
        return this.to('DescribeAggregateComplianceByConformancePacks');
    }
    /**
     * Grants permission to return a list of authorizations granted to various aggregator accounts and regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregationAuthorizations.html
     */
    toDescribeAggregationAuthorizations() {
        return this.to('DescribeAggregationAuthorizations');
    }
    /**
     * Grants permission to indicate whether the specified AWS Config rules are compliant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByConfigRule.html
     */
    toDescribeComplianceByConfigRule() {
        return this.to('DescribeComplianceByConfigRule');
    }
    /**
     * Grants permission to indicate whether the specified AWS resources are compliant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByResource.html
     */
    toDescribeComplianceByResource() {
        return this.to('DescribeComplianceByResource');
    }
    /**
     * Grants permission to return status information for each of your AWS managed Config rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRuleEvaluationStatus.html
     */
    toDescribeConfigRuleEvaluationStatus() {
        return this.to('DescribeConfigRuleEvaluationStatus');
    }
    /**
     * Grants permission to return details about your AWS Config rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRules.html
     */
    toDescribeConfigRules() {
        return this.to('DescribeConfigRules');
    }
    /**
     * Grants permission to return status information for sources within an aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregatorSourcesStatus.html
     */
    toDescribeConfigurationAggregatorSourcesStatus() {
        return this.to('DescribeConfigurationAggregatorSourcesStatus');
    }
    /**
     * Grants permission to return the details of one or more configuration aggregators
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregators.html
     */
    toDescribeConfigurationAggregators() {
        return this.to('DescribeConfigurationAggregators');
    }
    /**
     * Grants permission to return the current status of the specified configuration recorder
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html
     */
    toDescribeConfigurationRecorderStatus() {
        return this.to('DescribeConfigurationRecorderStatus');
    }
    /**
     * Grants permission to return the names of one or more specified configuration recorders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html
     */
    toDescribeConfigurationRecorders() {
        return this.to('DescribeConfigurationRecorders');
    }
    /**
     * Grants permission to return compliance information for each rule in that conformance pack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackCompliance.html
     */
    toDescribeConformancePackCompliance() {
        return this.to('DescribeConformancePackCompliance');
    }
    /**
     * Grants permission to provide one or more conformance packs deployment status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackStatus.html
     */
    toDescribeConformancePackStatus() {
        return this.to('DescribeConformancePackStatus');
    }
    /**
     * Grants permission to return a list of one or more conformance packs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePacks.html
     */
    toDescribeConformancePacks() {
        return this.to('DescribeConformancePacks');
    }
    /**
     * Grants permission to return the current status of the specified delivery channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannelStatus.html
     */
    toDescribeDeliveryChannelStatus() {
        return this.to('DescribeDeliveryChannelStatus');
    }
    /**
     * Grants permission to return details about the specified delivery channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannels.html
     */
    toDescribeDeliveryChannels() {
        return this.to('DescribeDeliveryChannels');
    }
    /**
     * Grants permission to provide organization config rule deployment status for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRuleStatuses.html
     */
    toDescribeOrganizationConfigRuleStatuses() {
        return this.to('DescribeOrganizationConfigRuleStatuses');
    }
    /**
     * Grants permission to return a list of organization config rules
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRules.html
     */
    toDescribeOrganizationConfigRules() {
        return this.to('DescribeOrganizationConfigRules');
    }
    /**
     * Grants permission to provide organization conformance pack deployment status for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePackStatuses.html
     */
    toDescribeOrganizationConformancePackStatuses() {
        return this.to('DescribeOrganizationConformancePackStatuses');
    }
    /**
     * Grants permission to return a list of organization conformance packs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePacks.html
     */
    toDescribeOrganizationConformancePacks() {
        return this.to('DescribeOrganizationConformancePacks');
    }
    /**
     * Grants permission to return a list of all pending aggregation requests
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribePendingAggregationRequests.html
     */
    toDescribePendingAggregationRequests() {
        return this.to('DescribePendingAggregationRequests');
    }
    /**
     * Grants permission to return the details of one or more remediation configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationConfigurations.html
     */
    toDescribeRemediationConfigurations() {
        return this.to('DescribeRemediationConfigurations');
    }
    /**
     * Grants permission to return the details of one or more remediation exceptions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExceptions.html
     */
    toDescribeRemediationExceptions() {
        return this.to('DescribeRemediationExceptions');
    }
    /**
     * Grants permission to provide a detailed view of a Remediation Execution for a set of resources including state, timestamps and any error messages for steps that have failed
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExecutionStatus.html
     */
    toDescribeRemediationExecutionStatus() {
        return this.to('DescribeRemediationExecutionStatus');
    }
    /**
     * Grants permission to return the details of one or more retention configurations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRetentionConfigurations.html
     */
    toDescribeRetentionConfigurations() {
        return this.to('DescribeRetentionConfigurations');
    }
    /**
     * Grants permission to return the evaluation results for the specified AWS Config rule for a specific resource in a rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateComplianceDetailsByConfigRule.html
     */
    toGetAggregateComplianceDetailsByConfigRule() {
        return this.to('GetAggregateComplianceDetailsByConfigRule');
    }
    /**
     * Grants permission to return the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateConfigRuleComplianceSummary.html
     */
    toGetAggregateConfigRuleComplianceSummary() {
        return this.to('GetAggregateConfigRuleComplianceSummary');
    }
    /**
     * Grants permission to return the number of compliant and noncompliant conformance packs for one or more accounts and regions in an aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateConformancePackComplianceSummary.html
     */
    toGetAggregateConformancePackComplianceSummary() {
        return this.to('GetAggregateConformancePackComplianceSummary');
    }
    /**
     * Grants permission to return the resource counts across accounts and regions that are present in your AWS Config aggregator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateDiscoveredResourceCounts.html
     */
    toGetAggregateDiscoveredResourceCounts() {
        return this.to('GetAggregateDiscoveredResourceCounts');
    }
    /**
     * Grants permission to return configuration item that is aggregated for your specific resource in a specific source account and region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateResourceConfig.html
     */
    toGetAggregateResourceConfig() {
        return this.to('GetAggregateResourceConfig');
    }
    /**
     * Grants permission to return the evaluation results for the specified AWS Config rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByConfigRule.html
     */
    toGetComplianceDetailsByConfigRule() {
        return this.to('GetComplianceDetailsByConfigRule');
    }
    /**
     * Grants permission to return the evaluation results for the specified AWS resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html
     */
    toGetComplianceDetailsByResource() {
        return this.to('GetComplianceDetailsByResource');
    }
    /**
     * Grants permission to return the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByConfigRule.html
     */
    toGetComplianceSummaryByConfigRule() {
        return this.to('GetComplianceSummaryByConfigRule');
    }
    /**
     * Grants permission to return the number of resources that are compliant and the number that are noncompliant
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByResourceType.html
     */
    toGetComplianceSummaryByResourceType() {
        return this.to('GetComplianceSummaryByResourceType');
    }
    /**
     * Grants permission to return compliance details of a conformance pack for all AWS resources that are monitered by conformance pack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceDetails.html
     */
    toGetConformancePackComplianceDetails() {
        return this.to('GetConformancePackComplianceDetails');
    }
    /**
     * Grants permission to provide compliance summary for one or more conformance packs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceSummary.html
     */
    toGetConformancePackComplianceSummary() {
        return this.to('GetConformancePackComplianceSummary');
    }
    /**
     * Grants permission to return the resource types, the number of each resource type, and the total number of resources that AWS Config is recording in this region for your AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetDiscoveredResourceCounts.html
     */
    toGetDiscoveredResourceCounts() {
        return this.to('GetDiscoveredResourceCounts');
    }
    /**
     * Grants permission to return detailed status for each member account within an organization for a given organization config rule
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConfigRuleDetailedStatus.html
     */
    toGetOrganizationConfigRuleDetailedStatus() {
        return this.to('GetOrganizationConfigRuleDetailedStatus');
    }
    /**
     * Grants permission to return detailed status for each member account within an organization for a given organization conformance pack
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConformancePackDetailedStatus.html
     */
    toGetOrganizationConformancePackDetailedStatus() {
        return this.to('GetOrganizationConformancePackDetailedStatus');
    }
    /**
     * Grants permission to return a list of configuration items for the specified resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html
     */
    toGetResourceConfigHistory() {
        return this.to('GetResourceConfigHistory');
    }
    /**
     * Grants permission to return the details of a specific stored query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetStoredQuery.html
     */
    toGetStoredQuery() {
        return this.to('GetStoredQuery');
    }
    /**
     * Grants permission to accept a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListAggregateDiscoveredResources.html
     */
    toListAggregateDiscoveredResources() {
        return this.to('ListAggregateDiscoveredResources');
    }
    /**
     * Grants permission to accept a resource type and returns a list of resource identifiers for the resources of that type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListDiscoveredResources.html
     */
    toListDiscoveredResources() {
        return this.to('ListDiscoveredResources');
    }
    /**
     * Grants permission to list the stored queries for an AWS account in an AWS Region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListStoredQueries.html
     */
    toListStoredQueries() {
        return this.to('ListStoredQueries');
    }
    /**
     * Grants permission to list the tags for AWS Config resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to authorize the aggregator account and region to collect data from the source account and region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutAggregationAuthorization.html
     */
    toPutAggregationAuthorization() {
        return this.to('PutAggregationAuthorization');
    }
    /**
     * Grants permission to add or update an AWS Config rule for evaluating whether your AWS resources comply with your desired configurations
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html
     */
    toPutConfigRule() {
        return this.to('PutConfigRule');
    }
    /**
     * Grants permission to create and update the configuration aggregator with the selected source accounts and regions
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationAggregator.html
     */
    toPutConfigurationAggregator() {
        return this.to('PutConfigurationAggregator');
    }
    /**
     * Grants permission to create a new configuration recorder to record the selected resource configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html
     */
    toPutConfigurationRecorder() {
        return this.to('PutConfigurationRecorder');
    }
    /**
     * Grants permission to create or update a conformance pack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html
     */
    toPutConformancePack() {
        return this.to('PutConformancePack');
    }
    /**
     * Grants permission to create a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutDeliveryChannel.html
     */
    toPutDeliveryChannel() {
        return this.to('PutDeliveryChannel');
    }
    /**
     * Grants permission to be used by an AWS Lambda function to deliver evaluation results to AWS Config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutEvaluations.html
     */
    toPutEvaluations() {
        return this.to('PutEvaluations');
    }
    /**
     * Grants permission to deliver evaluation result to AWS Config
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutExternalEvaluation.html
     */
    toPutExternalEvaluation() {
        return this.to('PutExternalEvaluation');
    }
    /**
     * Grants permission to add or update organization config rule for your entire organization evaluating whether your AWS resources comply with your desired configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html
     */
    toPutOrganizationConfigRule() {
        return this.to('PutOrganizationConfigRule');
    }
    /**
     * Grants permission to add or update organization conformance pack for your entire organization evaluating whether your AWS resources comply with your desired configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html
     */
    toPutOrganizationConformancePack() {
        return this.to('PutOrganizationConformancePack');
    }
    /**
     * Grants permission to add or update the remediation configuration with a specific AWS Config rule with the selected target or action
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationConfigurations.html
     */
    toPutRemediationConfigurations() {
        return this.to('PutRemediationConfigurations');
    }
    /**
     * Grants permission to add or update remediation exceptions for specific resources for a specific AWS Config rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationExceptions.html
     */
    toPutRemediationExceptions() {
        return this.to('PutRemediationExceptions');
    }
    /**
     * Grants permission to record the configuration state for the resource provided in the request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutResourceConfig.html
     */
    toPutResourceConfig() {
        return this.to('PutResourceConfig');
    }
    /**
     * Grants permission to create and update the retention configuration with details about retention period (number of days) that AWS Config stores your historical information
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRetentionConfiguration.html
     */
    toPutRetentionConfiguration() {
        return this.to('PutRetentionConfiguration');
    }
    /**
     * Grants permission to save a new query or updates an existing saved query
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html
     */
    toPutStoredQuery() {
        return this.to('PutStoredQuery');
    }
    /**
     * Grants permission to accept a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectAggregateResourceConfig.html
     */
    toSelectAggregateResourceConfig() {
        return this.to('SelectAggregateResourceConfig');
    }
    /**
     * Grants permission to accept a structured query language (SQL) SELECT command, performs the corresponding search, and returns resource configurations matching the properties
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectResourceConfig.html
     */
    toSelectResourceConfig() {
        return this.to('SelectResourceConfig');
    }
    /**
     * Grants permission to evaluate your resources against the specified Config rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigRulesEvaluation.html
     */
    toStartConfigRulesEvaluation() {
        return this.to('StartConfigRulesEvaluation');
    }
    /**
     * Grants permission to start recording configurations of the AWS resources you have selected to record in your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html
     */
    toStartConfigurationRecorder() {
        return this.to('StartConfigurationRecorder');
    }
    /**
     * Grants permission to run an on-demand remediation for the specified AWS Config rules against the last known remediation configuration
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartRemediationExecution.html
     */
    toStartRemediationExecution() {
        return this.to('StartRemediationExecution');
    }
    /**
     * Grants permission to stop recording configurations of the AWS resources you have selected to record in your AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html
     */
    toStopConfigurationRecorder() {
        return this.to('StopConfigurationRecorder');
    }
    /**
     * Grants permission to associate the specified tags to a resource with the specified resourceArn
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to delete specified tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Adds a resource of type AggregationAuthorization to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_AggregationAuthorization.html
     *
     * @param aggregatorAccount - Identifier for the aggregatorAccount.
     * @param aggregatorRegion - Identifier for the aggregatorRegion.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAggregationAuthorization(aggregatorAccount, aggregatorRegion, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:aggregation-authorization/${aggregatorAccount}/${aggregatorRegion}`);
    }
    /**
     * Adds a resource of type ConfigurationAggregator to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationAggregator.html
     *
     * @param aggregatorId - Identifier for the aggregatorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigurationAggregator(aggregatorId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:config-aggregator/${aggregatorId}`);
    }
    /**
     * Adds a resource of type ConfigRule to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigRule.html
     *
     * @param configRuleId - Identifier for the configRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfigRule(configRuleId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:config-rule/${configRuleId}`);
    }
    /**
     * Adds a resource of type ConformancePack to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConformancePack.html
     *
     * @param conformancePackName - Identifier for the conformancePackName.
     * @param conformancePackId - Identifier for the conformancePackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConformancePack(conformancePackName, conformancePackId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:conformance-pack/${conformancePackName}/${conformancePackId}`);
    }
    /**
     * Adds a resource of type OrganizationConfigRule to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_OrganizationConfigRule.html
     *
     * @param organizationConfigRuleId - Identifier for the organizationConfigRuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOrganizationConfigRule(organizationConfigRuleId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:organization-config-rule/${organizationConfigRuleId}`);
    }
    /**
     * Adds a resource of type OrganizationConformancePack to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_OrganizationConformancePack.html
     *
     * @param organizationConformancePackId - Identifier for the organizationConformancePackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOrganizationConformancePack(organizationConformancePackId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:organization-conformance-pack/${organizationConformancePackId}`);
    }
    /**
     * Adds a resource of type RemediationConfiguration to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_RemediationConfiguration.html
     *
     * @param remediationConfigurationId - Identifier for the remediationConfigurationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRemediationConfiguration(remediationConfigurationId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:remediation-configuration/${remediationConfigurationId}`);
    }
    /**
     * Adds a resource of type StoredQuery to the statement
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StoredQuery.html
     *
     * @param storedQueryName - Identifier for the storedQueryName.
     * @param storedQueryId - Identifier for the storedQueryId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onStoredQuery(storedQueryName, storedQueryId, account, region, partition) {
        return this.on(`arn:${partition || Config.defaultPartition}:config:${region || '*'}:${account || '*'}:stored-query/${storedQueryName}/${storedQueryId}`);
    }
}
exports.Config = Config;
_a = JSII_RTTI_SYMBOL_1;
Config[_a] = { fqn: "iam-floyd.Config", version: "0.392.0" };
//# sourceMappingURL=data:application/json;base64,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