import React from 'react';
import { FileDIDDetails, AttachedFile, RucioAuthType, RucioAuthCredentials, InstanceConfig, DirectoryItem, DIDSearchType, DIDSearchResult } from '../types';
export declare class Actions {
    fetchInstancesConfig(): Promise<InstanceConfig>;
    postActiveInstance(instanceName: string, authType: RucioAuthType): Promise<void>;
    fetchAuthConfig<T extends any>(namespace: string, type: RucioAuthType): Promise<T>;
    putAuthConfig(namespace: string, type: RucioAuthType, params: RucioAuthCredentials): Promise<void>;
    searchDID(namespace: string, did: string, type: DIDSearchType): Promise<DIDSearchResult[]>;
    fetchAttachedFileDIDs(namespace: string, did: string): Promise<AttachedFile[]>;
    fetchDIDDetails(namespace: string, did: string, poll?: boolean): Promise<FileDIDDetails[]>;
    getFileDIDDetails(namespace: string, did: string, poll?: boolean): Promise<FileDIDDetails>;
    getCollectionDIDDetails(namespace: string, did: string, poll?: boolean): Promise<FileDIDDetails[]>;
    makeFileAvailable(namespace: string, did: string): Promise<void>;
    makeCollectionAvailable(namespace: string, did: string): Promise<void>;
    listDirectory(path: string): Promise<DirectoryItem[]>;
}
export declare const actions: Actions;
export interface WithRequestAPIProps {
    actions: Actions;
}
export declare function withRequestAPI<P>(Component: React.ComponentType<P>): {
    new (props: Readonly<P>): {
        render(): JSX.Element;
        context: any;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<P>) => {} | Pick<{}, K>) | Pick<{}, K>, callback?: () => void): void;
        forceUpdate(callback?: () => void): void;
        readonly props: Readonly<P> & Readonly<{
            children?: React.ReactNode;
        }>;
        state: Readonly<{}>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidMount?(): void;
        shouldComponentUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): boolean;
        componentWillUnmount?(): void;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<P>, prevState: Readonly<{}>): any;
        componentDidUpdate?(prevProps: Readonly<P>, prevState: Readonly<{}>, snapshot?: any): void;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<P>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<P>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): void;
    };
    new (props: P, context?: any): {
        render(): JSX.Element;
        context: any;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<P>) => {} | Pick<{}, K>) | Pick<{}, K>, callback?: () => void): void;
        forceUpdate(callback?: () => void): void;
        readonly props: Readonly<P> & Readonly<{
            children?: React.ReactNode;
        }>;
        state: Readonly<{}>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidMount?(): void;
        shouldComponentUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): boolean;
        componentWillUnmount?(): void;
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<P>, prevState: Readonly<{}>): any;
        componentDidUpdate?(prevProps: Readonly<P>, prevState: Readonly<{}>, snapshot?: any): void;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<P>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<P>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<P>, nextState: Readonly<{}>, nextContext: any): void;
    };
    contextType?: React.Context<any>;
};
