#!/usr/bin/env python
# -*- coding: utf-8 -*-
# File:                ampel/contrib/hu/t2/xgb_trees.py
# License:             BSD-3-Clause
# Author:              jnordin@physik.hu-berlin.de
# Date:                06.04.2020
# Last Modified Date:  06.04.2020
# Last Modified By:    jnordin@physik.hu-berlin.de


import numpy as np


class xgboost_tree():
	"""
	Explicit python recording of xgboost tree.
	The parameter lists of the init function have to correspond to the order of the fits done.
	"""


	def predict_risedecline( self, featuredict, ndet, max_trees=100 ):
		"""
		Perform tree prediction based on dictionary with feature properties.
		"""

		# Initial prediction (base score)
		predict = 0.5
		# Loop through all trees
		treemethod = eval( 'xgb_tree_'+str(ndet) )
		for i in range(max_trees):
			predict = predict + treemethod(featuredict, i)
		return predict




def xgb_tree_2(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<17.0195007 else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.95450002)  else 4)
                if state == 3:
                    return -0.749048293
                if state == 4:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<2.9822278)  else 8)
                    if state == 7:
                        state = (13 if x['distnr_med']<7.95366764 else 14)
                        if state == 13:
                            return -0.728509068
                        if state == 14:
                            state = (23 if x['magnr_med']<16.2384987 else 24)
                            if state == 23:
                                return 0.499967992
                            if state == 24:
                                return -0.252000004
                    if state == 8:
                        state = (15 if x['distnr_med']<0.658522487 else 16)
                        if state == 15:
                            state = (25 if x['magnr_med']<14.470499 else 26)
                            if state == 25:
                                return -0.504000008
                            if state == 26:
                                state = (37 if x['maggaia_med']<16.0956631 else 38)
                                if state == 37:
                                    return -0.252000004
                                if state == 38:
                                    return 0.601887643
                        if state == 16:
                            return -0.635039985
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.863000035)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 10)
                    if state == 9:
                        return -0.737783134
                    if state == 10:
                        state = (17 if x['distnr_med']<6.27388191 else 18)
                        if state == 17:
                            state = (27 if x['magnr_med']<20.6984997 else 28)
                            if state == 27:
                                state = (39 if x['maggaia_med']<19.3743763 else 40)
                                if state == 39:
                                    state = (51 if np.isnan(x['t_lc']) or (x['t_lc']<3.03673601)  else 52)
                                    if state == 51:
                                        state = (63 if x['magnr_med']<18.0582504 else 64)
                                        if state == 63:
                                            state = (73 if x['magnr_med']<17.682251 else 74)
                                            if state == 73:
                                                state = (85 if x['distpsnr1_med']<0.69568944 else 86)
                                                if state == 85:
                                                    return -0.504000008
                                                if state == 86:
                                                    state = (101 if np.isnan(x['t_lc']) or (x['t_lc']<0.0780034959)  else 102)
                                                    if state == 101:
                                                        return -0.252000004
                                                    if state == 102:
                                                        return 0.507586002
                                            if state == 74:
                                                return -0.554400027
                                        if state == 64:
                                            state = (75 if x['magnr_med']<18.8052502 else 76)
                                            if state == 75:
                                                state = (87 if x['distpsnr1_med']<0.488713324 else 88)
                                                if state == 87:
                                                    return -0.453600019
                                                if state == 88:
                                                    return 0.650646627
                                            if state == 76:
                                                state = (89 if x['distpsnr1_med']<1.28214347 else 90)
                                                if state == 89:
                                                    state = (103 if np.isnan(x['t_lc']) or (x['t_lc']<3.0015626)  else 104)
                                                    if state == 103:
                                                        return -0.624521732
                                                    if state == 104:
                                                        state = (119 if x['distpsnr1_med']<0.284830689 else 120)
                                                        if state == 119:
                                                            return 0.499967992
                                                        if state == 120:
                                                            return -0.252000004
                                                if state == 90:
                                                    state = (105 if np.isnan(x['t_lc']) or (x['t_lc']<2.88651609)  else 106)
                                                    if state == 105:
                                                        return 0.588618279
                                                    if state == 106:
                                                        state = (121 if x['distpsnr1_med']<2.18345737 else 122)
                                                        if state == 121:
                                                            return 0.245569378
                                                        if state == 122:
                                                            return -0.504000008
                                    if state == 52:
                                        return -0.481090903
                                if state == 40:
                                    state = (53 if np.isnan(x['t_lc']) or (x['t_lc']<2.99189234)  else 54)
                                    if state == 53:
                                        state = (65 if x['magnr_med']<20.3062515 else 66)
                                        if state == 65:
                                            state = (77 if x['magnr_med']<18.0335007 else 78)
                                            if state == 77:
                                                return -0.420000017
                                            if state == 78:
                                                state = (91 if x['distpsnr1_med']<1.49141407 else 92)
                                                if state == 91:
                                                    return -0.624521732
                                                if state == 92:
                                                    state = (107 if np.isnan(x['t_lc']) or (x['t_lc']<0.989022017)  else 108)
                                                    if state == 107:
                                                        state = (123 if x['distpsnr1_med']<8.49810123 else 124)
                                                        if state == 123:
                                                            return -0.420000017
                                                        if state == 124:
                                                            return 0.438281804
                                                    if state == 108:
                                                        return 0.590652108
                                        if state == 66:
                                            return -0.540000021
                                    if state == 54:
                                        return -0.671999991
                            if state == 28:
                                state = (41 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.5813828)  else 42)
                                if state == 41:
                                    state = (55 if np.isnan(x['t_lc']) or (x['t_lc']<0.0443113521)  else 56)
                                    if state == 55:
                                        return -0.688799977
                                    if state == 56:
                                        state = (67 if x['magnr_med']<21.4202499 else 68)
                                        if state == 67:
                                            return -0.655200005
                                        if state == 68:
                                            state = (79 if x['magnr_med']<22.7962494 else 80)
                                            if state == 79:
                                                state = (93 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.155175447)  else 94)
                                                if state == 93:
                                                    state = (109 if np.isnan(x['t_lc']) or (x['t_lc']<0.0776504502)  else 110)
                                                    if state == 109:
                                                        return 0.645768046
                                                    if state == 110:
                                                        return -0.540000021
                                                if state == 94:
                                                    state = (111 if np.isnan(x['t_lc']) or (x['t_lc']<0.0505556017)  else 112)
                                                    if state == 111:
                                                        return 0.401929915
                                                    if state == 112:
                                                        state = (125 if x['distpsnr1_med']<4.67712355 else 126)
                                                        if state == 125:
                                                            return 0.0325943939
                                                        if state == 126:
                                                            return -0.540000021
                                            if state == 80:
                                                state = (95 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<12.2965326)  else 96)
                                                if state == 95:
                                                    state = (113 if np.isnan(x['t_lc']) or (x['t_lc']<1.95106483)  else 114)
                                                    if state == 113:
                                                        return -0.324000001
                                                    if state == 114:
                                                        state = (127 if x['distpsnr1_med']<8.59187317 else 128)
                                                        if state == 127:
                                                            return 0.53604126
                                                        if state == 128:
                                                            return -0.252000004
                                                if state == 96:
                                                    return 0.550516844
                                if state == 42:
                                    return -0.69165957
                        if state == 18:
                            state = (29 if x['magnr_med']<19.1669998 else 30)
                            if state == 29:
                                state = (43 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.8858681)  else 44)
                                if state == 43:
                                    return -0.523384631
                                if state == 44:
                                    return 0.499967992
                            if state == 30:
                                state = (45 if x['maggaia_med']<14.3526831 else 46)
                                if state == 45:
                                    return 0.401929915
                                if state == 46:
                                    return -0.636186182
                if state == 6:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<0.00391784962)  else 12)
                    if state == 11:
                        state = (19 if x['distnr_med']<1.49187016 else 20)
                        if state == 19:
                            state = (31 if x['magnr_med']<20.8937492 else 32)
                            if state == 31:
                                return 0.550516844
                            if state == 32:
                                return -0.420000017
                        if state == 20:
                            return -0.743504107
                    if state == 12:
                        state = (21 if x['distnr_med']<0.550524235 else 22)
                        if state == 21:
                            state = (33 if x['magnr_med']<20.6875 else 34)
                            if state == 33:
                                state = (47 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.7718773)  else 48)
                                if state == 47:
                                    state = (57 if np.isnan(x['t_lc']) or (x['t_lc']<0.0346470028)  else 58)
                                    if state == 57:
                                        return -0.377999991
                                    if state == 58:
                                        state = (69 if x['magnr_med']<17.8500004 else 70)
                                        if state == 69:
                                            state = (81 if x['magnr_med']<17.5900002 else 82)
                                            if state == 81:
                                                state = (97 if x['distpsnr1_med']<0.135641724 else 98)
                                                if state == 97:
                                                    return 0.499967992
                                                if state == 98:
                                                    state = (115 if np.isnan(x['t_lc']) or (x['t_lc']<1.50262725)  else 116)
                                                    if state == 115:
                                                        state = (129 if x['distpsnr1_med']<0.312010348 else 130)
                                                        if state == 129:
                                                            return -0.252000004
                                                        if state == 130:
                                                            return 0.499967992
                                                    if state == 116:
                                                        return -0.252000004
                                            if state == 82:
                                                return -0.324000001
                                        if state == 70:
                                            return 0.634498775
                                if state == 48:
                                    return -0.377999991
                            if state == 34:
                                return -0.648000002
                        if state == 22:
                            state = (35 if x['magnr_med']<21.4449997 else 36)
                            if state == 35:
                                return 0.69238615
                            if state == 36:
                                state = (49 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.6311378)  else 50)
                                if state == 49:
                                    state = (59 if np.isnan(x['t_lc']) or (x['t_lc']<0.018020751)  else 60)
                                    if state == 59:
                                        return -0.324000001
                                    if state == 60:
                                        state = (71 if x['magnr_med']<23.0542507 else 72)
                                        if state == 71:
                                            state = (83 if x['magnr_med']<21.581749 else 84)
                                            if state == 83:
                                                return -0.252000004
                                            if state == 84:
                                                state = (99 if x['distpsnr1_med']<0.213159144 else 100)
                                                if state == 99:
                                                    return -0.481090903
                                                if state == 100:
                                                    state = (117 if np.isnan(x['t_lc']) or (x['t_lc']<1.93774307)  else 118)
                                                    if state == 117:
                                                        state = (131 if x['distpsnr1_med']<3.44711828 else 132)
                                                        if state == 131:
                                                            return -0.252000004
                                                        if state == 132:
                                                            return 0.439581215
                                                    if state == 118:
                                                        return 0.59184885
                                        if state == 72:
                                            return -0.420000017
                                if state == 50:
                                    state = (61 if np.isnan(x['t_lc']) or (x['t_lc']<1.98170722)  else 62)
                                    if state == 61:
                                        return -0.578117669
                                    if state == 62:
                                        return 0.318088919
    elif num_booster == 1:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<10.7389936)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<2.48170805 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<18.9760513)  else 8)
                    if state == 7:
                        return -0.535633028
                    if state == 8:
                        state = (15 if x['col_det']<0.526902199 else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.148517996)  else 28)
                            if state == 27:
                                state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<0.0364987999)  else 44)
                                if state == 43:
                                    return -0.390822232
                                if state == 44:
                                    state = (65 if x['distpsnr1_med']<0.963503003 else 66)
                                    if state == 65:
                                        state = (83 if np.isnan(x['t_lc']) or (x['t_lc']<0.0385706015)  else 84)
                                        if state == 83:
                                            return 0.369502753
                                        if state == 84:
                                            return -0.417606145
                                    if state == 66:
                                        state = (85 if np.isnan(x['t_lc']) or (x['t_lc']<0.0384375006)  else 86)
                                        if state == 85:
                                            return 0.440335453
                                        if state == 86:
                                            state = (109 if x['sgscore1_med']<0.0384791493 else 110)
                                            if state == 109:
                                                return 0.359871358
                                            if state == 110:
                                                return -0.302940011
                            if state == 28:
                                state = (45 if np.isnan(x['t_lc']) or (x['t_lc']<0.0412094966)  else 46)
                                if state == 45:
                                    return -0.297750324
                                if state == 46:
                                    return 0.594573557
                        if state == 16:
                            state = (29 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0493124984)  else 30)
                            if state == 29:
                                state = (47 if np.isnan(x['t_lc']) or (x['t_lc']<2.8958621)  else 48)
                                if state == 47:
                                    return -0.422015518
                                if state == 48:
                                    state = (67 if x['distpsnr1_med']<0.558903575 else 68)
                                    if state == 67:
                                        state = (87 if np.isnan(x['t_lc']) or (x['t_lc']<2.96806717)  else 88)
                                        if state == 87:
                                            state = (111 if x['sgscore1_med']<0.010770835 else 112)
                                            if state == 111:
                                                return 0.39311713
                                            if state == 112:
                                                return -0.253452152
                                        if state == 88:
                                            return -0.2821908
                                    if state == 68:
                                        state = (89 if np.isnan(x['t_lc']) or (x['t_lc']<2.9588542)  else 90)
                                        if state == 89:
                                            return 0.593906224
                                        if state == 90:
                                            return -0.233512312
                            if state == 30:
                                state = (49 if np.isnan(x['t_lc']) or (x['t_lc']<3.00618649)  else 50)
                                if state == 49:
                                    return -0.574443102
                                if state == 50:
                                    state = (69 if x['distpsnr1_med']<0.970984042 else 70)
                                    if state == 69:
                                        return -0.491933763
                                    if state == 70:
                                        state = (91 if np.isnan(x['t_lc']) or (x['t_lc']<3.0221529)  else 92)
                                        if state == 91:
                                            return 0.391730934
                                        if state == 92:
                                            return -0.379671365
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.1842499)  else 10)
                    if state == 9:
                        state = (17 if x['col_det']<0.658545494 else 18)
                        if state == 17:
                            state = (31 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.587190509)  else 32)
                            if state == 31:
                                state = (51 if np.isnan(x['t_lc']) or (x['t_lc']<0.00960070081)  else 52)
                                if state == 51:
                                    return -0.425513834
                                if state == 52:
                                    state = (71 if x['distpsnr1_med']<0.462724984 else 72)
                                    if state == 71:
                                        state = (93 if np.isnan(x['t_lc']) or (x['t_lc']<0.0639988482)  else 94)
                                        if state == 93:
                                            return -0.537527025
                                        if state == 94:
                                            state = (113 if x['sgscore1_med']<0.0127083361 else 114)
                                            if state == 113:
                                                return 0.257109374
                                            if state == 114:
                                                return -0.344103932
                                    if state == 72:
                                        return 0.502095938
                            if state == 32:
                                state = (53 if np.isnan(x['t_lc']) or (x['t_lc']<0.107297495)  else 54)
                                if state == 53:
                                    return -0.616161764
                                if state == 54:
                                    return 0.288639754
                        if state == 18:
                            state = (33 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.563592494)  else 34)
                            if state == 33:
                                state = (55 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137730013)  else 56)
                                if state == 55:
                                    state = (73 if x['distpsnr1_med']<0.735778034 else 74)
                                    if state == 73:
                                        state = (95 if np.isnan(x['t_lc']) or (x['t_lc']<0.000457199989)  else 96)
                                        if state == 95:
                                            return 0.316159457
                                        if state == 96:
                                            return -0.170104906
                                    if state == 74:
                                        return -0.524500489
                                if state == 56:
                                    state = (75 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.199287385)  else 76)
                                    if state == 75:
                                        state = (97 if np.isnan(x['t_lc']) or (x['t_lc']<2.98338556)  else 98)
                                        if state == 97:
                                            state = (115 if x['sgscore1_med']<1.00000095 else 116)
                                            if state == 115:
                                                return -0.413392961
                                            if state == 116:
                                                state = (131 if np.isnan(x['rb_med']) or (x['rb_med']<0.63499999)  else 132)
                                                if state == 131:
                                                    state = (151 if np.isnan(x['rb_med']) or (x['rb_med']<0.455833256)  else 152)
                                                    if state == 151:
                                                        return -0.511733949
                                                    if state == 152:
                                                        return -0.148877919
                                                if state == 132:
                                                    return 0.440335453
                                        if state == 98:
                                            state = (117 if x['sgscore1_med']<1.00000095 else 118)
                                            if state == 117:
                                                return -0.443845093
                                            if state == 118:
                                                state = (133 if np.isnan(x['rb_med']) or (x['rb_med']<0.517499983)  else 134)
                                                if state == 133:
                                                    return -0.265842468
                                                if state == 134:
                                                    return 0.445554793
                                    if state == 76:
                                        state = (99 if np.isnan(x['t_lc']) or (x['t_lc']<0.922540545)  else 100)
                                        if state == 99:
                                            state = (119 if x['sgscore1_med']<0.0234375 else 120)
                                            if state == 119:
                                                state = (135 if np.isnan(x['rb_med']) or (x['rb_med']<0.656428576)  else 136)
                                                if state == 135:
                                                    state = (153 if np.isnan(x['rb_med']) or (x['rb_med']<0.427262098)  else 154)
                                                    if state == 153:
                                                        return 0.332560956
                                                    if state == 154:
                                                        return -0.266002953
                                                if state == 136:
                                                    return 0.516921341
                                            if state == 120:
                                                state = (137 if np.isnan(x['rb_med']) or (x['rb_med']<0.927857161)  else 138)
                                                if state == 137:
                                                    return -0.491098195
                                                if state == 138:
                                                    return 0.359871358
                                        if state == 100:
                                            state = (121 if x['sgscore1_med']<0.503708482 else 122)
                                            if state == 121:
                                                state = (139 if np.isnan(x['rb_med']) or (x['rb_med']<0.46416685)  else 140)
                                                if state == 139:
                                                    return -0.52379334
                                                if state == 140:
                                                    state = (155 if np.isnan(x['rb_med']) or (x['rb_med']<0.606666744)  else 156)
                                                    if state == 155:
                                                        return 0.341856807
                                                    if state == 156:
                                                        return 0.479655385
                                            if state == 122:
                                                state = (141 if np.isnan(x['rb_med']) or (x['rb_med']<0.693333387)  else 142)
                                                if state == 141:
                                                    state = (157 if np.isnan(x['rb_med']) or (x['rb_med']<0.375833154)  else 158)
                                                    if state == 157:
                                                        return -0.275078177
                                                    if state == 158:
                                                        return 0.367100894
                                                if state == 142:
                                                    return -0.4653337
                            if state == 34:
                                state = (57 if np.isnan(x['t_lc']) or (x['t_lc']<1.00771999)  else 58)
                                if state == 57:
                                    return -0.553363681
                                if state == 58:
                                    state = (77 if x['distpsnr1_med']<7.74134445 else 78)
                                    if state == 77:
                                        return -0.562971115
                                    if state == 78:
                                        state = (101 if np.isnan(x['t_lc']) or (x['t_lc']<1.52601278)  else 102)
                                        if state == 101:
                                            return 0.39311713
                                        if state == 102:
                                            state = (123 if x['sgscore1_med']<0.860895991 else 124)
                                            if state == 123:
                                                return -0.336394221
                                            if state == 124:
                                                state = (143 if np.isnan(x['rb_med']) or (x['rb_med']<0.692142904)  else 144)
                                                if state == 143:
                                                    return -0.201129079
                                                if state == 144:
                                                    return 0.265402287
                    if state == 10:
                        state = (19 if x['col_det']<-0.262050629 else 20)
                        if state == 19:
                            return -0.489255905
                        if state == 20:
                            state = (35 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.848304033)  else 36)
                            if state == 35:
                                state = (59 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 60)
                                if state == 59:
                                    return -0.517009616
                                if state == 60:
                                    state = (79 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.49141407)  else 80)
                                    if state == 79:
                                        state = (103 if np.isnan(x['t_lc']) or (x['t_lc']<2.91961217)  else 104)
                                        if state == 103:
                                            state = (125 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.207901508)  else 126)
                                            if state == 125:
                                                state = (145 if np.isnan(x['rb_med']) or (x['rb_med']<0.350357234)  else 146)
                                                if state == 145:
                                                    return -0.475341737
                                                if state == 146:
                                                    state = (159 if np.isnan(x['rb_med']) or (x['rb_med']<0.436666727)  else 160)
                                                    if state == 159:
                                                        return 0.429345429
                                                    if state == 160:
                                                        state = (163 if x['col_det']<2.40114307 else 164)
                                                        if state == 163:
                                                            return -0.57329154
                                                        if state == 164:
                                                            return 0.440005839
                                            if state == 126:
                                                return -0.437939525
                                        if state == 104:
                                            return -0.62801671
                                    if state == 80:
                                        state = (105 if np.isnan(x['t_lc']) or (x['t_lc']<0.0129282493)  else 106)
                                        if state == 105:
                                            return -0.436141521
                                        if state == 106:
                                            state = (127 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.000729166495)  else 128)
                                            if state == 127:
                                                return -0.457285643
                                            if state == 128:
                                                state = (147 if np.isnan(x['rb_med']) or (x['rb_med']<0.330357194)  else 148)
                                                if state == 147:
                                                    return -0.550228179
                                                if state == 148:
                                                    state = (161 if np.isnan(x['rb_med']) or (x['rb_med']<0.507500052)  else 162)
                                                    if state == 161:
                                                        state = (165 if x['col_det']<1.05581379 else 166)
                                                        if state == 165:
                                                            return -0.380349219
                                                        if state == 166:
                                                            return 0.245471388
                                                    if state == 162:
                                                        state = (167 if np.isnan(x['col_det']) or (x['col_det']<0.141078949)  else 168)
                                                        if state == 167:
                                                            return 0.469812363
                                                        if state == 168:
                                                            return 0.20466207
                            if state == 36:
                                return -0.580312967
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<11.3691196)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<20.3176498)  else 12)
                    if state == 11:
                        state = (21 if x['col_det']<1.30564213 else 22)
                        if state == 21:
                            return -0.344957739
                        if state == 22:
                            state = (37 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.999374986)  else 38)
                            if state == 37:
                                return -0.42882362
                            if state == 38:
                                return 0.359871358
                    if state == 12:
                        state = (23 if x['col_det']<0.35346508 else 24)
                        if state == 23:
                            return 0.507050335
                        if state == 24:
                            return -0.361785233
                if state == 6:
                    state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<20.4557495)  else 14)
                    if state == 13:
                        state = (25 if x['col_det']<0.0680055618 else 26)
                        if state == 25:
                            state = (39 if x['sgscore1_med']<0.402020991 else 40)
                            if state == 39:
                                return -0.292979509
                            if state == 40:
                                state = (61 if np.isnan(x['t_lc']) or (x['t_lc']<0.0436457992)  else 62)
                                if state == 61:
                                    return -0.32292369
                                if state == 62:
                                    return 0.467085272
                        if state == 26:
                            state = (41 if x['sgscore1_med']<0.542050481 else 42)
                            if state == 41:
                                state = (63 if np.isnan(x['t_lc']) or (x['t_lc']<0.51039356)  else 64)
                                if state == 63:
                                    return -0.539111912
                                if state == 64:
                                    state = (81 if x['distpsnr1_med']<13.8621807 else 82)
                                    if state == 81:
                                        return -0.231517017
                                    if state == 82:
                                        state = (107 if np.isnan(x['t_lc']) or (x['t_lc']<2.98704863)  else 108)
                                        if state == 107:
                                            state = (129 if x['sgscore1_med']<0.0107143 else 130)
                                            if state == 129:
                                                state = (149 if np.isnan(x['rb_med']) or (x['rb_med']<0.49964273)  else 150)
                                                if state == 149:
                                                    return -0.185068339
                                                if state == 150:
                                                    return 0.3840321
                                            if state == 130:
                                                return 0.648638844
                                        if state == 108:
                                            return -0.180126801
                            if state == 42:
                                return -0.549663782
                    if state == 14:
                        return -0.547733188
    elif num_booster == 2:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.583698988)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<1.4944241 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.769249976)  else 8)
                    if state == 7:
                        return -0.48369965
                    if state == 8:
                        state = (15 if x['distnr_med']<0.217259735 else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.968999982)  else 26)
                            if state == 25:
                                state = (41 if np.isnan(x['mag_last']) or (x['mag_last']<19.6214314)  else 42)
                                if state == 41:
                                    return 0.279071003
                                if state == 42:
                                    return -0.356589079
                            if state == 26:
                                return 0.479248554
                        if state == 16:
                            state = (27 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.989249945)  else 28)
                            if state == 27:
                                state = (43 if np.isnan(x['mag_last']) or (x['mag_last']<18.0600243)  else 44)
                                if state == 43:
                                    return -0.430574983
                                if state == 44:
                                    state = (65 if x['maggaia_med']<17.3263988 else 66)
                                    if state == 65:
                                        return -0.410596788
                                    if state == 66:
                                        state = (91 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.935500026)  else 92)
                                        if state == 91:
                                            state = (119 if np.isnan(x['mag_last']) or (x['mag_last']<19.7539902)  else 120)
                                            if state == 119:
                                                state = (147 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.861999989)  else 148)
                                                if state == 147:
                                                    state = (169 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790000021)  else 170)
                                                    if state == 169:
                                                        return 0.3821913
                                                    if state == 170:
                                                        state = (185 if np.isnan(x['rb_med']) or (x['rb_med']<0.630833268)  else 186)
                                                        if state == 185:
                                                            return -0.165804729
                                                        if state == 186:
                                                            return 0.280249
                                                if state == 148:
                                                    state = (171 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.888999999)  else 172)
                                                    if state == 171:
                                                        return -0.373289376
                                                    if state == 172:
                                                        return 0.224609002
                                            if state == 120:
                                                return -0.484253049
                                        if state == 92:
                                            return 0.469139636
                            if state == 28:
                                return -0.419505149
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.862749994)  else 10)
                    if state == 9:
                        state = (17 if x['distnr_med']<5.28807306 else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.704750001)  else 30)
                            if state == 29:
                                state = (45 if np.isnan(x['mag_last']) or (x['mag_last']<20.0196495)  else 46)
                                if state == 45:
                                    state = (67 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.8064156)  else 68)
                                    if state == 67:
                                        return -0.488439351
                                    if state == 68:
                                        state = (93 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.471249998)  else 94)
                                        if state == 93:
                                            return -0.433434516
                                        if state == 94:
                                            state = (121 if np.isnan(x['mag_last']) or (x['mag_last']<19.0614109)  else 122)
                                            if state == 121:
                                                return -0.390933573
                                            if state == 122:
                                                return 0.540315568
                                if state == 46:
                                    state = (69 if x['maggaia_med']<41.6919403 else 70)
                                    if state == 69:
                                        return -0.546432674
                                    if state == 70:
                                        state = (95 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.644250035)  else 96)
                                        if state == 95:
                                            return -0.49246031
                                        if state == 96:
                                            state = (123 if np.isnan(x['mag_last']) or (x['mag_last']<20.6267509)  else 124)
                                            if state == 123:
                                                return -0.254322559
                                            if state == 124:
                                                state = (149 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.656499982)  else 150)
                                                if state == 149:
                                                    return 0.302703917
                                                if state == 150:
                                                    return -0.18563351
                            if state == 30:
                                state = (47 if np.isnan(x['mag_last']) or (x['mag_last']<20.1041756)  else 48)
                                if state == 47:
                                    state = (71 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<14.3206472)  else 72)
                                    if state == 71:
                                        state = (97 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.726750016)  else 98)
                                        if state == 97:
                                            return 0.398385406
                                        if state == 98:
                                            state = (125 if np.isnan(x['mag_last']) or (x['mag_last']<19.9782143)  else 126)
                                            if state == 125:
                                                return -0.471193224
                                            if state == 126:
                                                return 0.365389973
                                    if state == 72:
                                        state = (99 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.854249954)  else 100)
                                        if state == 99:
                                            state = (127 if np.isnan(x['mag_last']) or (x['mag_last']<18.981039)  else 128)
                                            if state == 127:
                                                return -0.302089602
                                            if state == 128:
                                                return 0.461247653
                                        if state == 100:
                                            return -0.177819595
                                if state == 48:
                                    state = (73 if x['maggaia_med']<18.5569992 else 74)
                                    if state == 73:
                                        return -0.515016079
                                    if state == 74:
                                        state = (101 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.713249981)  else 102)
                                        if state == 101:
                                            return 0.329733968
                                        if state == 102:
                                            state = (129 if np.isnan(x['mag_last']) or (x['mag_last']<20.4561672)  else 130)
                                            if state == 129:
                                                state = (151 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.777500033)  else 152)
                                                if state == 151:
                                                    return -0.395697683
                                                if state == 152:
                                                    state = (173 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.797250032)  else 174)
                                                    if state == 173:
                                                        return 0.319924682
                                                    if state == 174:
                                                        state = (187 if np.isnan(x['rb_med']) or (x['rb_med']<0.489285588)  else 188)
                                                        if state == 187:
                                                            return 0.157753184
                                                        if state == 188:
                                                            return -0.298433125
                                            if state == 130:
                                                return -0.482771307
                        if state == 18:
                            state = (31 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.605250001)  else 32)
                            if state == 31:
                                return -0.50653553
                            if state == 32:
                                state = (49 if np.isnan(x['mag_last']) or (x['mag_last']<18.6690216)  else 50)
                                if state == 49:
                                    return 0.496867776
                                if state == 50:
                                    state = (75 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.9962044)  else 76)
                                    if state == 75:
                                        state = (103 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.621250033)  else 104)
                                        if state == 103:
                                            return 0.292236894
                                        if state == 104:
                                            state = (131 if np.isnan(x['mag_last']) or (x['mag_last']<20.1618195)  else 132)
                                            if state == 131:
                                                state = (153 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790750027)  else 154)
                                                if state == 153:
                                                    return -0.382464051
                                                if state == 154:
                                                    state = (175 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.800499976)  else 176)
                                                    if state == 175:
                                                        return 0.326271355
                                                    if state == 176:
                                                        return -0.395097762
                                            if state == 132:
                                                return -0.519704998
                                    if state == 76:
                                        state = (105 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.634000003)  else 106)
                                        if state == 105:
                                            return 0.543941021
                                        if state == 106:
                                            return -0.38154757
                    if state == 10:
                        state = (19 if x['distnr_med']<5.37503242 else 20)
                        if state == 19:
                            state = (33 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.991750002)  else 34)
                            if state == 33:
                                state = (51 if np.isnan(x['mag_last']) or (x['mag_last']<20.0568619)  else 52)
                                if state == 51:
                                    state = (77 if x['maggaia_med']<13.3895779 else 78)
                                    if state == 77:
                                        return -0.196859151
                                    if state == 78:
                                        state = (107 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.925249994)  else 108)
                                        if state == 107:
                                            state = (133 if np.isnan(x['mag_last']) or (x['mag_last']<18.0563507)  else 134)
                                            if state == 133:
                                                return -0.280854464
                                            if state == 134:
                                                return 0.477373064
                                        if state == 108:
                                            state = (135 if np.isnan(x['mag_last']) or (x['mag_last']<19.9009285)  else 136)
                                            if state == 135:
                                                state = (155 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.959250033)  else 156)
                                                if state == 155:
                                                    state = (177 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.935249984)  else 178)
                                                    if state == 177:
                                                        state = (189 if np.isnan(x['rb_med']) or (x['rb_med']<0.541547656)  else 190)
                                                        if state == 189:
                                                            return 0.212715566
                                                        if state == 190:
                                                            return -0.322183371
                                                    if state == 178:
                                                        state = (191 if np.isnan(x['rb_med']) or (x['rb_med']<0.492619216)  else 192)
                                                        if state == 191:
                                                            return -0.285706043
                                                        if state == 192:
                                                            return 0.283897012
                                                if state == 156:
                                                    return 0.431718498
                                            if state == 136:
                                                state = (157 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.966749966)  else 158)
                                                if state == 157:
                                                    state = (179 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.963)  else 180)
                                                    if state == 179:
                                                        state = (193 if np.isnan(x['rb_med']) or (x['rb_med']<0.539880872)  else 194)
                                                        if state == 193:
                                                            return 0.234962106
                                                        if state == 194:
                                                            return -0.454740763
                                                    if state == 180:
                                                        return 0.286736727
                                                if state == 158:
                                                    return -0.434928268
                                if state == 52:
                                    state = (79 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<15.8687744)  else 80)
                                    if state == 79:
                                        state = (109 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.966750026)  else 110)
                                        if state == 109:
                                            state = (137 if np.isnan(x['mag_last']) or (x['mag_last']<20.2963715)  else 138)
                                            if state == 137:
                                                return -0.802166283
                                            if state == 138:
                                                state = (159 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.919749975)  else 160)
                                                if state == 159:
                                                    return -0.398995757
                                                if state == 160:
                                                    return 0.184045523
                                        if state == 110:
                                            state = (139 if np.isnan(x['mag_last']) or (x['mag_last']<20.2140579)  else 140)
                                            if state == 139:
                                                return 0.235714212
                                            if state == 140:
                                                return -0.288385838
                                    if state == 80:
                                        state = (111 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.973999977)  else 112)
                                        if state == 111:
                                            state = (141 if np.isnan(x['mag_last']) or (x['mag_last']<20.2123146)  else 142)
                                            if state == 141:
                                                state = (161 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.918750048)  else 162)
                                                if state == 161:
                                                    state = (181 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.910000026)  else 182)
                                                    if state == 181:
                                                        return -0.437346369
                                                    if state == 182:
                                                        return 0.286736727
                                                if state == 162:
                                                    return -0.388287753
                                            if state == 142:
                                                state = (163 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.904999971)  else 164)
                                                if state == 163:
                                                    return 0.398887068
                                                if state == 164:
                                                    return -0.332234383
                                        if state == 112:
                                            return 0.455755293
                            if state == 34:
                                state = (53 if np.isnan(x['mag_last']) or (x['mag_last']<17.9159546)  else 54)
                                if state == 53:
                                    return -0.434257925
                                if state == 54:
                                    state = (81 if x['maggaia_med']<18.0728722 else 82)
                                    if state == 81:
                                        return 0.289860636
                                    if state == 82:
                                        return -0.269446254
                        if state == 20:
                            state = (35 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.958500028)  else 36)
                            if state == 35:
                                state = (55 if np.isnan(x['mag_last']) or (x['mag_last']<19.2435646)  else 56)
                                if state == 55:
                                    return 0.227804258
                                if state == 56:
                                    return -0.474656612
                            if state == 36:
                                state = (57 if np.isnan(x['mag_last']) or (x['mag_last']<20.0351467)  else 58)
                                if state == 57:
                                    state = (83 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.1673222)  else 84)
                                    if state == 83:
                                        state = (113 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.989499986)  else 114)
                                        if state == 113:
                                            return 0.258677781
                                        if state == 114:
                                            return -0.258484125
                                    if state == 84:
                                        state = (115 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.962749958)  else 116)
                                        if state == 115:
                                            state = (143 if np.isnan(x['mag_last']) or (x['mag_last']<19.5403042)  else 144)
                                            if state == 143:
                                                return 0.286736727
                                            if state == 144:
                                                return -0.163997591
                                        if state == 116:
                                            return -0.500629425
                                if state == 58:
                                    state = (85 if x['maggaia_med']<41.4342422 else 86)
                                    if state == 85:
                                        return -0.123935089
                                    if state == 86:
                                        return 0.433203042
            if state == 2:
                state = (5 if x['neargaia_med']<175.897018 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.694499969)  else 12)
                    if state == 11:
                        return -0.497782886
                    if state == 12:
                        state = (21 if x['distnr_med']<3.12265515 else 22)
                        if state == 21:
                            return -0.488063544
                        if state == 22:
                            state = (37 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.734500051)  else 38)
                            if state == 37:
                                state = (59 if np.isnan(x['mag_last']) or (x['mag_last']<19.5992508)  else 60)
                                if state == 59:
                                    return 0.436408252
                                if state == 60:
                                    state = (87 if x['maggaia_med']<14.8100414 else 88)
                                    if state == 87:
                                        return 0.310672551
                                    if state == 88:
                                        return -0.360757411
                            if state == 38:
                                state = (61 if np.isnan(x['mag_last']) or (x['mag_last']<19.8240395)  else 62)
                                if state == 61:
                                    state = (89 if x['maggaia_med']<18.0131149 else 90)
                                    if state == 89:
                                        state = (117 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.980750024)  else 118)
                                        if state == 117:
                                            state = (145 if np.isnan(x['mag_last']) or (x['mag_last']<19.6159401)  else 146)
                                            if state == 145:
                                                state = (165 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.979750037)  else 166)
                                                if state == 165:
                                                    return -0.348838538
                                                if state == 166:
                                                    return 0.333974898
                                            if state == 146:
                                                state = (167 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.933000028)  else 168)
                                                if state == 167:
                                                    return 0.528515875
                                                if state == 168:
                                                    state = (183 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.952000022)  else 184)
                                                    if state == 183:
                                                        return -0.121522956
                                                    if state == 184:
                                                        return 0.279348522
                                        if state == 118:
                                            return -0.284214467
                                    if state == 90:
                                        return -0.487477481
                                if state == 62:
                                    return -0.478948772
                if state == 6:
                    state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.863749981)  else 14)
                    if state == 13:
                        return -0.389056921
                    if state == 14:
                        state = (23 if x['distnr_med']<4.65449381 else 24)
                        if state == 23:
                            return -0.282101244
                        if state == 24:
                            state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.898000002)  else 40)
                            if state == 39:
                                return 0.320778906
                            if state == 40:
                                state = (63 if np.isnan(x['mag_last']) or (x['mag_last']<19.2767391)  else 64)
                                if state == 63:
                                    return 0.240317553
                                if state == 64:
                                    return -0.290786207
    elif num_booster == 3:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.583467007)  else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.0677321479 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.904681683)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<19.7026329)  else 16)
                        if state == 15:
                            state = (27 if x['sgscore1_med']<0.046583347 else 28)
                            if state == 27:
                                return 0.432207823
                            if state == 28:
                                return -0.294790924
                        if state == 16:
                            state = (29 if x['sgscore1_med']<0.00760417012 else 30)
                            if state == 29:
                                return -0.498312742
                            if state == 30:
                                state = (47 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0200636983)  else 48)
                                if state == 47:
                                    state = (71 if np.isnan(x['mag_last']) or (x['mag_last']<20.0331402)  else 72)
                                    if state == 71:
                                        return 0.214094326
                                    if state == 72:
                                        return -0.235890627
                                if state == 48:
                                    state = (73 if np.isnan(x['mag_last']) or (x['mag_last']<19.8961201)  else 74)
                                    if state == 73:
                                        state = (103 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.900500059)  else 104)
                                        if state == 103:
                                            return 0.064586401
                                        if state == 104:
                                            return -0.203075334
                                    if state == 74:
                                        return -0.470141619
                    if state == 8:
                        state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<20.2238445)  else 18)
                        if state == 17:
                            state = (31 if x['sgscore1_med']<0.0314582996 else 32)
                            if state == 31:
                                state = (49 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.87614584)  else 50)
                                if state == 49:
                                    state = (75 if np.isnan(x['mag_last']) or (x['mag_last']<19.8596764)  else 76)
                                    if state == 75:
                                        state = (105 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.819500029)  else 106)
                                        if state == 105:
                                            return -0.226859868
                                        if state == 106:
                                            state = (137 if x['col_det']<0.000001 else 138)
                                            if state == 137:
                                                return 0.069418028
                                            if state == 138:
                                                state = (163 if x['magnr_med']<18.6407509 else 164)
                                                if state == 163:
                                                    return -0.149570301
                                                if state == 164:
                                                    return 0.334182233
                                    if state == 76:
                                        return -0.341763347
                                if state == 50:
                                    state = (77 if np.isnan(x['mag_last']) or (x['mag_last']<20.1008663)  else 78)
                                    if state == 77:
                                        state = (107 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.740750015)  else 108)
                                        if state == 107:
                                            return -0.306616277
                                        if state == 108:
                                            return 0.371135443
                                    if state == 78:
                                        state = (109 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.818000019)  else 110)
                                        if state == 109:
                                            state = (139 if x['col_det']<0.268312454 else 140)
                                            if state == 139:
                                                return 0.23346813
                                            if state == 140:
                                                return -0.213721216
                                        if state == 110:
                                            return -0.373474807
                            if state == 32:
                                state = (51 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98637152)  else 52)
                                if state == 51:
                                    state = (79 if np.isnan(x['mag_last']) or (x['mag_last']<19.2494755)  else 80)
                                    if state == 79:
                                        state = (111 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.870249987)  else 112)
                                        if state == 111:
                                            return -0.178031474
                                        if state == 112:
                                            return 0.241712645
                                    if state == 80:
                                        state = (113 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.659250021)  else 114)
                                        if state == 113:
                                            state = (141 if np.isnan(x['col_det']) or (x['col_det']<0.28326416)  else 142)
                                            if state == 141:
                                                return -0.146526113
                                            if state == 142:
                                                return 0.330199957
                                        if state == 114:
                                            return 0.529327154
                                if state == 52:
                                    state = (81 if np.isnan(x['mag_last']) or (x['mag_last']<18.2931061)  else 82)
                                    if state == 81:
                                        return -0.201893777
                                    if state == 82:
                                        state = (115 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.975499988)  else 116)
                                        if state == 115:
                                            state = (143 if np.isnan(x['col_det']) or (x['col_det']<0.219976425)  else 144)
                                            if state == 143:
                                                return 0.451895565
                                            if state == 144:
                                                return -0.28677243
                                        if state == 116:
                                            state = (145 if x['col_det']<0.000001 else 146)
                                            if state == 145:
                                                return -0.272070527
                                            if state == 146:
                                                return 0.236684322
                        if state == 18:
                            state = (33 if x['sgscore1_med']<0.01672915 else 34)
                            if state == 33:
                                return -0.487785399
                            if state == 34:
                                state = (53 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.954427)  else 54)
                                if state == 53:
                                    return -0.343664527
                                if state == 54:
                                    state = (83 if np.isnan(x['mag_last']) or (x['mag_last']<20.4765472)  else 84)
                                    if state == 83:
                                        state = (117 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.852999926)  else 118)
                                        if state == 117:
                                            return -0.280433863
                                        if state == 118:
                                            return 0.326037675
                                    if state == 84:
                                        return -0.24800846
                if state == 4:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.83414364)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<19.5829639)  else 20)
                        if state == 19:
                            state = (35 if x['sgscore1_med']<0.147565514 else 36)
                            if state == 35:
                                state = (55 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.00159724988)  else 56)
                                if state == 55:
                                    return 0.264061213
                                if state == 56:
                                    return -0.347535908
                            if state == 36:
                                state = (57 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.93331599)  else 58)
                                if state == 57:
                                    state = (85 if np.isnan(x['mag_last']) or (x['mag_last']<16.85532)  else 86)
                                    if state == 85:
                                        return -0.360254318
                                    if state == 86:
                                        state = (119 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.696500063)  else 120)
                                        if state == 119:
                                            state = (147 if x['col_det']<5.69426823 else 148)
                                            if state == 147:
                                                return -0.197562084
                                            if state == 148:
                                                state = (165 if x['magnr_med']<18.444252 else 166)
                                                if state == 165:
                                                    return -0.236365288
                                                if state == 166:
                                                    return 0.103214748
                                        if state == 120:
                                            return 0.399631858
                                if state == 58:
                                    return -0.366270751
                        if state == 20:
                            state = (37 if x['sgscore1_med']<1.15911508 else 38)
                            if state == 37:
                                return -0.504573882
                            if state == 38:
                                state = (59 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0671122968)  else 60)
                                if state == 59:
                                    return -0.500901103
                                if state == 60:
                                    state = (87 if np.isnan(x['mag_last']) or (x['mag_last']<20.4715996)  else 88)
                                    if state == 87:
                                        state = (121 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.722249985)  else 122)
                                        if state == 121:
                                            return 0.327543885
                                        if state == 122:
                                            return -0.246596009
                                    if state == 88:
                                        return -0.33244732
                    if state == 10:
                        state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<18.3611679)  else 22)
                        if state == 21:
                            state = (39 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.145294502)  else 40)
                            if state == 39:
                                return -0.504649162
                            if state == 40:
                                state = (61 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01383686)  else 62)
                                if state == 61:
                                    state = (89 if np.isnan(x['mag_last']) or (x['mag_last']<16.7984676)  else 90)
                                    if state == 89:
                                        state = (123 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.99000001)  else 124)
                                        if state == 123:
                                            state = (149 if np.isnan(x['col_det']) or (x['col_det']<-0.0304689407)  else 150)
                                            if state == 149:
                                                state = (167 if x['magnr_med']<16.3285007 else 168)
                                                if state == 167:
                                                    return -0.300522268
                                                if state == 168:
                                                    return 0.301174164
                                            if state == 150:
                                                return -0.297624409
                                        if state == 124:
                                            return -0.356684119
                                    if state == 90:
                                        return -0.45812127
                                if state == 62:
                                    state = (91 if np.isnan(x['mag_last']) or (x['mag_last']<17.2647095)  else 92)
                                    if state == 91:
                                        return -0.321961284
                                    if state == 92:
                                        state = (125 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.754000008)  else 126)
                                        if state == 125:
                                            return -0.128818929
                                        if state == 126:
                                            return 0.473211735
                        if state == 22:
                            state = (41 if x['sgscore1_med']<0.412187517 else 42)
                            if state == 41:
                                state = (63 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97938657)  else 64)
                                if state == 63:
                                    state = (93 if np.isnan(x['mag_last']) or (x['mag_last']<20.1524239)  else 94)
                                    if state == 93:
                                        state = (127 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.962499976)  else 128)
                                        if state == 127:
                                            state = (151 if np.isnan(x['col_det']) or (x['col_det']<0.159308434)  else 152)
                                            if state == 151:
                                                return -0.435912222
                                            if state == 152:
                                                state = (169 if x['magnr_med']<18.3069992 else 170)
                                                if state == 169:
                                                    return -0.287729532
                                                if state == 170:
                                                    return 0.218708515
                                        if state == 128:
                                            state = (153 if x['col_det']<0.620513916 else 154)
                                            if state == 153:
                                                state = (171 if x['magnr_med']<20.7407494 else 172)
                                                if state == 171:
                                                    return 0.392789781
                                                if state == 172:
                                                    return -0.25500387
                                            if state == 154:
                                                state = (173 if x['magnr_med']<17.7905006 else 174)
                                                if state == 173:
                                                    return -0.298990607
                                                if state == 174:
                                                    state = (185 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95905662)  else 186)
                                                    if state == 185:
                                                        return -0.163357377
                                                    if state == 186:
                                                        return 0.198489815
                                    if state == 94:
                                        state = (129 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.628499985)  else 130)
                                        if state == 129:
                                            return -0.248671085
                                        if state == 130:
                                            state = (155 if np.isnan(x['col_det']) or (x['col_det']<-0.181976318)  else 156)
                                            if state == 155:
                                                return -0.217910692
                                            if state == 156:
                                                state = (175 if x['magnr_med']<20.4125004 else 176)
                                                if state == 175:
                                                    return 0.55056417
                                                if state == 176:
                                                    return 0.163156867
                                if state == 64:
                                    state = (95 if np.isnan(x['mag_last']) or (x['mag_last']<19.8725662)  else 96)
                                    if state == 95:
                                        state = (131 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.940750003)  else 132)
                                        if state == 131:
                                            return -0.435085565
                                        if state == 132:
                                            return 0.383871645
                                    if state == 96:
                                        return -0.38883394
                            if state == 42:
                                state = (65 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.87331009)  else 66)
                                if state == 65:
                                    state = (97 if np.isnan(x['mag_last']) or (x['mag_last']<20.3943825)  else 98)
                                    if state == 97:
                                        return 0.436977595
                                    if state == 98:
                                        return -0.13436158
                                if state == 66:
                                    state = (99 if np.isnan(x['mag_last']) or (x['mag_last']<20.4551353)  else 100)
                                    if state == 99:
                                        state = (133 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.828249991)  else 134)
                                        if state == 133:
                                            state = (157 if np.isnan(x['col_det']) or (x['col_det']<-0.0390138626)  else 158)
                                            if state == 157:
                                                state = (177 if x['magnr_med']<20.0929985 else 178)
                                                if state == 177:
                                                    state = (187 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.94005799)  else 188)
                                                    if state == 187:
                                                        return 0.331872493
                                                    if state == 188:
                                                        return -0.317463934
                                                if state == 178:
                                                    return -0.356918722
                                            if state == 158:
                                                state = (179 if x['magnr_med']<20.6167507 else 180)
                                                if state == 179:
                                                    state = (189 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95507526)  else 190)
                                                    if state == 189:
                                                        return -0.236327931
                                                    if state == 190:
                                                        return 0.380802929
                                                if state == 180:
                                                    state = (191 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98032403)  else 192)
                                                    if state == 191:
                                                        return 0.208606854
                                                    if state == 192:
                                                        return -0.167195573
                                        if state == 134:
                                            state = (159 if x['col_det']<0.546753883 else 160)
                                            if state == 159:
                                                state = (181 if x['magnr_med']<21.1362495 else 182)
                                                if state == 181:
                                                    state = (193 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.04462385)  else 194)
                                                    if state == 193:
                                                        return 0.411220759
                                                    if state == 194:
                                                        return 0.101614833
                                                if state == 182:
                                                    state = (195 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91370964)  else 196)
                                                    if state == 195:
                                                        return -0.342163324
                                                    if state == 196:
                                                        state = (199 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.52501899)  else 200)
                                                        if state == 199:
                                                            return 0.388602972
                                                        if state == 200:
                                                            return -0.150871664
                                            if state == 160:
                                                state = (183 if x['magnr_med']<20.8027496 else 184)
                                                if state == 183:
                                                    return 0.333280027
                                                if state == 184:
                                                    state = (197 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92668986)  else 198)
                                                    if state == 197:
                                                        return -0.419950575
                                                    if state == 198:
                                                        state = (201 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.48990202)  else 202)
                                                        if state == 201:
                                                            return -0.159441903
                                                        if state == 202:
                                                            return 0.103247404
                                    if state == 100:
                                        state = (135 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.656499982)  else 136)
                                        if state == 135:
                                            state = (161 if x['col_det']<-0.181599617 else 162)
                                            if state == 161:
                                                return 0.307657689
                                            if state == 162:
                                                return -0.337374181
                                        if state == 136:
                                            return -0.446035594
            if state == 2:
                state = (5 if x['sgscore1_med']<0.873729467 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.40126157)  else 12)
                    if state == 11:
                        return -0.429320902
                    if state == 12:
                        state = (23 if np.isnan(x['mag_last']) or (x['mag_last']<19.4309006)  else 24)
                        if state == 23:
                            state = (43 if x['sgscore1_med']<0.842774034 else 44)
                            if state == 43:
                                state = (67 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8495717)  else 68)
                                if state == 67:
                                    return 0.394397378
                                if state == 68:
                                    return -0.381542981
                            if state == 44:
                                return 0.378758729
                        if state == 24:
                            return -0.365785778
                if state == 6:
                    state = (13 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0386458486)  else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['mag_last']) or (x['mag_last']<20.168869)  else 26)
                        if state == 25:
                            state = (45 if x['sgscore1_med']<0.985520959 else 46)
                            if state == 45:
                                state = (69 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0385879502)  else 70)
                                if state == 69:
                                    state = (101 if np.isnan(x['mag_last']) or (x['mag_last']<20.1636658)  else 102)
                                    if state == 101:
                                        return -0.276668668
                                    if state == 102:
                                        return 0.277325392
                                if state == 70:
                                    return 0.289631426
                            if state == 46:
                                return -0.312166512
                        if state == 26:
                            return -0.382059872
                    if state == 14:
                        return -0.434543401
    elif num_booster == 4:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.79261589)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.22621965)  else 4)
                if state == 3:
                    state = (7 if x['col_det']<-0.0380010605 else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<18.4795494)  else 16)
                        if state == 15:
                            state = (29 if x['distpsnr1_med']<4.03579187 else 30)
                            if state == 29:
                                return -0.111925222
                            if state == 30:
                                return 0.190693349
                        if state == 16:
                            return -0.509129465
                    if state == 8:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<17.917099)  else 18)
                        if state == 17:
                            return -0.380851865
                        if state == 18:
                            state = (31 if x['distpsnr1_med']<2.47215748 else 32)
                            if state == 31:
                                state = (45 if x['sgscore1_med']<0.0395833477 else 46)
                                if state == 45:
                                    state = (67 if x['distpsnr1_med']<2.122648 else 68)
                                    if state == 67:
                                        state = (87 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0437673479)  else 88)
                                        if state == 87:
                                            state = (113 if x['maggaia_med']<19.0309105 else 114)
                                            if state == 113:
                                                return 0.364648998
                                            if state == 114:
                                                return -0.0888921618
                                        if state == 88:
                                            state = (115 if x['maggaia_med']<18.7192249 else 116)
                                            if state == 115:
                                                return 0.188443512
                                            if state == 116:
                                                return -0.372982115
                                    if state == 68:
                                        return -0.173631638
                                if state == 46:
                                    state = (69 if x['distpsnr1_med']<0.257383138 else 70)
                                    if state == 69:
                                        state = (89 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0227604508)  else 90)
                                        if state == 89:
                                            return 0.429217607
                                        if state == 90:
                                            state = (117 if x['maggaia_med']<41.0752945 else 118)
                                            if state == 117:
                                                return -0.310581535
                                            if state == 118:
                                                return 0.0840574726
                                    if state == 70:
                                        state = (91 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.937314808)  else 92)
                                        if state == 91:
                                            state = (119 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.3302193)  else 120)
                                            if state == 119:
                                                return -0.470925868
                                            if state == 120:
                                                return 0.192394421
                                        if state == 92:
                                            state = (121 if x['maggaia_med']<18.9771423 else 122)
                                            if state == 121:
                                                return -0.378786802
                                            if state == 122:
                                                return 0.197467297
                            if state == 32:
                                state = (47 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.525550485)  else 48)
                                if state == 47:
                                    state = (71 if x['distpsnr1_med']<2.75047493 else 72)
                                    if state == 71:
                                        return 0.336949587
                                    if state == 72:
                                        state = (93 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.565069437)  else 94)
                                        if state == 93:
                                            state = (123 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.3522797)  else 124)
                                            if state == 123:
                                                return 0.275598139
                                            if state == 124:
                                                return -0.241641313
                                        if state == 94:
                                            state = (125 if x['maggaia_med']<18.848011 else 126)
                                            if state == 125:
                                                return 0.193309933
                                            if state == 126:
                                                return -0.469498277
                                if state == 48:
                                    return -0.294958979
                if state == 4:
                    state = (9 if np.isnan(x['col_det']) or (x['col_det']<0.202965736)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.8490505)  else 20)
                        if state == 19:
                            return -0.432072431
                        if state == 20:
                            state = (33 if x['distpsnr1_med']<10.3451653 else 34)
                            if state == 33:
                                state = (49 if x['sgscore1_med']<0.982396007 else 50)
                                if state == 49:
                                    state = (73 if x['distpsnr1_med']<7.96378994 else 74)
                                    if state == 73:
                                        state = (95 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.532592535)  else 96)
                                        if state == 95:
                                            return -0.409516126
                                        if state == 96:
                                            state = (127 if x['maggaia_med']<17.4416676 else 128)
                                            if state == 127:
                                                return 0.19449231
                                            if state == 128:
                                                return -0.182614028
                                    if state == 74:
                                        state = (97 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.476313591)  else 98)
                                        if state == 97:
                                            state = (129 if x['maggaia_med']<19.102169 else 130)
                                            if state == 129:
                                                return 0.320985287
                                            if state == 130:
                                                return -0.337549299
                                        if state == 98:
                                            return -0.264003664
                                if state == 50:
                                    return -0.357474059
                            if state == 34:
                                return -0.349092662
                    if state == 10:
                        state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<20.3627892)  else 22)
                        if state == 21:
                            return -0.158335075
                        if state == 22:
                            return 0.264921039
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.407602638 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['col_det']) or (x['col_det']<-0.054444313)  else 12)
                    if state == 11:
                        return -0.433628172
                    if state == 12:
                        state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<19.6170502)  else 24)
                        if state == 23:
                            state = (35 if x['distpsnr1_med']<0.105146483 else 36)
                            if state == 35:
                                return -0.330286145
                            if state == 36:
                                state = (51 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0336041972)  else 52)
                                if state == 51:
                                    return 0.443839461
                                if state == 52:
                                    return -0.310064226
                        if state == 24:
                            return -0.359846801
                if state == 6:
                    state = (13 if x['col_det']<0.460152626 else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['mag_det']) or (x['mag_det']<18.2626495)  else 26)
                        if state == 25:
                            state = (37 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.46097565)  else 38)
                            if state == 37:
                                return -0.384784222
                            if state == 38:
                                state = (53 if x['sgscore1_med']<0.621708512 else 54)
                                if state == 53:
                                    return 0.172272652
                                if state == 54:
                                    return -0.252646565
                        if state == 26:
                            state = (39 if x['distpsnr1_med']<5.57307434 else 40)
                            if state == 39:
                                state = (55 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.64796102)  else 56)
                                if state == 55:
                                    state = (77 if x['distpsnr1_med']<1.3105793 else 78)
                                    if state == 77:
                                        state = (99 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0158565)  else 100)
                                        if state == 99:
                                            state = (131 if x['maggaia_med']<17.7026653 else 132)
                                            if state == 131:
                                                state = (151 if x['col_det']<0.000515937805 else 152)
                                                if state == 151:
                                                    state = (167 if x['distpsnr1_med']<0.917149544 else 168)
                                                    if state == 167:
                                                        return 0.172690406
                                                    if state == 168:
                                                        return -0.143678039
                                                if state == 152:
                                                    return -0.304304898
                                            if state == 132:
                                                return 0.350381464
                                        if state == 100:
                                            return -0.0160259288
                                    if state == 78:
                                        return 0.364842832
                                if state == 56:
                                    return -0.147250652
                            if state == 40:
                                state = (57 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.843657494)  else 58)
                                if state == 57:
                                    state = (79 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<8.48143768)  else 80)
                                    if state == 79:
                                        state = (101 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02112865)  else 102)
                                        if state == 101:
                                            state = (133 if x['maggaia_med']<17.7910748 else 134)
                                            if state == 133:
                                                return -0.331439912
                                            if state == 134:
                                                state = (153 if x['col_det']<-0.562947273 else 154)
                                                if state == 153:
                                                    return -0.235516042
                                                if state == 154:
                                                    state = (169 if x['distpsnr1_med']<5.89941406 else 170)
                                                    if state == 169:
                                                        return -0.344584733
                                                    if state == 170:
                                                        state = (183 if x['distnr_med']<0.754777491 else 184)
                                                        if state == 183:
                                                            return 0.088496238
                                                        if state == 184:
                                                            return 0.269196212
                                        if state == 102:
                                            return -0.370423168
                                    if state == 80:
                                        state = (103 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98225689)  else 104)
                                        if state == 103:
                                            state = (135 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.2002468)  else 136)
                                            if state == 135:
                                                return 0.403344125
                                            if state == 136:
                                                return -0.290210545
                                        if state == 104:
                                            state = (137 if x['maggaia_med']<17.4395409 else 138)
                                            if state == 137:
                                                return 0.183807746
                                            if state == 138:
                                                return -0.178610623
                                if state == 58:
                                    return -0.32753852
                    if state == 14:
                        state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<18.4298496)  else 28)
                        if state == 27:
                            state = (41 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<3.13899136)  else 42)
                            if state == 41:
                                state = (59 if x['sgscore1_med']<0.0390208513 else 60)
                                if state == 59:
                                    return 0.192107841
                                if state == 60:
                                    state = (81 if x['distpsnr1_med']<0.692079663 else 82)
                                    if state == 81:
                                        state = (105 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91653943)  else 106)
                                        if state == 105:
                                            return 0.203371972
                                        if state == 106:
                                            return -0.324404359
                                    if state == 82:
                                        return -0.418171078
                            if state == 42:
                                state = (61 if x['sgscore1_med']<0.738208532 else 62)
                                if state == 61:
                                    return 0.242156446
                                if state == 62:
                                    return -0.145850599
                        if state == 28:
                            state = (43 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<7.63257885)  else 44)
                            if state == 43:
                                state = (63 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.854720473)  else 64)
                                if state == 63:
                                    state = (83 if x['distpsnr1_med']<3.64256001 else 84)
                                    if state == 83:
                                        state = (107 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9408679)  else 108)
                                        if state == 107:
                                            state = (139 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.1634712)  else 140)
                                            if state == 139:
                                                return 0.325144917
                                            if state == 140:
                                                state = (157 if np.isnan(x['col_det']) or (x['col_det']<0.586990356)  else 158)
                                                if state == 157:
                                                    state = (171 if x['distpsnr1_med']<1.49424827 else 172)
                                                    if state == 171:
                                                        state = (185 if x['distnr_med']<0.796085119 else 186)
                                                        if state == 185:
                                                            return -0.195164084
                                                        if state == 186:
                                                            return 0.0210156832
                                                    if state == 172:
                                                        state = (187 if x['distnr_med']<1.68060458 else 188)
                                                        if state == 187:
                                                            return -0.190356001
                                                        if state == 188:
                                                            return 0.267307192
                                                if state == 158:
                                                    return -0.144087017
                                        if state == 108:
                                            state = (141 if x['maggaia_med']<18.0747528 else 142)
                                            if state == 141:
                                                return -0.258805841
                                            if state == 142:
                                                state = (159 if x['col_det']<1.32318211 else 160)
                                                if state == 159:
                                                    return -0.155406773
                                                if state == 160:
                                                    state = (173 if x['distpsnr1_med']<1.26598525 else 174)
                                                    if state == 173:
                                                        state = (189 if x['distnr_med']<0.61712265 else 190)
                                                        if state == 189:
                                                            return -0.193637282
                                                        if state == 190:
                                                            return 0.0535406768
                                                    if state == 174:
                                                        state = (191 if x['distnr_med']<1.88039935 else 192)
                                                        if state == 191:
                                                            return 0.0307662021
                                                        if state == 192:
                                                            return 0.314230442
                                    if state == 84:
                                        state = (109 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96769094)  else 110)
                                        if state == 109:
                                            state = (143 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.6067467)  else 144)
                                            if state == 143:
                                                state = (161 if x['col_det']<1.3720026 else 162)
                                                if state == 161:
                                                    return -0.29469192
                                                if state == 162:
                                                    state = (175 if x['distpsnr1_med']<14.5652561 else 176)
                                                    if state == 175:
                                                        return -0.19228971
                                                    if state == 176:
                                                        state = (193 if x['distnr_med']<1.37050676 else 194)
                                                        if state == 193:
                                                            return -0.136763573
                                                        if state == 194:
                                                            return 0.211340398
                                            if state == 144:
                                                state = (163 if x['col_det']<0.643917084 else 164)
                                                if state == 163:
                                                    return 0.352680326
                                                if state == 164:
                                                    state = (177 if x['distpsnr1_med']<4.93061018 else 178)
                                                    if state == 177:
                                                        state = (195 if x['distnr_med']<3.90550947 else 196)
                                                        if state == 195:
                                                            return -0.132729828
                                                        if state == 196:
                                                            return 0.235039219
                                                    if state == 178:
                                                        return -0.302381843
                                        if state == 110:
                                            state = (145 if x['maggaia_med']<17.8998642 else 146)
                                            if state == 145:
                                                return -0.128264666
                                            if state == 146:
                                                state = (165 if x['col_det']<1.94480228 else 166)
                                                if state == 165:
                                                    state = (179 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.3233881)  else 180)
                                                    if state == 179:
                                                        return -0.157433748
                                                    if state == 180:
                                                        return 0.223519146
                                                if state == 166:
                                                    state = (181 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.70302534)  else 182)
                                                    if state == 181:
                                                        return 0.395800829
                                                    if state == 182:
                                                        state = (197 if x['distnr_med']<2.92643404 else 198)
                                                        if state == 197:
                                                            return 0.209749281
                                                        if state == 198:
                                                            return -0.176887348
                                if state == 64:
                                    return -0.373384953
                            if state == 44:
                                state = (65 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.999166489)  else 66)
                                if state == 65:
                                    state = (85 if x['distpsnr1_med']<14.9472198 else 86)
                                    if state == 85:
                                        return -0.449223638
                                    if state == 86:
                                        state = (111 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.87390614)  else 112)
                                        if state == 111:
                                            state = (147 if x['maggaia_med']<19.782486 else 148)
                                            if state == 147:
                                                return -0.110829502
                                            if state == 148:
                                                return 0.33428362
                                        if state == 112:
                                            state = (149 if x['maggaia_med']<15.6595058 else 150)
                                            if state == 149:
                                                return 0.0798994377
                                            if state == 150:
                                                return -0.274499685
                                if state == 66:
                                    return 0.230077103
    elif num_booster == 5:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0105786994)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<19.9310112 else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<0.739422321 else 8)
                    if state == 7:
                        state = (15 if x['distpsnr1_med']<0.593342483 else 16)
                        if state == 15:
                            return -0.302688569
                        if state == 16:
                            return 0.278971225
                    if state == 8:
                        return -0.431815743
                if state == 4:
                    state = (9 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.39442515)  else 10)
                    if state == 9:
                        state = (17 if x['distpsnr1_med']<0.573653936 else 18)
                        if state == 17:
                            return -0.158081889
                        if state == 18:
                            state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.64857173)  else 26)
                            if state == 25:
                                return -0.337649912
                            if state == 26:
                                return 0.298137426
                    if state == 10:
                        state = (19 if x['distpsnr1_med']<9.24009705 else 20)
                        if state == 19:
                            state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.427262098)  else 28)
                            if state == 27:
                                return 0.238303661
                            if state == 28:
                                return -0.342467815
                        if state == 20:
                            return -0.348692596
            if state == 2:
                state = (5 if x['maggaia_med']<15.077879 else 6)
                if state == 5:
                    state = (11 if x['distpsnr1_med']<10.1726599 else 12)
                    if state == 11:
                        return -0.323596656
                    if state == 12:
                        state = (21 if x['distpsnr1_med']<10.5090542 else 22)
                        if state == 21:
                            return 0.244737506
                        if state == 22:
                            state = (29 if np.isnan(x['rb_med']) or (x['rb_med']<0.639642715)  else 30)
                            if state == 29:
                                return -0.283578485
                            if state == 30:
                                return 0.264992595
                if state == 6:
                    state = (13 if x['distpsnr1_med']<0.0847772956 else 14)
                    if state == 13:
                        return -0.405101091
                    if state == 14:
                        state = (23 if x['distpsnr1_med']<0.0880597755 else 24)
                        if state == 23:
                            return 0.607768953
                        if state == 24:
                            state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.512499988)  else 32)
                            if state == 31:
                                state = (33 if x['distpsnr1_med']<4.21035051 else 34)
                                if state == 33:
                                    state = (37 if x['magnr_med']<21.3964996 else 38)
                                    if state == 37:
                                        return -0.470181912
                                    if state == 38:
                                        state = (45 if x['maggaia_med']<16.9403152 else 46)
                                        if state == 45:
                                            return 0.13515538
                                        if state == 46:
                                            state = (57 if np.isnan(x['t_lc']) or (x['t_lc']<1.05361116)  else 58)
                                            if state == 57:
                                                state = (71 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00829268)  else 72)
                                                if state == 71:
                                                    return -0.254483312
                                                if state == 72:
                                                    return 0.1685711
                                            if state == 58:
                                                return -0.267606229
                                if state == 34:
                                    state = (39 if x['magnr_med']<20.2122498 else 40)
                                    if state == 39:
                                        state = (47 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.8577118)  else 48)
                                        if state == 47:
                                            state = (59 if np.isnan(x['t_lc']) or (x['t_lc']<0.0266261511)  else 60)
                                            if state == 59:
                                                return 0.326895475
                                            if state == 60:
                                                state = (73 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0026679)  else 74)
                                                if state == 73:
                                                    state = (87 if x['magnr_med']<19.8307495 else 88)
                                                    if state == 87:
                                                        state = (105 if np.isnan(x['t_lc']) or (x['t_lc']<3.00268507)  else 106)
                                                        if state == 105:
                                                            return -0.405468255
                                                        if state == 106:
                                                            return 0.0648396611
                                                    if state == 88:
                                                        state = (107 if np.isnan(x['t_lc']) or (x['t_lc']<0.472789347)  else 108)
                                                        if state == 107:
                                                            return 0.197523102
                                                        if state == 108:
                                                            return -0.150954679
                                                if state == 74:
                                                    state = (89 if x['magnr_med']<18.14575 else 90)
                                                    if state == 89:
                                                        return -0.222822204
                                                    if state == 90:
                                                        return 0.398768604
                                        if state == 48:
                                            return 0.323851228
                                    if state == 40:
                                        state = (49 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1942406)  else 50)
                                        if state == 49:
                                            state = (61 if np.isnan(x['t_lc']) or (x['t_lc']<0.0609085485)  else 62)
                                            if state == 61:
                                                state = (75 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9031713)  else 76)
                                                if state == 75:
                                                    state = (91 if x['magnr_med']<22.5680008 else 92)
                                                    if state == 91:
                                                        return -0.270451963
                                                    if state == 92:
                                                        return 0.164569914
                                                if state == 76:
                                                    state = (93 if x['magnr_med']<22.630249 else 94)
                                                    if state == 93:
                                                        state = (109 if np.isnan(x['t_lc']) or (x['t_lc']<0.0449769013)  else 110)
                                                        if state == 109:
                                                            return 0.00927013904
                                                        if state == 110:
                                                            return 0.277634919
                                                    if state == 94:
                                                        state = (111 if np.isnan(x['t_lc']) or (x['t_lc']<0.0475983471)  else 112)
                                                        if state == 111:
                                                            return 0.0596530735
                                                        if state == 112:
                                                            return -0.147492096
                                            if state == 62:
                                                state = (77 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.870057821)  else 78)
                                                if state == 77:
                                                    return -0.403811455
                                                if state == 78:
                                                    state = (95 if x['magnr_med']<21.654501 else 96)
                                                    if state == 95:
                                                        state = (113 if np.isnan(x['t_lc']) or (x['t_lc']<0.529340267)  else 114)
                                                        if state == 113:
                                                            return -0.248978719
                                                        if state == 114:
                                                            return 0.267362922
                                                    if state == 96:
                                                        return -0.46405527
                                        if state == 50:
                                            return -0.391745746
                            if state == 32:
                                state = (35 if x['distpsnr1_med']<0.492864847 else 36)
                                if state == 35:
                                    state = (41 if x['magnr_med']<20.5734997 else 42)
                                    if state == 41:
                                        state = (51 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.1317863)  else 52)
                                        if state == 51:
                                            state = (63 if np.isnan(x['t_lc']) or (x['t_lc']<2.98267937)  else 64)
                                            if state == 63:
                                                return -0.37976566
                                            if state == 64:
                                                state = (79 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0266667008)  else 80)
                                                if state == 79:
                                                    return 0.39759323
                                                if state == 80:
                                                    return -0.323286414
                                        if state == 52:
                                            state = (65 if np.isnan(x['t_lc']) or (x['t_lc']<0.0365104005)  else 66)
                                            if state == 65:
                                                return -0.294412225
                                            if state == 66:
                                                state = (81 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97891784)  else 82)
                                                if state == 81:
                                                    state = (97 if x['magnr_med']<17.3139992 else 98)
                                                    if state == 97:
                                                        return -0.135693565
                                                    if state == 98:
                                                        return 0.267786384
                                                if state == 82:
                                                    state = (99 if x['magnr_med']<19.0740013 else 100)
                                                    if state == 99:
                                                        return -0.26589641
                                                    if state == 100:
                                                        state = (115 if np.isnan(x['t_lc']) or (x['t_lc']<2.94087958)  else 116)
                                                        if state == 115:
                                                            return 0.1943506
                                                        if state == 116:
                                                            return -0.11559511
                                    if state == 42:
                                        return -0.440807253
                                if state == 36:
                                    state = (43 if x['magnr_med']<16.5545006 else 44)
                                    if state == 43:
                                        state = (53 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<15.6086617)  else 54)
                                        if state == 53:
                                            state = (67 if np.isnan(x['t_lc']) or (x['t_lc']<0.990480304)  else 68)
                                            if state == 67:
                                                return -0.258751392
                                            if state == 68:
                                                state = (83 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01285291)  else 84)
                                                if state == 83:
                                                    state = (101 if x['magnr_med']<16.0802498 else 102)
                                                    if state == 101:
                                                        return -0.224419966
                                                    if state == 102:
                                                        return 0.19685173
                                                if state == 84:
                                                    return 0.302986503
                                        if state == 54:
                                            return -0.387585431
                                    if state == 44:
                                        state = (55 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.9524651)  else 56)
                                        if state == 55:
                                            state = (69 if np.isnan(x['t_lc']) or (x['t_lc']<3.03744221)  else 70)
                                            if state == 69:
                                                state = (85 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02426505)  else 86)
                                                if state == 85:
                                                    state = (103 if x['magnr_med']<17.3614998 else 104)
                                                    if state == 103:
                                                        state = (117 if np.isnan(x['t_lc']) or (x['t_lc']<1.49795711)  else 118)
                                                        if state == 117:
                                                            return -0.244644314
                                                        if state == 118:
                                                            return -0.0462127328
                                                    if state == 104:
                                                        state = (119 if np.isnan(x['t_lc']) or (x['t_lc']<3.02725124)  else 120)
                                                        if state == 119:
                                                            return 0.272705793
                                                        if state == 120:
                                                            return -0.358521998
                                                if state == 86:
                                                    return 0.384853691
                                            if state == 70:
                                                return -0.315166205
                                        if state == 56:
                                            return -0.151143894
    elif num_booster == 6:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.0862373039 else 2)
            if state == 1:
                return -0.391920179
            if state == 2:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.635714352)  else 4)
                if state == 3:
                    state = (5 if x['col_det']<0.286049843 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.605250001)  else 10)
                        if state == 9:
                            return -0.352783173
                        if state == 10:
                            state = (17 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.966321468)  else 18)
                            if state == 17:
                                state = (29 if x['col_det']<-0.470607758 else 30)
                                if state == 29:
                                    return -0.27676782
                                if state == 30:
                                    state = (45 if x['distpsnr1_med']<1.04639935 else 46)
                                    if state == 45:
                                        return -0.279807448
                                    if state == 46:
                                        state = (67 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.79006326)  else 68)
                                        if state == 67:
                                            state = (87 if np.isnan(x['t_lc']) or (x['t_lc']<0.0346933007)  else 88)
                                            if state == 87:
                                                return -0.517807424
                                            if state == 88:
                                                state = (109 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.983749986)  else 110)
                                                if state == 109:
                                                    state = (125 if x['distnr_med']<6.40294266 else 126)
                                                    if state == 125:
                                                        state = (143 if np.isnan(x['mag_det']) or (x['mag_det']<20.4259987)  else 144)
                                                        if state == 143:
                                                            return 0.320546478
                                                        if state == 144:
                                                            return -0.161966711
                                                    if state == 126:
                                                        return -0.107009232
                                                if state == 110:
                                                    return -0.00486166263
                                        if state == 68:
                                            state = (89 if np.isnan(x['t_lc']) or (x['t_lc']<0.0333738476)  else 90)
                                            if state == 89:
                                                return 0.431069136
                                            if state == 90:
                                                state = (111 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.982749999)  else 112)
                                                if state == 111:
                                                    state = (127 if x['distnr_med']<8.88732719 else 128)
                                                    if state == 127:
                                                        state = (145 if np.isnan(x['mag_det']) or (x['mag_det']<20.4417992)  else 146)
                                                        if state == 145:
                                                            return 0.281309664
                                                        if state == 146:
                                                            return -0.339604169
                                                    if state == 128:
                                                        return -0.192067489
                                                if state == 112:
                                                    return -0.217208043
                            if state == 18:
                                return -0.302762091
                    if state == 6:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.954750001)  else 12)
                        if state == 11:
                            state = (19 if x['sgscore1_med']<0.0226458013 else 20)
                            if state == 19:
                                state = (31 if x['col_det']<2.05903339 else 32)
                                if state == 31:
                                    return -0.229152039
                                if state == 32:
                                    state = (47 if x['distpsnr1_med']<9.29355145 else 48)
                                    if state == 47:
                                        state = (69 if x['distpsnr1_med']<0.161489516 else 70)
                                        if state == 69:
                                            return 0.259087831
                                        if state == 70:
                                            state = (91 if np.isnan(x['t_lc']) or (x['t_lc']<0.00138889998)  else 92)
                                            if state == 91:
                                                return -0.27505517
                                            if state == 92:
                                                state = (113 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.725749969)  else 114)
                                                if state == 113:
                                                    return -0.265912831
                                                if state == 114:
                                                    state = (129 if x['distnr_med']<0.933472693 else 130)
                                                    if state == 129:
                                                        return -0.155795142
                                                    if state == 130:
                                                        state = (147 if np.isnan(x['mag_det']) or (x['mag_det']<20.6207504)  else 148)
                                                        if state == 147:
                                                            return 0.309304833
                                                        if state == 148:
                                                            return -0.181916058
                                    if state == 48:
                                        return -0.304469168
                            if state == 20:
                                state = (33 if x['col_det']<0.398426056 else 34)
                                if state == 33:
                                    state = (49 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.4701519)  else 50)
                                    if state == 49:
                                        return -0.281177014
                                    if state == 50:
                                        state = (71 if x['distpsnr1_med']<9.06550026 else 72)
                                        if state == 71:
                                            return 0.255754709
                                        if state == 72:
                                            return -0.134096846
                                if state == 34:
                                    state = (51 if x['distpsnr1_med']<14.0661316 else 52)
                                    if state == 51:
                                        return -0.353906602
                                    if state == 52:
                                        state = (73 if x['distpsnr1_med']<14.0994663 else 74)
                                        if state == 73:
                                            return 0.405182689
                                        if state == 74:
                                            state = (93 if np.isnan(x['t_lc']) or (x['t_lc']<0.0219270494)  else 94)
                                            if state == 93:
                                                return -0.368829668
                                            if state == 94:
                                                state = (115 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.760749996)  else 116)
                                                if state == 115:
                                                    state = (131 if x['distnr_med']<1.96997738 else 132)
                                                    if state == 131:
                                                        state = (149 if np.isnan(x['mag_det']) or (x['mag_det']<20.8016014)  else 150)
                                                        if state == 149:
                                                            return -0.192832798
                                                        if state == 150:
                                                            return 0.0154514657
                                                    if state == 132:
                                                        return -0.353387266
                                                if state == 116:
                                                    state = (133 if x['distnr_med']<1.68981504 else 134)
                                                    if state == 133:
                                                        state = (151 if np.isnan(x['mag_det']) or (x['mag_det']<19.0382996)  else 152)
                                                        if state == 151:
                                                            return -0.273952186
                                                        if state == 152:
                                                            return 0.311370343
                                                    if state == 134:
                                                        return -0.354555488
                        if state == 12:
                            state = (21 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0309791509)  else 22)
                            if state == 21:
                                state = (35 if x['col_det']<2.40139866 else 36)
                                if state == 35:
                                    return -0.200342059
                                if state == 36:
                                    state = (53 if x['distpsnr1_med']<50.1279526 else 54)
                                    if state == 53:
                                        return -0.323724627
                                    if state == 54:
                                        return 0.138903752
                            if state == 22:
                                state = (37 if np.isnan(x['col_det']) or (x['col_det']<0.586455345)  else 38)
                                if state == 37:
                                    state = (55 if x['distpsnr1_med']<1.26502085 else 56)
                                    if state == 55:
                                        state = (75 if x['distpsnr1_med']<0.269577146 else 76)
                                        if state == 75:
                                            return 0.288623095
                                        if state == 76:
                                            state = (95 if np.isnan(x['t_lc']) or (x['t_lc']<0.101765007)  else 96)
                                            if state == 95:
                                                state = (117 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.971249998)  else 118)
                                                if state == 117:
                                                    return 0.131548822
                                                if state == 118:
                                                    state = (135 if x['distnr_med']<1.06235504 else 136)
                                                    if state == 135:
                                                        return -0.120322034
                                                    if state == 136:
                                                        return 0.0988391265
                                            if state == 96:
                                                return -0.317294747
                                    if state == 56:
                                        state = (77 if x['distpsnr1_med']<8.82079506 else 78)
                                        if state == 77:
                                            state = (97 if np.isnan(x['t_lc']) or (x['t_lc']<0.107500046)  else 98)
                                            if state == 97:
                                                return -0.280637175
                                            if state == 98:
                                                state = (119 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.992250025)  else 120)
                                                if state == 119:
                                                    state = (137 if x['distnr_med']<1.44895756 else 138)
                                                    if state == 137:
                                                        state = (153 if np.isnan(x['mag_det']) or (x['mag_det']<19.3342113)  else 154)
                                                        if state == 153:
                                                            return -0.132443309
                                                        if state == 154:
                                                            return 0.276302278
                                                    if state == 138:
                                                        state = (155 if np.isnan(x['mag_det']) or (x['mag_det']<17.9970016)  else 156)
                                                        if state == 155:
                                                            return 0.0441935174
                                                        if state == 156:
                                                            return 0.421499789
                                                if state == 120:
                                                    return -0.101599298
                                        if state == 78:
                                            state = (99 if np.isnan(x['t_lc']) or (x['t_lc']<1.48827541)  else 100)
                                            if state == 99:
                                                return -0.229167566
                                            if state == 100:
                                                return 0.250344783
                                if state == 38:
                                    return -0.232357889
                if state == 4:
                    state = (7 if x['col_det']<0.657653809 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.620500028)  else 14)
                        if state == 13:
                            return -0.30654186
                        if state == 14:
                            state = (23 if x['sgscore1_med']<0.0175625011 else 24)
                            if state == 23:
                                state = (39 if x['col_det']<0.195489883 else 40)
                                if state == 39:
                                    state = (57 if x['distpsnr1_med']<1.17838609 else 58)
                                    if state == 57:
                                        return 0.261474848
                                    if state == 58:
                                        state = (79 if x['distpsnr1_med']<7.73736095 else 80)
                                        if state == 79:
                                            return -0.490458369
                                        if state == 80:
                                            return -0.042233713
                                if state == 40:
                                    return -0.471111149
                            if state == 24:
                                state = (41 if x['col_det']<-0.366446495 else 42)
                                if state == 41:
                                    state = (59 if x['distpsnr1_med']<1.31813514 else 60)
                                    if state == 59:
                                        return 0.258421421
                                    if state == 60:
                                        return -0.402766198
                                if state == 42:
                                    state = (61 if x['distpsnr1_med']<0.513632059 else 62)
                                    if state == 61:
                                        state = (81 if x['distpsnr1_med']<0.107469335 else 82)
                                        if state == 81:
                                            state = (101 if np.isnan(x['t_lc']) or (x['t_lc']<0.0550694503)  else 102)
                                            if state == 101:
                                                return 0.461025864
                                            if state == 102:
                                                return -0.17365934
                                        if state == 82:
                                            return -0.368688643
                                    if state == 62:
                                        return 0.322237104
                    if state == 8:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.739249945)  else 16)
                        if state == 15:
                            state = (25 if x['sgscore1_med']<2.00000095 else 26)
                            if state == 25:
                                return -0.421154618
                            if state == 26:
                                return -0.121094629
                        if state == 16:
                            state = (27 if x['sgscore1_med']<0.507874966 else 28)
                            if state == 27:
                                state = (43 if x['col_det']<1.14725685 else 44)
                                if state == 43:
                                    state = (63 if x['distpsnr1_med']<3.98295689 else 64)
                                    if state == 63:
                                        return -0.112387851
                                    if state == 64:
                                        return 0.115345225
                                if state == 44:
                                    state = (65 if x['distpsnr1_med']<0.235143214 else 66)
                                    if state == 65:
                                        state = (83 if x['distpsnr1_med']<0.133896172 else 84)
                                        if state == 83:
                                            state = (103 if np.isnan(x['t_lc']) or (x['t_lc']<2.96769667)  else 104)
                                            if state == 103:
                                                return 0.150596961
                                            if state == 104:
                                                return -0.143707931
                                        if state == 84:
                                            return -0.275676489
                                    if state == 66:
                                        state = (85 if x['distpsnr1_med']<3.89186144 else 86)
                                        if state == 85:
                                            state = (105 if np.isnan(x['t_lc']) or (x['t_lc']<2.44101858)  else 106)
                                            if state == 105:
                                                state = (121 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.97874999)  else 122)
                                                if state == 121:
                                                    state = (139 if x['distnr_med']<2.74023008 else 140)
                                                    if state == 139:
                                                        return -0.33064279
                                                    if state == 140:
                                                        state = (157 if np.isnan(x['mag_det']) or (x['mag_det']<19.9067993)  else 158)
                                                        if state == 157:
                                                            return 0.119958296
                                                        if state == 158:
                                                            return -0.182650506
                                                if state == 122:
                                                    return 0.285452276
                                            if state == 106:
                                                state = (123 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.978500009)  else 124)
                                                if state == 123:
                                                    state = (141 if x['distnr_med']<0.558533192 else 142)
                                                    if state == 141:
                                                        state = (159 if np.isnan(x['mag_det']) or (x['mag_det']<19.8711739)  else 160)
                                                        if state == 159:
                                                            return -0.0254041087
                                                        if state == 160:
                                                            return -0.350124061
                                                    if state == 142:
                                                        state = (161 if np.isnan(x['mag_det']) or (x['mag_det']<19.9071999)  else 162)
                                                        if state == 161:
                                                            return -0.191861778
                                                        if state == 162:
                                                            return 0.269605041
                                                if state == 124:
                                                    return 0.399430573
                                        if state == 86:
                                            state = (107 if np.isnan(x['t_lc']) or (x['t_lc']<0.929872632)  else 108)
                                            if state == 107:
                                                return -0.224589601
                                            if state == 108:
                                                return 0.358931571
                            if state == 28:
                                return -0.143849984
    elif num_booster == 7:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.0862373039 else 2)
            if state == 1:
                return -0.360514343
            if state == 2:
                state = (3 if x['distpsnr1_med']<0.262022376 else 4)
                if state == 3:
                    state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<20.1665497)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.264091998)  else 10)
                        if state == 9:
                            state = (17 if x['sgscore1_med']<0.168919504 else 18)
                            if state == 17:
                                state = (27 if x['distpsnr1_med']<0.214745671 else 28)
                                if state == 27:
                                    state = (39 if x['distpsnr1_med']<0.0942226201 else 40)
                                    if state == 39:
                                        return 0.38567242
                                    if state == 40:
                                        state = (49 if x['magnr_med']<18.7625008 else 50)
                                        if state == 49:
                                            state = (63 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0450694486)  else 64)
                                            if state == 63:
                                                return 0.11357113
                                            if state == 64:
                                                return -0.196307391
                                        if state == 50:
                                            return 0.246992052
                                if state == 28:
                                    return -0.142335385
                            if state == 18:
                                return 0.520125389
                        if state == 10:
                            state = (19 if x['sgscore1_med']<0.508413494 else 20)
                            if state == 19:
                                state = (29 if x['distpsnr1_med']<0.244786352 else 30)
                                if state == 29:
                                    return -0.330783546
                                if state == 30:
                                    return 0.319171935
                            if state == 20:
                                return -0.227665454
                    if state == 6:
                        state = (11 if x['sgscore1_med']<0.0190417003 else 12)
                        if state == 11:
                            state = (21 if x['sgscore1_med']<0.016104199 else 22)
                            if state == 21:
                                state = (31 if x['distpsnr1_med']<0.0976075828 else 32)
                                if state == 31:
                                    return 0.107911855
                                if state == 32:
                                    return -0.222198293
                            if state == 22:
                                return 0.221741617
                        if state == 12:
                            return -0.288175642
                if state == 4:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<18.1368999)  else 8)
                    if state == 7:
                        state = (13 if x['sgscore1_med']<0.243693501 else 14)
                        if state == 13:
                            state = (23 if x['sgscore1_med']<0.0270000007 else 24)
                            if state == 23:
                                return -0.392989427
                            if state == 24:
                                state = (33 if x['distpsnr1_med']<2.72817302 else 34)
                                if state == 33:
                                    return -0.19558613
                                if state == 34:
                                    return 0.222806484
                        if state == 14:
                            return -0.392004222
                    if state == 8:
                        state = (15 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.874173045)  else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0141874999)  else 26)
                            if state == 25:
                                state = (35 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.22095239)  else 36)
                                if state == 35:
                                    state = (41 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.486712039)  else 42)
                                    if state == 41:
                                        state = (51 if x['magnr_med']<20.1642494 else 52)
                                        if state == 51:
                                            state = (65 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.622806787)  else 66)
                                            if state == 65:
                                                state = (81 if x['magnr_med']<18.2815018 else 82)
                                                if state == 81:
                                                    return 0.0396150164
                                                if state == 82:
                                                    state = (105 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0607060492)  else 106)
                                                    if state == 105:
                                                        state = (123 if x['magnr_med']<19.043251 else 124)
                                                        if state == 123:
                                                            return -0.126453862
                                                        if state == 124:
                                                            return 0.265259594
                                                    if state == 106:
                                                        return 0.346167952
                                            if state == 66:
                                                state = (83 if x['magnr_med']<17.9570007 else 84)
                                                if state == 83:
                                                    return -0.22144717
                                                if state == 84:
                                                    state = (107 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98845482)  else 108)
                                                    if state == 107:
                                                        state = (125 if x['magnr_med']<19.2552509 else 126)
                                                        if state == 125:
                                                            return -0.097831592
                                                        if state == 126:
                                                            return 0.148037612
                                                    if state == 108:
                                                        return 0.268965095
                                        if state == 52:
                                            state = (67 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.86568284)  else 68)
                                            if state == 67:
                                                return -0.378543556
                                            if state == 68:
                                                state = (85 if x['magnr_med']<22.2819996 else 86)
                                                if state == 85:
                                                    state = (109 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97884846)  else 110)
                                                    if state == 109:
                                                        state = (129 if x['magnr_med']<21.9362507 else 130)
                                                        if state == 129:
                                                            return -0.043362122
                                                        if state == 130:
                                                            return 0.238586947
                                                    if state == 110:
                                                        return -0.306122065
                                                if state == 86:
                                                    return -0.390035242
                                    if state == 42:
                                        state = (53 if x['magnr_med']<21.970499 else 54)
                                        if state == 53:
                                            state = (69 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.545966506)  else 70)
                                            if state == 69:
                                                state = (87 if x['magnr_med']<18.65625 else 88)
                                                if state == 87:
                                                    return 0.212179288
                                                if state == 88:
                                                    return -0.292824715
                                            if state == 70:
                                                state = (89 if x['magnr_med']<18.4347496 else 90)
                                                if state == 89:
                                                    state = (111 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.99067712)  else 112)
                                                    if state == 111:
                                                        return 0.146412745
                                                    if state == 112:
                                                        return -0.0737297907
                                                if state == 90:
                                                    return 0.321946561
                                        if state == 54:
                                            return -0.156410977
                                if state == 36:
                                    state = (43 if x['distpsnr1_med']<1.39764833 else 44)
                                    if state == 43:
                                        return -0.453205228
                                    if state == 44:
                                        state = (55 if x['magnr_med']<21.2242508 else 56)
                                        if state == 55:
                                            state = (71 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9886806)  else 72)
                                            if state == 71:
                                                state = (91 if x['magnr_med']<19.4899998 else 92)
                                                if state == 91:
                                                    return 0.20569405
                                                if state == 92:
                                                    state = (113 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9786284)  else 114)
                                                    if state == 113:
                                                        state = (131 if x['magnr_med']<20.605751 else 132)
                                                        if state == 131:
                                                            return -0.119458094
                                                        if state == 132:
                                                            return 0.0982906371
                                                    if state == 114:
                                                        return 0.176074058
                                            if state == 72:
                                                return -0.219329417
                                        if state == 56:
                                            state = (73 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99934602)  else 74)
                                            if state == 73:
                                                state = (95 if x['magnr_med']<22.8260002 else 96)
                                                if state == 95:
                                                    return -0.384720176
                                                if state == 96:
                                                    state = (115 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.01372695)  else 116)
                                                    if state == 115:
                                                        state = (133 if x['magnr_med']<22.8304996 else 134)
                                                        if state == 133:
                                                            return 0.267058313
                                                        if state == 134:
                                                            return -0.192694515
                                                    if state == 116:
                                                        return -0.240105778
                                            if state == 74:
                                                state = (97 if x['magnr_med']<22.1417503 else 98)
                                                if state == 97:
                                                    return -0.223493576
                                                if state == 98:
                                                    return 0.205355555
                            if state == 26:
                                state = (37 if x['distpsnr1_med']<0.511591196 else 38)
                                if state == 37:
                                    state = (45 if x['distpsnr1_med']<0.374550372 else 46)
                                    if state == 45:
                                        return -0.293281734
                                    if state == 46:
                                        state = (57 if x['magnr_med']<17.762001 else 58)
                                        if state == 57:
                                            return -0.263895899
                                        if state == 58:
                                            state = (75 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0436805487)  else 76)
                                            if state == 75:
                                                return 0.210398123
                                            if state == 76:
                                                state = (99 if x['magnr_med']<19.0030003 else 100)
                                                if state == 99:
                                                    return -0.192089334
                                                if state == 100:
                                                    state = (117 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.06954861)  else 118)
                                                    if state == 117:
                                                        return -0.0469725654
                                                    if state == 118:
                                                        return 0.137214497
                                if state == 38:
                                    state = (47 if x['distpsnr1_med']<23.1877861 else 48)
                                    if state == 47:
                                        state = (59 if x['magnr_med']<16.5540009 else 60)
                                        if state == 59:
                                            state = (77 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01087952)  else 78)
                                            if state == 77:
                                                return -0.338190526
                                            if state == 78:
                                                state = (101 if x['magnr_med']<15.835 else 102)
                                                if state == 101:
                                                    return 0.219817266
                                                if state == 102:
                                                    return -0.163784876
                                        if state == 60:
                                            state = (79 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02508688)  else 80)
                                            if state == 79:
                                                state = (103 if x['magnr_med']<20.8082504 else 104)
                                                if state == 103:
                                                    state = (119 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00483799)  else 120)
                                                    if state == 119:
                                                        state = (137 if x['magnr_med']<17.019249 else 138)
                                                        if state == 137:
                                                            return -0.18534337
                                                        if state == 138:
                                                            return 0.24545604
                                                    if state == 120:
                                                        state = (139 if x['magnr_med']<19.2905006 else 140)
                                                        if state == 139:
                                                            return 0.0226911288
                                                        if state == 140:
                                                            return -0.440095186
                                                if state == 104:
                                                    state = (121 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.990983844)  else 122)
                                                    if state == 121:
                                                        state = (141 if x['magnr_med']<22.8730011 else 142)
                                                        if state == 141:
                                                            return -0.290517002
                                                        if state == 142:
                                                            return -0.0294766948
                                                    if state == 122:
                                                        state = (143 if x['magnr_med']<22.5834999 else 144)
                                                        if state == 143:
                                                            return -0.082209751
                                                        if state == 144:
                                                            return 0.144075438
                                            if state == 80:
                                                return 0.323155582
                                    if state == 48:
                                        state = (61 if x['magnr_med']<22.2735004 else 62)
                                        if state == 61:
                                            return 0.747397304
                                        if state == 62:
                                            return -0.16738826
                        if state == 16:
                            return -0.330967128
    elif num_booster == 8:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<13.7891951 else 2)
            if state == 1:
                state = (3 if x['col_det']<0.162837029 else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<9.42046261 else 8)
                    if state == 7:
                        return -0.143971622
                    if state == 8:
                        return 0.16255109
                if state == 4:
                    return -0.393435895
            if state == 2:
                state = (5 if x['col_det']<0.427095413 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.0862373039)  else 10)
                    if state == 9:
                        state = (13 if x['maggaia_med']<42.018074 else 14)
                        if state == 13:
                            return -0.290444613
                        if state == 14:
                            state = (21 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.908749998)  else 22)
                            if state == 21:
                                return -0.162606731
                            if state == 22:
                                return 0.0817219466
                    if state == 10:
                        state = (15 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4253502)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.617750049)  else 24)
                            if state == 23:
                                return -0.222293034
                            if state == 24:
                                state = (33 if x['neargaia_med']<0.260023832 else 34)
                                if state == 33:
                                    return 0.412651539
                                if state == 34:
                                    state = (47 if np.isnan(x['rb_med']) or (x['rb_med']<0.504166603)  else 48)
                                    if state == 47:
                                        state = (65 if x['neargaia_med']<23.1565666 else 66)
                                        if state == 65:
                                            state = (85 if x['col_det']<-0.321071625 else 86)
                                            if state == 85:
                                                return 0.0919198692
                                            if state == 86:
                                                return -0.287837476
                                        if state == 66:
                                            state = (87 if x['col_det']<-0.0512733459 else 88)
                                            if state == 87:
                                                state = (101 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92018509)  else 102)
                                                if state == 101:
                                                    return 0.176222578
                                                if state == 102:
                                                    return -0.178610504
                                            if state == 88:
                                                return 0.27586934
                                    if state == 48:
                                        state = (67 if x['neargaia_med']<8.68958664 else 68)
                                        if state == 67:
                                            state = (89 if x['col_det']<-0.00802612305 else 90)
                                            if state == 89:
                                                state = (105 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93208933)  else 106)
                                                if state == 105:
                                                    state = (119 if x['col_det']<-0.0868091583 else 120)
                                                    if state == 119:
                                                        return 0.311695933
                                                    if state == 120:
                                                        return 0.0330838822
                                                if state == 106:
                                                    state = (121 if x['col_det']<-0.107714653 else 122)
                                                    if state == 121:
                                                        state = (133 if np.isnan(x['t_lc']) or (x['t_lc']<0.103854254)  else 134)
                                                        if state == 133:
                                                            return -0.293888301
                                                        if state == 134:
                                                            return 0.144273221
                                                    if state == 122:
                                                        return 0.224642366
                                            if state == 90:
                                                state = (107 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.88759851)  else 108)
                                                if state == 107:
                                                    return 0.103051662
                                                if state == 108:
                                                    return -0.298566729
                                        if state == 68:
                                            state = (91 if x['col_det']<0.238675117 else 92)
                                            if state == 91:
                                                state = (109 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02963543)  else 110)
                                                if state == 109:
                                                    state = (123 if x['col_det']<-0.375477791 else 124)
                                                    if state == 123:
                                                        return 0.0729913637
                                                    if state == 124:
                                                        return 0.352170974
                                                if state == 110:
                                                    return 0.000384660205
                                            if state == 92:
                                                state = (111 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90708923)  else 112)
                                                if state == 111:
                                                    return 0.351238161
                                                if state == 112:
                                                    state = (125 if x['col_det']<0.376420975 else 126)
                                                    if state == 125:
                                                        state = (135 if np.isnan(x['t_lc']) or (x['t_lc']<0.0405150503)  else 136)
                                                        if state == 135:
                                                            return -0.398740143
                                                        if state == 136:
                                                            return 0.093623288
                                                    if state == 126:
                                                        return 0.115686789
                        if state == 16:
                            state = (25 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.97724998)  else 26)
                            if state == 25:
                                state = (35 if x['neargaia_med']<10.2711601 else 36)
                                if state == 35:
                                    state = (49 if np.isnan(x['rb_med']) or (x['rb_med']<0.727500021)  else 50)
                                    if state == 49:
                                        state = (69 if x['neargaia_med']<1.52299547 else 70)
                                        if state == 69:
                                            return -0.0353001431
                                        if state == 70:
                                            return -0.428333938
                                    if state == 50:
                                        return 0.0396302976
                                if state == 36:
                                    state = (51 if np.isnan(x['rb_med']) or (x['rb_med']<0.784523726)  else 52)
                                    if state == 51:
                                        state = (71 if x['neargaia_med']<39.2397842 else 72)
                                        if state == 71:
                                            state = (93 if x['col_det']<0.299508095 else 94)
                                            if state == 93:
                                                state = (113 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96785307)  else 114)
                                                if state == 113:
                                                    state = (127 if x['col_det']<0.281560898 else 128)
                                                    if state == 127:
                                                        return -0.228412241
                                                    if state == 128:
                                                        return 0.166892081
                                                if state == 114:
                                                    return 0.274411708
                                            if state == 94:
                                                return -0.13321878
                                        if state == 72:
                                            return -0.122787558
                                    if state == 52:
                                        return -0.291952997
                            if state == 26:
                                state = (37 if x['neargaia_med']<11.1304836 else 38)
                                if state == 37:
                                    return 0.220905542
                                if state == 38:
                                    state = (53 if np.isnan(x['rb_med']) or (x['rb_med']<0.88500005)  else 54)
                                    if state == 53:
                                        return 0.164135337
                                    if state == 54:
                                        return -0.193450078
                if state == 6:
                    state = (11 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<23.1376495)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.3137169)  else 18)
                        if state == 17:
                            state = (27 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.734000027)  else 28)
                            if state == 27:
                                return -0.299335986
                            if state == 28:
                                state = (39 if x['neargaia_med']<1.49824727 else 40)
                                if state == 39:
                                    state = (55 if np.isnan(x['rb_med']) or (x['rb_med']<0.859285712)  else 56)
                                    if state == 55:
                                        state = (73 if x['neargaia_med']<0.621789873 else 74)
                                        if state == 73:
                                            return -0.106404826
                                        if state == 74:
                                            state = (95 if x['col_det']<0.490218163 else 96)
                                            if state == 95:
                                                return 0.0959294736
                                            if state == 96:
                                                return -0.353973806
                                    if state == 56:
                                        return 0.131741852
                                if state == 40:
                                    state = (57 if np.isnan(x['rb_med']) or (x['rb_med']<0.457499743)  else 58)
                                    if state == 57:
                                        return -0.299095273
                                    if state == 58:
                                        state = (75 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<60.9836769)  else 76)
                                        if state == 75:
                                            state = (97 if np.isnan(x['col_det']) or (x['col_det']<0.80010891)  else 98)
                                            if state == 97:
                                                state = (115 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.04432297)  else 116)
                                                if state == 115:
                                                    return 0.167112336
                                                if state == 116:
                                                    return 0.34531036
                                            if state == 98:
                                                return -0.235309437
                                        if state == 76:
                                            return -0.247717187
                        if state == 18:
                            state = (29 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.973749995)  else 30)
                            if state == 29:
                                state = (41 if x['neargaia_med']<26.2820854 else 42)
                                if state == 41:
                                    state = (59 if np.isnan(x['rb_med']) or (x['rb_med']<0.422499895)  else 60)
                                    if state == 59:
                                        state = (77 if x['neargaia_med']<7.28698444 else 78)
                                        if state == 77:
                                            return 0.19957687
                                        if state == 78:
                                            return -0.293204099
                                    if state == 60:
                                        state = (79 if x['neargaia_med']<0.14541626 else 80)
                                        if state == 79:
                                            return 0.00180799013
                                        if state == 80:
                                            return -0.369976133
                                if state == 42:
                                    state = (61 if np.isnan(x['rb_med']) or (x['rb_med']<0.574999928)  else 62)
                                    if state == 61:
                                        state = (81 if x['neargaia_med']<32.052494 else 82)
                                        if state == 81:
                                            return -0.0697134733
                                        if state == 82:
                                            return -0.330246568
                                    if state == 62:
                                        state = (83 if x['neargaia_med']<36.2926254 else 84)
                                        if state == 83:
                                            return 0.257976472
                                        if state == 84:
                                            state = (99 if np.isnan(x['col_det']) or (x['col_det']<1.0031147)  else 100)
                                            if state == 99:
                                                state = (117 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96192694)  else 118)
                                                if state == 117:
                                                    state = (129 if x['col_det']<1.63869572 else 130)
                                                    if state == 129:
                                                        return -0.0158657748
                                                    if state == 130:
                                                        state = (137 if np.isnan(x['t_lc']) or (x['t_lc']<1.45331025)  else 138)
                                                        if state == 137:
                                                            return -0.133283436
                                                        if state == 138:
                                                            return 0.192254335
                                                if state == 118:
                                                    return -0.223848253
                                            if state == 100:
                                                return 0.119162306
                            if state == 30:
                                state = (43 if x['neargaia_med']<11.247591 else 44)
                                if state == 43:
                                    return -0.252721012
                                if state == 44:
                                    state = (63 if np.isnan(x['rb_med']) or (x['rb_med']<0.517023802)  else 64)
                                    if state == 63:
                                        return 0.00663087144
                                    if state == 64:
                                        return 0.278775454
                    if state == 12:
                        state = (19 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.1201591)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.917250037)  else 32)
                            if state == 31:
                                return -0.171071589
                            if state == 32:
                                state = (45 if x['neargaia_med']<26.6432114 else 46)
                                if state == 45:
                                    return 0.129527062
                                if state == 46:
                                    return -0.156247929
                        if state == 20:
                            return 0.440148145
    elif num_booster == 9:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<17.3241501)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.3899384)  else 4)
                if state == 3:
                    return -0.391312391
                if state == 4:
                    return 0.124990337
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4055023)  else 6)
                if state == 5:
                    state = (7 if x['maggaia_med']<17.3329906 else 8)
                    if state == 7:
                        state = (11 if x['distnr_med']<9.40089798 else 12)
                        if state == 11:
                            state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0244733989)  else 18)
                            if state == 17:
                                return 0.194206417
                            if state == 18:
                                state = (27 if x['col_det']<0.427095413 else 28)
                                if state == 27:
                                    state = (41 if np.isnan(x['t_lc']) or (x['t_lc']<0.0719559938)  else 42)
                                    if state == 41:
                                        state = (61 if x['col_det']<-0.195786476 else 62)
                                        if state == 61:
                                            return -0.244724527
                                        if state == 62:
                                            state = (77 if x['maggaia_med']<16.7729797 else 78)
                                            if state == 77:
                                                state = (97 if x['distnr_med']<2.77071095 else 98)
                                                if state == 97:
                                                    state = (117 if np.isnan(x['rb_med']) or (x['rb_med']<0.456666589)  else 118)
                                                    if state == 117:
                                                        return 0.117291257
                                                    if state == 118:
                                                        state = (139 if x['col_det']<-0.162604332 else 140)
                                                        if state == 139:
                                                            return 0.129980296
                                                        if state == 140:
                                                            return -0.250142723
                                                if state == 98:
                                                    return 0.254674345
                                            if state == 78:
                                                return -0.21655567
                                    if state == 42:
                                        return 0.225756764
                                if state == 28:
                                    state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<0.980347157)  else 44)
                                    if state == 43:
                                        return -0.231857553
                                    if state == 44:
                                        return -0.0565246455
                        if state == 12:
                            return -0.322840482
                    if state == 8:
                        state = (13 if x['distnr_med']<5.0004096 else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98130798)  else 20)
                            if state == 19:
                                state = (29 if x['col_det']<0.236618042 else 30)
                                if state == 29:
                                    state = (45 if np.isnan(x['t_lc']) or (x['t_lc']<0.0752199441)  else 46)
                                    if state == 45:
                                        state = (63 if x['col_det']<0.0726747513 else 64)
                                        if state == 63:
                                            state = (79 if x['maggaia_med']<17.9289703 else 80)
                                            if state == 79:
                                                state = (99 if x['distnr_med']<1.17594767 else 100)
                                                if state == 99:
                                                    return -0.151035354
                                                if state == 100:
                                                    state = (119 if np.isnan(x['rb_med']) or (x['rb_med']<0.698690534)  else 120)
                                                    if state == 119:
                                                        return 0.14142777
                                                    if state == 120:
                                                        return -0.144080728
                                            if state == 80:
                                                state = (101 if x['distnr_med']<0.253441006 else 102)
                                                if state == 101:
                                                    return -0.0993236676
                                                if state == 102:
                                                    state = (121 if np.isnan(x['rb_med']) or (x['rb_med']<0.521666646)  else 122)
                                                    if state == 121:
                                                        state = (141 if x['col_det']<-0.26115036 else 142)
                                                        if state == 141:
                                                            return -0.159975037
                                                        if state == 142:
                                                            return 0.159583375
                                                    if state == 122:
                                                        return 0.239545897
                                        if state == 64:
                                            state = (81 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.0191917)  else 82)
                                            if state == 81:
                                                return 0.335113972
                                            if state == 82:
                                                return -0.0327994265
                                    if state == 46:
                                        state = (65 if x['col_det']<-0.298700333 else 66)
                                        if state == 65:
                                            return -0.238234133
                                        if state == 66:
                                            state = (83 if x['maggaia_med']<18.5708237 else 84)
                                            if state == 83:
                                                return 0.170106545
                                            if state == 84:
                                                state = (103 if x['distnr_med']<3.06433988 else 104)
                                                if state == 103:
                                                    return 0.136216477
                                                if state == 104:
                                                    return -0.206539631
                                if state == 30:
                                    state = (47 if np.isnan(x['t_lc']) or (x['t_lc']<2.99758673)  else 48)
                                    if state == 47:
                                        state = (67 if x['col_det']<0.326242447 else 68)
                                        if state == 67:
                                            state = (85 if x['maggaia_med']<18.8294353 else 86)
                                            if state == 85:
                                                return 0.144141749
                                            if state == 86:
                                                return -0.33625257
                                        if state == 68:
                                            state = (87 if x['maggaia_med']<19.3316917 else 88)
                                            if state == 87:
                                                state = (105 if x['distnr_med']<1.72137177 else 106)
                                                if state == 105:
                                                    state = (125 if np.isnan(x['rb_med']) or (x['rb_med']<0.623928547)  else 126)
                                                    if state == 125:
                                                        return -0.208143234
                                                    if state == 126:
                                                        state = (145 if x['col_det']<0.356444359 else 146)
                                                        if state == 145:
                                                            return 0.234771162
                                                        if state == 146:
                                                            return -0.00751722045
                                                if state == 106:
                                                    state = (127 if np.isnan(x['rb_med']) or (x['rb_med']<0.569285631)  else 128)
                                                    if state == 127:
                                                        return 0.0913822278
                                                    if state == 128:
                                                        return 0.287899226
                                            if state == 88:
                                                state = (107 if x['distnr_med']<1.92370176 else 108)
                                                if state == 107:
                                                    state = (129 if np.isnan(x['rb_med']) or (x['rb_med']<0.842381001)  else 130)
                                                    if state == 129:
                                                        return 0.0992467999
                                                    if state == 130:
                                                        return -0.317881674
                                                if state == 108:
                                                    return -0.352471322
                                    if state == 48:
                                        return 0.236584872
                            if state == 20:
                                state = (31 if np.isnan(x['col_det']) or (x['col_det']<0.44380188)  else 32)
                                if state == 31:
                                    state = (49 if np.isnan(x['t_lc']) or (x['t_lc']<2.94190979)  else 50)
                                    if state == 49:
                                        state = (69 if np.isnan(x['col_det']) or (x['col_det']<0.0241727829)  else 70)
                                        if state == 69:
                                            state = (89 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.5707359)  else 90)
                                            if state == 89:
                                                state = (109 if x['distnr_med']<0.348801315 else 110)
                                                if state == 109:
                                                    return -0.187221214
                                                if state == 110:
                                                    return 0.275267929
                                            if state == 90:
                                                state = (111 if x['distnr_med']<1.80617881 else 112)
                                                if state == 111:
                                                    return -0.321844071
                                                if state == 112:
                                                    return 0.123435415
                                        if state == 70:
                                            return -0.286159873
                                    if state == 50:
                                        return -0.222227514
                                if state == 32:
                                    return 0.216617957
                        if state == 14:
                            state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.124745294)  else 22)
                            if state == 21:
                                return -0.349275887
                            if state == 22:
                                state = (33 if x['col_det']<-0.20759964 else 34)
                                if state == 33:
                                    state = (51 if np.isnan(x['t_lc']) or (x['t_lc']<0.0633738488)  else 52)
                                    if state == 51:
                                        return -0.0103086857
                                    if state == 52:
                                        return 0.304096818
                                if state == 34:
                                    state = (53 if np.isnan(x['t_lc']) or (x['t_lc']<2.95272565)  else 54)
                                    if state == 53:
                                        state = (71 if np.isnan(x['col_det']) or (x['col_det']<-0.13955307)  else 72)
                                        if state == 71:
                                            return -0.334248573
                                        if state == 72:
                                            state = (91 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.329298)  else 92)
                                            if state == 91:
                                                state = (113 if x['distnr_med']<7.14109421 else 114)
                                                if state == 113:
                                                    state = (135 if np.isnan(x['rb_med']) or (x['rb_med']<0.50666666)  else 136)
                                                    if state == 135:
                                                        return -0.0345116965
                                                    if state == 136:
                                                        return 0.206537351
                                                if state == 114:
                                                    return -0.145103067
                                            if state == 92:
                                                return -0.129484221
                                    if state == 54:
                                        return 0.14726983
                if state == 6:
                    state = (9 if x['maggaia_med']<19.5770149 else 10)
                    if state == 9:
                        return -0.394391418
                    if state == 10:
                        state = (15 if x['distnr_med']<2.59481144 else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0441377498)  else 24)
                            if state == 23:
                                return 0.153194681
                            if state == 24:
                                state = (35 if x['col_det']<-0.0528821945 else 36)
                                if state == 35:
                                    state = (55 if np.isnan(x['t_lc']) or (x['t_lc']<0.063350752)  else 56)
                                    if state == 55:
                                        state = (73 if x['col_det']<-0.301325798 else 74)
                                        if state == 73:
                                            return 0.159578189
                                        if state == 74:
                                            return -0.255875498
                                    if state == 56:
                                        return -0.321978331
                                if state == 36:
                                    state = (57 if np.isnan(x['t_lc']) or (x['t_lc']<0.543153942)  else 58)
                                    if state == 57:
                                        state = (75 if np.isnan(x['col_det']) or (x['col_det']<0.308117867)  else 76)
                                        if state == 75:
                                            state = (93 if x['maggaia_med']<19.9505882 else 94)
                                            if state == 93:
                                                state = (115 if x['distnr_med']<0.693750501 else 116)
                                                if state == 115:
                                                    return 0.163683727
                                                if state == 116:
                                                    return -0.0574509613
                                            if state == 94:
                                                return 0.175208688
                                        if state == 76:
                                            state = (95 if x['maggaia_med']<20.1717758 else 96)
                                            if state == 95:
                                                return -0.162290901
                                            if state == 96:
                                                return 0.100198187
                                    if state == 58:
                                        return -0.0321812071
                        if state == 16:
                            state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96985531)  else 26)
                            if state == 25:
                                state = (37 if np.isnan(x['col_det']) or (x['col_det']<1.10819912)  else 38)
                                if state == 37:
                                    return -0.455883652
                                if state == 38:
                                    return 0.101043977
                            if state == 26:
                                state = (39 if x['col_det']<0.00728130341 else 40)
                                if state == 39:
                                    return -0.144112825
                                if state == 40:
                                    state = (59 if np.isnan(x['t_lc']) or (x['t_lc']<0.00140045001)  else 60)
                                    if state == 59:
                                        return -0.180428892
                                    if state == 60:
                                        return 0.27526325
    elif num_booster == 10:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0562744)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.873729467)  else 4)
                if state == 3:
                    state = (7 if x['maggaia_med']<14.1992092 else 8)
                    if state == 7:
                        state = (13 if x['col_det']<0.162837029 else 14)
                        if state == 13:
                            return 0.138407528
                        if state == 14:
                            return -0.289355427
                    if state == 8:
                        state = (15 if x['col_det']<-0.118923187 else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.513333201)  else 24)
                            if state == 23:
                                state = (33 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0894317031)  else 34)
                                if state == 33:
                                    return 0.202232689
                                if state == 34:
                                    return -0.128430635
                            if state == 24:
                                state = (35 if x['sgscore1_med']<0.0193332992 else 36)
                                if state == 35:
                                    state = (51 if x['magnr_med']<21.4814987 else 52)
                                    if state == 51:
                                        state = (71 if x['maggaia_med']<20.0147247 else 72)
                                        if state == 71:
                                            return -0.214544639
                                        if state == 72:
                                            return 0.132262096
                                    if state == 52:
                                        return -0.336470783
                                if state == 36:
                                    state = (53 if x['magnr_med']<21.1607513 else 54)
                                    if state == 53:
                                        state = (73 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.6058693)  else 74)
                                        if state == 73:
                                            return 0.182864547
                                        if state == 74:
                                            state = (89 if x['distpsnr1_med']<2.69127035 else 90)
                                            if state == 89:
                                                return -0.269715995
                                            if state == 90:
                                                state = (101 if np.isnan(x['mag_last']) or (x['mag_last']<18.9574814)  else 102)
                                                if state == 101:
                                                    return 0.19190073
                                                if state == 102:
                                                    return -0.107045688
                                    if state == 54:
                                        return -0.363455415
                        if state == 16:
                            state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.330357194)  else 26)
                            if state == 25:
                                state = (37 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.482782483)  else 38)
                                if state == 37:
                                    return -0.231082857
                                if state == 38:
                                    state = (55 if x['magnr_med']<20.6167507 else 56)
                                    if state == 55:
                                        return 0.0660176724
                                    if state == 56:
                                        return -0.114612706
                            if state == 26:
                                state = (39 if x['sgscore1_med']<0.0171458013 else 40)
                                if state == 39:
                                    state = (57 if x['magnr_med']<18.4347496 else 58)
                                    if state == 57:
                                        state = (75 if x['maggaia_med']<18.6501007 else 76)
                                        if state == 75:
                                            return -0.323807567
                                        if state == 76:
                                            return 0.18434234
                                    if state == 58:
                                        state = (77 if x['maggaia_med']<19.10009 else 78)
                                        if state == 77:
                                            state = (91 if x['distpsnr1_med']<0.0815681443 else 92)
                                            if state == 91:
                                                return -0.17914702
                                            if state == 92:
                                                state = (103 if np.isnan(x['mag_last']) or (x['mag_last']<19.9484959)  else 104)
                                                if state == 103:
                                                    return 0.280472755
                                                if state == 104:
                                                    return -0.267410696
                                        if state == 78:
                                            state = (93 if x['distpsnr1_med']<0.526782513 else 94)
                                            if state == 93:
                                                return 0.00289796828
                                            if state == 94:
                                                return 0.410839677
                                if state == 40:
                                    state = (59 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5540009)  else 60)
                                    if state == 59:
                                        state = (79 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.421133)  else 80)
                                        if state == 79:
                                            state = (95 if x['distpsnr1_med']<0.250110954 else 96)
                                            if state == 95:
                                                return 0.16196534
                                            if state == 96:
                                                state = (105 if np.isnan(x['mag_last']) or (x['mag_last']<17.8191566)  else 106)
                                                if state == 105:
                                                    return -0.272014588
                                                if state == 106:
                                                    state = (113 if np.isnan(x['mag_det']) or (x['mag_det']<18.39715)  else 114)
                                                    if state == 113:
                                                        return -0.183633715
                                                    if state == 114:
                                                        return 0.0352847315
                                        if state == 80:
                                            return -0.314197421
                                    if state == 60:
                                        state = (81 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4260025)  else 82)
                                        if state == 81:
                                            state = (97 if x['distpsnr1_med']<0.217205286 else 98)
                                            if state == 97:
                                                state = (107 if np.isnan(x['mag_last']) or (x['mag_last']<19.9256554)  else 108)
                                                if state == 107:
                                                    return -0.297230214
                                                if state == 108:
                                                    return 0.208698869
                                            if state == 98:
                                                state = (109 if np.isnan(x['mag_last']) or (x['mag_last']<19.703371)  else 110)
                                                if state == 109:
                                                    state = (115 if np.isnan(x['mag_det']) or (x['mag_det']<19.8779106)  else 116)
                                                    if state == 115:
                                                        state = (123 if x['col_det']<0.231146812 else 124)
                                                        if state == 123:
                                                            return 0.302185714
                                                        if state == 124:
                                                            return 0.128992572
                                                    if state == 116:
                                                        state = (125 if np.isnan(x['col_det']) or (x['col_det']<0.457063675)  else 126)
                                                        if state == 125:
                                                            return 0.413189799
                                                        if state == 126:
                                                            return 0.0432157852
                                                if state == 110:
                                                    state = (117 if np.isnan(x['mag_det']) or (x['mag_det']<20.2395)  else 118)
                                                    if state == 117:
                                                        state = (127 if np.isnan(x['col_det']) or (x['col_det']<-0.0614147186)  else 128)
                                                        if state == 127:
                                                            return -0.189419553
                                                        if state == 128:
                                                            return 0.255528927
                                                    if state == 118:
                                                        return 0.304287821
                                        if state == 82:
                                            state = (99 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.684059858)  else 100)
                                            if state == 99:
                                                return -0.285274863
                                            if state == 100:
                                                state = (111 if np.isnan(x['mag_last']) or (x['mag_last']<19.5233898)  else 112)
                                                if state == 111:
                                                    state = (119 if np.isnan(x['mag_det']) or (x['mag_det']<19.6555996)  else 120)
                                                    if state == 119:
                                                        state = (129 if x['col_det']<0.471012115 else 130)
                                                        if state == 129:
                                                            return 0.192318276
                                                        if state == 130:
                                                            return -0.0951137319
                                                    if state == 120:
                                                        return 0.320765108
                                                if state == 112:
                                                    state = (121 if np.isnan(x['mag_det']) or (x['mag_det']<20.0649872)  else 122)
                                                    if state == 121:
                                                        return -0.327206671
                                                    if state == 122:
                                                        state = (131 if x['col_det']<0.203231812 else 132)
                                                        if state == 131:
                                                            return 0.182161674
                                                        if state == 132:
                                                            return -0.227423921
                if state == 4:
                    return -0.315847307
            if state == 2:
                state = (5 if x['sgscore1_med']<0.119400002 else 6)
                if state == 5:
                    state = (9 if x['maggaia_med']<18.4763603 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['col_det']) or (x['col_det']<0.0781431198)  else 18)
                        if state == 17:
                            return -0.28790912
                        if state == 18:
                            state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.777499914)  else 28)
                            if state == 27:
                                state = (41 if x['sgscore1_med']<0.00883333012 else 42)
                                if state == 41:
                                    return 0.120726421
                                if state == 42:
                                    state = (61 if x['magnr_med']<19.6322498 else 62)
                                    if state == 61:
                                        return 0.0938307643
                                    if state == 62:
                                        return -0.175430402
                            if state == 28:
                                return 0.175946698
                    if state == 10:
                        state = (19 if x['col_det']<-0.00036907196 else 20)
                        if state == 19:
                            return 0.00181703456
                        if state == 20:
                            return -0.466716617
                if state == 6:
                    state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.0120583)  else 12)
                    if state == 11:
                        state = (21 if x['col_det']<0.0816307068 else 22)
                        if state == 21:
                            state = (29 if np.isnan(x['rb_med']) or (x['rb_med']<0.31892848)  else 30)
                            if state == 29:
                                return -0.132061571
                            if state == 30:
                                state = (43 if x['sgscore1_med']<1.28216696 else 44)
                                if state == 43:
                                    return 0.198530808
                                if state == 44:
                                    state = (63 if x['magnr_med']<22.1257496 else 64)
                                    if state == 63:
                                        return 0.0748676062
                                    if state == 64:
                                        return -0.210559756
                        if state == 22:
                            state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.53000015)  else 32)
                            if state == 31:
                                state = (45 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.180081487)  else 46)
                                if state == 45:
                                    state = (65 if x['magnr_med']<21.7877502 else 66)
                                    if state == 65:
                                        state = (83 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<14.6634769)  else 84)
                                        if state == 83:
                                            return -0.0215021688
                                        if state == 84:
                                            return 0.269461066
                                    if state == 66:
                                        return -0.208768412
                                if state == 46:
                                    state = (67 if x['magnr_med']<22.6172485 else 68)
                                    if state == 67:
                                        return -0.305140585
                                    if state == 68:
                                        state = (85 if x['maggaia_med']<37.899559 else 86)
                                        if state == 85:
                                            return -0.198120907
                                        if state == 86:
                                            return 0.0866389126
                            if state == 32:
                                state = (47 if x['sgscore1_med']<0.169351012 else 48)
                                if state == 47:
                                    return -0.0308337882
                                if state == 48:
                                    state = (69 if x['magnr_med']<19.9762497 else 70)
                                    if state == 69:
                                        return -0.380355865
                                    if state == 70:
                                        state = (87 if x['maggaia_med']<37.7381516 else 88)
                                        if state == 87:
                                            return -0.264191091
                                        if state == 88:
                                            return 0.11152938
                    if state == 12:
                        return -0.343441576
    elif num_booster == 11:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95839691)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.559999943)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<27.5614166)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0375867486)  else 16)
                        if state == 15:
                            state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.467500091)  else 32)
                            if state == 31:
                                state = (61 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.725749969)  else 62)
                                if state == 61:
                                    return -0.1712915
                                if state == 62:
                                    state = (89 if x['neargaia_med']<7.69453716 else 90)
                                    if state == 89:
                                        return 0.148336619
                                    if state == 90:
                                        state = (123 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0168402493)  else 124)
                                        if state == 123:
                                            return 0.0499961004
                                        if state == 124:
                                            return -0.152655452
                            if state == 32:
                                state = (63 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.798500001)  else 64)
                                if state == 63:
                                    return -0.123594619
                                if state == 64:
                                    state = (91 if x['neargaia_med']<27.2490768 else 92)
                                    if state == 91:
                                        return -0.0190469734
                                    if state == 92:
                                        return 0.238428175
                        if state == 16:
                            state = (33 if np.isnan(x['rb_med']) or (x['rb_med']<0.416666567)  else 34)
                            if state == 33:
                                state = (65 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.613749981)  else 66)
                                if state == 65:
                                    return -0.266265392
                                if state == 66:
                                    state = (93 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<16.3110161)  else 94)
                                    if state == 93:
                                        state = (125 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90656829)  else 126)
                                        if state == 125:
                                            return -0.295132041
                                        if state == 126:
                                            state = (163 if np.isnan(x['mag_last']) or (x['mag_last']<20.0253353)  else 164)
                                            if state == 163:
                                                return -0.0246382821
                                            if state == 164:
                                                return 0.179467708
                                    if state == 94:
                                        state = (127 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.56246525)  else 128)
                                        if state == 127:
                                            return 0.218556434
                                        if state == 128:
                                            return -0.123046696
                            if state == 34:
                                state = (67 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.966250002)  else 68)
                                if state == 67:
                                    state = (95 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<22.5734215)  else 96)
                                    if state == 95:
                                        state = (129 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0648032501)  else 130)
                                        if state == 129:
                                            state = (165 if np.isnan(x['mag_last']) or (x['mag_last']<19.9464607)  else 166)
                                            if state == 165:
                                                return 0.0397801399
                                            if state == 166:
                                                return -0.155050308
                                        if state == 130:
                                            return -0.341457963
                                    if state == 96:
                                        state = (131 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8897512)  else 132)
                                        if state == 131:
                                            return -0.105967671
                                        if state == 132:
                                            return 0.132290438
                                if state == 68:
                                    state = (97 if x['neargaia_med']<19.2157917 else 98)
                                    if state == 97:
                                        return -0.200059339
                                    if state == 98:
                                        return 0.184395015
                    if state == 8:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0244676005)  else 18)
                        if state == 17:
                            state = (35 if np.isnan(x['rb_med']) or (x['rb_med']<0.511666656)  else 36)
                            if state == 35:
                                return -0.161614507
                            if state == 36:
                                return 0.0528373979
                        if state == 18:
                            return -0.326094717
                if state == 4:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.960377634)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0426967517)  else 20)
                        if state == 19:
                            state = (37 if np.isnan(x['rb_med']) or (x['rb_med']<0.620833397)  else 38)
                            if state == 37:
                                return 0.24700512
                            if state == 38:
                                state = (71 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.898249984)  else 72)
                                if state == 71:
                                    return -0.264683336
                                if state == 72:
                                    return 0.240804359
                        if state == 20:
                            state = (39 if np.isnan(x['rb_med']) or (x['rb_med']<0.845714271)  else 40)
                            if state == 39:
                                state = (73 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.908749938)  else 74)
                                if state == 73:
                                    state = (99 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.767785728)  else 100)
                                    if state == 99:
                                        state = (133 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0692013949)  else 134)
                                        if state == 133:
                                            state = (167 if np.isnan(x['mag_last']) or (x['mag_last']<20.4465675)  else 168)
                                            if state == 167:
                                                return -0.126529977
                                            if state == 168:
                                                return 0.0665756389
                                        if state == 134:
                                            state = (169 if np.isnan(x['mag_last']) or (x['mag_last']<19.6245232)  else 170)
                                            if state == 169:
                                                return -0.0568351559
                                            if state == 170:
                                                return -0.373118639
                                    if state == 100:
                                        return 0.0516485535
                                if state == 74:
                                    state = (101 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.588193059)  else 102)
                                    if state == 101:
                                        state = (135 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.94511557)  else 136)
                                        if state == 135:
                                            state = (171 if np.isnan(x['mag_last']) or (x['mag_last']<18.3292065)  else 172)
                                            if state == 171:
                                                return -0.241550982
                                            if state == 172:
                                                return 0.191729099
                                        if state == 136:
                                            return -0.178608015
                                    if state == 102:
                                        return 0.13839829
                            if state == 40:
                                return -0.38192302
                    if state == 10:
                        state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93641186)  else 22)
                        if state == 21:
                            state = (41 if np.isnan(x['rb_med']) or (x['rb_med']<0.679166555)  else 42)
                            if state == 41:
                                state = (75 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.95450002)  else 76)
                                if state == 75:
                                    state = (103 if x['neargaia_med']<34.8703346 else 104)
                                    if state == 103:
                                        state = (137 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0341030508)  else 138)
                                        if state == 137:
                                            state = (173 if np.isnan(x['mag_last']) or (x['mag_last']<19.3955994)  else 174)
                                            if state == 173:
                                                return 0.128730059
                                            if state == 174:
                                                return -0.17037113
                                        if state == 138:
                                            state = (175 if np.isnan(x['mag_last']) or (x['mag_last']<19.7087631)  else 176)
                                            if state == 175:
                                                state = (197 if x['magnr_med']<17.0960007 else 198)
                                                if state == 197:
                                                    return -0.0952832848
                                                if state == 198:
                                                    return 0.293112665
                                            if state == 176:
                                                state = (199 if x['magnr_med']<18.6040001 else 200)
                                                if state == 199:
                                                    return 0.173461512
                                                if state == 200:
                                                    return -0.298252821
                                    if state == 104:
                                        state = (139 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.54719907)  else 140)
                                        if state == 139:
                                            return -0.306625932
                                        if state == 140:
                                            state = (177 if np.isnan(x['mag_last']) or (x['mag_last']<19.9580154)  else 178)
                                            if state == 177:
                                                return 0.0643802136
                                            if state == 178:
                                                return -0.112331048
                                if state == 76:
                                    state = (105 if x['neargaia_med']<15.5270853 else 106)
                                    if state == 105:
                                        return 0.264049321
                                    if state == 106:
                                        state = (141 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.45163774)  else 142)
                                        if state == 141:
                                            return 0.0449019484
                                        if state == 142:
                                            return -0.321642488
                            if state == 42:
                                state = (77 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976999998)  else 78)
                                if state == 77:
                                    state = (107 if x['neargaia_med']<23.2147026 else 108)
                                    if state == 107:
                                        state = (143 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.104722247)  else 144)
                                        if state == 143:
                                            return -0.398587108
                                        if state == 144:
                                            state = (181 if np.isnan(x['mag_last']) or (x['mag_last']<20.0991325)  else 182)
                                            if state == 181:
                                                return 0.27782625
                                            if state == 182:
                                                return -0.185651496
                                    if state == 108:
                                        state = (145 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.86767364)  else 146)
                                        if state == 145:
                                            state = (183 if np.isnan(x['mag_last']) or (x['mag_last']<19.1510296)  else 184)
                                            if state == 183:
                                                return -0.0603072345
                                            if state == 184:
                                                state = (201 if x['magnr_med']<19.8197479 else 202)
                                                if state == 201:
                                                    return 0.365149498
                                                if state == 202:
                                                    return -0.13615495
                                        if state == 146:
                                            state = (185 if np.isnan(x['mag_last']) or (x['mag_last']<19.7488422)  else 186)
                                            if state == 185:
                                                return 0.109061673
                                            if state == 186:
                                                return -0.204762936
                                if state == 78:
                                    return 0.231626943
                        if state == 22:
                            state = (43 if np.isnan(x['rb_med']) or (x['rb_med']<0.69059515)  else 44)
                            if state == 43:
                                return -0.347069621
                            if state == 44:
                                state = (79 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.898000002)  else 80)
                                if state == 79:
                                    state = (109 if x['neargaia_med']<27.8509407 else 110)
                                    if state == 109:
                                        state = (147 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95020247)  else 148)
                                        if state == 147:
                                            return -0.120950669
                                        if state == 148:
                                            return 0.075551711
                                    if state == 110:
                                        return 0.124054603
                                if state == 80:
                                    state = (111 if x['neargaia_med']<13.1537228 else 112)
                                    if state == 111:
                                        return 0.0162710268
                                    if state == 112:
                                        return -0.212162465
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.503333271)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<29.1880951 else 12)
                    if state == 11:
                        state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97370386)  else 24)
                        if state == 23:
                            return 0.118801497
                        if state == 24:
                            state = (47 if np.isnan(x['rb_med']) or (x['rb_med']<0.354166508)  else 48)
                            if state == 47:
                                return 0.00366948615
                            if state == 48:
                                return -0.279692203
                    if state == 12:
                        state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01947355)  else 26)
                        if state == 25:
                            state = (49 if np.isnan(x['rb_med']) or (x['rb_med']<0.452499837)  else 50)
                            if state == 49:
                                state = (81 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.616999984)  else 82)
                                if state == 81:
                                    return -0.157901391
                                if state == 82:
                                    state = (113 if x['neargaia_med']<49.6701202 else 114)
                                    if state == 113:
                                        return 0.204786301
                                    if state == 114:
                                        return -0.117107362
                            if state == 50:
                                return -0.202511057
                        if state == 26:
                            state = (51 if np.isnan(x['rb_med']) or (x['rb_med']<0.419642866)  else 52)
                            if state == 51:
                                return -0.112322897
                            if state == 52:
                                return 0.243253127
                if state == 6:
                    state = (13 if x['neargaia_med']<19.9994812 else 14)
                    if state == 13:
                        state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97368622)  else 28)
                        if state == 27:
                            state = (53 if np.isnan(x['rb_med']) or (x['rb_med']<0.669166803)  else 54)
                            if state == 53:
                                return -0.0949864984
                            if state == 54:
                                return 0.328193069
                        if state == 28:
                            state = (55 if np.isnan(x['rb_med']) or (x['rb_med']<0.5200001)  else 56)
                            if state == 55:
                                return 0.268403769
                            if state == 56:
                                state = (83 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.942000031)  else 84)
                                if state == 83:
                                    state = (115 if x['neargaia_med']<0.556552172 else 116)
                                    if state == 115:
                                        state = (149 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01721048)  else 150)
                                        if state == 149:
                                            return -0.146191925
                                        if state == 150:
                                            return 0.0828808621
                                    if state == 116:
                                        return -0.320358008
                                if state == 84:
                                    state = (117 if x['neargaia_med']<11.8321075 else 118)
                                    if state == 117:
                                        state = (153 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02593184)  else 154)
                                        if state == 153:
                                            state = (189 if np.isnan(x['mag_last']) or (x['mag_last']<18.6876259)  else 190)
                                            if state == 189:
                                                return -0.161602005
                                            if state == 190:
                                                return 0.0879715756
                                        if state == 154:
                                            return 0.292537361
                                    if state == 118:
                                        state = (155 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01822329)  else 156)
                                        if state == 155:
                                            return -0.287236989
                                        if state == 156:
                                            state = (191 if np.isnan(x['mag_last']) or (x['mag_last']<19.615181)  else 192)
                                            if state == 191:
                                                return -0.139913902
                                            if state == 192:
                                                return 0.167558268
                    if state == 14:
                        state = (29 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00790501)  else 30)
                        if state == 29:
                            state = (57 if np.isnan(x['rb_med']) or (x['rb_med']<0.518333316)  else 58)
                            if state == 57:
                                return 0.338348269
                            if state == 58:
                                state = (85 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.752499998)  else 86)
                                if state == 85:
                                    return -0.231650785
                                if state == 86:
                                    state = (119 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<42.0890503)  else 120)
                                    if state == 119:
                                        state = (157 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0022974)  else 158)
                                        if state == 157:
                                            state = (193 if np.isnan(x['mag_last']) or (x['mag_last']<20.106205)  else 194)
                                            if state == 193:
                                                state = (207 if x['magnr_med']<17.9292488 else 208)
                                                if state == 207:
                                                    return 0.00258283783
                                                if state == 208:
                                                    return 0.320792258
                                            if state == 194:
                                                state = (209 if x['magnr_med']<18.0904999 else 210)
                                                if state == 209:
                                                    return 0.233069181
                                                if state == 210:
                                                    state = (211 if np.isnan(x['mag_det']) or (x['mag_det']<20.1048126)  else 212)
                                                    if state == 211:
                                                        return 0.143905908
                                                    if state == 212:
                                                        return -0.225142717
                                        if state == 158:
                                            return -0.0112428861
                                    if state == 120:
                                        state = (159 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96367478)  else 160)
                                        if state == 159:
                                            return 0.113976061
                                        if state == 160:
                                            return -0.135178953
                        if state == 30:
                            state = (59 if np.isnan(x['rb_med']) or (x['rb_med']<0.580118895)  else 60)
                            if state == 59:
                                return -0.121167161
                            if state == 60:
                                state = (87 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.824249983)  else 88)
                                if state == 87:
                                    return -0.262345761
                                if state == 88:
                                    state = (121 if x['neargaia_med']<63.4665375 else 122)
                                    if state == 121:
                                        state = (161 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0244503)  else 162)
                                        if state == 161:
                                            return -0.194613397
                                        if state == 162:
                                            return 0.200967163
                                    if state == 122:
                                        return 0.232778773
    elif num_booster == 12:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.5337496)  else 2)
            if state == 1:
                return -0.338781267
            if state == 2:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.7920418)  else 4)
                if state == 3:
                    state = (5 if x['neargaia_med']<4.44630623 else 6)
                    if state == 5:
                        state = (9 if x['distnr_med']<0.691525221 else 10)
                        if state == 9:
                            state = (17 if x['magnr_med']<18.4632492 else 18)
                            if state == 17:
                                state = (29 if x['col_det']<0.0990447998 else 30)
                                if state == 29:
                                    return 0.325488269
                                if state == 30:
                                    state = (49 if x['distpsnr1_med']<0.552746177 else 50)
                                    if state == 49:
                                        state = (77 if x['magnr_med']<15.5342503 else 78)
                                        if state == 77:
                                            return 0.142794892
                                        if state == 78:
                                            return -0.108646132
                                    if state == 50:
                                        return 0.176195741
                            if state == 18:
                                return -0.105878308
                        if state == 10:
                            state = (19 if x['magnr_med']<16.5545006 else 20)
                            if state == 19:
                                return -0.217628762
                            if state == 20:
                                state = (31 if np.isnan(x['col_det']) or (x['col_det']<-0.220357895)  else 32)
                                if state == 31:
                                    state = (51 if x['distpsnr1_med']<1.11264277 else 52)
                                    if state == 51:
                                        state = (79 if x['magnr_med']<18.0240002 else 80)
                                        if state == 79:
                                            return -0.216854572
                                        if state == 80:
                                            return 0.107718632
                                    if state == 52:
                                        state = (81 if x['magnr_med']<18.5142479 else 82)
                                        if state == 81:
                                            state = (107 if np.isnan(x['mag_last']) or (x['mag_last']<18.6844139)  else 108)
                                            if state == 107:
                                                return 0.132888868
                                            if state == 108:
                                                return -0.180965766
                                        if state == 82:
                                            return 0.18795605
                                if state == 32:
                                    state = (53 if x['distpsnr1_med']<1.90270615 else 54)
                                    if state == 53:
                                        return -0.244848624
                                    if state == 54:
                                        state = (83 if x['magnr_med']<18.1637497 else 84)
                                        if state == 83:
                                            return 0.11606852
                                        if state == 84:
                                            return -0.108655065
                    if state == 6:
                        state = (11 if x['distnr_med']<12.2598324 else 12)
                        if state == 11:
                            state = (21 if x['magnr_med']<22.0662498 else 22)
                            if state == 21:
                                state = (33 if np.isnan(x['col_det']) or (x['col_det']<-0.521520615)  else 34)
                                if state == 33:
                                    state = (55 if x['distpsnr1_med']<0.148055196 else 56)
                                    if state == 55:
                                        return -0.0980245396
                                    if state == 56:
                                        state = (85 if x['magnr_med']<17.5157509 else 86)
                                        if state == 85:
                                            state = (109 if np.isnan(x['mag_last']) or (x['mag_last']<19.5035019)  else 110)
                                            if state == 109:
                                                state = (125 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.452003002)  else 126)
                                                if state == 125:
                                                    return -0.186849773
                                                if state == 126:
                                                    return 0.0976746231
                                            if state == 110:
                                                return 0.113976195
                                        if state == 86:
                                            state = (111 if np.isnan(x['mag_last']) or (x['mag_last']<19.6657715)  else 112)
                                            if state == 111:
                                                state = (127 if x['sgscore1_med']<0.57388401 else 128)
                                                if state == 127:
                                                    return 0.399844408
                                                if state == 128:
                                                    return 0.173329607
                                            if state == 112:
                                                state = (129 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0386041999)  else 130)
                                                if state == 129:
                                                    return 0.0969366208
                                                if state == 130:
                                                    return -0.15317215
                                if state == 34:
                                    state = (57 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.96097279)  else 58)
                                    if state == 57:
                                        state = (87 if x['magnr_med']<21.1917496 else 88)
                                        if state == 87:
                                            state = (113 if np.isnan(x['mag_last']) or (x['mag_last']<19.1472836)  else 114)
                                            if state == 113:
                                                state = (131 if x['sgscore1_med']<1.41863108 else 132)
                                                if state == 131:
                                                    state = (141 if x['col_det']<0.17632103 else 142)
                                                    if state == 141:
                                                        return -0.417964369
                                                    if state == 142:
                                                        return 0.0836978853
                                                if state == 132:
                                                    state = (143 if x['col_det']<-0.260450363 else 144)
                                                    if state == 143:
                                                        return 0.14122805
                                                    if state == 144:
                                                        return -0.0640965402
                                            if state == 114:
                                                state = (133 if x['sgscore1_med']<0.232387006 else 134)
                                                if state == 133:
                                                    state = (145 if x['col_det']<0.217421532 else 146)
                                                    if state == 145:
                                                        return 0.105543181
                                                    if state == 146:
                                                        state = (149 if x['neargaia_med']<42.2250328 else 150)
                                                        if state == 149:
                                                            return 0.0744583905
                                                        if state == 150:
                                                            return -0.166529983
                                                if state == 134:
                                                    return 0.272237092
                                        if state == 88:
                                            return -0.451072127
                                    if state == 58:
                                        state = (89 if x['magnr_med']<21.2900009 else 90)
                                        if state == 89:
                                            return 0.246366277
                                        if state == 90:
                                            return -0.129195362
                            if state == 22:
                                state = (35 if np.isnan(x['col_det']) or (x['col_det']<-0.367570877)  else 36)
                                if state == 35:
                                    state = (59 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.14850712)  else 60)
                                    if state == 59:
                                        return -0.27628994
                                    if state == 60:
                                        state = (91 if x['magnr_med']<22.6905003 else 92)
                                        if state == 91:
                                            state = (115 if np.isnan(x['mag_last']) or (x['mag_last']<17.3204784)  else 116)
                                            if state == 115:
                                                return 0.122903675
                                            if state == 116:
                                                state = (135 if x['sgscore1_med']<0.00425000023 else 136)
                                                if state == 135:
                                                    return 0.0992800146
                                                if state == 136:
                                                    return -0.193965778
                                        if state == 92:
                                            return 0.23954542
                                if state == 36:
                                    return -0.406276911
                        if state == 12:
                            return -0.245113447
                if state == 4:
                    state = (7 if x['neargaia_med']<22.8072262 else 8)
                    if state == 7:
                        state = (13 if x['distnr_med']<0.201410025 else 14)
                        if state == 13:
                            return 0.0398421288
                        if state == 14:
                            state = (23 if x['magnr_med']<21.2145004 else 24)
                            if state == 23:
                                state = (37 if x['col_det']<-0.0165328979 else 38)
                                if state == 37:
                                    state = (61 if x['distpsnr1_med']<0.855360627 else 62)
                                    if state == 61:
                                        return -0.103995025
                                    if state == 62:
                                        return 0.186291412
                                if state == 38:
                                    state = (63 if x['distpsnr1_med']<6.75426865 else 64)
                                    if state == 63:
                                        return -0.43351838
                                    if state == 64:
                                        return -0.0453331172
                            if state == 24:
                                state = (39 if np.isnan(x['col_det']) or (x['col_det']<-0.00648117065)  else 40)
                                if state == 39:
                                    return -0.323862284
                                if state == 40:
                                    state = (65 if x['distpsnr1_med']<14.8677473 else 66)
                                    if state == 65:
                                        return 0.199028343
                                    if state == 66:
                                        return -0.143294439
                    if state == 8:
                        state = (15 if x['distnr_med']<2.19575906 else 16)
                        if state == 15:
                            state = (25 if x['magnr_med']<19.2777481 else 26)
                            if state == 25:
                                state = (41 if x['col_det']<0.813950539 else 42)
                                if state == 41:
                                    state = (67 if x['distpsnr1_med']<0.476442069 else 68)
                                    if state == 67:
                                        return -0.128562361
                                    if state == 68:
                                        state = (95 if x['magnr_med']<18.5272522 else 96)
                                        if state == 95:
                                            return 0.26609984
                                        if state == 96:
                                            state = (121 if np.isnan(x['mag_last']) or (x['mag_last']<19.9331322)  else 122)
                                            if state == 121:
                                                return 0.131555393
                                            if state == 122:
                                                return -0.205226496
                                if state == 42:
                                    state = (69 if x['distpsnr1_med']<3.64848089 else 70)
                                    if state == 69:
                                        return -0.316739172
                                    if state == 70:
                                        state = (97 if x['magnr_med']<18.6072502 else 98)
                                        if state == 97:
                                            return 0.0951290056
                                        if state == 98:
                                            return -0.218941525
                            if state == 26:
                                state = (43 if x['col_det']<0.426534653 else 44)
                                if state == 43:
                                    state = (71 if x['distpsnr1_med']<0.535810471 else 72)
                                    if state == 71:
                                        return -0.116097011
                                    if state == 72:
                                        return 0.223213822
                                if state == 44:
                                    state = (73 if x['distpsnr1_med']<40.1616745 else 74)
                                    if state == 73:
                                        state = (99 if x['magnr_med']<19.6349983 else 100)
                                        if state == 99:
                                            return 0.0478193797
                                        if state == 100:
                                            return -0.307093352
                                    if state == 74:
                                        state = (101 if x['magnr_med']<20.1580009 else 102)
                                        if state == 101:
                                            state = (123 if np.isnan(x['mag_last']) or (x['mag_last']<20.5244007)  else 124)
                                            if state == 123:
                                                return 0.266405106
                                            if state == 124:
                                                return -0.138874158
                                        if state == 102:
                                            return -0.177427977
                        if state == 16:
                            state = (27 if x['magnr_med']<22.3155003 else 28)
                            if state == 27:
                                state = (45 if np.isnan(x['col_det']) or (x['col_det']<0.281193733)  else 46)
                                if state == 45:
                                    return -0.338018775
                                if state == 46:
                                    state = (75 if x['distpsnr1_med']<9.28799725 else 76)
                                    if state == 75:
                                        return 0.169634134
                                    if state == 76:
                                        state = (103 if x['magnr_med']<19.3217506 else 104)
                                        if state == 103:
                                            return 0.10327664
                                        if state == 104:
                                            return -0.106521584
                            if state == 28:
                                state = (47 if x['col_det']<0.25622654 else 48)
                                if state == 47:
                                    return 0.311580718
                                if state == 48:
                                    return -0.333135337
    elif num_booster == 13:
        state = 0
        if state == 0:
            state = (1 if x['distnr_med']<12.2592449 else 2)
            if state == 1:
                state = (3 if x['magnr_med']<15.5337496 else 4)
                if state == 3:
                    return -0.316142052
                if state == 4:
                    state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<7.86786699)  else 6)
                    if state == 5:
                        state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.733333409)  else 8)
                        if state == 7:
                            state = (11 if x['magnr_med']<21.7092495 else 12)
                            if state == 11:
                                state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.680357218)  else 20)
                                if state == 19:
                                    state = (31 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0250001)  else 32)
                                    if state == 31:
                                        state = (45 if np.isnan(x['mag_det']) or (x['mag_det']<20.4860001)  else 46)
                                        if state == 45:
                                            state = (69 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96976852)  else 70)
                                            if state == 69:
                                                state = (89 if x['neargaia_med']<1.22065973 else 90)
                                                if state == 89:
                                                    return -0.175459176
                                                if state == 90:
                                                    state = (109 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<41.8243561)  else 110)
                                                    if state == 109:
                                                        state = (117 if np.isnan(x['mag_det']) or (x['mag_det']<19.0695992)  else 118)
                                                        if state == 117:
                                                            return 0.0497388765
                                                        if state == 118:
                                                            return 0.174148411
                                                    if state == 110:
                                                        return -0.154318631
                                            if state == 70:
                                                state = (91 if x['neargaia_med']<31.9943962 else 92)
                                                if state == 91:
                                                    return -0.209497556
                                                if state == 92:
                                                    return 0.180168852
                                        if state == 46:
                                            state = (71 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.0336864)  else 72)
                                            if state == 71:
                                                state = (93 if x['neargaia_med']<48.6984138 else 94)
                                                if state == 93:
                                                    return -0.195050195
                                                if state == 94:
                                                    return 0.142718822
                                            if state == 72:
                                                return -0.297435254
                                    if state == 32:
                                        state = (47 if np.isnan(x['mag_det']) or (x['mag_det']<19.4412994)  else 48)
                                        if state == 47:
                                            return -0.0747481585
                                        if state == 48:
                                            return 0.184034929
                                if state == 20:
                                    state = (33 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0322800986)  else 34)
                                    if state == 33:
                                        return -0.132404327
                                    if state == 34:
                                        state = (49 if np.isnan(x['mag_det']) or (x['mag_det']<19.9482498)  else 50)
                                        if state == 49:
                                            return 0.293475568
                                        if state == 50:
                                            state = (73 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9439292)  else 74)
                                            if state == 73:
                                                state = (95 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<3.40692806)  else 96)
                                                if state == 95:
                                                    state = (113 if x['neargaia_med']<0.959630132 else 114)
                                                    if state == 113:
                                                        return 0.11806795
                                                    if state == 114:
                                                        state = (121 if np.isnan(x['mag_det']) or (x['mag_det']<20.4368496)  else 122)
                                                        if state == 121:
                                                            return -0.167150602
                                                        if state == 122:
                                                            return 0.137703598
                                                if state == 96:
                                                    return 0.190993071
                                            if state == 74:
                                                state = (97 if x['neargaia_med']<38.0834656 else 98)
                                                if state == 97:
                                                    return 0.0518330634
                                                if state == 98:
                                                    return -0.149690613
                            if state == 12:
                                state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.65464282)  else 22)
                                if state == 21:
                                    state = (35 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00225687)  else 36)
                                    if state == 35:
                                        state = (51 if np.isnan(x['mag_det']) or (x['mag_det']<20.15765)  else 52)
                                        if state == 51:
                                            return -0.351303577
                                        if state == 52:
                                            state = (75 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90758681)  else 76)
                                            if state == 75:
                                                return -0.221479565
                                            if state == 76:
                                                state = (99 if x['neargaia_med']<116.112091 else 100)
                                                if state == 99:
                                                    return -0.136985645
                                                if state == 100:
                                                    return 0.127001762
                                    if state == 36:
                                        return 0.0231221635
                                if state == 22:
                                    return 0.116037607
                        if state == 8:
                            state = (13 if x['magnr_med']<19.3732491 else 14)
                            if state == 13:
                                state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.744404674)  else 24)
                                if state == 23:
                                    return -0.188493028
                                if state == 24:
                                    state = (37 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.191666663)  else 38)
                                    if state == 37:
                                        state = (55 if np.isnan(x['mag_det']) or (x['mag_det']<20.3899994)  else 56)
                                        if state == 55:
                                            state = (77 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0227604508)  else 78)
                                            if state == 77:
                                                return 0.120734915
                                            if state == 78:
                                                state = (101 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<24.9171104)  else 102)
                                                if state == 101:
                                                    return -0.322303206
                                                if state == 102:
                                                    return 0.0374175943
                                        if state == 56:
                                            return 0.119518243
                                    if state == 38:
                                        state = (57 if np.isnan(x['mag_det']) or (x['mag_det']<19.8684502)  else 58)
                                        if state == 57:
                                            state = (81 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.01868057)  else 82)
                                            if state == 81:
                                                return -0.000569163298
                                            if state == 82:
                                                return 0.303046614
                                        if state == 58:
                                            state = (83 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95282412)  else 84)
                                            if state == 83:
                                                return 0.108665511
                                            if state == 84:
                                                return -0.362345815
                            if state == 14:
                                state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.911785483)  else 26)
                                if state == 25:
                                    return -0.415424645
                                if state == 26:
                                    state = (39 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96186352)  else 40)
                                    if state == 39:
                                        state = (59 if np.isnan(x['mag_det']) or (x['mag_det']<18.3064995)  else 60)
                                        if state == 59:
                                            return 0.0159480572
                                        if state == 60:
                                            return -0.298014402
                                    if state == 40:
                                        state = (61 if np.isnan(x['mag_det']) or (x['mag_det']<18.9053001)  else 62)
                                        if state == 61:
                                            return -0.0643702224
                                        if state == 62:
                                            return 0.109620817
                    if state == 6:
                        state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.496666521)  else 10)
                        if state == 9:
                            state = (15 if x['magnr_med']<22.6417503 else 16)
                            if state == 15:
                                state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.422500074)  else 28)
                                if state == 27:
                                    state = (41 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.124745294)  else 42)
                                    if state == 41:
                                        return -0.0871188268
                                    if state == 42:
                                        state = (65 if np.isnan(x['mag_det']) or (x['mag_det']<20.3346996)  else 66)
                                        if state == 65:
                                            state = (85 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.9845891)  else 86)
                                            if state == 85:
                                                return 0.372970194
                                            if state == 86:
                                                state = (105 if x['neargaia_med']<30.3646622 else 106)
                                                if state == 105:
                                                    state = (115 if x['neargaia_med']<9.11329842 else 116)
                                                    if state == 115:
                                                        return 0.130318508
                                                    if state == 116:
                                                        return -0.132948145
                                                if state == 106:
                                                    return 0.176617756
                                        if state == 66:
                                            return -0.187614799
                                if state == 28:
                                    return -0.216113627
                            if state == 16:
                                return -0.277825356
                        if state == 10:
                            state = (17 if x['magnr_med']<22.3227501 else 18)
                            if state == 17:
                                return 0.27402854
                            if state == 18:
                                state = (29 if np.isnan(x['rb_med']) or (x['rb_med']<0.498333335)  else 30)
                                if state == 29:
                                    return 0.251893014
                                if state == 30:
                                    state = (43 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.986487269)  else 44)
                                    if state == 43:
                                        return -0.223250479
                                    if state == 44:
                                        state = (67 if np.isnan(x['mag_det']) or (x['mag_det']<20.237999)  else 68)
                                        if state == 67:
                                            state = (87 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97181702)  else 88)
                                            if state == 87:
                                                return -0.219660863
                                            if state == 88:
                                                return 0.00187688484
                                        if state == 68:
                                            return 0.227582395
            if state == 2:
                return -0.27447623
    elif num_booster == 14:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<18.396801)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<0.0325637013)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.106433347)  else 8)
                    if state == 7:
                        return 0.111145861
                    if state == 8:
                        return -0.177526265
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.590795994 else 10)
                    if state == 9:
                        state = (13 if x['neargaia_med']<130.080994 else 14)
                        if state == 13:
                            state = (19 if x['magnr_med']<22.2600002 else 20)
                            if state == 19:
                                return -0.199626356
                            if state == 20:
                                return 0.0316866189
                        if state == 14:
                            return 0.136446953
                    if state == 10:
                        return -0.339655071
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 6)
                if state == 5:
                    return -0.306022942
                if state == 6:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.500625014)  else 12)
                    if state == 11:
                        state = (15 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<1.84909284)  else 16)
                        if state == 15:
                            state = (21 if x['magnr_med']<17.993 else 22)
                            if state == 21:
                                state = (29 if x['magnr_med']<16.7097492 else 30)
                                if state == 29:
                                    state = (41 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.203494012)  else 42)
                                    if state == 41:
                                        state = (53 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.50756574)  else 54)
                                        if state == 53:
                                            return -0.211585209
                                        if state == 54:
                                            return 0.086914897
                                    if state == 42:
                                        return 0.148326278
                                if state == 30:
                                    state = (43 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0874523968)  else 44)
                                    if state == 43:
                                        return -0.313162923
                                    if state == 44:
                                        state = (55 if x['distpsnr1_med']<1.08468556 else 56)
                                        if state == 55:
                                            return -0.207660139
                                        if state == 56:
                                            return 0.120841168
                            if state == 22:
                                state = (31 if x['magnr_med']<18.4724998 else 32)
                                if state == 31:
                                    state = (45 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00354166515)  else 46)
                                    if state == 45:
                                        return 0.29944402
                                    if state == 46:
                                        state = (57 if x['distpsnr1_med']<0.118212685 else 58)
                                        if state == 57:
                                            return 0.0927224979
                                        if state == 58:
                                            state = (71 if np.isnan(x['mag_det']) or (x['mag_det']<19.9398499)  else 72)
                                            if state == 71:
                                                return 0.0726406798
                                            if state == 72:
                                                return -0.155863538
                                if state == 32:
                                    state = (47 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0077083353)  else 48)
                                    if state == 47:
                                        state = (59 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.00581098)  else 60)
                                        if state == 59:
                                            state = (73 if np.isnan(x['mag_det']) or (x['mag_det']<20.5095997)  else 74)
                                            if state == 73:
                                                state = (85 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90656829)  else 86)
                                                if state == 85:
                                                    state = (97 if np.isnan(x['mag_det']) or (x['mag_det']<20.4794502)  else 98)
                                                    if state == 97:
                                                        return -0.156020299
                                                    if state == 98:
                                                        return 0.19184579
                                                if state == 86:
                                                    state = (99 if np.isnan(x['mag_det']) or (x['mag_det']<19.8790741)  else 100)
                                                    if state == 99:
                                                        return 0.274873406
                                                    if state == 100:
                                                        return 0.074962683
                                            if state == 74:
                                                return -0.320900947
                                        if state == 60:
                                            state = (75 if np.isnan(x['mag_det']) or (x['mag_det']<19.4990501)  else 76)
                                            if state == 75:
                                                return 0.102266856
                                            if state == 76:
                                                return -0.361685127
                                    if state == 48:
                                        state = (61 if x['distpsnr1_med']<0.530229807 else 62)
                                        if state == 61:
                                            return -0.179176852
                                        if state == 62:
                                            state = (77 if np.isnan(x['mag_det']) or (x['mag_det']<20.3931007)  else 78)
                                            if state == 77:
                                                state = (87 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.4488368)  else 88)
                                                if state == 87:
                                                    state = (101 if np.isnan(x['mag_det']) or (x['mag_det']<20.1676998)  else 102)
                                                    if state == 101:
                                                        return -0.15047133
                                                    if state == 102:
                                                        return 0.106138371
                                                if state == 88:
                                                    return 0.257587016
                                            if state == 78:
                                                state = (89 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.0106771)  else 90)
                                                if state == 89:
                                                    return 0.0842576697
                                                if state == 90:
                                                    return -0.18991746
                        if state == 16:
                            state = (23 if x['magnr_med']<22.3322506 else 24)
                            if state == 23:
                                state = (33 if x['magnr_med']<16.7587509 else 34)
                                if state == 33:
                                    return -0.160555512
                                if state == 34:
                                    state = (49 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0141874999)  else 50)
                                    if state == 49:
                                        state = (63 if x['distpsnr1_med']<4.35730457 else 64)
                                        if state == 63:
                                            state = (79 if np.isnan(x['mag_det']) or (x['mag_det']<20.77635)  else 80)
                                            if state == 79:
                                                state = (91 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00671291)  else 92)
                                                if state == 91:
                                                    state = (105 if np.isnan(x['mag_det']) or (x['mag_det']<19.7211494)  else 106)
                                                    if state == 105:
                                                        return -0.0675413236
                                                    if state == 106:
                                                        state = (113 if x['neargaia_med']<25.120039 else 114)
                                                        if state == 113:
                                                            return 0.179440975
                                                        if state == 114:
                                                            return 0.0329223163
                                                if state == 92:
                                                    return -0.240089566
                                            if state == 80:
                                                return -0.207304537
                                        if state == 64:
                                            return 0.150428027
                                    if state == 50:
                                        state = (65 if x['distpsnr1_med']<9.00817108 else 66)
                                        if state == 65:
                                            state = (81 if np.isnan(x['mag_det']) or (x['mag_det']<20.4805984)  else 82)
                                            if state == 81:
                                                state = (93 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0338888504)  else 94)
                                                if state == 93:
                                                    return -0.0716487616
                                                if state == 94:
                                                    state = (107 if np.isnan(x['mag_det']) or (x['mag_det']<19.6975498)  else 108)
                                                    if state == 107:
                                                        state = (115 if x['neargaia_med']<2.38972855 else 116)
                                                        if state == 115:
                                                            return -0.00717836991
                                                        if state == 116:
                                                            return 0.272199959
                                                    if state == 108:
                                                        state = (117 if x['neargaia_med']<51.5619392 else 118)
                                                        if state == 117:
                                                            return 0.155149668
                                                        if state == 118:
                                                            return -0.137786731
                                            if state == 82:
                                                state = (95 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02316546)  else 96)
                                                if state == 95:
                                                    state = (109 if np.isnan(x['mag_det']) or (x['mag_det']<20.5352001)  else 110)
                                                    if state == 109:
                                                        return -0.201402262
                                                    if state == 110:
                                                        return -0.00967144687
                                                if state == 96:
                                                    return 0.125385776
                                        if state == 66:
                                            return 0.307097971
                            if state == 24:
                                state = (35 if x['magnr_med']<22.6940002 else 36)
                                if state == 35:
                                    return -0.275381416
                                if state == 36:
                                    state = (51 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.344024003)  else 52)
                                    if state == 51:
                                        state = (67 if x['distpsnr1_med']<6.70453358 else 68)
                                        if state == 67:
                                            return 0.0287456475
                                        if state == 68:
                                            return -0.208121404
                                    if state == 52:
                                        state = (69 if x['distpsnr1_med']<12.838953 else 70)
                                        if state == 69:
                                            state = (83 if np.isnan(x['mag_det']) or (x['mag_det']<19.6687508)  else 84)
                                            if state == 83:
                                                return -0.109315187
                                            if state == 84:
                                                return 0.26730001
                                        if state == 70:
                                            return 0.0122568728
                    if state == 12:
                        state = (17 if x['neargaia_med']<31.4047813 else 18)
                        if state == 17:
                            state = (25 if x['magnr_med']<22.0267487 else 26)
                            if state == 25:
                                return -0.306778938
                            if state == 26:
                                state = (37 if x['magnr_med']<22.6022491 else 38)
                                if state == 37:
                                    return 0.0403892584
                                if state == 38:
                                    return -0.177729979
                        if state == 18:
                            state = (27 if x['magnr_med']<19.6549988 else 28)
                            if state == 27:
                                return 0.150673375
                            if state == 28:
                                return -0.0550513901
    elif num_booster == 15:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.873729467)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.655822754)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.981750011)  else 16)
                        if state == 15:
                            return -0.303124636
                        if state == 16:
                            return 0.0146701401
                    if state == 8:
                        state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.69174999)  else 18)
                        if state == 17:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.258095086)  else 22)
                            if state == 21:
                                state = (25 if x['distnr_med']<5.51353455 else 26)
                                if state == 25:
                                    return -0.125300676
                                if state == 26:
                                    return 0.0690477192
                            if state == 22:
                                state = (27 if x['distnr_med']<11.4715662 else 28)
                                if state == 27:
                                    state = (33 if x['distnr_med']<0.122701108 else 34)
                                    if state == 33:
                                        return 0.0701077208
                                    if state == 34:
                                        state = (43 if x['neargaia_med']<11.8054638 else 44)
                                        if state == 43:
                                            state = (55 if x['distnr_med']<1.99890637 else 56)
                                            if state == 55:
                                                return -0.262865305
                                            if state == 56:
                                                return 0.0771933869
                                        if state == 44:
                                            return -0.353652984
                                if state == 28:
                                    return 0.117066003
                        if state == 18:
                            state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.731190503)  else 24)
                            if state == 23:
                                state = (29 if x['distnr_med']<0.647312045 else 30)
                                if state == 29:
                                    state = (35 if x['distnr_med']<0.427625775 else 36)
                                    if state == 35:
                                        state = (45 if x['neargaia_med']<29.0862751 else 46)
                                        if state == 45:
                                            state = (57 if x['distnr_med']<0.21513465 else 58)
                                            if state == 57:
                                                state = (69 if x['magnr_med']<17.0534992 else 70)
                                                if state == 69:
                                                    return 0.150929332
                                                if state == 70:
                                                    return -0.111374214
                                            if state == 58:
                                                return -0.193332344
                                        if state == 46:
                                            state = (59 if x['distnr_med']<0.382870823 else 60)
                                            if state == 59:
                                                state = (71 if x['magnr_med']<21.573 else 72)
                                                if state == 71:
                                                    return -0.122086994
                                                if state == 72:
                                                    return 0.149128675
                                            if state == 60:
                                                return 0.211553007
                                    if state == 36:
                                        return -0.184582233
                                if state == 30:
                                    state = (37 if x['distnr_med']<9.34478569 else 38)
                                    if state == 37:
                                        state = (47 if x['neargaia_med']<41.6847992 else 48)
                                        if state == 47:
                                            state = (61 if x['distnr_med']<5.26359272 else 62)
                                            if state == 61:
                                                state = (73 if x['magnr_med']<16.52425 else 74)
                                                if state == 73:
                                                    return -0.164627731
                                                if state == 74:
                                                    state = (87 if x['col_det']<-0.109416962 else 88)
                                                    if state == 87:
                                                        state = (101 if x['neargaia_med']<6.89260435 else 102)
                                                        if state == 101:
                                                            return -0.167321146
                                                        if state == 102:
                                                            return 0.0305292346
                                                    if state == 88:
                                                        return 0.254667699
                                            if state == 62:
                                                state = (75 if x['magnr_med']<20.8922501 else 76)
                                                if state == 75:
                                                    return -0.24223499
                                                if state == 76:
                                                    return 0.186816022
                                        if state == 48:
                                            state = (63 if x['distnr_med']<0.954876423 else 64)
                                            if state == 63:
                                                return -0.0886647031
                                            if state == 64:
                                                state = (79 if x['magnr_med']<20.3037491 else 80)
                                                if state == 79:
                                                    state = (89 if x['col_det']<0.294365883 else 90)
                                                    if state == 89:
                                                        return 0.210063636
                                                    if state == 90:
                                                        state = (103 if x['neargaia_med']<127.104347 else 104)
                                                        if state == 103:
                                                            return -0.0566744171
                                                        if state == 104:
                                                            return 0.10769967
                                                if state == 80:
                                                    state = (91 if np.isnan(x['col_det']) or (x['col_det']<-0.364094734)  else 92)
                                                    if state == 91:
                                                        return -0.111937992
                                                    if state == 92:
                                                        return 0.0494538248
                                    if state == 38:
                                        return -0.169680834
                            if state == 24:
                                state = (31 if x['distnr_med']<2.51209402 else 32)
                                if state == 31:
                                    state = (39 if x['distnr_med']<1.89057672 else 40)
                                    if state == 39:
                                        state = (49 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<63.658287)  else 50)
                                        if state == 49:
                                            state = (65 if x['distnr_med']<0.318104029 else 66)
                                            if state == 65:
                                                state = (81 if x['magnr_med']<18.8959999 else 82)
                                                if state == 81:
                                                    state = (93 if np.isnan(x['col_det']) or (x['col_det']<0.0157594681)  else 94)
                                                    if state == 93:
                                                        return -0.15659909
                                                    if state == 94:
                                                        return 0.092633307
                                                if state == 82:
                                                    return -0.233082756
                                            if state == 66:
                                                state = (83 if x['magnr_med']<19.3719997 else 84)
                                                if state == 83:
                                                    state = (95 if np.isnan(x['col_det']) or (x['col_det']<-0.200656891)  else 96)
                                                    if state == 95:
                                                        state = (107 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<9.72846603)  else 108)
                                                        if state == 107:
                                                            return -0.0740445033
                                                        if state == 108:
                                                            return 0.0779106319
                                                    if state == 96:
                                                        state = (109 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<41.9649811)  else 110)
                                                        if state == 109:
                                                            return 0.203597069
                                                        if state == 110:
                                                            return -0.0982049555
                                                if state == 84:
                                                    state = (97 if x['col_det']<-0.307743073 else 98)
                                                    if state == 97:
                                                        return 0.151988149
                                                    if state == 98:
                                                        return -0.288243234
                                        if state == 50:
                                            return 0.21340023
                                    if state == 40:
                                        return 0.225833088
                                if state == 32:
                                    state = (41 if x['distnr_med']<6.78640652 else 42)
                                    if state == 41:
                                        state = (51 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<15.4492884)  else 52)
                                        if state == 51:
                                            state = (67 if x['distnr_med']<3.12132573 else 68)
                                            if state == 67:
                                                return -0.193861812
                                            if state == 68:
                                                state = (85 if x['magnr_med']<22.3139992 else 86)
                                                if state == 85:
                                                    state = (99 if x['col_det']<-0.102819443 else 100)
                                                    if state == 99:
                                                        return 0.0176748335
                                                    if state == 100:
                                                        return -0.202822104
                                                if state == 86:
                                                    return 0.137408197
                                        if state == 52:
                                            return -0.362589747
                                    if state == 42:
                                        return 0.034390416
                if state == 4:
                    return -0.187468573
            if state == 2:
                state = (5 if np.isnan(x['col_det']) or (x['col_det']<0.202965736)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<2.97436905)  else 12)
                    if state == 11:
                        return -0.297804713
                    if state == 12:
                        state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.977999985)  else 20)
                        if state == 19:
                            return -0.16179888
                        if state == 20:
                            return 0.0565541871
                if state == 6:
                    state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<0.0230497997)  else 14)
                    if state == 13:
                        return 0.0886262581
                    if state == 14:
                        return -0.123340182
    elif num_booster == 16:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<24.747303)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.0222291946 else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<10.2537451 else 8)
                    if state == 7:
                        return 0.165288478
                    if state == 8:
                        state = (15 if x['neargaia_med']<15.0892315 else 16)
                        if state == 15:
                            return -0.171119809
                        if state == 16:
                            state = (25 if x['maggaia_med']<19.9909878 else 26)
                            if state == 25:
                                return 0.0774670839
                            if state == 26:
                                state = (43 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<10.4213562)  else 44)
                                if state == 43:
                                    state = (61 if np.isnan(x['mag_det']) or (x['mag_det']<19.9148502)  else 62)
                                    if state == 61:
                                        return 0.169340402
                                    if state == 62:
                                        return -0.129054949
                                if state == 44:
                                    return -0.115999937
                if state == 4:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<8.04639721)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<4.61288738)  else 18)
                        if state == 17:
                            state = (27 if x['maggaia_med']<16.3680305 else 28)
                            if state == 27:
                                return -0.222080275
                            if state == 28:
                                state = (45 if x['distpsnr1_med']<1.94081187 else 46)
                                if state == 45:
                                    state = (63 if np.isnan(x['mag_det']) or (x['mag_det']<18.72295)  else 64)
                                    if state == 63:
                                        return 0.142270461
                                    if state == 64:
                                        state = (87 if x['distpsnr1_med']<1.51607084 else 88)
                                        if state == 87:
                                            state = (111 if np.isnan(x['mag_det']) or (x['mag_det']<19.8648224)  else 112)
                                            if state == 111:
                                                state = (135 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.731249988)  else 136)
                                                if state == 135:
                                                    return -0.157813549
                                                if state == 136:
                                                    state = (151 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01873255)  else 152)
                                                    if state == 151:
                                                        state = (169 if x['magnr_med']<17.425499 else 170)
                                                        if state == 169:
                                                            return -0.139642864
                                                        if state == 170:
                                                            return 0.0631348044
                                                    if state == 152:
                                                        return 0.119011655
                                            if state == 112:
                                                state = (137 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.842000008)  else 138)
                                                if state == 137:
                                                    return -0.221656933
                                                if state == 138:
                                                    state = (153 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0653240979)  else 154)
                                                    if state == 153:
                                                        return 0.141961917
                                                    if state == 154:
                                                        return -0.192978501
                                        if state == 88:
                                            return -0.312349737
                                if state == 46:
                                    state = (65 if np.isnan(x['mag_det']) or (x['mag_det']<20.3709507)  else 66)
                                    if state == 65:
                                        state = (89 if x['distpsnr1_med']<2.62456656 else 90)
                                        if state == 89:
                                            return 0.15711081
                                        if state == 90:
                                            state = (113 if np.isnan(x['mag_det']) or (x['mag_det']<19.8012505)  else 114)
                                            if state == 113:
                                                state = (139 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.962249994)  else 140)
                                                if state == 139:
                                                    state = (155 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00205445)  else 156)
                                                    if state == 155:
                                                        return -0.144956797
                                                    if state == 156:
                                                        return 0.0546184294
                                                if state == 140:
                                                    return 0.119478039
                                            if state == 114:
                                                state = (141 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.780250072)  else 142)
                                                if state == 141:
                                                    state = (159 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92981482)  else 160)
                                                    if state == 159:
                                                        return -0.129863024
                                                    if state == 160:
                                                        return 0.159603655
                                                if state == 142:
                                                    state = (161 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0423726998)  else 162)
                                                    if state == 161:
                                                        return 0.010889492
                                                    if state == 162:
                                                        state = (171 if x['magnr_med']<21.9547501 else 172)
                                                        if state == 171:
                                                            return -0.348455787
                                                        if state == 172:
                                                            return 0.0953593552
                                    if state == 66:
                                        state = (91 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.99101019)  else 92)
                                        if state == 91:
                                            state = (115 if np.isnan(x['mag_det']) or (x['mag_det']<20.5250492)  else 116)
                                            if state == 115:
                                                return 0.25537172
                                            if state == 116:
                                                state = (143 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.777750015)  else 144)
                                                if state == 143:
                                                    state = (163 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0507175997)  else 164)
                                                    if state == 163:
                                                        return 0.0562087409
                                                    if state == 164:
                                                        return -0.17454645
                                                if state == 144:
                                                    return 0.150678605
                                        if state == 92:
                                            state = (117 if np.isnan(x['mag_det']) or (x['mag_det']<20.3811989)  else 118)
                                            if state == 117:
                                                return 0.0976833701
                                            if state == 118:
                                                return -0.112928651
                        if state == 18:
                            return -0.268980056
                    if state == 10:
                        state = (19 if x['neargaia_med']<22.4363441 else 20)
                        if state == 19:
                            state = (29 if x['maggaia_med']<19.1441593 else 30)
                            if state == 29:
                                state = (47 if x['distpsnr1_med']<6.67664814 else 48)
                                if state == 47:
                                    state = (67 if np.isnan(x['mag_det']) or (x['mag_det']<20.27565)  else 68)
                                    if state == 67:
                                        state = (93 if x['distpsnr1_med']<1.14297509 else 94)
                                        if state == 93:
                                            return 0.0407018065
                                        if state == 94:
                                            state = (121 if np.isnan(x['mag_det']) or (x['mag_det']<19.8055496)  else 122)
                                            if state == 121:
                                                state = (147 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.982749999)  else 148)
                                                if state == 147:
                                                    return -0.0980747268
                                                if state == 148:
                                                    return 0.0755214393
                                            if state == 122:
                                                return -0.232512489
                                    if state == 68:
                                        return 0.17114307
                                if state == 48:
                                    state = (69 if np.isnan(x['mag_det']) or (x['mag_det']<19.0335999)  else 70)
                                    if state == 69:
                                        return -0.0662152842
                                    if state == 70:
                                        state = (97 if x['distpsnr1_med']<8.96192169 else 98)
                                        if state == 97:
                                            return 0.252468586
                                        if state == 98:
                                            state = (125 if np.isnan(x['mag_det']) or (x['mag_det']<19.8667488)  else 126)
                                            if state == 125:
                                                return 0.10840369
                                            if state == 126:
                                                state = (149 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.796750009)  else 150)
                                                if state == 149:
                                                    return -0.133435652
                                                if state == 150:
                                                    state = (167 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.43739605)  else 168)
                                                    if state == 167:
                                                        state = (173 if x['magnr_med']<22.7799988 else 174)
                                                        if state == 173:
                                                            return -0.118834212
                                                        if state == 174:
                                                            return 0.0984947085
                                                    if state == 168:
                                                        return 0.0873889104
                            if state == 30:
                                state = (49 if x['distpsnr1_med']<7.00626755 else 50)
                                if state == 49:
                                    state = (71 if np.isnan(x['mag_det']) or (x['mag_det']<19.357151)  else 72)
                                    if state == 71:
                                        return 0.0155808311
                                    if state == 72:
                                        return -0.196580261
                                if state == 50:
                                    state = (73 if np.isnan(x['mag_det']) or (x['mag_det']<20.6786499)  else 74)
                                    if state == 73:
                                        state = (99 if x['distpsnr1_med']<7.39396954 else 100)
                                        if state == 99:
                                            return 0.138442293
                                        if state == 100:
                                            return -0.195405453
                                    if state == 74:
                                        return 0.108503029
                        if state == 20:
                            state = (31 if x['maggaia_med']<19.9959221 else 32)
                            if state == 31:
                                state = (51 if x['distpsnr1_med']<4.93379593 else 52)
                                if state == 51:
                                    state = (75 if np.isnan(x['mag_det']) or (x['mag_det']<19.9720001)  else 76)
                                    if state == 75:
                                        return -0.0261523649
                                    if state == 76:
                                        return 0.219513714
                                if state == 52:
                                    return -0.150435939
                            if state == 32:
                                return 0.204829514
            if state == 2:
                state = (5 if x['col_det']<-0.169613838 else 6)
                if state == 5:
                    return -0.357830524
                if state == 6:
                    state = (13 if x['neargaia_med']<27.5280037 else 14)
                    if state == 13:
                        state = (21 if x['neargaia_med']<26.3804588 else 22)
                        if state == 21:
                            return -0.0167692695
                        if state == 22:
                            state = (35 if x['maggaia_med']<20.0357399 else 36)
                            if state == 35:
                                return -0.317115039
                            if state == 36:
                                return 0.0317357108
                    if state == 14:
                        state = (23 if x['neargaia_med']<33.9673157 else 24)
                        if state == 23:
                            state = (37 if x['maggaia_med']<19.10009 else 38)
                            if state == 37:
                                return -0.0871213675
                            if state == 38:
                                state = (55 if x['distpsnr1_med']<2.40080881 else 56)
                                if state == 55:
                                    return -0.0291184746
                                if state == 56:
                                    return 0.242042035
                        if state == 24:
                            state = (39 if x['maggaia_med']<17.7177315 else 40)
                            if state == 39:
                                state = (57 if x['distpsnr1_med']<2.2735281 else 58)
                                if state == 57:
                                    return 0.158297658
                                if state == 58:
                                    state = (81 if np.isnan(x['mag_det']) or (x['mag_det']<19.6070499)  else 82)
                                    if state == 81:
                                        return 0.067034319
                                    if state == 82:
                                        state = (105 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<9.54959297)  else 106)
                                        if state == 105:
                                            return -0.194742963
                                        if state == 106:
                                            state = (131 if np.isnan(x['mag_det']) or (x['mag_det']<19.9838486)  else 132)
                                            if state == 131:
                                                return -0.13283208
                                            if state == 132:
                                                return 0.0458289459
                            if state == 40:
                                state = (59 if x['distpsnr1_med']<0.274308443 else 60)
                                if state == 59:
                                    return 0.0647627711
                                if state == 60:
                                    state = (83 if np.isnan(x['mag_det']) or (x['mag_det']<19.6921005)  else 84)
                                    if state == 83:
                                        return -0.243147433
                                    if state == 84:
                                        state = (107 if x['distpsnr1_med']<6.72001505 else 108)
                                        if state == 107:
                                            state = (133 if np.isnan(x['mag_det']) or (x['mag_det']<20.1356888)  else 134)
                                            if state == 133:
                                                return 0.106068388
                                            if state == 134:
                                                return -0.088073656
                                        if state == 108:
                                            return -0.152742803
    elif num_booster == 17:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<18.3973007)  else 2)
            if state == 1:
                state = (3 if x['distnr_med']<0.283298135 else 4)
                if state == 3:
                    return 0.0931645781
                if state == 4:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<18.2481995)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<16.7905502)  else 14)
                        if state == 13:
                            return -0.0796016827
                        if state == 14:
                            state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<0.0325637013)  else 24)
                            if state == 23:
                                state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.981249988)  else 40)
                                if state == 39:
                                    return -0.125300765
                                if state == 40:
                                    return 0.0404623784
                            if state == 24:
                                return -0.314511597
                    if state == 8:
                        return -0.0418896712
            if state == 2:
                state = (5 if x['distnr_med']<3.43950796 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.4103508)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<19.9358749)  else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['t_lc']) or (x['t_lc']<3.02119207)  else 26)
                            if state == 25:
                                state = (41 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.634250045)  else 42)
                                if state == 41:
                                    state = (55 if x['distpsnr1_med']<2.39251852 else 56)
                                    if state == 55:
                                        return -0.194772661
                                    if state == 56:
                                        return 0.124813274
                                if state == 42:
                                    state = (57 if x['distpsnr1_med']<0.0862373039 else 58)
                                    if state == 57:
                                        return -0.129569352
                                    if state == 58:
                                        state = (71 if x['distpsnr1_med']<1.37765539 else 72)
                                        if state == 71:
                                            state = (81 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.547807992)  else 82)
                                            if state == 81:
                                                state = (89 if x['distnr_med']<1.37838149 else 90)
                                                if state == 89:
                                                    state = (95 if np.isnan(x['col_det']) or (x['col_det']<0.213113785)  else 96)
                                                    if state == 95:
                                                        state = (103 if np.isnan(x['rb_med']) or (x['rb_med']<0.632499933)  else 104)
                                                        if state == 103:
                                                            return 0.0544847138
                                                        if state == 104:
                                                            return 0.247415558
                                                    if state == 96:
                                                        return -0.043570634
                                                if state == 90:
                                                    state = (97 if np.isnan(x['col_det']) or (x['col_det']<-0.269873619)  else 98)
                                                    if state == 97:
                                                        return 0.0735328719
                                                    if state == 98:
                                                        return -0.177142099
                                            if state == 82:
                                                return -0.125539765
                                        if state == 72:
                                            state = (83 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.533294499)  else 84)
                                            if state == 83:
                                                state = (91 if x['distnr_med']<0.914159298 else 92)
                                                if state == 91:
                                                    state = (99 if np.isnan(x['col_det']) or (x['col_det']<-0.234237671)  else 100)
                                                    if state == 99:
                                                        return -0.128080428
                                                    if state == 100:
                                                        state = (107 if np.isnan(x['rb_med']) or (x['rb_med']<0.744047761)  else 108)
                                                        if state == 107:
                                                            return 0.134190828
                                                        if state == 108:
                                                            return -0.0505664125
                                                if state == 92:
                                                    return 0.302292794
                                            if state == 84:
                                                return 0.0391435288
                            if state == 26:
                                state = (43 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.979499996)  else 44)
                                if state == 43:
                                    state = (59 if x['distpsnr1_med']<2.53987765 else 60)
                                    if state == 59:
                                        state = (73 if x['distpsnr1_med']<2.39943027 else 74)
                                        if state == 73:
                                            return -0.120401002
                                        if state == 74:
                                            return 0.159630984
                                    if state == 60:
                                        return -0.260210782
                                if state == 44:
                                    return 0.156035647
                        if state == 16:
                            state = (27 if np.isnan(x['t_lc']) or (x['t_lc']<1.03480911)  else 28)
                            if state == 27:
                                state = (45 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.800500035)  else 46)
                                if state == 45:
                                    state = (61 if x['distpsnr1_med']<1.32661366 else 62)
                                    if state == 61:
                                        return -0.0410220884
                                    if state == 62:
                                        return 0.177124172
                                if state == 46:
                                    state = (63 if x['distpsnr1_med']<2.36746454 else 64)
                                    if state == 63:
                                        state = (77 if x['distpsnr1_med']<1.2988503 else 78)
                                        if state == 77:
                                            return -0.138542011
                                        if state == 78:
                                            return 0.187108085
                                    if state == 64:
                                        return -0.228862137
                            if state == 28:
                                return -0.283775836
                    if state == 10:
                        state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<20.0146484)  else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['t_lc']) or (x['t_lc']<2.41610527)  else 30)
                            if state == 29:
                                state = (47 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.749499977)  else 48)
                                if state == 47:
                                    return 0.0563091412
                                if state == 48:
                                    return -0.156477198
                            if state == 30:
                                state = (49 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.858749986)  else 50)
                                if state == 49:
                                    return 0.205196083
                                if state == 50:
                                    return -0.0324180797
                        if state == 18:
                            state = (31 if np.isnan(x['t_lc']) or (x['t_lc']<0.00251734979)  else 32)
                            if state == 31:
                                return 0.119096726
                            if state == 32:
                                return -0.334876895
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.3282013)  else 12)
                    if state == 11:
                        return -0.383292466
                    if state == 12:
                        state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<19.6987076)  else 20)
                        if state == 19:
                            state = (33 if np.isnan(x['t_lc']) or (x['t_lc']<0.0104918508)  else 34)
                            if state == 33:
                                return -0.239827082
                            if state == 34:
                                state = (51 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.730499983)  else 52)
                                if state == 51:
                                    return 0.0125063462
                                if state == 52:
                                    return 0.334853709
                        if state == 20:
                            state = (35 if np.isnan(x['t_lc']) or (x['t_lc']<0.0751099512)  else 36)
                            if state == 35:
                                state = (53 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.958500028)  else 54)
                                if state == 53:
                                    state = (67 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.78743792)  else 68)
                                    if state == 67:
                                        return -0.35037306
                                    if state == 68:
                                        state = (79 if x['distpsnr1_med']<12.8561249 else 80)
                                        if state == 79:
                                            state = (87 if x['sgscore1_med']<0.648082972 else 88)
                                            if state == 87:
                                                state = (93 if x['distnr_med']<6.37311077 else 94)
                                                if state == 93:
                                                    return 0.192131028
                                                if state == 94:
                                                    state = (101 if x['col_det']<0.22951889 else 102)
                                                    if state == 101:
                                                        return 0.168946728
                                                    if state == 102:
                                                        return -0.124743685
                                            if state == 88:
                                                return -0.0556199998
                                        if state == 80:
                                            return -0.224334717
                                if state == 54:
                                    return 0.126245633
                            if state == 36:
                                return -0.293708444
    elif num_booster == 18:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0129282493)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<18.8864117)  else 4)
                if state == 3:
                    return -0.0185907967
                if state == 4:
                    return -0.222379893
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.8389549)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8145833)  else 10)
                    if state == 9:
                        state = (13 if x['distnr_med']<1.86665654 else 14)
                        if state == 13:
                            state = (21 if x['distnr_med']<0.839460969 else 22)
                            if state == 21:
                                return 0.161692023
                            if state == 22:
                                state = (35 if np.isnan(x['t_lc']) or (x['t_lc']<2.85479164)  else 36)
                                if state == 35:
                                    return -0.14566727
                                if state == 36:
                                    state = (51 if np.isnan(x['mag_det']) or (x['mag_det']<20.3240509)  else 52)
                                    if state == 51:
                                        state = (67 if np.isnan(x['t_lc']) or (x['t_lc']<2.97726846)  else 68)
                                        if state == 67:
                                            return 0.044026766
                                        if state == 68:
                                            return -0.129559934
                                    if state == 52:
                                        return 0.117563896
                        if state == 14:
                            return 0.295607269
                    if state == 10:
                        state = (15 if x['distnr_med']<0.645311594 else 16)
                        if state == 15:
                            state = (23 if x['distnr_med']<0.361729145 else 24)
                            if state == 23:
                                state = (37 if np.isnan(x['t_lc']) or (x['t_lc']<0.0646990538)  else 38)
                                if state == 37:
                                    state = (53 if np.isnan(x['mag_det']) or (x['mag_det']<19.6641502)  else 54)
                                    if state == 53:
                                        return 0.196542069
                                    if state == 54:
                                        return -0.151129708
                                if state == 38:
                                    return -0.0683881342
                            if state == 24:
                                return -0.219948962
                        if state == 16:
                            state = (25 if x['distnr_med']<4.50911522 else 26)
                            if state == 25:
                                state = (39 if np.isnan(x['t_lc']) or (x['t_lc']<0.0614410006)  else 40)
                                if state == 39:
                                    state = (55 if np.isnan(x['mag_det']) or (x['mag_det']<19.0549011)  else 56)
                                    if state == 55:
                                        state = (69 if np.isnan(x['t_lc']) or (x['t_lc']<0.0424999967)  else 70)
                                        if state == 69:
                                            state = (83 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.981750011)  else 84)
                                            if state == 83:
                                                return -0.13517952
                                            if state == 84:
                                                return 0.0938738137
                                        if state == 70:
                                            return 0.156736821
                                    if state == 56:
                                        state = (71 if np.isnan(x['t_lc']) or (x['t_lc']<0.028333351)  else 72)
                                        if state == 71:
                                            return 0.0999730751
                                        if state == 72:
                                            state = (85 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.986750007)  else 86)
                                            if state == 85:
                                                return -0.268622607
                                            if state == 86:
                                                return 0.100129932
                                if state == 40:
                                    state = (57 if np.isnan(x['mag_det']) or (x['mag_det']<19.6546001)  else 58)
                                    if state == 57:
                                        state = (73 if np.isnan(x['t_lc']) or (x['t_lc']<3.03552103)  else 74)
                                        if state == 73:
                                            state = (87 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.894999981)  else 88)
                                            if state == 87:
                                                return -0.206380263
                                            if state == 88:
                                                state = (95 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8986516)  else 96)
                                                if state == 95:
                                                    return -0.0262971055
                                                if state == 96:
                                                    state = (99 if np.isnan(x['mag_last']) or (x['mag_last']<16.7838707)  else 100)
                                                    if state == 99:
                                                        return -0.0221730918
                                                    if state == 100:
                                                        return 0.255197614
                                        if state == 74:
                                            return -0.118088543
                                    if state == 58:
                                        return 0.298663884
                            if state == 26:
                                state = (41 if np.isnan(x['t_lc']) or (x['t_lc']<0.0477256998)  else 42)
                                if state == 41:
                                    state = (59 if np.isnan(x['mag_det']) or (x['mag_det']<19.1309662)  else 60)
                                    if state == 59:
                                        return -0.103699699
                                    if state == 60:
                                        return 0.125719741
                                if state == 42:
                                    state = (61 if np.isnan(x['mag_det']) or (x['mag_det']<19.3282013)  else 62)
                                    if state == 61:
                                        return -0.199155375
                                    if state == 62:
                                        state = (75 if np.isnan(x['t_lc']) or (x['t_lc']<2.95733213)  else 76)
                                        if state == 75:
                                            return -0.106089331
                                        if state == 76:
                                            return 0.157836094
                if state == 6:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8249073)  else 12)
                    if state == 11:
                        state = (17 if x['distnr_med']<4.73093414 else 18)
                        if state == 17:
                            return -0.29122588
                        if state == 18:
                            state = (27 if x['distnr_med']<4.83563805 else 28)
                            if state == 27:
                                return 0.107002236
                            if state == 28:
                                return -0.18025969
                    if state == 12:
                        state = (19 if x['distnr_med']<6.26584625 else 20)
                        if state == 19:
                            state = (29 if x['distnr_med']<1.0464623 else 30)
                            if state == 29:
                                state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<0.04050925)  else 44)
                                if state == 43:
                                    return -0.120025255
                                if state == 44:
                                    state = (63 if np.isnan(x['mag_det']) or (x['mag_det']<20.0858879)  else 64)
                                    if state == 63:
                                        return 0.12927705
                                    if state == 64:
                                        state = (79 if np.isnan(x['t_lc']) or (x['t_lc']<0.0417881496)  else 80)
                                        if state == 79:
                                            return 0.155499801
                                        if state == 80:
                                            return -0.0763119757
                            if state == 30:
                                state = (45 if np.isnan(x['t_lc']) or (x['t_lc']<0.0376388989)  else 46)
                                if state == 45:
                                    state = (65 if np.isnan(x['mag_det']) or (x['mag_det']<20.3526497)  else 66)
                                    if state == 65:
                                        state = (81 if np.isnan(x['t_lc']) or (x['t_lc']<0.0205902494)  else 82)
                                        if state == 81:
                                            return -0.0259510167
                                        if state == 82:
                                            state = (91 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.792000055)  else 92)
                                            if state == 91:
                                                return 0.206028119
                                            if state == 92:
                                                state = (97 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9484663)  else 98)
                                                if state == 97:
                                                    return 0.0920196846
                                                if state == 98:
                                                    return -0.0852570608
                                    if state == 66:
                                        return -0.105174556
                                if state == 46:
                                    return -0.222323045
                        if state == 20:
                            state = (31 if x['distnr_med']<6.51303959 else 32)
                            if state == 31:
                                return 0.15053457
                            if state == 32:
                                state = (47 if np.isnan(x['t_lc']) or (x['t_lc']<0.0166261494)  else 48)
                                if state == 47:
                                    return 0.15285404
                                if state == 48:
                                    return -0.112970859
    elif num_booster == 19:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 2)
            if state == 1:
                return -0.221684396
            if state == 2:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<2.97509837)  else 4)
                if state == 3:
                    state = (5 if x['magnr_med']<20.3037491 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<20.4773617)  else 10)
                        if state == 9:
                            state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9757061)  else 18)
                            if state == 17:
                                state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.0028858)  else 30)
                                if state == 29:
                                    state = (45 if x['magnr_med']<18.3269997 else 46)
                                    if state == 45:
                                        state = (61 if x['distnr_med']<0.944565713 else 62)
                                        if state == 61:
                                            return 0.0491646007
                                        if state == 62:
                                            return -0.311108321
                                    if state == 46:
                                        return 0.172846526
                                if state == 30:
                                    state = (47 if x['magnr_med']<19.2405014 else 48)
                                    if state == 47:
                                        state = (63 if x['distnr_med']<1.32205856 else 64)
                                        if state == 63:
                                            state = (75 if x['distnr_med']<1.05953538 else 76)
                                            if state == 75:
                                                state = (91 if np.isnan(x['mag_last']) or (x['mag_last']<19.744381)  else 92)
                                                if state == 91:
                                                    state = (111 if x['maggaia_med']<17.7179337 else 112)
                                                    if state == 111:
                                                        state = (119 if np.isnan(x['t_lc']) or (x['t_lc']<0.531365752)  else 120)
                                                        if state == 119:
                                                            return -0.0990547761
                                                        if state == 120:
                                                            return 0.1460917
                                                    if state == 112:
                                                        return 0.212119609
                                                if state == 92:
                                                    return -0.172336146
                                            if state == 76:
                                                return -0.116953343
                                        if state == 64:
                                            state = (77 if x['distnr_med']<3.68479061 else 78)
                                            if state == 77:
                                                state = (95 if np.isnan(x['mag_last']) or (x['mag_last']<20.0301208)  else 96)
                                                if state == 95:
                                                    return 0.256797522
                                                if state == 96:
                                                    state = (113 if x['maggaia_med']<19.1591167 else 114)
                                                    if state == 113:
                                                        return 0.0959125832
                                                    if state == 114:
                                                        return -0.114085212
                                            if state == 78:
                                                state = (97 if np.isnan(x['mag_last']) or (x['mag_last']<19.6476784)  else 98)
                                                if state == 97:
                                                    return 0.171124473
                                                if state == 98:
                                                    return -0.18475379
                                    if state == 48:
                                        return 0.281781763
                            if state == 18:
                                state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<20.106205)  else 32)
                                if state == 31:
                                    state = (49 if x['magnr_med']<18.9220009 else 50)
                                    if state == 49:
                                        state = (65 if x['distnr_med']<1.18646264 else 66)
                                        if state == 65:
                                            return -0.15542689
                                        if state == 66:
                                            state = (81 if x['distnr_med']<1.19991624 else 82)
                                            if state == 81:
                                                return 0.0997188613
                                            if state == 82:
                                                state = (101 if np.isnan(x['mag_last']) or (x['mag_last']<18.5474777)  else 102)
                                                if state == 101:
                                                    return 0.0764001459
                                                if state == 102:
                                                    return -0.125658318
                                    if state == 50:
                                        return 0.206814528
                                if state == 32:
                                    return -0.204287365
                        if state == 10:
                            return -0.23100026
                    if state == 6:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.1090336)  else 12)
                        if state == 11:
                            state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.87641191)  else 20)
                            if state == 19:
                                return 0.0831014886
                            if state == 20:
                                state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<18.8162766)  else 36)
                                if state == 35:
                                    state = (51 if x['magnr_med']<22.5662498 else 52)
                                    if state == 51:
                                        return -0.329857051
                                    if state == 52:
                                        return 0.0101101873
                                if state == 36:
                                    return -0.0407798216
                        if state == 12:
                            state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97534132)  else 22)
                            if state == 21:
                                state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<20.6436501)  else 38)
                                if state == 37:
                                    state = (53 if x['magnr_med']<22.6412506 else 54)
                                    if state == 53:
                                        state = (67 if x['distnr_med']<0.711632729 else 68)
                                        if state == 67:
                                            state = (83 if x['distnr_med']<0.454772294 else 84)
                                            if state == 83:
                                                return -0.0894404203
                                            if state == 84:
                                                return 0.160558328
                                        if state == 68:
                                            state = (85 if x['distnr_med']<4.71101141 else 86)
                                            if state == 85:
                                                state = (105 if np.isnan(x['mag_last']) or (x['mag_last']<19.822052)  else 106)
                                                if state == 105:
                                                    return 0.0461676195
                                                if state == 106:
                                                    state = (115 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1715508)  else 116)
                                                    if state == 115:
                                                        return -0.290724158
                                                    if state == 116:
                                                        return 0.0625318214
                                            if state == 86:
                                                state = (107 if np.isnan(x['mag_last']) or (x['mag_last']<20.1118431)  else 108)
                                                if state == 107:
                                                    return -0.0885866359
                                                if state == 108:
                                                    return 0.117404923
                                    if state == 54:
                                        return -0.236613438
                                if state == 38:
                                    return 0.0637401715
                            if state == 22:
                                state = (39 if np.isnan(x['mag_last']) or (x['mag_last']<20.0578136)  else 40)
                                if state == 39:
                                    state = (55 if x['magnr_med']<22.2767487 else 56)
                                    if state == 55:
                                        return 0.217737138
                                    if state == 56:
                                        state = (69 if x['distnr_med']<3.47758412 else 70)
                                        if state == 69:
                                            return -0.0789207891
                                        if state == 70:
                                            return 0.117530666
                                if state == 40:
                                    state = (57 if x['magnr_med']<22.3134995 else 58)
                                    if state == 57:
                                        return -0.123094097
                                    if state == 58:
                                        return 0.0817550346
                if state == 4:
                    state = (7 if x['magnr_med']<20.5212517 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.521944)  else 14)
                        if state == 13:
                            state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.914184093)  else 24)
                            if state == 23:
                                return 0.189442128
                            if state == 24:
                                state = (41 if np.isnan(x['mag_last']) or (x['mag_last']<18.0734596)  else 42)
                                if state == 41:
                                    return -0.109617405
                                if state == 42:
                                    state = (59 if x['magnr_med']<18.1697502 else 60)
                                    if state == 59:
                                        state = (71 if x['distnr_med']<0.643134892 else 72)
                                        if state == 71:
                                            return -0.151581779
                                        if state == 72:
                                            state = (87 if x['distnr_med']<0.657836199 else 88)
                                            if state == 87:
                                                return 0.102004163
                                            if state == 88:
                                                return -0.092014499
                                    if state == 60:
                                        return 0.140413254
                        if state == 14:
                            return -0.281567007
                    if state == 8:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<19.7266846)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91226268)  else 28)
                            if state == 27:
                                return -0.0346012898
                            if state == 28:
                                return 0.170558542
                        if state == 16:
                            return -0.201552212
    elif num_booster == 20:
        state = 0
        if state == 0:
            state = (1 if x['distnr_med']<4.83447599 else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.956738472)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<17.3264008)  else 8)
                    if state == 7:
                        return -0.168621898
                    if state == 8:
                        state = (13 if x['col_det']<-0.430595398 else 14)
                        if state == 13:
                            return -0.168935567
                        if state == 14:
                            state = (23 if x['magnr_med']<16.5545006 else 24)
                            if state == 23:
                                return -0.208310708
                            if state == 24:
                                state = (35 if np.isnan(x['mag_det']) or (x['mag_det']<20.5250492)  else 36)
                                if state == 35:
                                    state = (39 if x['magnr_med']<19.0865002 else 40)
                                    if state == 39:
                                        state = (45 if np.isnan(x['col_det']) or (x['col_det']<0.0592536926)  else 46)
                                        if state == 45:
                                            state = (51 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91157389)  else 52)
                                            if state == 51:
                                                state = (57 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0327199027)  else 58)
                                                if state == 57:
                                                    return -0.243339822
                                                if state == 58:
                                                    state = (67 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0308125019)  else 68)
                                                    if state == 67:
                                                        state = (79 if np.isnan(x['mag_last']) or (x['mag_last']<19.7087631)  else 80)
                                                        if state == 79:
                                                            return 0.0813378841
                                                        if state == 80:
                                                            return -0.323233247
                                                    if state == 68:
                                                        state = (81 if np.isnan(x['mag_last']) or (x['mag_last']<18.9869747)  else 82)
                                                        if state == 81:
                                                            return -0.140368879
                                                        if state == 82:
                                                            return 0.147924677
                                            if state == 52:
                                                state = (59 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96220493)  else 60)
                                                if state == 59:
                                                    return 0.215130791
                                                if state == 60:
                                                    state = (69 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0221041497)  else 70)
                                                    if state == 69:
                                                        return -0.127453372
                                                    if state == 70:
                                                        state = (83 if np.isnan(x['mag_last']) or (x['mag_last']<18.4501915)  else 84)
                                                        if state == 83:
                                                            return 0.144077703
                                                        if state == 84:
                                                            return -0.018250173
                                        if state == 46:
                                            return 0.180411667
                                    if state == 40:
                                        state = (47 if np.isnan(x['col_det']) or (x['col_det']<0.478796959)  else 48)
                                        if state == 47:
                                            state = (53 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96062493)  else 54)
                                            if state == 53:
                                                state = (61 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95615149)  else 62)
                                                if state == 61:
                                                    state = (71 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0201250017)  else 72)
                                                    if state == 71:
                                                        state = (85 if np.isnan(x['mag_last']) or (x['mag_last']<18.4008865)  else 86)
                                                        if state == 85:
                                                            return -0.119673871
                                                        if state == 86:
                                                            return 0.20390527
                                                    if state == 72:
                                                        state = (87 if np.isnan(x['mag_last']) or (x['mag_last']<19.3881187)  else 88)
                                                        if state == 87:
                                                            return 0.135018706
                                                        if state == 88:
                                                            return -0.0641628131
                                                if state == 62:
                                                    return -0.134608403
                                            if state == 54:
                                                state = (63 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99909711)  else 64)
                                                if state == 63:
                                                    return 0.225784302
                                                if state == 64:
                                                    state = (75 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0225833002)  else 76)
                                                    if state == 75:
                                                        return 0.125154838
                                                    if state == 76:
                                                        state = (89 if np.isnan(x['mag_last']) or (x['mag_last']<19.5109386)  else 90)
                                                        if state == 89:
                                                            return 0.105171576
                                                        if state == 90:
                                                            return -0.136590615
                                        if state == 48:
                                            return -0.153459355
                                if state == 36:
                                    state = (41 if x['magnr_med']<18.7000008 else 42)
                                    if state == 41:
                                        return 0.149572879
                                    if state == 42:
                                        state = (49 if x['col_det']<1.07964134 else 50)
                                        if state == 49:
                                            return -0.189959466
                                        if state == 50:
                                            state = (55 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.03097224)  else 56)
                                            if state == 55:
                                                return 0.025354119
                                            if state == 56:
                                                return -0.13978
                if state == 4:
                    return -0.198802233
            if state == 2:
                state = (5 if x['sgscore1_med']<0.500625014 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.7616501)  else 10)
                    if state == 9:
                        state = (15 if x['col_det']<0.212258339 else 16)
                        if state == 15:
                            return 0.0770823807
                        if state == 16:
                            return -0.231277317
                    if state == 10:
                        state = (17 if np.isnan(x['col_det']) or (x['col_det']<0.02942276)  else 18)
                        if state == 17:
                            state = (27 if x['magnr_med']<19.0004997 else 28)
                            if state == 27:
                                return -0.117469519
                            if state == 28:
                                state = (37 if np.isnan(x['mag_det']) or (x['mag_det']<20.3260002)  else 38)
                                if state == 37:
                                    return 0.183909684
                                if state == 38:
                                    return -0.0202047378
                        if state == 18:
                            state = (29 if x['magnr_med']<22.0087509 else 30)
                            if state == 29:
                                return 0.0594463758
                            if state == 30:
                                return -0.121187598
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.3282013)  else 12)
                    if state == 11:
                        return -0.38062641
                    if state == 12:
                        state = (19 if x['col_det']<0.233449936 else 20)
                        if state == 19:
                            return 0.0985422507
                        if state == 20:
                            state = (33 if x['magnr_med']<19.5869999 else 34)
                            if state == 33:
                                return 0.0869496316
                            if state == 34:
                                return -0.207193166
    elif num_booster == 21:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.04114585)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.796750009)  else 4)
                if state == 3:
                    state = (7 if x['col_det']<0.0544061661 else 8)
                    if state == 7:
                        return -0.133424431
                    if state == 8:
                        state = (13 if x['magnr_med']<22.3322506 else 14)
                        if state == 13:
                            state = (23 if np.isnan(x['mag_last']) or (x['mag_last']<19.7521992)  else 24)
                            if state == 23:
                                return -0.107862592
                            if state == 24:
                                state = (33 if np.isnan(x['col_det']) or (x['col_det']<0.360129356)  else 34)
                                if state == 33:
                                    return 0.182316467
                                if state == 34:
                                    return -0.0297848061
                        if state == 14:
                            return -0.148981586
                if state == 4:
                    state = (9 if np.isnan(x['col_det']) or (x['col_det']<-0.0301399231)  else 10)
                    if state == 9:
                        state = (15 if x['magnr_med']<21.14575 else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['mag_last']) or (x['mag_last']<18.7685337)  else 26)
                            if state == 25:
                                return -0.192712158
                            if state == 26:
                                state = (37 if x['col_det']<-0.0852718353 else 38)
                                if state == 37:
                                    return 0.0744636282
                                if state == 38:
                                    state = (51 if np.isnan(x['mag_last']) or (x['mag_last']<19.2622414)  else 52)
                                    if state == 51:
                                        return 0.0860269666
                                    if state == 52:
                                        return -0.125603974
                        if state == 16:
                            return -0.313396811
                    if state == 10:
                        state = (17 if x['magnr_med']<18.3769989 else 18)
                        if state == 17:
                            return 0.0718515068
                        if state == 18:
                            state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<19.8917351)  else 28)
                            if state == 27:
                                state = (39 if x['col_det']<0.215722084 else 40)
                                if state == 39:
                                    return 0.0990877002
                                if state == 40:
                                    return -0.123634122
                            if state == 28:
                                return -0.126497865
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.630250037)  else 6)
                if state == 5:
                    return -0.230775699
                if state == 6:
                    state = (11 if x['col_det']<0.131872177 else 12)
                    if state == 11:
                        state = (19 if x['magnr_med']<20.7550011 else 20)
                        if state == 19:
                            return 0.198610768
                        if state == 20:
                            state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<20.0211029)  else 30)
                            if state == 29:
                                state = (43 if x['col_det']<-0.21169281 else 44)
                                if state == 43:
                                    return 0.0839954987
                                if state == 44:
                                    state = (57 if np.isnan(x['mag_last']) or (x['mag_last']<19.6964321)  else 58)
                                    if state == 57:
                                        state = (63 if np.isnan(x['mag_last']) or (x['mag_last']<19.0041504)  else 64)
                                        if state == 63:
                                            return -0.120862238
                                        if state == 64:
                                            return 0.0795592964
                                    if state == 58:
                                        return -0.160507277
                            if state == 30:
                                return 0.149771377
                    if state == 12:
                        state = (21 if x['magnr_med']<15.5297499 else 22)
                        if state == 21:
                            return -0.193775237
                        if state == 22:
                            state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<19.7403603)  else 32)
                            if state == 31:
                                state = (45 if x['col_det']<1.1651783 else 46)
                                if state == 45:
                                    state = (59 if np.isnan(x['mag_last']) or (x['mag_last']<19.5223007)  else 60)
                                    if state == 59:
                                        return -0.112695552
                                    if state == 60:
                                        return 0.0575839654
                                if state == 46:
                                    state = (61 if np.isnan(x['mag_last']) or (x['mag_last']<16.7838707)  else 62)
                                    if state == 61:
                                        return -0.0570692532
                                    if state == 62:
                                        state = (67 if np.isnan(x['mag_last']) or (x['mag_last']<19.6664734)  else 68)
                                        if state == 67:
                                            state = (71 if np.isnan(x['rb_med']) or (x['rb_med']<0.819285631)  else 72)
                                            if state == 71:
                                                state = (73 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0236226507)  else 74)
                                                if state == 73:
                                                    return -0.0275907628
                                                if state == 74:
                                                    state = (77 if np.isnan(x['rb_med']) or (x['rb_med']<0.488333255)  else 78)
                                                    if state == 77:
                                                        state = (81 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.879750013)  else 82)
                                                        if state == 81:
                                                            return 0.111300647
                                                        if state == 82:
                                                            return -0.0624714829
                                                    if state == 78:
                                                        return 0.271586537
                                            if state == 72:
                                                state = (75 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0227604508)  else 76)
                                                if state == 75:
                                                    return 0.140882194
                                                if state == 76:
                                                    state = (79 if np.isnan(x['rb_med']) or (x['rb_med']<0.888214111)  else 80)
                                                    if state == 79:
                                                        state = (83 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.93324995)  else 84)
                                                        if state == 83:
                                                            return 0.0867896527
                                                        if state == 84:
                                                            return -0.269543022
                                                    if state == 80:
                                                        state = (85 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.978500009)  else 86)
                                                        if state == 85:
                                                            return 0.135472849
                                                        if state == 86:
                                                            return -0.0927039385
                                        if state == 68:
                                            return 0.0160714891
                            if state == 32:
                                state = (47 if np.isnan(x['col_det']) or (x['col_det']<0.277019501)  else 48)
                                if state == 47:
                                    return -0.305983394
                                if state == 48:
                                    return 0.14633061
    elif num_booster == 22:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<7.11181116 else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<18.9518471)  else 4)
                if state == 3:
                    return -0.188001245
                if state == 4:
                    state = (7 if x['maggaia_med']<18.8394794 else 8)
                    if state == 7:
                        state = (13 if x['magnr_med']<17.5214996 else 14)
                        if state == 13:
                            state = (25 if np.isnan(x['mag_last']) or (x['mag_last']<19.0250397)  else 26)
                            if state == 25:
                                return 0.0426266342
                            if state == 26:
                                return -0.140847519
                        if state == 14:
                            state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<19.9557343)  else 28)
                            if state == 27:
                                return 0.158448204
                            if state == 28:
                                return -0.128204077
                    if state == 8:
                        state = (15 if x['magnr_med']<20.8800011 else 16)
                        if state == 15:
                            return -0.153848857
                        if state == 16:
                            return 0.0484779328
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.8197956)  else 6)
                if state == 5:
                    state = (9 if x['maggaia_med']<20.6145039 else 10)
                    if state == 9:
                        state = (17 if x['magnr_med']<17.3167496 else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.319458)  else 30)
                            if state == 29:
                                return -0.160018429
                            if state == 30:
                                return 0.0638946667
                        if state == 18:
                            state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<18.1968307)  else 32)
                            if state == 31:
                                return 0.0202173069
                            if state == 32:
                                state = (47 if np.isnan(x['mag_det']) or (x['mag_det']<19.8012505)  else 48)
                                if state == 47:
                                    state = (59 if np.isnan(x['mag_det']) or (x['mag_det']<19.6892891)  else 60)
                                    if state == 59:
                                        state = (69 if np.isnan(x['mag_det']) or (x['mag_det']<19.1837006)  else 70)
                                        if state == 69:
                                            state = (77 if x['maggaia_med']<15.985651 else 78)
                                            if state == 77:
                                                return -0.0136812134
                                            if state == 78:
                                                state = (85 if x['neargaia_med']<11.7040405 else 86)
                                                if state == 85:
                                                    return 0.00841246359
                                                if state == 86:
                                                    state = (93 if x['distnr_med']<3.1669023 else 94)
                                                    if state == 93:
                                                        return 0.206611484
                                                    if state == 94:
                                                        return -0.0795272067
                                        if state == 70:
                                            state = (79 if x['maggaia_med']<18.5660973 else 80)
                                            if state == 79:
                                                return 0.0733410046
                                            if state == 80:
                                                state = (89 if x['neargaia_med']<29.9958344 else 90)
                                                if state == 89:
                                                    state = (95 if x['distnr_med']<2.38169384 else 96)
                                                    if state == 95:
                                                        return 0.0793423057
                                                    if state == 96:
                                                        return -0.087308839
                                                if state == 90:
                                                    return -0.114809804
                                    if state == 60:
                                        return -0.24289979
                                if state == 48:
                                    return 0.269987792
                    if state == 10:
                        state = (19 if x['magnr_med']<21.2177505 else 20)
                        if state == 19:
                            state = (33 if np.isnan(x['mag_last']) or (x['mag_last']<18.3991013)  else 34)
                            if state == 33:
                                return -0.0631036386
                            if state == 34:
                                return 0.166822612
                        if state == 20:
                            return -0.302712262
                if state == 6:
                    state = (11 if x['maggaia_med']<16.0724144 else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<23.0507507)  else 22)
                        if state == 21:
                            return -0.218908861
                        if state == 22:
                            return 0.0548299327
                    if state == 12:
                        state = (23 if x['magnr_med']<21.3969994 else 24)
                        if state == 23:
                            state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<20.4765472)  else 36)
                            if state == 35:
                                state = (51 if np.isnan(x['mag_det']) or (x['mag_det']<20.4983997)  else 52)
                                if state == 51:
                                    state = (63 if np.isnan(x['mag_det']) or (x['mag_det']<20.1842499)  else 64)
                                    if state == 63:
                                        state = (71 if np.isnan(x['mag_det']) or (x['mag_det']<20.1569004)  else 72)
                                        if state == 71:
                                            state = (81 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.5126724)  else 82)
                                            if state == 81:
                                                return -0.140637487
                                            if state == 82:
                                                state = (91 if x['neargaia_med']<29.0819874 else 92)
                                                if state == 91:
                                                    return -0.117683716
                                                if state == 92:
                                                    return 0.140684247
                                        if state == 72:
                                            return 0.12987709
                                    if state == 64:
                                        return -0.152705655
                                if state == 52:
                                    state = (65 if np.isnan(x['mag_det']) or (x['mag_det']<20.6025505)  else 66)
                                    if state == 65:
                                        return 0.156167388
                                    if state == 66:
                                        return -0.127354577
                            if state == 36:
                                return -0.183196649
                        if state == 24:
                            state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<20.0002213)  else 38)
                            if state == 37:
                                return -0.125945464
                            if state == 38:
                                state = (55 if np.isnan(x['mag_det']) or (x['mag_det']<20.7505493)  else 56)
                                if state == 55:
                                    state = (67 if np.isnan(x['mag_det']) or (x['mag_det']<20.3199501)  else 68)
                                    if state == 67:
                                        state = (73 if np.isnan(x['mag_det']) or (x['mag_det']<20.0764599)  else 74)
                                        if state == 73:
                                            return 0.0507876128
                                        if state == 74:
                                            return -0.128896818
                                    if state == 68:
                                        return 0.170203328
                                if state == 56:
                                    return -0.0958291665
    elif num_booster == 23:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<2.97509837)  else 2)
            if state == 1:
                state = (3 if x['magnr_med']<20.3295002 else 4)
                if state == 3:
                    state = (7 if x['magnr_med']<15.7934999 else 8)
                    if state == 7:
                        return -0.176320657
                    if state == 8:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<20.1996994)  else 14)
                        if state == 13:
                            state = (23 if x['magnr_med']<17.3392506 else 24)
                            if state == 23:
                                state = (37 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9580152)  else 38)
                                if state == 37:
                                    state = (59 if np.isnan(x['mag_last']) or (x['mag_last']<19.6137581)  else 60)
                                    if state == 59:
                                        state = (73 if x['distpsnr1_med']<0.190212667 else 74)
                                        if state == 73:
                                            return 0.079063639
                                        if state == 74:
                                            return -0.140948936
                                    if state == 60:
                                        return 0.0290674102
                                if state == 38:
                                    return 0.0790153295
                            if state == 24:
                                state = (39 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91157389)  else 40)
                                if state == 39:
                                    state = (61 if np.isnan(x['mag_last']) or (x['mag_last']<18.6701927)  else 62)
                                    if state == 61:
                                        return -0.207449779
                                    if state == 62:
                                        state = (75 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.17688298)  else 76)
                                        if state == 75:
                                            return 0.198176786
                                        if state == 76:
                                            state = (83 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.93599999)  else 84)
                                            if state == 83:
                                                state = (87 if x['magnr_med']<19.2195015 else 88)
                                                if state == 87:
                                                    return -0.195029482
                                                if state == 88:
                                                    return 0.0598819591
                                            if state == 84:
                                                return 0.00881775841
                                if state == 40:
                                    return 0.190242738
                        if state == 14:
                            state = (25 if x['magnr_med']<19.4407501 else 26)
                            if state == 25:
                                state = (41 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.540358782)  else 42)
                                if state == 41:
                                    state = (63 if np.isnan(x['mag_last']) or (x['mag_last']<19.7216187)  else 64)
                                    if state == 63:
                                        return 0.151594684
                                    if state == 64:
                                        return -0.130543619
                                if state == 42:
                                    return -0.190047547
                            if state == 26:
                                return 0.095076941
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5982513)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.1816998)  else 16)
                        if state == 15:
                            state = (27 if x['magnr_med']<21.618 else 28)
                            if state == 27:
                                state = (45 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93817711)  else 46)
                                if state == 45:
                                    return -0.146087512
                                if state == 46:
                                    state = (65 if np.isnan(x['mag_last']) or (x['mag_last']<19.9550514)  else 66)
                                    if state == 65:
                                        return 0.122147523
                                    if state == 66:
                                        return -0.0915150344
                            if state == 28:
                                return -0.293214858
                        if state == 16:
                            state = (29 if x['magnr_med']<21.4377518 else 30)
                            if state == 29:
                                return -0.0968695357
                            if state == 30:
                                return 0.124081783
                    if state == 10:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<20.4568005)  else 18)
                        if state == 17:
                            state = (31 if x['magnr_med']<22.8502502 else 32)
                            if state == 31:
                                return 0.125513196
                            if state == 32:
                                state = (53 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.992419)  else 54)
                                if state == 53:
                                    state = (71 if np.isnan(x['mag_last']) or (x['mag_last']<20.3467751)  else 72)
                                    if state == 71:
                                        return -0.148566484
                                    if state == 72:
                                        return 0.0665018633
                                if state == 54:
                                    return 0.0568990186
                        if state == 18:
                            return -0.116413325
            if state == 2:
                state = (5 if x['magnr_med']<15.5529995 else 6)
                if state == 5:
                    return 0.0602087304
                if state == 6:
                    state = (11 if x['magnr_med']<20.3102493 else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.2987995)  else 20)
                        if state == 19:
                            return -0.243444458
                        if state == 20:
                            return 0.0435563102
                    if state == 12:
                        state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<19.9982986)  else 22)
                        if state == 21:
                            return -0.0885124654
                        if state == 22:
                            return 0.0725146085
    elif num_booster == 24:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.647312045)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.995249987)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.78549999)  else 8)
                    if state == 7:
                        state = (11 if x['distnr_med']<0.469456315 else 12)
                        if state == 11:
                            state = (19 if x['distnr_med']<0.320005119 else 20)
                            if state == 19:
                                return -0.0634747446
                            if state == 20:
                                return 0.108959116
                        if state == 12:
                            return -0.113319039
                    if state == 8:
                        state = (13 if x['distnr_med']<0.2205984 else 14)
                        if state == 13:
                            state = (21 if x['distnr_med']<0.1546579 else 22)
                            if state == 21:
                                return -0.160379708
                            if state == 22:
                                return 0.111488715
                        if state == 14:
                            return -0.191652834
                if state == 4:
                    return 0.106613472
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.605250001)  else 6)
                if state == 5:
                    return -0.198669463
                if state == 6:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.79974997)  else 10)
                    if state == 9:
                        state = (15 if x['distnr_med']<0.87906146 else 16)
                        if state == 15:
                            return -0.00955648534
                        if state == 16:
                            state = (25 if x['distnr_med']<0.96874094 else 26)
                            if state == 25:
                                return 0.20080474
                            if state == 26:
                                state = (33 if np.isnan(x['t_lc']) or (x['t_lc']<0.0129282493)  else 34)
                                if state == 33:
                                    return -0.0657284111
                                if state == 34:
                                    state = (41 if np.isnan(x['t_lc']) or (x['t_lc']<2.91537046)  else 42)
                                    if state == 41:
                                        state = (51 if np.isnan(x['mag_det']) or (x['mag_det']<20.4548988)  else 52)
                                        if state == 51:
                                            state = (67 if np.isnan(x['col_det']) or (x['col_det']<0.286049843)  else 68)
                                            if state == 67:
                                                return 0.212822542
                                            if state == 68:
                                                return -0.00609036302
                                        if state == 52:
                                            state = (69 if x['col_det']<0.0431022644 else 70)
                                            if state == 69:
                                                return -0.115161009
                                            if state == 70:
                                                state = (79 if np.isnan(x['col_det']) or (x['col_det']<0.0908622742)  else 80)
                                                if state == 79:
                                                    return 0.149325371
                                                if state == 80:
                                                    return -0.0429104418
                                    if state == 42:
                                        return -0.0183992833
                    if state == 10:
                        state = (17 if x['distnr_med']<2.61319733 else 18)
                        if state == 17:
                            state = (27 if x['distnr_med']<1.86470771 else 28)
                            if state == 27:
                                state = (35 if np.isnan(x['t_lc']) or (x['t_lc']<2.9770081)  else 36)
                                if state == 35:
                                    state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<0.0359664485)  else 44)
                                    if state == 43:
                                        state = (55 if np.isnan(x['mag_det']) or (x['mag_det']<19.8074493)  else 56)
                                        if state == 55:
                                            return 0.131674245
                                        if state == 56:
                                            return -0.181001306
                                    if state == 44:
                                        state = (57 if np.isnan(x['mag_det']) or (x['mag_det']<19.421299)  else 58)
                                        if state == 57:
                                            state = (71 if np.isnan(x['col_det']) or (x['col_det']<-0.340242386)  else 72)
                                            if state == 71:
                                                return 0.0925886929
                                            if state == 72:
                                                return -0.101996131
                                        if state == 58:
                                            return 0.16879496
                                if state == 36:
                                    state = (45 if np.isnan(x['t_lc']) or (x['t_lc']<2.98111105)  else 46)
                                    if state == 45:
                                        return -0.229046434
                                    if state == 46:
                                        return 0.0345125422
                            if state == 28:
                                return 0.176289782
                        if state == 18:
                            state = (29 if x['distnr_med']<2.89385748 else 30)
                            if state == 29:
                                return -0.27475813
                            if state == 30:
                                state = (39 if np.isnan(x['t_lc']) or (x['t_lc']<0.0510416999)  else 40)
                                if state == 39:
                                    state = (47 if np.isnan(x['t_lc']) or (x['t_lc']<0.0176561996)  else 48)
                                    if state == 47:
                                        return -0.225485459
                                    if state == 48:
                                        state = (61 if np.isnan(x['mag_det']) or (x['mag_det']<20.0453491)  else 62)
                                        if state == 61:
                                            state = (75 if np.isnan(x['col_det']) or (x['col_det']<0.0621881485)  else 76)
                                            if state == 75:
                                                return -0.269324839
                                            if state == 76:
                                                return 0.0905909091
                                        if state == 62:
                                            return 0.0403767601
                                if state == 40:
                                    state = (49 if np.isnan(x['t_lc']) or (x['t_lc']<2.94900465)  else 50)
                                    if state == 49:
                                        state = (63 if np.isnan(x['mag_det']) or (x['mag_det']<19.3738499)  else 64)
                                        if state == 63:
                                            return -0.177718267
                                        if state == 64:
                                            return 0.144879892
                                    if state == 50:
                                        state = (65 if np.isnan(x['mag_det']) or (x['mag_det']<19.1023006)  else 66)
                                        if state == 65:
                                            return -0.181134313
                                        if state == 66:
                                            return 0.00261318847
    elif num_booster == 25:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0562744)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.420833349)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<11.8789139 else 8)
                    if state == 7:
                        return 0.0162903294
                    if state == 8:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<0.0286342502)  else 16)
                        if state == 15:
                            return -0.0133588128
                        if state == 16:
                            state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<20.0253677)  else 30)
                            if state == 29:
                                return -0.233293355
                            if state == 30:
                                return 0.09623193
                if state == 4:
                    state = (9 if x['neargaia_med']<25.6445923 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<0.116880804)  else 18)
                        if state == 17:
                            state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<16.759964)  else 32)
                            if state == 31:
                                return 0.00676461263
                            if state == 32:
                                state = (47 if np.isnan(x['mag_last']) or (x['mag_last']<18.8733616)  else 48)
                                if state == 47:
                                    return -0.195365623
                                if state == 48:
                                    state = (59 if x['distpsnr1_med']<0.568983793 else 60)
                                    if state == 59:
                                        return -0.194379613
                                    if state == 60:
                                        state = (69 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0127083501)  else 70)
                                        if state == 69:
                                            return 0.142826378
                                        if state == 70:
                                            state = (77 if np.isnan(x['mag_det']) or (x['mag_det']<19.5980492)  else 78)
                                            if state == 77:
                                                return 0.0771624297
                                            if state == 78:
                                                return -0.200582474
                        if state == 18:
                            state = (33 if np.isnan(x['mag_last']) or (x['mag_last']<19.7157612)  else 34)
                            if state == 33:
                                state = (49 if np.isnan(x['mag_last']) or (x['mag_last']<17.5890694)  else 50)
                                if state == 49:
                                    return -0.111590832
                                if state == 50:
                                    state = (61 if x['distpsnr1_med']<0.144867599 else 62)
                                    if state == 61:
                                        return -0.0568131097
                                    if state == 62:
                                        state = (71 if x['sgscore1_med']<0.87708652 else 72)
                                        if state == 71:
                                            state = (79 if np.isnan(x['mag_det']) or (x['mag_det']<19.4566498)  else 80)
                                            if state == 79:
                                                state = (85 if np.isnan(x['mag_last']) or (x['mag_last']<18.357542)  else 86)
                                                if state == 85:
                                                    return 0.183149695
                                                if state == 86:
                                                    return -0.089590542
                                            if state == 80:
                                                return 0.244403154
                                        if state == 72:
                                            return -0.113287076
                            if state == 34:
                                return -0.103448197
                    if state == 10:
                        state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<0.0288947001)  else 20)
                        if state == 19:
                            state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<19.6774731)  else 36)
                            if state == 35:
                                return -0.268111706
                            if state == 36:
                                return 0.0884815976
                        if state == 20:
                            state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<18.4198036)  else 38)
                            if state == 37:
                                state = (51 if np.isnan(x['mag_last']) or (x['mag_last']<17.866787)  else 52)
                                if state == 51:
                                    state = (63 if x['distpsnr1_med']<4.61794519 else 64)
                                    if state == 63:
                                        return 0.084350124
                                    if state == 64:
                                        return -0.128782541
                                if state == 52:
                                    return -0.144507319
                            if state == 38:
                                state = (53 if np.isnan(x['mag_last']) or (x['mag_last']<19.8453484)  else 54)
                                if state == 53:
                                    state = (65 if x['distpsnr1_med']<1.37765539 else 66)
                                    if state == 65:
                                        state = (73 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00904166512)  else 74)
                                        if state == 73:
                                            return 0.157336399
                                        if state == 74:
                                            state = (83 if np.isnan(x['mag_det']) or (x['mag_det']<19.2085991)  else 84)
                                            if state == 83:
                                                return -0.100866415
                                            if state == 84:
                                                state = (87 if np.isnan(x['mag_last']) or (x['mag_last']<19.3630714)  else 88)
                                                if state == 87:
                                                    return 0.145039812
                                                if state == 88:
                                                    return -0.0935268849
                                    if state == 66:
                                        return 0.227366015
                                if state == 54:
                                    return 0.0210587084
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.526904941)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<19.1572304)  else 12)
                    if state == 11:
                        return -0.125793442
                    if state == 12:
                        state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<0.0352951512)  else 24)
                        if state == 23:
                            state = (41 if np.isnan(x['mag_last']) or (x['mag_last']<20.6621895)  else 42)
                            if state == 41:
                                return -0.117339276
                            if state == 42:
                                return 0.087328732
                        if state == 24:
                            return 0.0730363876
                if state == 6:
                    state = (13 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<31.7810059)  else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['t_lc']) or (x['t_lc']<0.0265161991)  else 26)
                        if state == 25:
                            return 0.0085420562
                        if state == 26:
                            return -0.243056476
                    if state == 14:
                        return -0.0438046642
    elif num_booster == 26:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.593250036)  else 2)
            if state == 1:
                return -0.221703321
            if state == 2:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.9823125)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99323511)  else 6)
                    if state == 5:
                        state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93457747)  else 8)
                        if state == 7:
                            state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<0.0405555516)  else 12)
                            if state == 11:
                                state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<0.0235358998)  else 18)
                                if state == 17:
                                    state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<20.3492012)  else 28)
                                    if state == 27:
                                        return -0.179343075
                                    if state == 28:
                                        return 0.122856997
                                if state == 18:
                                    state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<18.263649)  else 30)
                                    if state == 29:
                                        return 0.080389142
                                    if state == 30:
                                        return -0.285630137
                            if state == 12:
                                state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<2.93854761)  else 20)
                                if state == 19:
                                    state = (31 if np.isnan(x['mag_det']) or (x['mag_det']<18.4323997)  else 32)
                                    if state == 31:
                                        return 0.00793258566
                                    if state == 32:
                                        state = (39 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<31.307682)  else 40)
                                        if state == 39:
                                            state = (49 if np.isnan(x['mag_last']) or (x['mag_last']<19.7303333)  else 50)
                                            if state == 49:
                                                return 0.220174447
                                            if state == 50:
                                                state = (63 if x['magnr_med']<21.6267509 else 64)
                                                if state == 63:
                                                    state = (77 if np.isnan(x['col_det']) or (x['col_det']<0.277019501)  else 78)
                                                    if state == 77:
                                                        return -0.125296533
                                                    if state == 78:
                                                        return 0.0747144297
                                                if state == 64:
                                                    return 0.136547372
                                        if state == 40:
                                            state = (51 if np.isnan(x['mag_last']) or (x['mag_last']<19.1365509)  else 52)
                                            if state == 51:
                                                return -0.113354713
                                            if state == 52:
                                                return 0.108601548
                                if state == 20:
                                    state = (33 if np.isnan(x['mag_det']) or (x['mag_det']<19.9824009)  else 34)
                                    if state == 33:
                                        state = (41 if x['neargaia_med']<0.239404768 else 42)
                                        if state == 41:
                                            return 0.0896113589
                                        if state == 42:
                                            state = (53 if np.isnan(x['mag_last']) or (x['mag_last']<18.8917923)  else 54)
                                            if state == 53:
                                                return 0.00219868612
                                            if state == 54:
                                                return -0.208018035
                                    if state == 34:
                                        state = (43 if x['neargaia_med']<11.4189167 else 44)
                                        if state == 43:
                                            return -0.0811712667
                                        if state == 44:
                                            state = (55 if np.isnan(x['mag_last']) or (x['mag_last']<19.633543)  else 56)
                                            if state == 55:
                                                return 0.153962135
                                            if state == 56:
                                                return -0.0883279294
                        if state == 8:
                            state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.96979189)  else 14)
                            if state == 13:
                                state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<0.0122510996)  else 22)
                                if state == 21:
                                    return 0.00308907987
                                if state == 22:
                                    state = (35 if np.isnan(x['mag_det']) or (x['mag_det']<20.4554996)  else 36)
                                    if state == 35:
                                        state = (45 if x['neargaia_med']<4.44630623 else 46)
                                        if state == 45:
                                            return -0.0171083044
                                        if state == 46:
                                            return 0.207056254
                                    if state == 36:
                                        state = (47 if x['neargaia_med']<24.4081154 else 48)
                                        if state == 47:
                                            return 0.118300557
                                        if state == 48:
                                            return -0.116502292
                            if state == 14:
                                state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<3.0070138)  else 24)
                                if state == 23:
                                    return -0.124316745
                                if state == 24:
                                    return 0.148200542
                    if state == 6:
                        state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.0244503)  else 10)
                        if state == 9:
                            return -0.171906695
                        if state == 10:
                            return 0.0918504298
                if state == 4:
                    return -0.124156244
    elif num_booster == 27:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6987839)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.5758858)  else 4)
                if state == 3:
                    state = (7 if x['magnr_med']<22.2947502 else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.415435493)  else 12)
                        if state == 11:
                            state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.650595307)  else 18)
                            if state == 17:
                                return 0.0073968037
                            if state == 18:
                                return 0.178551346
                        if state == 12:
                            state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.804166675)  else 20)
                            if state == 19:
                                state = (27 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.589224458)  else 28)
                                if state == 27:
                                    state = (37 if x['magnr_med']<17.3974991 else 38)
                                    if state == 37:
                                        return -0.125683531
                                    if state == 38:
                                        state = (53 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01626158)  else 54)
                                        if state == 53:
                                            return 0.223850325
                                        if state == 54:
                                            return -0.0213732012
                                if state == 28:
                                    return -0.0938726068
                            if state == 20:
                                return -0.166038066
                    if state == 8:
                        state = (13 if x['neargaia_med']<13.8477135 else 14)
                        if state == 13:
                            return 0.0438253172
                        if state == 14:
                            return -0.206112072
                if state == 4:
                    return 0.162498951
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.7262497)  else 6)
                if state == 5:
                    return -0.140468612
                if state == 6:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.9864998)  else 10)
                    if state == 9:
                        return -0.167325243
                    if state == 10:
                        state = (15 if x['neargaia_med']<22.8072262 else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.354166597)  else 22)
                            if state == 21:
                                return -0.00917191245
                            if state == 22:
                                state = (31 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.114959501)  else 32)
                                if state == 31:
                                    state = (41 if x['magnr_med']<18.2884998 else 42)
                                    if state == 41:
                                        return 0.0134025933
                                    if state == 42:
                                        return -0.199225307
                                if state == 32:
                                    return -0.0388590582
                        if state == 16:
                            state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.812499881)  else 24)
                            if state == 23:
                                state = (33 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0140624996)  else 34)
                                if state == 33:
                                    state = (45 if x['magnr_med']<18.4212494 else 46)
                                    if state == 45:
                                        return 0.0679186657
                                    if state == 46:
                                        state = (57 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00334501)  else 58)
                                        if state == 57:
                                            state = (67 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<31.9877739)  else 68)
                                            if state == 67:
                                                return -0.166080594
                                            if state == 68:
                                                return 0.0016587493
                                        if state == 58:
                                            return 0.0826964453
                                if state == 34:
                                    return 0.0767406076
                            if state == 24:
                                return 0.0841980502
    elif num_booster == 28:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<1.86631393 else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<2.98112845)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0362351499)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.932857037)  else 16)
                        if state == 15:
                            state = (29 if x['distpsnr1_med']<0.899805307 else 30)
                            if state == 29:
                                state = (39 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00931248534)  else 40)
                                if state == 39:
                                    return 0.143827468
                                if state == 40:
                                    return -0.0356453396
                            if state == 30:
                                return -0.181963846
                        if state == 16:
                            return 0.110485435
                    if state == 8:
                        return -0.200742036
                if state == 4:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.201168001)  else 10)
                    if state == 9:
                        return 0.112384707
                    if state == 10:
                        return -0.0550414696
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.0129282493)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00135416491)  else 12)
                    if state == 11:
                        return 0.0590678938
                    if state == 12:
                        return -0.16704753
                if state == 6:
                    state = (13 if x['sgscore1_med']<0.956738472 else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.367857277)  else 26)
                        if state == 25:
                            state = (35 if x['distpsnr1_med']<17.9426575 else 36)
                            if state == 35:
                                return -0.0913035572
                            if state == 36:
                                return 0.105752468
                        if state == 26:
                            return 0.107389256
                    if state == 14:
                        state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.630833387)  else 28)
                        if state == 27:
                            state = (37 if x['distpsnr1_med']<57.372757 else 38)
                            if state == 37:
                                return -0.0877756327
                            if state == 38:
                                return 0.0682082102
                        if state == 28:
                            return -0.116055474
    elif num_booster == 29:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.9915504)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.223388016 else 4)
                if state == 3:
                    return -0.19714357
                if state == 4:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4293747)  else 8)
                    if state == 7:
                        state = (13 if x['maggaia_med']<16.1306839 else 14)
                        if state == 13:
                            return -0.12520507
                        if state == 14:
                            state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.9398003)  else 20)
                            if state == 19:
                                state = (25 if np.isnan(x['mag_det']) or (x['mag_det']<19.7999496)  else 26)
                                if state == 25:
                                    state = (33 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.8626213)  else 34)
                                    if state == 33:
                                        state = (43 if x['distnr_med']<0.511026263 else 44)
                                        if state == 43:
                                            return 0.103452675
                                        if state == 44:
                                            state = (49 if x['magnr_med']<20.1207504 else 50)
                                            if state == 49:
                                                state = (57 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.6371918)  else 58)
                                                if state == 57:
                                                    return 0.0910582393
                                                if state == 58:
                                                    return -0.0881268382
                                            if state == 50:
                                                return -0.132124081
                                    if state == 34:
                                        state = (45 if x['distnr_med']<0.672421575 else 46)
                                        if state == 45:
                                            return -0.0283782799
                                        if state == 46:
                                            state = (51 if x['magnr_med']<21.6662483 else 52)
                                            if state == 51:
                                                return 0.160413444
                                            if state == 52:
                                                return -0.0173915997
                                if state == 26:
                                    return 0.147104889
                            if state == 20:
                                return -0.115585037
                    if state == 8:
                        return -0.160118982
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.611245155 else 6)
                if state == 5:
                    return -0.039755743
                if state == 6:
                    state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.3565578)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.4482422)  else 18)
                        if state == 17:
                            state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<20.52495)  else 22)
                            if state == 21:
                                state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<20.3922005)  else 30)
                                if state == 29:
                                    state = (37 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<15.6601439)  else 38)
                                    if state == 37:
                                        return 0.0444715098
                                    if state == 38:
                                        return -0.117731027
                                if state == 30:
                                    return 0.115308315
                            if state == 22:
                                return -0.139365852
                        if state == 18:
                            state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<20.361351)  else 24)
                            if state == 23:
                                return 0.168774992
                            if state == 24:
                                return 0.0206486899
                    if state == 12:
                        return -0.0751999095
    elif num_booster == 30:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.1954498)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.503708482)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<48.9493942)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.753095269)  else 14)
                        if state == 13:
                            state = (21 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<21.4964237)  else 22)
                            if state == 21:
                                state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<18.9741001)  else 30)
                                if state == 29:
                                    state = (39 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.145419508)  else 40)
                                    if state == 39:
                                        return -0.136627421
                                    if state == 40:
                                        return 0.0579558946
                                if state == 30:
                                    state = (41 if x['sgscore1_med']<0.205568492 else 42)
                                    if state == 41:
                                        state = (55 if np.isnan(x['mag_det']) or (x['mag_det']<19.9322014)  else 56)
                                        if state == 55:
                                            return -0.0420941897
                                        if state == 56:
                                            return 0.102509737
                                    if state == 42:
                                        state = (57 if np.isnan(x['mag_det']) or (x['mag_det']<20.09025)  else 58)
                                        if state == 57:
                                            return 0.148564577
                                        if state == 58:
                                            return -0.0526434705
                            if state == 22:
                                return 0.154361457
                        if state == 14:
                            state = (23 if x['neargaia_med']<32.4735413 else 24)
                            if state == 23:
                                return -0.0737082586
                            if state == 24:
                                state = (33 if np.isnan(x['mag_det']) or (x['mag_det']<19.1392994)  else 34)
                                if state == 33:
                                    return -0.0720516294
                                if state == 34:
                                    return 0.113977186
                    if state == 8:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.822857141)  else 16)
                        if state == 15:
                            return -0.138601527
                        if state == 16:
                            return 0.0430035852
                if state == 4:
                    return -0.129766271
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.634961009)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<24.3428116)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.507976174)  else 18)
                        if state == 17:
                            state = (25 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<7.75372791)  else 26)
                            if state == 25:
                                state = (35 if np.isnan(x['mag_det']) or (x['mag_det']<20.40695)  else 36)
                                if state == 35:
                                    return 0.0788250417
                                if state == 36:
                                    return -0.137962908
                            if state == 26:
                                return -0.109804802
                        if state == 18:
                            state = (27 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<11.2607098)  else 28)
                            if state == 27:
                                state = (37 if np.isnan(x['mag_det']) or (x['mag_det']<20.4590988)  else 38)
                                if state == 37:
                                    return -0.126848906
                                if state == 38:
                                    return 0.0373401865
                            if state == 28:
                                return 0.107682243
                    if state == 10:
                        state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.851071477)  else 20)
                        if state == 19:
                            return -0.210142493
                        if state == 20:
                            return 0.0419110321
                if state == 6:
                    return 0.0293512084
    elif num_booster == 31:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<17.9202499)  else 2)
            if state == 1:
                return -0.105118893
            if state == 2:
                state = (3 if x['neargaia_med']<27.2281685 else 4)
                if state == 3:
                    state = (5 if x['neargaia_med']<14.7388268 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['col_det']) or (x['col_det']<0.276171684)  else 10)
                        if state == 9:
                            state = (17 if np.isnan(x['col_det']) or (x['col_det']<0.0921220779)  else 18)
                            if state == 17:
                                state = (31 if x['distpsnr1_med']<0.223388016 else 32)
                                if state == 31:
                                    return -0.13385281
                                if state == 32:
                                    state = (43 if np.isnan(x['rb_med']) or (x['rb_med']<0.569999933)  else 44)
                                    if state == 43:
                                        return -0.0372466892
                                    if state == 44:
                                        state = (57 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.86372089)  else 58)
                                        if state == 57:
                                            state = (73 if np.isnan(x['mag_det']) or (x['mag_det']<19.0873985)  else 74)
                                            if state == 73:
                                                return 0.109134085
                                            if state == 74:
                                                return -0.0958252698
                                        if state == 58:
                                            state = (75 if np.isnan(x['mag_det']) or (x['mag_det']<19.778801)  else 76)
                                            if state == 75:
                                                return 0.199926093
                                            if state == 76:
                                                state = (81 if x['neargaia_med']<2.10691881 else 82)
                                                if state == 81:
                                                    return 0.112470277
                                                if state == 82:
                                                    return -0.133008778
                            if state == 18:
                                return -0.0690732673
                        if state == 10:
                            return 0.0960987583
                    if state == 6:
                        state = (11 if x['col_det']<0.0493364334 else 12)
                        if state == 11:
                            return -0.173384219
                        if state == 12:
                            state = (21 if x['col_det']<0.285839081 else 22)
                            if state == 21:
                                return 0.0332823656
                            if state == 22:
                                state = (35 if x['distpsnr1_med']<1.61699224 else 36)
                                if state == 35:
                                    state = (45 if np.isnan(x['rb_med']) or (x['rb_med']<0.67464298)  else 46)
                                    if state == 45:
                                        return -0.0786036849
                                    if state == 46:
                                        return 0.0821016058
                                if state == 36:
                                    return -0.158288136
                if state == 4:
                    state = (7 if x['neargaia_med']<55.2961464 else 8)
                    if state == 7:
                        state = (13 if x['col_det']<-0.0593671799 else 14)
                        if state == 13:
                            return -0.0785892159
                        if state == 14:
                            state = (25 if x['col_det']<0.203544617 else 26)
                            if state == 25:
                                return 0.184283555
                            if state == 26:
                                state = (37 if x['distpsnr1_med']<6.72001505 else 38)
                                if state == 37:
                                    return 0.114955395
                                if state == 38:
                                    state = (49 if np.isnan(x['rb_med']) or (x['rb_med']<0.422261983)  else 50)
                                    if state == 49:
                                        return 0.0893769339
                                    if state == 50:
                                        return -0.125364065
                    if state == 8:
                        state = (15 if np.isnan(x['col_det']) or (x['col_det']<0.0814504623)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['col_det']) or (x['col_det']<-0.0558567047)  else 28)
                            if state == 27:
                                return 0.0202360172
                            if state == 28:
                                return -0.148584232
                        if state == 16:
                            state = (29 if x['col_det']<0.237739563 else 30)
                            if state == 29:
                                return 0.145246074
                            if state == 30:
                                return -0.019897772
    elif num_booster == 32:
        state = 0
        if state == 0:
            state = (1 if x['distnr_med']<0.218413025 else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<18.9309082 else 4)
                if state == 3:
                    return 0.143456101
                if state == 4:
                    return -0.0381341837
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.6130486)  else 6)
                if state == 5:
                    state = (7 if x['maggaia_med']<13.786644 else 8)
                    if state == 7:
                        return -0.114133239
                    if state == 8:
                        state = (11 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.512381792)  else 12)
                        if state == 11:
                            state = (17 if x['distnr_med']<3.53622746 else 18)
                            if state == 17:
                                state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<19.2020988)  else 28)
                                if state == 27:
                                    state = (41 if x['distnr_med']<0.509679437 else 42)
                                    if state == 41:
                                        return 0.0564929694
                                    if state == 42:
                                        return -0.107534669
                                if state == 28:
                                    state = (43 if x['distnr_med']<0.356557518 else 44)
                                    if state == 43:
                                        return -0.117935732
                                    if state == 44:
                                        return 0.0751838908
                            if state == 18:
                                return -0.121959552
                        if state == 12:
                            state = (19 if x['distnr_med']<0.60299921 else 20)
                            if state == 19:
                                return -0.103901826
                            if state == 20:
                                state = (31 if np.isnan(x['mag_det']) or (x['mag_det']<20.0113983)  else 32)
                                if state == 31:
                                    state = (45 if x['distnr_med']<4.11653566 else 46)
                                    if state == 45:
                                        state = (55 if x['distpsnr1_med']<1.33121943 else 56)
                                        if state == 55:
                                            state = (63 if x['magnr_med']<17.0219994 else 64)
                                            if state == 63:
                                                return -0.0954758748
                                            if state == 64:
                                                return 0.135826021
                                        if state == 56:
                                            return 0.185200363
                                    if state == 46:
                                        state = (57 if x['distpsnr1_med']<8.34697151 else 58)
                                        if state == 57:
                                            return -0.124780819
                                        if state == 58:
                                            return 0.075401023
                                if state == 32:
                                    state = (47 if x['distnr_med']<4.69015408 else 48)
                                    if state == 47:
                                        state = (59 if x['distpsnr1_med']<3.2551477 else 60)
                                        if state == 59:
                                            return 0.0594991744
                                        if state == 60:
                                            return -0.140700743
                                    if state == 48:
                                        return 0.0396468416
                if state == 6:
                    state = (9 if x['maggaia_med']<19.9505882 else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.42328262)  else 14)
                        if state == 13:
                            state = (21 if x['distnr_med']<3.48325419 else 22)
                            if state == 21:
                                state = (33 if np.isnan(x['mag_det']) or (x['mag_det']<20.000351)  else 34)
                                if state == 33:
                                    return -0.20990175
                                if state == 34:
                                    state = (51 if x['distnr_med']<1.20266461 else 52)
                                    if state == 51:
                                        return -0.161613956
                                    if state == 52:
                                        return 0.0858094245
                            if state == 22:
                                return -0.0160276257
                        if state == 14:
                            state = (23 if x['distnr_med']<3.87892318 else 24)
                            if state == 23:
                                return 0.121131793
                            if state == 24:
                                return -0.0535075217
                    if state == 10:
                        state = (15 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.67551291)  else 16)
                        if state == 15:
                            return -0.0758501142
                        if state == 16:
                            return 0.0846809149
    elif num_booster == 33:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0424843)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<28.7846642 else 4)
                if state == 3:
                    state = (7 if x['sgscore1_med']<0.382836521 else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.682500124)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<17.9813595)  else 28)
                            if state == 27:
                                return 0.0803432241
                            if state == 28:
                                state = (43 if x['distnr_med']<1.15329671 else 44)
                                if state == 43:
                                    return -0.0991990045
                                if state == 44:
                                    state = (63 if x['neargaia_med']<14.6812401 else 64)
                                    if state == 63:
                                        state = (77 if x['magnr_med']<19.0825005 else 78)
                                        if state == 77:
                                            return -0.0488295779
                                        if state == 78:
                                            return 0.139387041
                                    if state == 64:
                                        return -0.116539069
                        if state == 16:
                            state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.5266266)  else 30)
                            if state == 29:
                                state = (45 if x['distnr_med']<0.278383493 else 46)
                                if state == 45:
                                    return -0.0360263176
                                if state == 46:
                                    return 0.148192734
                            if state == 30:
                                return 0.019804731
                    if state == 8:
                        state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.650000215)  else 18)
                        if state == 17:
                            return -0.0332555547
                        if state == 18:
                            state = (33 if np.isnan(x['mag_last']) or (x['mag_last']<19.6717129)  else 34)
                            if state == 33:
                                return -0.162268341
                            if state == 34:
                                return 0.0366421901
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.521456957 else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.392499924)  else 20)
                        if state == 19:
                            return -0.0416885242
                        if state == 20:
                            state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<19.3750267)  else 36)
                            if state == 35:
                                state = (53 if x['distnr_med']<0.415127635 else 54)
                                if state == 53:
                                    return 0.0107263615
                                if state == 54:
                                    state = (71 if x['neargaia_med']<33.6673317 else 72)
                                    if state == 71:
                                        return -0.0332376771
                                    if state == 72:
                                        return 0.210070282
                            if state == 36:
                                state = (55 if x['distnr_med']<0.754168987 else 56)
                                if state == 55:
                                    return -0.0692981556
                                if state == 56:
                                    state = (75 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<37.2960014)  else 76)
                                    if state == 75:
                                        return 0.138169467
                                    if state == 76:
                                        return -0.0283865873
                    if state == 10:
                        state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.580000043)  else 22)
                        if state == 21:
                            state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<19.9827995)  else 38)
                            if state == 37:
                                return -0.141446099
                            if state == 38:
                                return 0.136359885
                        if state == 22:
                            state = (39 if np.isnan(x['mag_last']) or (x['mag_last']<19.1671886)  else 40)
                            if state == 39:
                                state = (57 if x['distnr_med']<1.77265751 else 58)
                                if state == 57:
                                    return 0.10129071
                                if state == 58:
                                    return -0.107650012
                            if state == 40:
                                return 0.0691771656
            if state == 2:
                state = (5 if x['neargaia_med']<19.5059471 else 6)
                if state == 5:
                    return -0.0146857472
                if state == 6:
                    state = (13 if x['sgscore1_med']<0.636723042 else 14)
                    if state == 13:
                        return -0.167159855
                    if state == 14:
                        state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.67738086)  else 26)
                        if state == 25:
                            return -0.0925192758
                        if state == 26:
                            return 0.0877983272
    elif num_booster == 34:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<36.1096725)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.105146483 else 4)
                if state == 3:
                    return -0.160621881
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<20.1238823)  else 8)
                    if state == 7:
                        state = (11 if x['distpsnr1_med']<1.9808867 else 12)
                        if state == 11:
                            state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<0.0363194495)  else 16)
                            if state == 15:
                                return -0.0822568312
                            if state == 16:
                                state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.679166675)  else 24)
                                if state == 23:
                                    state = (29 if x['neargaia_med']<29.0862751 else 30)
                                    if state == 29:
                                        return -0.113960013
                                    if state == 30:
                                        return 0.0568372458
                                if state == 24:
                                    return 0.122569382
                        if state == 12:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.01929975)  else 18)
                            if state == 17:
                                state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.414642662)  else 26)
                                if state == 25:
                                    return 0.0137421135
                                if state == 26:
                                    state = (35 if x['neargaia_med']<7.11181116 else 36)
                                    if state == 35:
                                        state = (43 if x['distpsnr1_med']<4.59342098 else 44)
                                        if state == 43:
                                            return 0.13864395
                                        if state == 44:
                                            return -0.108092241
                                    if state == 36:
                                        return 0.144720197
                            if state == 18:
                                return -0.147292539
                    if state == 8:
                        state = (13 if x['distpsnr1_med']<1.30585909 else 14)
                        if state == 13:
                            return -0.113050587
                        if state == 14:
                            state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<0.0751099512)  else 20)
                            if state == 19:
                                state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.665237963)  else 28)
                                if state == 27:
                                    return -0.0524451323
                                if state == 28:
                                    return 0.177400216
                            if state == 20:
                                return -0.172420293
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.219411314 else 6)
                if state == 5:
                    return 0.0548481643
                if state == 6:
                    return -0.117884427
    elif num_booster == 35:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0105786994)  else 2)
            if state == 1:
                return -0.122485608
            if state == 2:
                state = (5 if x['magnr_med']<16.0812492 else 6)
                if state == 5:
                    return -0.131899148
                if state == 6:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.503333211)  else 12)
                    if state == 11:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.9979477)  else 14)
                        if state == 13:
                            return -0.0966622308
                        if state == 14:
                            state = (19 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<10.4593801)  else 20)
                            if state == 19:
                                state = (27 if x['magnr_med']<21.96525 else 28)
                                if state == 27:
                                    return -0.0377823934
                                if state == 28:
                                    return 0.123496003
                            if state == 20:
                                return -0.0684858188
                    if state == 12:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<19.8389549)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<6.98908234)  else 22)
                            if state == 21:
                                state = (29 if x['magnr_med']<21.3552513 else 30)
                                if state == 29:
                                    state = (39 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.4242744)  else 40)
                                    if state == 39:
                                        return 0.112203382
                                    if state == 40:
                                        state = (55 if np.isnan(x['t_lc']) or (x['t_lc']<2.96799183)  else 56)
                                        if state == 55:
                                            state = (65 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.04251742)  else 66)
                                            if state == 65:
                                                return 0.107114509
                                            if state == 66:
                                                state = (71 if x['magnr_med']<18.4632492 else 72)
                                                if state == 71:
                                                    return 0.0752220079
                                                if state == 72:
                                                    return -0.0744416639
                                        if state == 56:
                                            return -0.148219064
                                if state == 30:
                                    return -0.134541899
                            if state == 22:
                                state = (31 if x['magnr_med']<21.29175 else 32)
                                if state == 31:
                                    state = (41 if x['maggaia_med']<19.0915947 else 42)
                                    if state == 41:
                                        return 0.207883254
                                    if state == 42:
                                        state = (59 if np.isnan(x['t_lc']) or (x['t_lc']<0.122725651)  else 60)
                                        if state == 59:
                                            return -0.0283192545
                                        if state == 60:
                                            state = (69 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.12938666)  else 70)
                                            if state == 69:
                                                return -0.0633082613
                                            if state == 70:
                                                return 0.123087488
                                if state == 32:
                                    state = (43 if x['maggaia_med']<19.4443607 else 44)
                                    if state == 43:
                                        return 0.0759002343
                                    if state == 44:
                                        return -0.0787991434
                        if state == 16:
                            state = (23 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<21.6142979)  else 24)
                            if state == 23:
                                state = (33 if x['magnr_med']<18.0820007 else 34)
                                if state == 33:
                                    return 0.0114588719
                                if state == 34:
                                    return -0.174889952
                            if state == 24:
                                return 0.0175766684
    elif num_booster == 36:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.604749978)  else 2)
            if state == 1:
                return -0.153802171
            if state == 2:
                state = (3 if x['distpsnr1_med']<0.512381792 else 4)
                if state == 3:
                    state = (5 if x['distpsnr1_med']<0.131968945 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.1009731)  else 10)
                        if state == 9:
                            return -0.120127141
                        if state == 10:
                            return 0.0875105113
                    if state == 6:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.20644)  else 12)
                        if state == 11:
                            return 0.0170215815
                        if state == 12:
                            return -0.217558712
                if state == 4:
                    state = (7 if x['distpsnr1_med']<0.778483152 else 8)
                    if state == 7:
                        return 0.150649309
                    if state == 8:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.5716743)  else 14)
                        if state == 13:
                            state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<20.2310505)  else 18)
                            if state == 17:
                                state = (23 if x['distnr_med']<1.86665654 else 24)
                                if state == 23:
                                    return -0.122831255
                                if state == 24:
                                    state = (29 if x['sgscore1_med']<0.4264175 else 30)
                                    if state == 29:
                                        return 0.121647455
                                    if state == 30:
                                        state = (37 if x['sgscore1_med']<0.712363005 else 38)
                                        if state == 37:
                                            state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<0.0439352021)  else 44)
                                            if state == 43:
                                                return -0.105226636
                                            if state == 44:
                                                return 0.0787867829
                                        if state == 38:
                                            return -0.10245432
                            if state == 18:
                                return 0.15765667
                        if state == 14:
                            state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.8314514)  else 20)
                            if state == 19:
                                return 0.0987771302
                            if state == 20:
                                state = (25 if x['distnr_med']<2.04341197 else 26)
                                if state == 25:
                                    state = (31 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00552083505)  else 32)
                                    if state == 31:
                                        return -0.015921073
                                    if state == 32:
                                        return 0.115712933
                                if state == 26:
                                    state = (33 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.496340513)  else 34)
                                    if state == 33:
                                        state = (39 if x['sgscore1_med']<0.0144375004 else 40)
                                        if state == 39:
                                            return 0.0276627149
                                        if state == 40:
                                            return -0.140566826
                                    if state == 34:
                                        return 0.0576601475
    elif num_booster == 37:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.655822754)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.0104484558)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.536547542)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.350357324)  else 10)
                        if state == 9:
                            return -0.0874387398
                        if state == 10:
                            state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<18.4272404)  else 16)
                            if state == 15:
                                return -0.0753791407
                            if state == 16:
                                state = (21 if x['col_det']<-0.254532814 else 22)
                                if state == 21:
                                    return -0.0520065539
                                if state == 22:
                                    state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.128396958)  else 28)
                                    if state == 27:
                                        return -0.0398109443
                                    if state == 28:
                                        return 0.145482391
                    if state == 6:
                        state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.573333442)  else 12)
                        if state == 11:
                            return -0.149708018
                        if state == 12:
                            state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<19.7920418)  else 18)
                            if state == 17:
                                state = (23 if np.isnan(x['col_det']) or (x['col_det']<-0.300398827)  else 24)
                                if state == 23:
                                    state = (29 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0234490503)  else 30)
                                    if state == 29:
                                        return -0.0745101646
                                    if state == 30:
                                        state = (35 if x['distnr_med']<2.85448027 else 36)
                                        if state == 35:
                                            state = (39 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01968169)  else 40)
                                            if state == 39:
                                                state = (43 if x['distnr_med']<0.58251375 else 44)
                                                if state == 43:
                                                    return -0.0351914577
                                                if state == 44:
                                                    return 0.212524936
                                            if state == 40:
                                                return 0.0118733775
                                        if state == 36:
                                            return -0.0557384528
                                if state == 24:
                                    state = (31 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.94567132)  else 32)
                                    if state == 31:
                                        return -0.141759187
                                    if state == 32:
                                        return 0.0394386537
                            if state == 18:
                                state = (25 if x['col_det']<-0.0200681686 else 26)
                                if state == 25:
                                    return 0.00418294594
                                if state == 26:
                                    return -0.229971647
                if state == 4:
                    return 0.0850253552
            if state == 2:
                return -0.123250417
    elif num_booster == 38:
        state = 0
        if state == 0:
            state = (1 if x['col_det']<0.132285118 else 2)
            if state == 1:
                return 0.0386008881
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.863214135)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['col_det']) or (x['col_det']<0.643074989)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0616376996)  else 20)
                        if state == 19:
                            return -0.110825256
                        if state == 20:
                            state = (27 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.593853)  else 28)
                            if state == 27:
                                state = (37 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.712499976)  else 38)
                                if state == 37:
                                    return -0.144871533
                                if state == 38:
                                    state = (47 if np.isnan(x['rb_med']) or (x['rb_med']<0.731190503)  else 48)
                                    if state == 47:
                                        state = (51 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.989000022)  else 52)
                                        if state == 51:
                                            state = (55 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.04005206)  else 56)
                                            if state == 55:
                                                return 0.129937619
                                            if state == 56:
                                                state = (57 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.96875)  else 58)
                                                if state == 57:
                                                    state = (59 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97912025)  else 60)
                                                    if state == 59:
                                                        return -0.091192089
                                                    if state == 60:
                                                        return 0.0707151368
                                                if state == 58:
                                                    return 0.0901574492
                                        if state == 52:
                                            return -0.0630751997
                                    if state == 48:
                                        return -0.115768164
                            if state == 28:
                                return 0.0249180682
                    if state == 12:
                        return -0.120213486
                if state == 6:
                    return 0.0872827023
    elif num_booster == 39:
        state = 0
        if state == 0:
            state = (1 if x['distnr_med']<4.83447599 else 2)
            if state == 1:
                state = (3 if x['magnr_med']<17.5377502 else 4)
                if state == 3:
                    return -0.120117545
                if state == 4:
                    state = (9 if x['distnr_med']<0.16133821 else 10)
                    if state == 9:
                        return -0.0743167624
                    if state == 10:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<19.8228493)  else 16)
                        if state == 15:
                            state = (19 if x['col_det']<0.804894447 else 20)
                            if state == 19:
                                return 0.18482618
                            if state == 20:
                                return 0.015299568
                        if state == 16:
                            state = (21 if np.isnan(x['col_det']) or (x['col_det']<-0.0415124893)  else 22)
                            if state == 21:
                                state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<19.9769497)  else 30)
                                if state == 29:
                                    return -0.119634964
                                if state == 30:
                                    state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.915000021)  else 40)
                                    if state == 39:
                                        state = (47 if np.isnan(x['mag_det']) or (x['mag_det']<20.4176502)  else 48)
                                        if state == 47:
                                            return 0.0915645882
                                        if state == 48:
                                            return -0.0816008821
                                    if state == 40:
                                        return -0.0829589292
                            if state == 22:
                                return 0.0504931547
            if state == 2:
                state = (5 if x['magnr_med']<18.8052502 else 6)
                if state == 5:
                    return 0.0422704443
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<11.5260715)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.1327171)  else 18)
                        if state == 17:
                            return -0.199523002
                        if state == 18:
                            state = (23 if x['col_det']<0.277825356 else 24)
                            if state == 23:
                                return 0.0412341319
                            if state == 24:
                                return -0.142881349
                    if state == 12:
                        return 0.0124379834
    elif num_booster == 40:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5253105)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.973894596)  else 4)
                if state == 3:
                    return 0.0946020633
                if state == 4:
                    state = (9 if x['neargaia_med']<11.5132608 else 10)
                    if state == 9:
                        return 0.0352262482
                    if state == 10:
                        state = (19 if x['distnr_med']<2.79366302 else 20)
                        if state == 19:
                            state = (31 if x['distnr_med']<1.65355206 else 32)
                            if state == 31:
                                return -0.097944133
                            if state == 32:
                                return 0.112206534
                        if state == 20:
                            return -0.120950542
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.8249073)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<175.897018 else 12)
                    if state == 11:
                        return -0.164544702
                    if state == 12:
                        return 0.0184494033
                if state == 6:
                    state = (13 if x['neargaia_med']<17.0009556 else 14)
                    if state == 13:
                        state = (23 if x['distnr_med']<0.581920445 else 24)
                        if state == 23:
                            return -0.0440715402
                        if state == 24:
                            state = (37 if x['distnr_med']<1.36199725 else 38)
                            if state == 37:
                                return 0.0986892283
                            if state == 38:
                                state = (49 if x['neargaia_med']<7.3961525 else 50)
                                if state == 49:
                                    return -0.0617999546
                                if state == 50:
                                    return 0.0826500654
                    if state == 14:
                        state = (25 if x['distnr_med']<0.756918728 else 26)
                        if state == 25:
                            return -0.0900800079
                        if state == 26:
                            state = (41 if x['distnr_med']<2.22883248 else 42)
                            if state == 41:
                                return 0.0457385331
                            if state == 42:
                                state = (53 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<29.7097034)  else 54)
                                if state == 53:
                                    return -0.140473723
                                if state == 54:
                                    return 0.0603330694
    elif num_booster == 41:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<20.6757507 else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<6.27689552 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<2.9691782)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9979167)  else 16)
                        if state == 15:
                            state = (29 if x['magnr_med']<19.257 else 30)
                            if state == 29:
                                state = (43 if np.isnan(x['mag_last']) or (x['mag_last']<19.005909)  else 44)
                                if state == 43:
                                    return -0.0916258395
                                if state == 44:
                                    state = (55 if x['maggaia_med']<19.8072891 else 56)
                                    if state == 55:
                                        return 0.0725912824
                                    if state == 56:
                                        return -0.101705417
                            if state == 30:
                                state = (45 if np.isnan(x['mag_last']) or (x['mag_last']<19.1418343)  else 46)
                                if state == 45:
                                    return -0.0283128079
                                if state == 46:
                                    return 0.163536638
                        if state == 16:
                            return -0.0693089366
                    if state == 8:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.02593184)  else 18)
                        if state == 17:
                            return -0.125375554
                        if state == 18:
                            return 0.0767574534
                if state == 4:
                    return 0.0947744399
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<10.7328424)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<0.0559896529)  else 12)
                    if state == 11:
                        state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90942144)  else 24)
                        if state == 23:
                            return 0.0249102525
                        if state == 24:
                            state = (39 if x['magnr_med']<21.4127502 else 40)
                            if state == 39:
                                return 0.0483623222
                            if state == 40:
                                return -0.127136394
                    if state == 12:
                        return -0.140032381
                if state == 6:
                    state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<0.0227256995)  else 14)
                    if state == 13:
                        return -0.0268787295
                    if state == 14:
                        state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91774893)  else 28)
                        if state == 27:
                            return 0.118759416
                        if state == 28:
                            return -0.0552839562
    elif num_booster == 42:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<17.7361946)  else 2)
            if state == 1:
                return -0.115902841
            if state == 2:
                state = (3 if x['distnr_med']<5.26400042 else 4)
                if state == 3:
                    state = (5 if x['distnr_med']<1.47439265 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['col_det']) or (x['col_det']<-0.361822128)  else 10)
                        if state == 9:
                            state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<18.2712402)  else 16)
                            if state == 15:
                                return 0.0828181952
                            if state == 16:
                                state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<19.0347023)  else 28)
                                if state == 27:
                                    return -0.100019835
                                if state == 28:
                                    state = (41 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0201250017)  else 42)
                                    if state == 41:
                                        state = (53 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<25.1215019)  else 54)
                                        if state == 53:
                                            return 0.133690283
                                        if state == 54:
                                            return -0.0421656258
                                    if state == 42:
                                        return -0.0815979242
                        if state == 10:
                            state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<19.4400139)  else 18)
                            if state == 17:
                                return 0.00314852176
                            if state == 18:
                                state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<20.4189339)  else 32)
                                if state == 31:
                                    state = (45 if x['sgscore1_med']<0.0238124989 else 46)
                                    if state == 45:
                                        return 0.0422668047
                                    if state == 46:
                                        return -0.139597535
                                if state == 32:
                                    return 0.00131460628
                    if state == 6:
                        state = (11 if x['col_det']<0.0414419174 else 12)
                        if state == 11:
                            return -0.0701307058
                        if state == 12:
                            state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<20.0424004)  else 22)
                            if state == 21:
                                state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<18.5312958)  else 36)
                                if state == 35:
                                    return 0.00702018151
                                if state == 36:
                                    state = (49 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.503708482)  else 50)
                                    if state == 49:
                                        state = (59 if x['neargaia_med']<2.77428055 else 60)
                                        if state == 59:
                                            return -0.054083854
                                        if state == 60:
                                            return 0.188781366
                                    if state == 50:
                                        return 0.0103422906
                            if state == 22:
                                return 0.00571461394
                if state == 4:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.27143288)  else 8)
                    if state == 7:
                        return -0.106019564
                    if state == 8:
                        state = (13 if x['col_det']<0.0596456528 else 14)
                        if state == 13:
                            return 0.0679752603
                        if state == 14:
                            return -0.074011974
    elif num_booster == 43:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.6380005)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<2.67024803)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.88178575)  else 8)
                    if state == 7:
                        return -0.138775408
                    if state == 8:
                        return 0.0536069945
                if state == 4:
                    return 0.00841690972
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<28.7859173)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.733452559)  else 12)
                    if state == 11:
                        state = (17 if x['maggaia_med']<17.8218079 else 18)
                        if state == 17:
                            return -0.0971149653
                        if state == 18:
                            state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<0.00404514978)  else 24)
                            if state == 23:
                                return -0.078793183
                            if state == 24:
                                state = (31 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<1.85272598)  else 32)
                                if state == 31:
                                    state = (33 if x['magnr_med']<21.9362507 else 34)
                                    if state == 33:
                                        return -0.0328138322
                                    if state == 34:
                                        return 0.100860476
                                if state == 32:
                                    state = (35 if x['magnr_med']<22.3322506 else 36)
                                    if state == 35:
                                        return 0.138274267
                                    if state == 36:
                                        return -0.0453140624
                    if state == 12:
                        state = (19 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.8267136)  else 20)
                        if state == 19:
                            return 0.0471555665
                        if state == 20:
                            state = (27 if np.isnan(x['t_lc']) or (x['t_lc']<0.0373958498)  else 28)
                            if state == 27:
                                return 0.0560154989
                            if state == 28:
                                return -0.167205527
                if state == 6:
                    state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.49666661)  else 14)
                    if state == 13:
                        return 0.00672265561
                    if state == 14:
                        state = (21 if x['maggaia_med']<19.7799625 else 22)
                        if state == 21:
                            state = (29 if np.isnan(x['t_lc']) or (x['t_lc']<0.0294502489)  else 30)
                            if state == 29:
                                return -0.0258067492
                            if state == 30:
                                return 0.178858399
                        if state == 22:
                            return -0.0200489126
    elif num_booster == 44:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0407233499)  else 2)
            if state == 1:
                return -0.0742460862
            if state == 2:
                state = (5 if x['neargaia_med']<10.4105072 else 6)
                if state == 5:
                    return 0.0628610998
                if state == 6:
                    state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.93840861)  else 14)
                    if state == 13:
                        state = (21 if np.isnan(x['col_det']) or (x['col_det']<-0.446475983)  else 22)
                        if state == 21:
                            return 0.130560935
                        if state == 22:
                            state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.383571327)  else 32)
                            if state == 31:
                                return 0.0690542161
                            if state == 32:
                                state = (37 if x['col_det']<-0.111516953 else 38)
                                if state == 37:
                                    return -0.186390951
                                if state == 38:
                                    state = (43 if x['neargaia_med']<28.9235077 else 44)
                                    if state == 43:
                                        return -0.0862248465
                                    if state == 44:
                                        return 0.0947969928
                    if state == 14:
                        return -0.0494943969
    elif num_booster == 45:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.0862373039)  else 2)
            if state == 1:
                return -0.0457016528
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.0623322502)  else 6)
                if state == 5:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.3487968)  else 8)
                    if state == 7:
                        state = (11 if x['magnr_med']<19.7137489 else 12)
                        if state == 11:
                            return 0.0712158158
                        if state == 12:
                            state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.526904941)  else 18)
                            if state == 17:
                                state = (27 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.796000004)  else 28)
                                if state == 27:
                                    return -0.071764864
                                if state == 28:
                                    return 0.0892926604
                            if state == 18:
                                return -0.119230844
                    if state == 8:
                        return -0.117249325
                if state == 6:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.2328415)  else 10)
                    if state == 9:
                        state = (13 if x['magnr_med']<18.3637505 else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.580833316)  else 20)
                            if state == 19:
                                return -0.113132216
                            if state == 20:
                                state = (29 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976750016)  else 30)
                                if state == 29:
                                    state = (37 if x['distnr_med']<0.961011529 else 38)
                                    if state == 37:
                                        return -0.104012035
                                    if state == 38:
                                        return 0.0442859828
                                if state == 30:
                                    return 0.115480721
                        if state == 14:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.835357308)  else 22)
                            if state == 21:
                                return 0.126259401
                            if state == 22:
                                return -0.0579369217
                    if state == 10:
                        return -0.0567421094
    elif num_booster == 46:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.9310112 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.883214176)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.733333409)  else 8)
                    if state == 7:
                        state = (13 if x['distnr_med']<5.86913109 else 14)
                        if state == 13:
                            state = (25 if x['distnr_med']<0.699022412 else 26)
                            if state == 25:
                                state = (29 if x['sgscore1_med']<0.0110208355 else 30)
                                if state == 29:
                                    return 0.0577592179
                                if state == 30:
                                    return -0.131299913
                            if state == 26:
                                state = (31 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.418479502)  else 32)
                                if state == 31:
                                    state = (33 if x['maggaia_med']<19.4244957 else 34)
                                    if state == 33:
                                        state = (37 if x['distnr_med']<1.78412545 else 38)
                                        if state == 37:
                                            state = (39 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0518362969)  else 40)
                                            if state == 39:
                                                return 0.113406703
                                            if state == 40:
                                                return -0.050853435
                                        if state == 38:
                                            return 0.142285436
                                    if state == 34:
                                        return -0.105332032
                                if state == 32:
                                    return -0.0469031483
                        if state == 14:
                            return -0.147305503
                    if state == 8:
                        state = (15 if x['distnr_med']<0.208828807 else 16)
                        if state == 15:
                            return 0.0401141867
                        if state == 16:
                            return -0.162319079
                if state == 4:
                    return 0.116460182
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.580000043)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.382737815)  else 10)
                    if state == 9:
                        return 0.0692531317
                    if state == 10:
                        state = (19 if x['distnr_med']<6.14177227 else 20)
                        if state == 19:
                            return -0.125217021
                        if state == 20:
                            return 0.084343262
                if state == 6:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.753095269)  else 12)
                    if state == 11:
                        state = (21 if x['distnr_med']<2.59481144 else 22)
                        if state == 21:
                            return 0.134252846
                        if state == 22:
                            return -0.0740007386
                    if state == 12:
                        return -0.0129750893
    elif num_booster == 47:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<21.7132492 else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97357059)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93457747)  else 8)
                    if state == 7:
                        state = (13 if x['col_det']<0.128781319 else 14)
                        if state == 13:
                            return -0.0654625297
                        if state == 14:
                            state = (25 if x['magnr_med']<19.7147503 else 26)
                            if state == 25:
                                state = (39 if x['distnr_med']<1.77578926 else 40)
                                if state == 39:
                                    return 0.0131625915
                                if state == 40:
                                    return 0.169812396
                            if state == 26:
                                state = (41 if x['distnr_med']<0.731696486 else 42)
                                if state == 41:
                                    return 0.0836014301
                                if state == 42:
                                    return -0.131437257
                    if state == 8:
                        return 0.115993053
                if state == 4:
                    return -0.0401026011
            if state == 2:
                return -0.0883183032
    elif num_booster == 48:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7072124)  else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.00204166491 else 4)
                if state == 3:
                    return -0.0695437267
                if state == 4:
                    state = (7 if x['neargaia_med']<6.98908234 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.213014513)  else 14)
                        if state == 13:
                            state = (19 if x['sgscore1_med']<0.137127489 else 20)
                            if state == 19:
                                return -0.0455117449
                            if state == 20:
                                return 0.119928963
                        if state == 14:
                            return -0.114146121
                    if state == 8:
                        state = (15 if x['sgscore1_med']<0.0586815476 else 16)
                        if state == 15:
                            return 0.134687021
                        if state == 16:
                            state = (21 if x['sgscore1_med']<0.149636999 else 22)
                            if state == 21:
                                return -0.0512833074
                            if state == 22:
                                state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<18.3405457)  else 28)
                                if state == 27:
                                    return -0.0214568898
                                if state == 28:
                                    state = (33 if np.isnan(x['rb_med']) or (x['rb_med']<0.502499998)  else 34)
                                    if state == 33:
                                        return -0.0296124723
                                    if state == 34:
                                        state = (39 if np.isnan(x['t_lc']) or (x['t_lc']<0.0355671495)  else 40)
                                        if state == 39:
                                            return -0.0418964699
                                        if state == 40:
                                            return 0.159826279
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0030878)  else 6)
                if state == 5:
                    return 0.0401873887
                if state == 6:
                    return -0.0878552943
    elif num_booster == 49:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.53480959)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.584944963)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<0.0200579017)  else 8)
                    if state == 7:
                        return -0.0816905349
                    if state == 8:
                        state = (11 if x['distpsnr1_med']<0.0847772956 else 12)
                        if state == 11:
                            return -0.102715075
                        if state == 12:
                            state = (15 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.04649305)  else 16)
                            if state == 15:
                                return -0.0542964749
                            if state == 16:
                                state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<2.91218758)  else 22)
                                if state == 21:
                                    state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<18.406496)  else 28)
                                    if state == 27:
                                        return -0.0628758147
                                    if state == 28:
                                        state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<19.5580044)  else 36)
                                        if state == 35:
                                            return 0.145735726
                                        if state == 36:
                                            state = (43 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97057295)  else 44)
                                            if state == 43:
                                                return 0.0861398578
                                            if state == 44:
                                                return -0.118364364
                                if state == 22:
                                    state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.7686653)  else 30)
                                    if state == 29:
                                        return 0.0508902706
                                    if state == 30:
                                        return -0.147576347
                if state == 4:
                    return -0.10890118
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0114374999)  else 6)
                if state == 5:
                    return -0.0393709466
                if state == 6:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<0.0206017997)  else 10)
                    if state == 9:
                        return -0.0549040921
                    if state == 10:
                        return 0.108398035
    elif num_booster == 50:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.119902998)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.5816927)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.4999504)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.981750011)  else 16)
                        if state == 15:
                            return -0.0269332658
                        if state == 16:
                            state = (25 if x['magnr_med']<21.161499 else 26)
                            if state == 25:
                                return 0.149898723
                            if state == 26:
                                return -0.0522688217
                    if state == 8:
                        return -0.120548181
                if state == 4:
                    return 0.00813348498
            if state == 2:
                state = (5 if x['distnr_med']<0.64575696 else 6)
                if state == 5:
                    return -0.0596508905
                if state == 6:
                    state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<20.6693573)  else 14)
                    if state == 13:
                        state = (21 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.635249972)  else 22)
                        if state == 21:
                            return -0.104022354
                        if state == 22:
                            state = (31 if x['magnr_med']<20.0709991 else 32)
                            if state == 31:
                                return 0.139890179
                            if state == 32:
                                state = (39 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4115982)  else 40)
                                if state == 39:
                                    state = (45 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.9982452)  else 46)
                                    if state == 45:
                                        return -0.0412640683
                                    if state == 46:
                                        return 0.0993828103
                                if state == 40:
                                    return -0.102994852
                    if state == 14:
                        return 0.0927764475
    elif num_booster == 51:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.00281250011 else 2)
            if state == 1:
                return -0.0606961884
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.492864847 else 6)
                if state == 5:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.04328705)  else 8)
                    if state == 7:
                        return 0.101189278
                    if state == 8:
                        return -0.120841235
                if state == 6:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.82625008)  else 10)
                    if state == 9:
                        state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0386285)  else 12)
                        if state == 11:
                            return 0.0604716279
                        if state == 12:
                            return -0.077085726
                    if state == 10:
                        return 0.0627267361
    elif num_booster == 52:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.207983017)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.9853001)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.879999876)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.958000004)  else 16)
                        if state == 15:
                            return -0.100015715
                        if state == 16:
                            return 0.00139331492
                    if state == 8:
                        return 0.067746833
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.395000011)  else 10)
                    if state == 9:
                        return -0.0542117134
                    if state == 10:
                        return 0.084872365
            if state == 2:
                return -0.0768339261
    elif num_booster == 53:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.0999393 else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<18.6130486 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.88228011)  else 8)
                    if state == 7:
                        return 0.077396147
                    if state == 8:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.822857141)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.451666594)  else 22)
                            if state == 21:
                                return 0.0395127088
                            if state == 22:
                                state = (27 if x['maggaia_med']<17.8532715 else 28)
                                if state == 27:
                                    return -0.146986589
                                if state == 28:
                                    return 0.0299496651
                        if state == 16:
                            return 0.0533426739
                if state == 4:
                    return -0.110233031
            if state == 2:
                state = (5 if x['maggaia_med']<19.4107971 else 6)
                if state == 5:
                    return 0.10651572
                if state == 6:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95881367)  else 12)
                    if state == 11:
                        return -0.0728850365
                    if state == 12:
                        return 0.102723569
    elif num_booster == 54:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.0406249985 else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.00774999987 else 4)
                if state == 3:
                    state = (7 if x['distnr_med']<1.3882103 else 8)
                    if state == 7:
                        return 0.0905046239
                    if state == 8:
                        return -0.0885332599
                if state == 4:
                    return 0.0714006275
            if state == 2:
                state = (5 if x['sgscore1_med']<0.119902998 else 6)
                if state == 5:
                    return -0.10208796
                if state == 6:
                    state = (11 if x['distnr_med']<1.06072903 else 12)
                    if state == 11:
                        return 0.0530361496
                    if state == 12:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92714691)  else 20)
                        if state == 19:
                            return -0.0747711137
                        if state == 20:
                            return 0.0299012382
    elif num_booster == 55:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<20.3287506 else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.00562500022 else 4)
                if state == 3:
                    return -0.0678295195
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.7049294)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.319568276)  else 16)
                        if state == 15:
                            state = (21 if x['magnr_med']<16.5545006 else 22)
                            if state == 21:
                                return -0.0663626641
                            if state == 22:
                                return 0.131193399
                        if state == 16:
                            return -0.0376915671
                    if state == 10:
                        state = (17 if x['sgscore1_med']<0.0847499967 else 18)
                        if state == 17:
                            state = (25 if x['magnr_med']<19.5857506 else 26)
                            if state == 25:
                                return -0.1458866
                            if state == 26:
                                return 0.0837652981
                        if state == 18:
                            return 0.0258391891
            if state == 2:
                state = (5 if x['sgscore1_med']<0.0162083507 else 6)
                if state == 5:
                    return 0.0223107897
                if state == 6:
                    state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.8176193)  else 14)
                    if state == 13:
                        return -0.0842192098
                    if state == 14:
                        state = (19 if x['sgscore1_med']<0.410145998 else 20)
                        if state == 19:
                            return -0.0669817775
                        if state == 20:
                            state = (29 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.3222504)  else 30)
                            if state == 29:
                                return -0.0601223372
                            if state == 30:
                                return 0.107313752
    elif num_booster == 56:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.9823125 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.650000215)  else 4)
                if state == 3:
                    state = (7 if x['distnr_med']<0.808425784 else 8)
                    if state == 7:
                        return -0.0799484402
                    if state == 8:
                        state = (17 if x['distpsnr1_med']<1.12061048 else 18)
                        if state == 17:
                            return -0.0236024894
                        if state == 18:
                            state = (23 if x['distnr_med']<9.35765076 else 24)
                            if state == 23:
                                state = (27 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.733999968)  else 28)
                                if state == 27:
                                    return -0.0223080311
                                if state == 28:
                                    return 0.137554303
                            if state == 24:
                                return -0.0112476116
                if state == 4:
                    state = (9 if x['distnr_med']<0.468597054 else 10)
                    if state == 9:
                        return -0.0788545087
                    if state == 10:
                        state = (21 if x['distpsnr1_med']<7.0544672 else 22)
                        if state == 21:
                            state = (25 if x['distnr_med']<2.59656858 else 26)
                            if state == 25:
                                state = (29 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.893749952)  else 30)
                                if state == 29:
                                    return 0.0850601494
                                if state == 30:
                                    state = (35 if x['magnr_med']<18.5927505 else 36)
                                    if state == 35:
                                        return -0.121502183
                                    if state == 36:
                                        return 0.0772258192
                            if state == 26:
                                return -0.123510733
                        if state == 22:
                            return 0.0732715651
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.533333421)  else 6)
                if state == 5:
                    state = (11 if x['distnr_med']<0.701883912 else 12)
                    if state == 11:
                        return 0.0867624134
                    if state == 12:
                        return -0.0645353645
                if state == 6:
                    return -0.0708936751
    elif num_booster == 57:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<18.3654995 else 2)
            if state == 1:
                return -0.0917271152
            if state == 2:
                state = (5 if x['sgscore1_med']<0.500625014 else 6)
                if state == 5:
                    return 0.0596567355
                if state == 6:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.956839502)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.7245636)  else 20)
                        if state == 19:
                            state = (29 if x['distnr_med']<4.82937908 else 30)
                            if state == 29:
                                state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<20.4657192)  else 36)
                                if state == 35:
                                    return 0.0814813673
                                if state == 36:
                                    return -0.0605932139
                            if state == 30:
                                return -0.0321487412
                        if state == 20:
                            return -0.0890430883
                    if state == 12:
                        return -0.0889320523
    elif num_booster == 58:
        return  -0.00766548188
    elif num_booster == 59:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.1859512)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<28.7846642 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.678809643)  else 8)
                    if state == 7:
                        return -0.0453691892
                    if state == 8:
                        state = (17 if x['magnr_med']<17.3715 else 18)
                        if state == 17:
                            return 0.126925558
                        if state == 18:
                            return -0.0233807378
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.867857337)  else 10)
                    if state == 9:
                        return 0.084864758
                    if state == 10:
                        return -0.0590884313
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<21.1738548)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.414642662)  else 12)
                    if state == 11:
                        state = (21 if x['magnr_med']<21.9550018 else 22)
                        if state == 21:
                            return -0.142759234
                        if state == 22:
                            return 0.0515590012
                    if state == 12:
                        state = (23 if x['magnr_med']<19.5682487 else 24)
                        if state == 23:
                            return -0.054550536
                        if state == 24:
                            return 0.0997822657
                if state == 6:
                    return -0.12745969
    elif num_booster == 60:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<22.0602493 else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.317470014 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.747999966)  else 8)
                    if state == 7:
                        return -0.0878475904
                    if state == 8:
                        return 0.0979402363
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.870249987)  else 10)
                    if state == 9:
                        return -0.107360721
                    if state == 10:
                        return 0.00922169909
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.367482007)  else 6)
                if state == 5:
                    return -0.146315023
                if state == 6:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.919499993)  else 12)
                    if state == 11:
                        return 0.0906031802
                    if state == 12:
                        return -0.0823387727
    elif num_booster == 61:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0195717495)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.5938492)  else 4)
                if state == 3:
                    return 0.0311457347
                if state == 4:
                    return -0.144724995
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<20.4860001)  else 6)
                if state == 5:
                    state = (7 if x['magnr_med']<19.8024998 else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.617500007)  else 12)
                        if state == 11:
                            return -0.0719697103
                        if state == 12:
                            state = (17 if x['neargaia_med']<6.99839211 else 18)
                            if state == 17:
                                state = (25 if x['neargaia_med']<0.413720965 else 26)
                                if state == 25:
                                    return 0.0926594213
                                if state == 26:
                                    return -0.0524383821
                            if state == 18:
                                return 0.0949563459
                    if state == 8:
                        return -0.0208603218
                if state == 6:
                    return -0.0446178429
    elif num_booster == 62:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.511190414)  else 2)
            if state == 1:
                return -0.0270207673
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.0007)  else 6)
                if state == 5:
                    return -0.0802389532
                if state == 6:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.7842503)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.99838543)  else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<0.0317130014)  else 20)
                            if state == 19:
                                state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92177081)  else 28)
                                if state == 27:
                                    return -0.0886406973
                                if state == 28:
                                    return 0.0721398294
                            if state == 20:
                                return 0.0998461843
                        if state == 14:
                            return -0.0249999631
                    if state == 10:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<0.112783551)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<0.0196701512)  else 22)
                            if state == 21:
                                return -0.100950189
                            if state == 22:
                                state = (29 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.89795732)  else 30)
                                if state == 29:
                                    return 0.0142580969
                                if state == 30:
                                    state = (35 if x['col_det']<0.212035179 else 36)
                                    if state == 35:
                                        return 0.053412687
                                    if state == 36:
                                        return -0.113542743
                        if state == 16:
                            return 0.0417340472
    elif num_booster == 63:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<22.0602493 else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<18.4461823)  else 4)
                if state == 3:
                    return 0.0672043115
                if state == 4:
                    state = (9 if x['magnr_med']<18.0037498 else 10)
                    if state == 9:
                        return -0.0688755661
                    if state == 10:
                        state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<20.0569115)  else 18)
                        if state == 17:
                            state = (25 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.965313)  else 26)
                            if state == 25:
                                return 0.0785110965
                            if state == 26:
                                state = (35 if np.isnan(x['mag_last']) or (x['mag_last']<19.9660339)  else 36)
                                if state == 35:
                                    return -0.100175999
                                if state == 36:
                                    return 0.0736256018
                        if state == 18:
                            state = (27 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.801321)  else 28)
                            if state == 27:
                                state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<20.2104797)  else 38)
                                if state == 37:
                                    return -0.0666340515
                                if state == 38:
                                    state = (47 if x['sgscore1_med']<0.0192291513 else 48)
                                    if state == 47:
                                        return -0.100892499
                                    if state == 48:
                                        return 0.102973886
                            if state == 28:
                                return -0.0770201981
            if state == 2:
                return -0.0719390363
    elif num_booster == 64:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.4327507)  else 2)
            if state == 1:
                return -0.0252696164
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95854759)  else 6)
                if state == 5:
                    return 0.00868856069
                if state == 6:
                    state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<0.0104339998)  else 14)
                    if state == 13:
                        return -0.0102124028
                    if state == 14:
                        state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.864500046)  else 24)
                        if state == 23:
                            state = (33 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.800000012)  else 34)
                            if state == 33:
                                return 0.0891654417
                            if state == 34:
                                return -0.0971884131
                        if state == 24:
                            return 0.118607692
    elif num_booster == 65:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<17.5467491 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.721190631)  else 4)
                if state == 3:
                    return -0.149837345
                if state == 4:
                    return 0.0483120382
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.536547542)  else 6)
                if state == 5:
                    return 0.0471913368
                if state == 6:
                    state = (11 if x['distnr_med']<3.36395979 else 12)
                    if state == 11:
                        state = (15 if x['magnr_med']<21.161499 else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['mag_last']) or (x['mag_last']<19.8040657)  else 24)
                            if state == 23:
                                return 0.097403951
                            if state == 24:
                                state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<19.9220905)  else 28)
                                if state == 27:
                                    return -0.0899719819
                                if state == 28:
                                    state = (31 if np.isnan(x['mag_last']) or (x['mag_last']<20.4670792)  else 32)
                                    if state == 31:
                                        state = (33 if x['sgscore1_med']<0.0203333013 else 34)
                                        if state == 33:
                                            return -0.0666222796
                                        if state == 34:
                                            return 0.103534706
                                    if state == 32:
                                        return -0.0852313414
                        if state == 16:
                            return -0.0801583678
                    if state == 12:
                        return -0.0800962225
    elif num_booster == 66:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.617750049)  else 2)
            if state == 1:
                return -0.100329936
            if state == 2:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.0726747513)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.19241428)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.9917507)  else 10)
                        if state == 9:
                            return -0.0647079051
                        if state == 10:
                            state = (17 if x['magnr_med']<18.5939999 else 18)
                            if state == 17:
                                return 0.0944153294
                            if state == 18:
                                state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0382118523)  else 28)
                                if state == 27:
                                    return 0.0136178182
                                if state == 28:
                                    state = (33 if x['magnr_med']<19.8487511 else 34)
                                    if state == 33:
                                        return -0.0879304335
                                    if state == 34:
                                        state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.964249969)  else 40)
                                        if state == 39:
                                            return 0.0794270635
                                        if state == 40:
                                            return -0.113810755
                    if state == 6:
                        return 0.0360550396
                if state == 4:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.0856859684)  else 8)
                    if state == 7:
                        return -0.0567062125
                    if state == 8:
                        return 0.116326414
    elif num_booster == 67:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.00774999987 else 2)
            if state == 1:
                return -0.0878765807
            if state == 2:
                state = (5 if x['col_det']<-0.350215912 else 6)
                if state == 5:
                    return -0.111599058
                if state == 6:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.394001)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.954750001)  else 14)
                        if state == 13:
                            state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<27.2281685)  else 18)
                            if state == 17:
                                state = (23 if x['neargaia_med']<3.23744392 else 24)
                                if state == 23:
                                    return 0.0262294281
                                if state == 24:
                                    return -0.104758985
                            if state == 18:
                                return 0.0629292578
                        if state == 14:
                            return 0.0298997387
                    if state == 10:
                        return 0.0632319227
    elif num_booster == 68:
        state = 0
        if state == 0:
            state = (1 if x['distnr_med']<4.15871811 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.733452559)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.956249952)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.0289745)  else 14)
                        if state == 13:
                            return -0.132757828
                        if state == 14:
                            state = (21 if x['maggaia_med']<19.4357758 else 22)
                            if state == 21:
                                return 0.0909414291
                            if state == 22:
                                return -0.0718801171
                    if state == 8:
                        return 0.132805094
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.782500029)  else 10)
                    if state == 9:
                        return 0.0769789144
                    if state == 10:
                        return -0.0881410986
            if state == 2:
                return -0.0494015776
    elif num_booster == 69:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<17.4135361 else 2)
            if state == 1:
                return 0.026190633
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.1371384)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<12.2973423)  else 10)
                    if state == 9:
                        state = (15 if x['col_det']<0.415416718 else 16)
                        if state == 15:
                            return 0.026110813
                        if state == 16:
                            state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00406837)  else 22)
                            if state == 21:
                                state = (29 if np.isnan(x['rb_med']) or (x['rb_med']<0.722499847)  else 30)
                                if state == 29:
                                    return -0.00292111957
                                if state == 30:
                                    return -0.172208548
                            if state == 22:
                                return 0.047390487
                    if state == 10:
                        return -0.076689221
                if state == 6:
                    return 0.0131140901
    elif num_booster == 70:
        return  -0.00577309541
    elif num_booster == 71:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<0.0291724503)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<0.00137155014)  else 4)
                if state == 3:
                    return -0.0671450347
                if state == 4:
                    return 0.0855460986
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.113969952)  else 6)
                if state == 5:
                    state = (9 if x['magnr_med']<22.7992496 else 10)
                    if state == 9:
                        state = (13 if x['maggaia_med']<19.4115982 else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0336042009)  else 20)
                            if state == 19:
                                return 0.0634400174
                            if state == 20:
                                return -0.0922276303
                        if state == 14:
                            return -0.110195279
                    if state == 10:
                        return 0.0593296327
                if state == 6:
                    state = (11 if x['magnr_med']<17.3435001 else 12)
                    if state == 11:
                        return 0.0296825171
                    if state == 12:
                        state = (17 if x['maggaia_med']<19.0922775 else 18)
                        if state == 17:
                            return 0.0242977142
                        if state == 18:
                            return -0.0874383226
    elif num_booster == 72:
        return  0.0189674441
    elif num_booster == 73:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<16.3983517 else 2)
            if state == 1:
                return -0.0637473762
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.957051039)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.536547542)  else 10)
                    if state == 9:
                        return 0.0498849526
                    if state == 10:
                        state = (13 if x['maggaia_med']<18.008667 else 14)
                        if state == 13:
                            return 0.0515075922
                        if state == 14:
                            state = (17 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.53033781)  else 18)
                            if state == 17:
                                return -0.0457098447
                            if state == 18:
                                return 0.0781349093
                if state == 6:
                    return -0.0651269332
    elif num_booster == 74:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.706501)  else 2)
            if state == 1:
                return -0.0906154588
            if state == 2:
                state = (3 if x['maggaia_med']<19.1041794 else 4)
                if state == 3:
                    state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.642383993)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.6837006)  else 10)
                        if state == 9:
                            return 0.0349690206
                        if state == 10:
                            state = (17 if x['magnr_med']<18.5605011 else 18)
                            if state == 17:
                                return -0.1106923
                            if state == 18:
                                return 0.0192105174
                    if state == 6:
                        return -0.0789164975
                if state == 4:
                    return 0.0573318265
    elif num_booster == 75:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<12.038763)  else 2)
            if state == 1:
                state = (3 if x['magnr_med']<22.2439995 else 4)
                if state == 3:
                    state = (7 if x['magnr_med']<20.3287506 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93674183)  else 14)
                        if state == 13:
                            return 0.0717160329
                        if state == 14:
                            return -0.0409476124
                    if state == 8:
                        return -0.0657376349
                if state == 4:
                    return 0.0628934503
            if state == 2:
                return -0.0487761013
    elif num_booster == 76:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.522184193 else 2)
            if state == 1:
                return -0.0512675308
            if state == 2:
                state = (5 if x['distnr_med']<2.5624249 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<41.6490822)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.768749952)  else 16)
                        if state == 15:
                            return -0.0347160101
                        if state == 16:
                            state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.512499928)  else 24)
                            if state == 23:
                                return -0.0389181674
                            if state == 24:
                                return 0.104654595
                    if state == 10:
                        return -0.0757762864
                if state == 6:
                    state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<16.5640144)  else 12)
                    if state == 11:
                        return 0.0596412979
                    if state == 12:
                        return -0.0936794952
    elif num_booster == 77:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.593000054)  else 2)
            if state == 1:
                return -0.0982018039
            if state == 2:
                state = (3 if x['maggaia_med']<17.3738327 else 4)
                if state == 3:
                    return -0.056821391
                if state == 4:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.984343529)  else 8)
                    if state == 7:
                        return 0.0564725436
                    if state == 8:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.5127754)  else 12)
                        if state == 11:
                            return 0.0466810651
                        if state == 12:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<2.49271989)  else 18)
                            if state == 17:
                                return 0.00690863933
                            if state == 18:
                                return -0.157933086
    elif num_booster == 78:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0562744)  else 2)
            if state == 1:
                return 0.0336731784
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<20.4238319)  else 6)
                if state == 5:
                    return -0.0844558179
                if state == 6:
                    return 0.046704568
    elif num_booster == 79:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.9917507)  else 2)
            if state == 1:
                return -0.0404569134
            if state == 2:
                state = (5 if x['neargaia_med']<34.8755455 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.98574996)  else 12)
                    if state == 11:
                        state = (17 if x['maggaia_med']<20.2380981 else 18)
                        if state == 17:
                            return 0.0851085559
                        if state == 18:
                            return -0.0637193024
                    if state == 12:
                        return -0.0489872955
                if state == 6:
                    state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.771999955)  else 14)
                    if state == 13:
                        return -0.0760236382
                    if state == 14:
                        state = (21 if x['maggaia_med']<17.7177315 else 22)
                        if state == 21:
                            return 0.0376456082
                        if state == 22:
                            state = (25 if x['distpsnr1_med']<17.5803566 else 26)
                            if state == 25:
                                return -0.101309069
                            if state == 26:
                                return 0.0613505766
    elif num_booster == 80:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.925000012)  else 2)
            if state == 1:
                return 0.0356339701
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.380378008)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.735833287)  else 12)
                    if state == 11:
                        return 0.0791726857
                    if state == 12:
                        return -0.0669468418
                if state == 6:
                    return -0.0715935007
    elif num_booster == 81:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.6329994)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.69083333)  else 4)
                if state == 3:
                    return -0.0956548378
                if state == 4:
                    state = (7 if x['sgscore1_med']<0.130116001 else 8)
                    if state == 7:
                        return -0.0948466286
                    if state == 8:
                        return 0.113215283
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.533333421)  else 6)
                if state == 5:
                    return 0.0578587428
                if state == 6:
                    return -0.0374870561
    elif num_booster == 82:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.0826815516 else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.15092507 else 4)
                if state == 3:
                    return 0.0636750236
                if state == 4:
                    return -0.0810220838
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.216608286 else 6)
                if state == 5:
                    return -0.0983166993
                if state == 6:
                    return 0.0371749476
    elif num_booster == 83:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<19.4314137)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.235736847)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.3622265)  else 8)
                    if state == 7:
                        return -0.0766444057
                    if state == 8:
                        state = (13 if x['neargaia_med']<2.66573143 else 14)
                        if state == 13:
                            return 0.0745385364
                        if state == 14:
                            return -0.0794518366
                if state == 4:
                    return 0.0352594145
            if state == 2:
                return 0.0147256441
    elif num_booster == 84:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.56157124)  else 2)
            if state == 1:
                return -0.0200344212
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99895811)  else 6)
                if state == 5:
                    return 0.0555846319
                if state == 6:
                    return -0.0393636338
    elif num_booster == 85:
        return  -0.0091948323
    elif num_booster == 86:
        return  0.000853671751
    elif num_booster == 87:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<10.4068975 else 2)
            if state == 1:
                return 0.0426127389
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.644285917)  else 6)
                if state == 5:
                    return -0.0525996089
                if state == 6:
                    return 0.0404563993
    elif num_booster == 88:
        return  0.00472516753
    elif num_booster == 89:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<22.0602493 else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.3797264)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.413571268)  else 8)
                    if state == 7:
                        return -0.0885086954
                    if state == 8:
                        return 0.041633483
                if state == 4:
                    return -0.0580154993
            if state == 2:
                return -0.0522805974
    elif num_booster == 90:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.1674366)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<26.2886658)  else 4)
                if state == 3:
                    state = (7 if x['col_det']<0.0726747513 else 8)
                    if state == 7:
                        return -0.0654467195
                    if state == 8:
                        state = (17 if x['sgscore1_med']<0.0475624986 else 18)
                        if state == 17:
                            return 0.0603041276
                        if state == 18:
                            state = (27 if x['magnr_med']<21.2635002 else 28)
                            if state == 27:
                                return -0.0542250909
                            if state == 28:
                                return 0.0673738942
                if state == 4:
                    state = (9 if x['col_det']<-0.0407867432 else 10)
                    if state == 9:
                        return -0.0416517407
                    if state == 10:
                        state = (19 if x['sgscore1_med']<0.0036249999 else 20)
                        if state == 19:
                            return -0.0738520175
                        if state == 20:
                            return 0.103103325
            if state == 2:
                return -0.0807990804
    elif num_booster == 91:
        state = 0
        if state == 0:
            state = (1 if x['magnr_med']<22.0602493 else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<6.98908234 else 4)
                if state == 3:
                    return -0.0518089384
                if state == 4:
                    state = (9 if x['magnr_med']<18.6227493 else 10)
                    if state == 9:
                        return -0.025594173
                    if state == 10:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.767499983)  else 16)
                        if state == 15:
                            return 0.0836137682
                        if state == 16:
                            return -0.0380724967
            if state == 2:
                return -0.0577936471
    elif num_booster == 92:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.83549333)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.1771851)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00217605)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0129375001)  else 14)
                        if state == 13:
                            return -0.0181386098
                        if state == 14:
                            state = (23 if x['magnr_med']<17.0532494 else 24)
                            if state == 23:
                                return 0.000293811958
                            if state == 24:
                                state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<18.8791695)  else 28)
                                if state == 27:
                                    return 0.0430392027
                                if state == 28:
                                    return -0.147282347
                    if state == 8:
                        return 0.0122030256
                if state == 4:
                    return 0.0507497489
            if state == 2:
                state = (5 if x['maggaia_med']<20.2328415 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96107054)  else 10)
                    if state == 9:
                        state = (17 if x['sgscore1_med']<0.373211503 else 18)
                        if state == 17:
                            return 0.0886910036
                        if state == 18:
                            return -0.0803347081
                    if state == 10:
                        return 0.0761027709
                if state == 6:
                    return -0.0321929976
    elif num_booster == 93:
        return  0.00788587704
    elif num_booster == 94:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.97724998)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.7920418)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<19.8374996)  else 8)
                    if state == 7:
                        return -0.0913957357
                    if state == 8:
                        return 0.105837747
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.8314514)  else 10)
                    if state == 9:
                        return 0.0541905798
                    if state == 10:
                        return -0.0998337269
            if state == 2:
                return 0.0205878336
    elif num_booster == 95:
        return  0.0021443197
    elif num_booster == 96:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.00964117)  else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.336827517 else 4)
                if state == 3:
                    return 0.055505313
                if state == 4:
                    state = (9 if x['maggaia_med']<19.9504242 else 10)
                    if state == 9:
                        return -0.0658948421
                    if state == 10:
                        return 0.0416982025
            if state == 2:
                return -0.0782744363
    elif num_booster == 97:
        return  0.0201248415
    elif num_booster == 98:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.1238823)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.87671876)  else 4)
                if state == 3:
                    return 0.043691881
                if state == 4:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96515036)  else 10)
                    if state == 9:
                        return -0.0685957298
                    if state == 10:
                        state = (17 if np.isnan(x['col_det']) or (x['col_det']<0.343710899)  else 18)
                        if state == 17:
                            state = (25 if np.isnan(x['mag_last']) or (x['mag_last']<19.5758858)  else 26)
                            if state == 25:
                                return -0.0367292054
                            if state == 26:
                                return 0.103944883
                        if state == 18:
                            return -0.0525639504
            if state == 2:
                return -0.0402471721
    elif num_booster == 99:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5758858)  else 2)
            if state == 1:
                return -0.0249658078
            if state == 2:
                state = (5 if x['neargaia_med']<36.0913239 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<2.01377892)  else 12)
                    if state == 11:
                        return 0.0701781511
                    if state == 12:
                        return -0.0641591921
                if state == 6:
                    return -0.0131347477


def xgb_tree_3(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.944000006)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<30.4451332)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.877499998)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.16323137)  else 16)
                        if state == 15:
                            return -0.313600004
                        if state == 16:
                            state = (27 if x['sgscore1_med']<0.332547486 else 28)
                            if state == 27:
                                state = (41 if x['sgscore1_med']<0.0299166515 else 42)
                                if state == 41:
                                    return -0.224000007
                                if state == 42:
                                    return 0.121794075
                            if state == 28:
                                return -0.280000001
                    if state == 8:
                        state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.909000039)  else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.1970005)  else 30)
                            if state == 29:
                                return -0.112000003
                            if state == 30:
                                return 0.161434487
                        if state == 18:
                            state = (31 if np.isnan(x['t_lc']) or (x['t_lc']<2.97333336)  else 32)
                            if state == 31:
                                return 0.0322559997
                            if state == 32:
                                return -0.232615381
                if state == 4:
                    state = (9 if x['neargaia_med']<56.6469116 else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.5810509)  else 20)
                        if state == 19:
                            state = (33 if x['sgscore1_med']<0.00177083502 else 34)
                            if state == 33:
                                return -0.0159629192
                            if state == 34:
                                return 0.249066979
                        if state == 20:
                            return -0.143999994
                    if state == 10:
                        return -0.2016
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.276001)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<24.9923973 else 12)
                    if state == 11:
                        state = (21 if x['distpsnr1_med']<7.83899212 else 22)
                        if state == 21:
                            return -0.287999988
                        if state == 22:
                            return 0.0322559997
                    if state == 12:
                        state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<17.3089504)  else 24)
                        if state == 23:
                            return -0.112000003
                        if state == 24:
                            return 0.208590612
                if state == 6:
                    state = (13 if x['distpsnr1_med']<0.153212503 else 14)
                    if state == 13:
                        return -0.2016
                    if state == 14:
                        state = (25 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.712202013)  else 26)
                        if state == 25:
                            state = (37 if np.isnan(x['t_lc']) or (x['t_lc']<0.0340162516)  else 38)
                            if state == 37:
                                return -0.0671999976
                            if state == 38:
                                state = (49 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.187175542)  else 50)
                                if state == 49:
                                    return -0.0671999976
                                if state == 50:
                                    return 0.307409644
                        if state == 26:
                            state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.973999977)  else 40)
                            if state == 39:
                                return -0.167999998
                            if state == 40:
                                return 0.0923550799
    elif num_booster == 1:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7672234)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6357498)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<3.64184141)  else 8)
                    if state == 7:
                        return -0.238010198
                    if state == 8:
                        state = (17 if x['sgscore1_med']<0.618071496 else 18)
                        if state == 17:
                            return 0.220449671
                        if state == 18:
                            return -0.160770699
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.868167281 else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.050270848)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['mag_det']) or (x['mag_det']<18.9397507)  else 32)
                            if state == 31:
                                return -0.0605713464
                            if state == 32:
                                return 0.233003139
                        if state == 20:
                            state = (33 if np.isnan(x['rb_med']) or (x['rb_med']<0.711666644)  else 34)
                            if state == 33:
                                return -0.220658198
                            if state == 34:
                                state = (41 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96045709)  else 42)
                                if state == 41:
                                    return 0.158980012
                                if state == 42:
                                    return -0.130089179
                    if state == 10:
                        state = (21 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.6646309)  else 22)
                        if state == 21:
                            state = (35 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.959818482)  else 36)
                            if state == 35:
                                state = (43 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.460500002)  else 44)
                                if state == 43:
                                    return -0.0570244193
                                if state == 44:
                                    return 0.276426226
                            if state == 36:
                                return -0.0999571607
                        if state == 22:
                            return -0.110059023
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.9962673)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.04569888)  else 12)
                    if state == 11:
                        state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<19.8070488)  else 24)
                        if state == 23:
                            return 0.0212526023
                        if state == 24:
                            return -0.250615776
                    if state == 12:
                        state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97837973)  else 26)
                        if state == 25:
                            state = (39 if x['maggaia_med']<16.3179131 else 40)
                            if state == 39:
                                return -0.0624344535
                            if state == 40:
                                return 0.230058312
                        if state == 26:
                            return -0.123899341
                if state == 6:
                    state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.890714288)  else 14)
                    if state == 13:
                        return -0.281296462
                    if state == 14:
                        return 0.0300846696
    elif num_booster == 2:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.92050004)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<28.3113251)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<21.2101994)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.881428659)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['t_lc']) or (x['t_lc']<6.03033543)  else 28)
                            if state == 27:
                                state = (41 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.55974817)  else 42)
                                if state == 41:
                                    return -0.259711623
                                if state == 42:
                                    state = (51 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.6054993)  else 52)
                                    if state == 51:
                                        state = (57 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93366337)  else 58)
                                        if state == 57:
                                            return 0.128685147
                                        if state == 58:
                                            state = (67 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.4659996)  else 68)
                                            if state == 67:
                                                return -0.19315733
                                            if state == 68:
                                                return 0.0776001662
                                    if state == 52:
                                        return -0.223537818
                            if state == 28:
                                return -0.0214146301
                        if state == 16:
                            return 0.0459842794
                    if state == 8:
                        return 0.123927981
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.0573997)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.4589996)  else 18)
                        if state == 17:
                            return -0.123381414
                        if state == 18:
                            return 0.196734712
                    if state == 10:
                        state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.642499983)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.49644423)  else 32)
                            if state == 31:
                                return 0.174962282
                            if state == 32:
                                return -0.162193432
                        if state == 20:
                            return -0.229435161
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.1480007)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<23.9629917 else 12)
                    if state == 11:
                        return -0.229532391
                    if state == 12:
                        state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.735776305)  else 22)
                        if state == 21:
                            return -0.127762422
                        if state == 22:
                            return 0.134939209
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.5965004)  else 14)
                    if state == 13:
                        state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.422380805)  else 24)
                        if state == 23:
                            return -0.14776665
                        if state == 24:
                            state = (35 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.016180601)  else 36)
                            if state == 35:
                                return -0.0680796653
                            if state == 36:
                                state = (45 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<61.521347)  else 46)
                                if state == 45:
                                    return 0.247885495
                                if state == 46:
                                    return -0.0536839701
                    if state == 14:
                        state = (25 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.489698797)  else 26)
                        if state == 25:
                            state = (37 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<34.5825272)  else 38)
                            if state == 37:
                                return -0.216012657
                            if state == 38:
                                return 0.0715537667
                        if state == 26:
                            state = (39 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.973500013)  else 40)
                            if state == 39:
                                state = (47 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5180016)  else 48)
                                if state == 47:
                                    return 0.141123414
                                if state == 48:
                                    return -0.206484616
                            if state == 40:
                                state = (49 if x['neargaia_med']<8.69891071 else 50)
                                if state == 49:
                                    return -0.106205955
                                if state == 50:
                                    state = (55 if np.isnan(x['col_det']) or (x['col_det']<-0.0401201248)  else 56)
                                    if state == 55:
                                        return 0.229434714
                                    if state == 56:
                                        return -0.0638426393
    elif num_booster == 3:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0442085)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5514984)  else 4)
                if state == 3:
                    return -0.203019872
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.656560123 else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.3530006)  else 16)
                        if state == 15:
                            state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.656666517)  else 20)
                            if state == 19:
                                return -0.0814990401
                            if state == 20:
                                return 0.192291141
                        if state == 16:
                            state = (21 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00406249985)  else 22)
                            if state == 21:
                                return 0.143344223
                            if state == 22:
                                state = (29 if np.isnan(x['t_lc']) or (x['t_lc']<6.00034714)  else 30)
                                if state == 29:
                                    return -0.22902666
                                if state == 30:
                                    return 0.049245514
                    if state == 10:
                        state = (17 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.963776946)  else 18)
                        if state == 17:
                            state = (23 if x['col_det']<-0.508301258 else 24)
                            if state == 23:
                                return -0.108681098
                            if state == 24:
                                state = (31 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9982233)  else 32)
                                if state == 31:
                                    return 0.242264032
                                if state == 32:
                                    state = (41 if np.isnan(x['mag_last']) or (x['mag_last']<19.6107216)  else 42)
                                    if state == 41:
                                        state = (45 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.4819984)  else 46)
                                        if state == 45:
                                            state = (47 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.5370007)  else 48)
                                            if state == 47:
                                                return -0.0304900594
                                            if state == 48:
                                                return 0.199098051
                                        if state == 46:
                                            return -0.0192823391
                                    if state == 42:
                                        return -0.17397961
                        if state == 18:
                            return -0.0718256161
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<21.2101994)  else 6)
                if state == 5:
                    return -0.247759789
                if state == 6:
                    return 0.0651815161
    elif num_booster == 4:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.924000025)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.53697681)  else 4)
                if state == 3:
                    state = (7 if x['sgscore1_med']<0.00883333478 else 8)
                    if state == 7:
                        state = (15 if x['sgscore1_med']<0.00797916483 else 16)
                        if state == 15:
                            state = (29 if x['neargaia_med']<59.713562 else 30)
                            if state == 29:
                                return -0.184344605
                            if state == 30:
                                return 0.104241572
                        if state == 16:
                            return 0.17687057
                    if state == 8:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<6.02598381)  else 18)
                        if state == 17:
                            state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.881428659)  else 32)
                            if state == 31:
                                state = (41 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.9630013)  else 42)
                                if state == 41:
                                    return -0.229294419
                                if state == 42:
                                    state = (47 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.0880013)  else 48)
                                    if state == 47:
                                        return 0.132965028
                                    if state == 48:
                                        return -0.147183061
                            if state == 32:
                                return -0.00601336779
                        if state == 18:
                            return 0.0439582951
                if state == 4:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.72052193)  else 10)
                    if state == 9:
                        return 0.180538118
                    if state == 10:
                        state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<23.2770004)  else 20)
                        if state == 19:
                            return -0.18037346
                        if state == 20:
                            return 0.103351273
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.587669492)  else 6)
                if state == 5:
                    state = (11 if x['distpsnr1_med']<0.375561744 else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.4475002)  else 22)
                        if state == 21:
                            state = (35 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0947411507)  else 36)
                            if state == 35:
                                return 0.161501661
                            if state == 36:
                                return -0.114846446
                        if state == 22:
                            return -0.208841711
                    if state == 12:
                        state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.993499994)  else 24)
                        if state == 23:
                            state = (37 if np.isnan(x['magnr_med']) or (x['magnr_med']<14.9554996)  else 38)
                            if state == 37:
                                return -0.103396066
                            if state == 38:
                                state = (45 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.4274998)  else 46)
                                if state == 45:
                                    state = (49 if np.isnan(x['rb_med']) or (x['rb_med']<0.388095081)  else 50)
                                    if state == 49:
                                        return -0.0911015719
                                    if state == 50:
                                        state = (53 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.942999959)  else 54)
                                        if state == 53:
                                            state = (57 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.2609997)  else 58)
                                            if state == 57:
                                                return -0.111766733
                                            if state == 58:
                                                return 0.142761946
                                        if state == 54:
                                            return 0.227580339
                                if state == 46:
                                    state = (51 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<9.12114239)  else 52)
                                    if state == 51:
                                        return 0.150932491
                                    if state == 52:
                                        return -0.0677119195
                        if state == 24:
                            return -0.165766045
                if state == 6:
                    state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.844523668)  else 14)
                    if state == 13:
                        return -0.201483935
                    if state == 14:
                        return 0.0609389022
    elif num_booster == 5:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.970000029)  else 2)
            if state == 1:
                state = (3 if x['col_det']<0.365387917 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.4900208)  else 8)
                    if state == 7:
                        return -0.15909934
                    if state == 8:
                        state = (17 if x['sgscore1_med']<0.0322291479 else 18)
                        if state == 17:
                            state = (33 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.93599999)  else 34)
                            if state == 33:
                                state = (47 if np.isnan(x['mag_det']) or (x['mag_det']<19.9828987)  else 48)
                                if state == 47:
                                    return 0.0571391098
                                if state == 48:
                                    return -0.183440983
                            if state == 34:
                                return 0.128888756
                        if state == 18:
                            state = (35 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.93599999)  else 36)
                            if state == 35:
                                return 0.180348441
                            if state == 36:
                                return -0.0485087447
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<21.0964508)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['distnr_med']) or (x['distnr_med']<5.03026772)  else 20)
                        if state == 19:
                            state = (37 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.05842018)  else 38)
                            if state == 37:
                                state = (53 if np.isnan(x['rb_med']) or (x['rb_med']<0.947142839)  else 54)
                                if state == 53:
                                    state = (61 if x['sgscore1_med']<0.000916666526 else 62)
                                    if state == 61:
                                        return 0.0139286481
                                    if state == 62:
                                        state = (69 if x['maggaia_med']<41.3903427 else 70)
                                        if state == 69:
                                            return -0.222020879
                                        if state == 70:
                                            state = (73 if x['sgscore1_med']<0.0347023644 else 74)
                                            if state == 73:
                                                return 0.0921638831
                                            if state == 74:
                                                return -0.165198237
                                if state == 54:
                                    return 0.0474725626
                            if state == 38:
                                return 0.0508653112
                        if state == 20:
                            state = (39 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.12963486)  else 40)
                            if state == 39:
                                return 0.113476217
                            if state == 40:
                                return -0.103115283
                    if state == 10:
                        return 0.115401328
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.2519989)  else 6)
                if state == 5:
                    return -0.160982266
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.536499)  else 14)
                    if state == 13:
                        state = (27 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.587669492)  else 28)
                        if state == 27:
                            return 0.213622794
                        if state == 28:
                            return -0.0492184237
                    if state == 14:
                        state = (29 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0319375023)  else 30)
                        if state == 29:
                            return 0.168364227
                        if state == 30:
                            return -0.147456422
    elif num_booster == 6:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.9403725)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.2779999)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0597648509)  else 8)
                    if state == 7:
                        return 0.0416698232
                    if state == 8:
                        return -0.190915897
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.195022345 else 10)
                    if state == 9:
                        return -0.186591908
                    if state == 10:
                        state = (19 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.630880475)  else 20)
                        if state == 19:
                            state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.412380785)  else 28)
                            if state == 27:
                                state = (33 if np.isnan(x['mag_last']) or (x['mag_last']<19.3877163)  else 34)
                                if state == 33:
                                    return 0.0961903185
                                if state == 34:
                                    return -0.136476502
                            if state == 28:
                                state = (35 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.1280003)  else 36)
                                if state == 35:
                                    return 0.189623117
                                if state == 36:
                                    state = (43 if x['distpsnr1_med']<3.73938107 else 44)
                                    if state == 43:
                                        return -0.124635227
                                    if state == 44:
                                        return 0.12818408
                        if state == 20:
                            state = (29 if x['distpsnr1_med']<9.51527691 else 30)
                            if state == 29:
                                return -0.17983447
                            if state == 30:
                                return 0.0570784025
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.6205959)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0114757)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.00776620023)  else 22)
                        if state == 21:
                            return -0.139880717
                        if state == 22:
                            return 0.15305911
                    if state == 12:
                        return -0.208640933
                if state == 6:
                    return 0.0736802369
    elif num_booster == 7:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.855648)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.2384987)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.91971004)  else 8)
                    if state == 7:
                        return -0.175413489
                    if state == 8:
                        return 0.122048847
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.192713603 else 10)
                    if state == 9:
                        return -0.150510922
                    if state == 10:
                        state = (17 if x['neargaia_med']<2.05946541 else 18)
                        if state == 17:
                            return -0.0275282729
                        if state == 18:
                            state = (29 if np.isnan(x['col_det']) or (x['col_det']<0.591900826)  else 30)
                            if state == 29:
                                state = (37 if np.isnan(x['mag_det']) or (x['mag_det']<18.5033493)  else 38)
                                if state == 37:
                                    state = (43 if np.isnan(x['mag_last']) or (x['mag_last']<18.0557098)  else 44)
                                    if state == 43:
                                        return 0.109296754
                                    if state == 44:
                                        return -0.111138545
                                if state == 38:
                                    state = (45 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.4295006)  else 46)
                                    if state == 45:
                                        return -0.0329517275
                                    if state == 46:
                                        state = (51 if np.isnan(x['mag_last']) or (x['mag_last']<19.7793388)  else 52)
                                        if state == 51:
                                            return 0.204197913
                                        if state == 52:
                                            state = (55 if np.isnan(x['t_lc']) or (x['t_lc']<3.04636574)  else 56)
                                            if state == 55:
                                                return 0.149739742
                                            if state == 56:
                                                return -0.0920136198
                            if state == 30:
                                return -0.0977149606
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<21.1078491)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.3110008)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<3.95983219)  else 20)
                        if state == 19:
                            return 0.154838324
                        if state == 20:
                            return -0.120696545
                    if state == 12:
                        state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<20.5236492)  else 22)
                        if state == 21:
                            return -0.213503212
                        if state == 22:
                            state = (31 if np.isnan(x['mag_det']) or (x['mag_det']<20.5356503)  else 32)
                            if state == 31:
                                return 0.105072699
                            if state == 32:
                                state = (39 if x['col_det']<-0.0885648727 else 40)
                                if state == 39:
                                    return 0.045934163
                                if state == 40:
                                    return -0.180924088
                if state == 6:
                    return 0.13609013
    elif num_booster == 8:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.586961031)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.680792332)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<36.2071877)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.97862267)  else 14)
                        if state == 13:
                            state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<2.9708333)  else 24)
                            if state == 23:
                                return -0.110281803
                            if state == 24:
                                return 0.136422858
                        if state == 14:
                            state = (25 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.0169983)  else 26)
                            if state == 25:
                                return 0.0126054836
                            if state == 26:
                                return -0.185057551
                    if state == 8:
                        return 0.100493066
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.422857285)  else 10)
                    if state == 9:
                        return -0.169711724
                    if state == 10:
                        state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<0.0295834001)  else 20)
                        if state == 19:
                            return -0.137254655
                        if state == 20:
                            state = (31 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.6219997)  else 32)
                            if state == 31:
                                return -0.104297608
                            if state == 32:
                                state = (39 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00116071501)  else 40)
                                if state == 39:
                                    return -0.0228098109
                                if state == 40:
                                    state = (47 if x['maggaia_med']<14.0630693 else 48)
                                    if state == 47:
                                        return -0.0802784339
                                    if state == 48:
                                        state = (53 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.0125141)  else 54)
                                        if state == 53:
                                            return 0.160511583
                                        if state == 54:
                                            return 0.0588513389
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.724523664)  else 6)
                if state == 5:
                    return -0.196674421
                if state == 6:
                    return 0.00678870315
    elif num_booster == 9:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967499971)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.9596498)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.9407864)  else 8)
                    if state == 7:
                        state = (15 if x['sgscore1_med']<0.0159374997 else 16)
                        if state == 15:
                            return 0.127597317
                        if state == 16:
                            state = (29 if np.isnan(x['rb_med']) or (x['rb_med']<0.78000021)  else 30)
                            if state == 29:
                                return -0.174313858
                            if state == 30:
                                state = (39 if x['distpsnr1_med']<0.48820895 else 40)
                                if state == 39:
                                    return -0.106280342
                                if state == 40:
                                    return 0.13740471
                    if state == 8:
                        return -0.194085717
                if state == 4:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<4.46839714)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.421428561)  else 18)
                        if state == 17:
                            return -0.149904013
                        if state == 18:
                            state = (31 if np.isnan(x['t_lc']) or (x['t_lc']<0.0211979002)  else 32)
                            if state == 31:
                                return -0.105205901
                            if state == 32:
                                state = (41 if np.isnan(x['mag_det']) or (x['mag_det']<20.3106003)  else 42)
                                if state == 41:
                                    state = (47 if np.isnan(x['mag_last']) or (x['mag_last']<19.8781643)  else 48)
                                    if state == 47:
                                        return 0.109312847
                                    if state == 48:
                                        return -0.105611131
                                if state == 42:
                                    state = (49 if x['col_det']<-0.0662412643 else 50)
                                    if state == 49:
                                        return -0.0540753566
                                    if state == 50:
                                        return 0.227017432
                    if state == 10:
                        state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<19.1439667)  else 20)
                        if state == 19:
                            return 0.0870903134
                        if state == 20:
                            return -0.192035109
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.276001)  else 6)
                if state == 5:
                    return -0.122098848
                if state == 6:
                    state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.4569931)  else 14)
                    if state == 13:
                        state = (23 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.134956226)  else 24)
                        if state == 23:
                            return -0.0225987863
                        if state == 24:
                            return 0.198161215
                    if state == 14:
                        return -0.0956786051
    elif num_booster == 10:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4899502)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.7066498)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.941428423)  else 8)
                    if state == 7:
                        return -0.172801211
                    if state == 8:
                        return 0.062980406
                if state == 4:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.499102831)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.004425)  else 14)
                        if state == 13:
                            return 0.0766752586
                        if state == 14:
                            return -0.149922624
                    if state == 10:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<16.1481457)  else 16)
                        if state == 15:
                            return -0.0642107576
                        if state == 16:
                            state = (25 if x['distpsnr1_med']<0.288145602 else 26)
                            if state == 25:
                                return -0.0638725907
                            if state == 26:
                                state = (37 if np.isnan(x['mag_last']) or (x['mag_last']<19.3426247)  else 38)
                                if state == 37:
                                    return 0.193766907
                                if state == 38:
                                    state = (51 if np.isnan(x['t_lc']) or (x['t_lc']<3.55114007)  else 52)
                                    if state == 51:
                                        return 0.145674556
                                    if state == 52:
                                        return -0.108122021
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<4.00269127)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.9415054)  else 12)
                    if state == 11:
                        return 0.0232110955
                    if state == 12:
                        state = (19 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.76356673)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['mag_det']) or (x['mag_det']<21.2101994)  else 32)
                            if state == 31:
                                return -0.17778872
                            if state == 32:
                                return 0.0728831142
                        if state == 20:
                            return 0.0171594694
                if state == 6:
                    return -0.207574204
    elif num_booster == 11:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.847499967)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.581295)  else 4)
                if state == 3:
                    return -0.179290056
                if state == 4:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<3.02914929)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<20.1130257)  else 14)
                        if state == 13:
                            state = (23 if x['sgscore1_med']<0.966297984 else 24)
                            if state == 23:
                                return 0.195169017
                            if state == 24:
                                return -0.0597325042
                        if state == 14:
                            return -0.122931406
                    if state == 8:
                        return -0.168806449
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.682606995)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.7879333)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<19.2327499)  else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.5494995)  else 26)
                            if state == 25:
                                state = (35 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.0628128)  else 36)
                                if state == 35:
                                    return -0.193474367
                                if state == 36:
                                    return 0.0431389697
                            if state == 26:
                                state = (37 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0914993)  else 38)
                                if state == 37:
                                    return 0.125274837
                                if state == 38:
                                    return -0.0504356883
                        if state == 16:
                            return 0.141293094
                    if state == 10:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.50373268)  else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<20.3376007)  else 30)
                            if state == 29:
                                state = (41 if np.isnan(x['mag_det']) or (x['mag_det']<19.875452)  else 42)
                                if state == 41:
                                    return 0.0869329646
                                if state == 42:
                                    return -0.131488889
                            if state == 30:
                                return 0.115826853
                        if state == 18:
                            return -0.167583838
                if state == 6:
                    return -0.137908548
    elif num_booster == 12:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.0442791)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.4258499)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.671666682)  else 8)
                    if state == 7:
                        return -0.154249936
                    if state == 8:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.804523647)  else 16)
                        if state == 15:
                            return 0.117271177
                        if state == 16:
                            return -0.0664894953
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.48820895 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.4957008)  else 18)
                        if state == 17:
                            return 0.0830162168
                        if state == 18:
                            return -0.153767124
                    if state == 10:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98327541)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.524500012)  else 32)
                            if state == 31:
                                return -0.0386274941
                            if state == 32:
                                state = (43 if np.isnan(x['t_lc']) or (x['t_lc']<3.94896412)  else 44)
                                if state == 43:
                                    return 0.200046301
                                if state == 44:
                                    state = (53 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.951499999)  else 54)
                                    if state == 53:
                                        return -0.11429812
                                    if state == 54:
                                        return 0.146030009
                        if state == 20:
                            state = (33 if np.isnan(x['mag_last']) or (x['mag_last']<19.5646667)  else 34)
                            if state == 33:
                                state = (45 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.923500001)  else 46)
                                if state == 45:
                                    return -0.114582591
                                if state == 46:
                                    return 0.139281571
                            if state == 34:
                                return -0.142160177
            if state == 2:
                return -0.165452346
    elif num_booster == 13:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.9745)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<20.7438507)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.86811924)  else 8)
                    if state == 7:
                        return -0.151375055
                    if state == 8:
                        state = (17 if x['sgscore1_med']<0.327614754 else 18)
                        if state == 17:
                            return 0.0718957558
                        if state == 18:
                            state = (33 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.46249413)  else 34)
                            if state == 33:
                                return 0.0525182225
                            if state == 34:
                                return -0.173716888
                if state == 4:
                    return 0.0839135498
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.4130001)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.983500004)  else 12)
                    if state == 11:
                        return -0.151782051
                    if state == 12:
                        state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.57882559)  else 22)
                        if state == 21:
                            return -0.097576201
                        if state == 22:
                            return 0.157482728
                if state == 6:
                    state = (13 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.132762462)  else 14)
                    if state == 13:
                        return -0.080320321
                    if state == 14:
                        state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.05829859)  else 26)
                        if state == 25:
                            return 0.19166927
                        if state == 26:
                            return -0.0380654074
    elif num_booster == 14:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6755142)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5340004)  else 4)
                if state == 3:
                    return -0.128780976
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.386666477)  else 10)
                    if state == 9:
                        return -0.185071394
                    if state == 10:
                        state = (17 if x['distpsnr1_med']<0.32053408 else 18)
                        if state == 17:
                            state = (27 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.297610879)  else 28)
                            if state == 27:
                                return 0.0484472327
                            if state == 28:
                                return -0.156946853
                        if state == 18:
                            state = (29 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.969496965)  else 30)
                            if state == 29:
                                state = (41 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.223726004)  else 42)
                                if state == 41:
                                    return -0.0773142651
                                if state == 42:
                                    state = (47 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.2524986)  else 48)
                                    if state == 47:
                                        state = (49 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.965999961)  else 50)
                                        if state == 49:
                                            return -0.125936419
                                        if state == 50:
                                            return 0.109225698
                                    if state == 48:
                                        return 0.165128097
                            if state == 30:
                                return -0.0706321374
            if state == 2:
                state = (5 if x['sgscore1_med']<0.00870833546 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.83949995)  else 12)
                    if state == 11:
                        return -0.108957924
                    if state == 12:
                        return 0.144550234
                if state == 6:
                    state = (13 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.6408997)  else 14)
                    if state == 13:
                        return -0.169288501
                    if state == 14:
                        state = (23 if x['distpsnr1_med']<2.72369432 else 24)
                        if state == 23:
                            return -0.100899324
                        if state == 24:
                            return 0.137130961
    elif num_booster == 15:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<1.98872685)  else 2)
            if state == 1:
                return -0.135317832
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.2975006)  else 6)
                if state == 5:
                    return -0.139978766
                if state == 6:
                    state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4443607)  else 12)
                    if state == 11:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.842999995)  else 14)
                        if state == 13:
                            state = (17 if x['distpsnr1_med']<0.381066263 else 18)
                            if state == 17:
                                return 0.0668758228
                            if state == 18:
                                return -0.124440111
                        if state == 14:
                            state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.435952365)  else 20)
                            if state == 19:
                                return -0.0206533801
                            if state == 20:
                                state = (29 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.995000005)  else 30)
                                if state == 29:
                                    return 0.158077165
                                if state == 30:
                                    state = (43 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99526048)  else 44)
                                    if state == 43:
                                        return 0.0963215455
                                    if state == 44:
                                        return -0.16081512
                    if state == 12:
                        state = (15 if x['distpsnr1_med']<7.01866817 else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.3610001)  else 22)
                            if state == 21:
                                return 0.0261238366
                            if state == 22:
                                return -0.138528153
                        if state == 16:
                            return 0.14067398
    elif num_booster == 16:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<20.105175)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<7.03467417 else 4)
                if state == 3:
                    state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00858333521)  else 6)
                    if state == 5:
                        return 0.0871626958
                    if state == 6:
                        state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.829149306)  else 12)
                        if state == 11:
                            return -0.165293947
                        if state == 12:
                            state = (19 if x['neargaia_med']<0.960421324 else 20)
                            if state == 19:
                                return 0.11047861
                            if state == 20:
                                return -0.0902216956
                if state == 4:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<19.5548573)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967499971)  else 14)
                        if state == 13:
                            return -0.163161337
                        if state == 14:
                            state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<18.5033302)  else 22)
                            if state == 21:
                                state = (31 if np.isnan(x['rb_med']) or (x['rb_med']<0.735000014)  else 32)
                                if state == 31:
                                    return 0.0535421893
                                if state == 32:
                                    return -0.126842812
                            if state == 22:
                                state = (33 if np.isnan(x['mag_det']) or (x['mag_det']<19.5539074)  else 34)
                                if state == 33:
                                    return 0.158239603
                                if state == 34:
                                    return -0.121640213
                    if state == 8:
                        state = (15 if x['maggaia_med']<17.1613007 else 16)
                        if state == 15:
                            return -0.0346760377
                        if state == 16:
                            state = (25 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.6344776)  else 26)
                            if state == 25:
                                state = (35 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.33313441)  else 36)
                                if state == 35:
                                    return 0.199106663
                                if state == 36:
                                    return 0.0194968283
                            if state == 26:
                                return -0.0624348111
            if state == 2:
                return -0.152724802
    elif num_booster == 17:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<8.93502045 else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.586961031 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.904000044)  else 8)
                    if state == 7:
                        return -0.117617413
                    if state == 8:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.815000176)  else 16)
                        if state == 15:
                            return 0.108664118
                        if state == 16:
                            return -0.0897387341
                if state == 4:
                    return -0.14631997
            if state == 2:
                state = (5 if np.isnan(x['col_det']) or (x['col_det']<-0.295884609)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.7870007)  else 12)
                    if state == 11:
                        return -0.159808666
                    if state == 12:
                        state = (17 if x['neargaia_med']<19.4717751 else 18)
                        if state == 17:
                            return -0.0752355158
                        if state == 18:
                            state = (29 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.8730011)  else 30)
                            if state == 29:
                                return 0.121752381
                            if state == 30:
                                state = (41 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976500034)  else 42)
                                if state == 41:
                                    return -0.120297126
                                if state == 42:
                                    return 0.0703043491
                if state == 6:
                    return 0.108386882
    elif num_booster == 18:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.698779464 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.435952365)  else 4)
                if state == 3:
                    return -0.145999476
                if state == 4:
                    state = (9 if x['neargaia_med']<13.667038 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.982499957)  else 18)
                        if state == 17:
                            state = (27 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0402025506)  else 28)
                            if state == 27:
                                return -0.0966001973
                            if state == 28:
                                state = (41 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96335077)  else 42)
                                if state == 41:
                                    return 0.124239191
                                if state == 42:
                                    return -0.0375261977
                        if state == 18:
                            return -0.157428712
                    if state == 10:
                        state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.845000029)  else 20)
                        if state == 19:
                            state = (31 if np.isnan(x['col_det']) or (x['col_det']<-0.225169182)  else 32)
                            if state == 31:
                                return -0.115347862
                            if state == 32:
                                return 0.0883732066
                        if state == 20:
                            return 0.130223602
            if state == 2:
                return -0.104204416
    elif num_booster == 19:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8857651)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.1658249)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95818281)  else 8)
                    if state == 7:
                        return -0.119008124
                    if state == 8:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.7205009)  else 18)
                        if state == 17:
                            return -0.102952652
                        if state == 18:
                            state = (27 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.9524994)  else 28)
                            if state == 27:
                                return 0.150558278
                            if state == 28:
                                return -0.0793404728
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.4534302)  else 10)
                    if state == 9:
                        return 0.142669067
                    if state == 10:
                        return 0.0159989949
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.6205959)  else 6)
                if state == 5:
                    return -0.164369181
                if state == 6:
                    return 0.0657925829
    elif num_booster == 20:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.768379688)  else 2)
            if state == 1:
                return -0.0867643878
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<20.103117)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.2294006)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.2455006)  else 20)
                        if state == 19:
                            state = (25 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.980499983)  else 26)
                            if state == 25:
                                return -0.119347379
                            if state == 26:
                                return 0.122367494
                        if state == 20:
                            return -0.16675435
                    if state == 12:
                        state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<19.5646667)  else 22)
                        if state == 21:
                            return 0.151011646
                        if state == 22:
                            state = (29 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.46092677)  else 30)
                            if state == 29:
                                return 0.15194577
                            if state == 30:
                                return -0.066630505
                if state == 6:
                    return -0.103706524
    elif num_booster == 21:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.07608795)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.3888512)  else 4)
                if state == 3:
                    return -0.0570736118
                if state == 4:
                    state = (9 if x['col_det']<-0.153840065 else 10)
                    if state == 9:
                        return -0.0987656415
                    if state == 10:
                        state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<19.9407864)  else 22)
                        if state == 21:
                            return 0.163003996
                        if state == 22:
                            state = (33 if np.isnan(x['mag_det']) or (x['mag_det']<20.5172997)  else 34)
                            if state == 33:
                                return -0.136793137
                            if state == 34:
                                state = (45 if np.isnan(x['mag_last']) or (x['mag_last']<20.3637466)  else 46)
                                if state == 45:
                                    return 0.179187194
                                if state == 46:
                                    return -0.0661102086
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.1519699)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<18.59375)  else 12)
                    if state == 11:
                        return -0.1142461
                    if state == 12:
                        return 0.141459301
                if state == 6:
                    return -0.170599744
    elif num_booster == 22:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<1.9596498 else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00858333521)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.8599434)  else 8)
                    if state == 7:
                        return 0.0960616469
                    if state == 8:
                        return -0.119809352
                if state == 4:
                    return -0.132285491
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<21.2390022)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<11.7429276)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<19.9859676)  else 22)
                        if state == 21:
                            return 0.0641954094
                        if state == 22:
                            return -0.105406903
                    if state == 12:
                        return -0.117013142
                if state == 6:
                    return 0.10925512
    elif num_booster == 23:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.4897728 else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.973999)  else 4)
                if state == 3:
                    return -0.0996513963
                if state == 4:
                    return 0.0549369752
            if state == 2:
                state = (5 if x['neargaia_med']<19.3889256 else 6)
                if state == 5:
                    return -0.147846639
                if state == 6:
                    return -0.0104582934
    elif num_booster == 24:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.0022335)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.69127351)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.99849999)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.558333516)  else 16)
                        if state == 15:
                            return -0.00409352034
                        if state == 16:
                            return 0.164065316
                    if state == 8:
                        return -0.107874826
                if state == 4:
                    return -0.0799016133
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.646666527)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<20.0500431)  else 12)
                    if state == 11:
                        return 0.0457740575
                    if state == 12:
                        return -0.1166199
                if state == 6:
                    return -0.156236544
    elif num_booster == 25:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<2.90901613)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.857380986)  else 4)
                if state == 3:
                    return -0.171921924
                if state == 4:
                    return 0.0732517689
            if state == 2:
                state = (5 if x['distpsnr1_med']<6.31456184 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.473999)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<5.89190388)  else 16)
                        if state == 15:
                            return 0.0399728119
                        if state == 16:
                            return -0.101122521
                    if state == 10:
                        return -0.192919254
                if state == 6:
                    return 0.104316063
    elif num_booster == 26:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7896996)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.815782487)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.985499978)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<0.0340162516)  else 14)
                        if state == 13:
                            return -0.115732811
                        if state == 14:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.528999984)  else 20)
                            if state == 19:
                                return -0.0843096301
                            if state == 20:
                                state = (27 if x['distpsnr1_med']<0.126201794 else 28)
                                if state == 27:
                                    return -0.0731473267
                                if state == 28:
                                    state = (33 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967000008)  else 34)
                                    if state == 33:
                                        state = (35 if np.isnan(x['mag_det']) or (x['mag_det']<19.1177006)  else 36)
                                        if state == 35:
                                            return -0.116406657
                                        if state == 36:
                                            state = (37 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99960065)  else 38)
                                            if state == 37:
                                                return 0.161571696
                                            if state == 38:
                                                return -0.0820194185
                                    if state == 34:
                                        return 0.166847423
                    if state == 8:
                        return -0.110114157
                if state == 4:
                    return -0.109999321
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.0213716)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<20.103117)  else 12)
                    if state == 11:
                        return 0.0689285323
                    if state == 12:
                        return -0.110486656
                if state == 6:
                    return -0.159196332
    elif num_booster == 27:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.4070511)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<8.26251125 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90730333)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<3.05429983)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<19.4290009)  else 28)
                            if state == 27:
                                return -0.11716155
                            if state == 28:
                                return 0.0658148602
                        if state == 16:
                            return -0.204357222
                    if state == 8:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.0259991)  else 18)
                        if state == 17:
                            return 0.0245854817
                        if state == 18:
                            return -0.124602981
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967000008)  else 10)
                    if state == 9:
                        return -0.0646958724
                    if state == 10:
                        return 0.138262957
            if state == 2:
                return 0.0850518346
    elif num_booster == 28:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.243317068 else 2)
            if state == 1:
                return -0.125109926
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.43761903)  else 6)
                if state == 5:
                    return -0.135079607
                if state == 6:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.9424667)  else 12)
                    if state == 11:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<18.4801998)  else 16)
                        if state == 15:
                            return -0.0620646551
                        if state == 16:
                            state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<4.00547457)  else 22)
                            if state == 21:
                                return 0.130640626
                            if state == 22:
                                state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.3426247)  else 30)
                                if state == 29:
                                    return 0.106612988
                                if state == 30:
                                    return -0.15616405
                    if state == 12:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<21.0657501)  else 18)
                        if state == 17:
                            return -0.118222579
                        if state == 18:
                            return 0.115830518
    elif num_booster == 29:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<15.9054508 else 2)
            if state == 1:
                return -0.140807867
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.195042223)  else 6)
                if state == 5:
                    return -0.0925275907
                if state == 6:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4597301)  else 10)
                    if state == 9:
                        state = (15 if x['neargaia_med']<9.04711246 else 16)
                        if state == 15:
                            return -0.0273450445
                        if state == 16:
                            state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<20.1057739)  else 22)
                            if state == 21:
                                return 0.156268924
                            if state == 22:
                                return -0.0351374038
                    if state == 10:
                        state = (17 if x['maggaia_med']<20.4755287 else 18)
                        if state == 17:
                            return -0.106112786
                        if state == 18:
                            return 0.0778201893
    elif num_booster == 30:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.2751522)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0900002)  else 4)
                if state == 3:
                    state = (7 if x['maggaia_med']<17.3341408 else 8)
                    if state == 7:
                        return -0.0943958089
                    if state == 8:
                        return 0.0469355732
                if state == 4:
                    return -0.168344483
            if state == 2:
                state = (5 if x['distpsnr1_med']<1.02120018 else 6)
                if state == 5:
                    return -0.0668995604
                if state == 6:
                    return 0.117867649
    elif num_booster == 31:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.33775425)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.71449995)  else 4)
                if state == 3:
                    return -0.074084647
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<18.4106503)  else 10)
                    if state == 9:
                        return -0.0712641105
                    if state == 10:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<1.90869212)  else 14)
                        if state == 13:
                            return -0.0890880376
                        if state == 14:
                            return 0.0834973752
            if state == 2:
                return -0.156423032
    elif num_booster == 32:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.04211235)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.38902009)  else 4)
                if state == 3:
                    return 0.106831409
                if state == 4:
                    state = (9 if x['col_det']<0.201600075 else 10)
                    if state == 9:
                        return -0.0926291049
                    if state == 10:
                        return 0.0752354562
            if state == 2:
                state = (5 if x['col_det']<0.316198349 else 6)
                if state == 5:
                    return 0.0583914332
                if state == 6:
                    return -0.108361006
    elif num_booster == 33:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.965499997)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<20.3458996)  else 4)
                if state == 3:
                    state = (7 if x['col_det']<0.0670595169 else 8)
                    if state == 7:
                        return 0.023109505
                    if state == 8:
                        return -0.156838581
                if state == 4:
                    return 0.0190595053
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5149994)  else 6)
                if state == 5:
                    return 0.0919425786
                if state == 6:
                    return -0.0821255073
    elif num_booster == 34:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7930489)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.7919502)  else 4)
                if state == 3:
                    return -0.0310074594
                if state == 4:
                    state = (9 if x['col_det']<-0.466777325 else 10)
                    if state == 9:
                        return -0.0929257721
                    if state == 10:
                        state = (19 if x['maggaia_med']<15.0223427 else 20)
                        if state == 19:
                            return -0.0916430727
                        if state == 20:
                            return 0.129504517
            if state == 2:
                return -0.107602306
    elif num_booster == 35:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.369999826)  else 2)
            if state == 1:
                return -0.147960767
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<20.105175)  else 6)
                if state == 5:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.700556099)  else 8)
                    if state == 7:
                        state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<25.2205677)  else 10)
                        if state == 9:
                            return -0.0891550779
                        if state == 10:
                            return 0.0807947293
                    if state == 8:
                        state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.8824997)  else 12)
                        if state == 11:
                            return -0.0776164234
                        if state == 12:
                            state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.743333459)  else 20)
                            if state == 19:
                                state = (27 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<17.4481621)  else 28)
                                if state == 27:
                                    return 0.155366361
                                if state == 28:
                                    state = (39 if x['neargaia_med']<20.998188 else 40)
                                    if state == 39:
                                        return -0.148415804
                                    if state == 40:
                                        return 0.096989125
                            if state == 20:
                                return -0.014767345
                if state == 6:
                    return -0.111789554
    elif num_booster == 36:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.89188957)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.83038998)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<29.0151443 else 8)
                    if state == 7:
                        return -0.0963235199
                    if state == 8:
                        return 0.0428599641
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.7311249)  else 10)
                    if state == 9:
                        return 0.141229287
                    if state == 10:
                        return -0.0514542162
            if state == 2:
                return -0.162122399
    elif num_booster == 37:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.333165824)  else 2)
            if state == 1:
                return -0.0769351497
            if state == 2:
                state = (5 if x['maggaia_med']<15.9613419 else 6)
                if state == 5:
                    return -0.0848953947
                if state == 6:
                    state = (13 if x['col_det']<-0.295884609 else 14)
                    if state == 13:
                        return -0.0806528479
                    if state == 14:
                        state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<4.0503006)  else 22)
                        if state == 21:
                            state = (27 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.600499988)  else 28)
                            if state == 27:
                                return -0.0702135637
                            if state == 28:
                                state = (35 if x['neargaia_med']<1.94470668 else 36)
                                if state == 35:
                                    return -0.0655686557
                                if state == 36:
                                    return 0.144464895
                        if state == 22:
                            state = (29 if np.isnan(x['mag_last']) or (x['mag_last']<19.2872658)  else 30)
                            if state == 29:
                                return 0.109444015
                            if state == 30:
                                return -0.14935796
    elif num_booster == 38:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.99730921)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<16.4554996 else 4)
                if state == 3:
                    return -0.0802148953
                if state == 4:
                    state = (9 if x['col_det']<-0.278990269 else 10)
                    if state == 9:
                        return -0.0919627845
                    if state == 10:
                        return 0.0870161057
            if state == 2:
                return -0.0988503397
    elif num_booster == 39:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.608921409)  else 2)
            if state == 1:
                return -0.0876054689
            if state == 2:
                return 0.0410716198
    elif num_booster == 40:
        return  0.0286544785
    elif num_booster == 41:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<8.99505424 else 2)
            if state == 1:
                return -0.131363586
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.153171301)  else 6)
                if state == 5:
                    return -0.0906200856
                if state == 6:
                    return 0.0627302304
    elif num_booster == 42:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.3341408)  else 2)
            if state == 1:
                return -0.0662285313
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.31446815)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<2.978374)  else 12)
                    if state == 11:
                        return -0.0631377846
                    if state == 12:
                        return 0.135000944
                if state == 6:
                    state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.83965731)  else 14)
                    if state == 13:
                        return -0.145303443
                    if state == 14:
                        state = (25 if x['maggaia_med']<19.4632378 else 26)
                        if state == 25:
                            return 0.0887715369
                        if state == 26:
                            return -0.066749312
    elif num_booster == 43:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.68335402)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<20.103117)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.79333353)  else 6)
                    if state == 5:
                        state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<19.5755081)  else 8)
                        if state == 7:
                            state = (11 if x['distpsnr1_med']<6.21901321 else 12)
                            if state == 11:
                                return 0.0534853861
                            if state == 12:
                                return -0.189156532
                        if state == 8:
                            return 0.104495123
                    if state == 6:
                        return -0.05373317
                if state == 4:
                    return -0.0981033519
            if state == 2:
                return -0.114775695
    elif num_booster == 44:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<18.5226002)  else 2)
            if state == 1:
                return -0.108951695
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.963999987)  else 6)
                if state == 5:
                    state = (9 if x['col_det']<0.352702141 else 10)
                    if state == 9:
                        return 0.06371665
                    if state == 10:
                        return -0.0932844803
                if state == 6:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<1.99926496)  else 12)
                    if state == 11:
                        return -0.0755888894
                    if state == 12:
                        return 0.121373281
    elif num_booster == 45:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<17.8486004)  else 2)
            if state == 1:
                return -0.100566104
            if state == 2:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.1633492)  else 4)
                if state == 3:
                    return 0.0917329639
                if state == 4:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<20.3435001)  else 8)
                    if state == 7:
                        return -0.0865757316
                    if state == 8:
                        return 0.0777517855
    elif num_booster == 46:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<18.1355629 else 2)
            if state == 1:
                return -0.0588986687
            if state == 2:
                return 0.0607936569
    elif num_booster == 47:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.368588448)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.8845673)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.4350471)  else 8)
                    if state == 7:
                        return 0.108603708
                    if state == 8:
                        return -0.0271323733
                if state == 4:
                    return -0.050325647
            if state == 2:
                return -0.161474198
    elif num_booster == 48:
        return  0.00872695073
    elif num_booster == 49:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.8387623)  else 2)
            if state == 1:
                return -0.0726563185
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.722143054)  else 6)
                if state == 5:
                    return 0.0757862628
                if state == 6:
                    state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.874285817)  else 14)
                    if state == 13:
                        return -0.130781114
                    if state == 14:
                        return 0.0849539116
    elif num_booster == 50:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.18844986)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.796904922)  else 4)
                if state == 3:
                    return 0.0538446195
                if state == 4:
                    return -0.0707502514
            if state == 2:
                return -0.11183615
    elif num_booster == 51:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.693132401)  else 2)
            if state == 1:
                return -0.0934397429
            if state == 2:
                return 0.0281168837
    elif num_booster == 52:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.7438507)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.8105011)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.1310787)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.4594994)  else 14)
                        if state == 13:
                            return 0.0381855927
                        if state == 14:
                            return -0.11905767
                    if state == 8:
                        return 0.0383154899
                if state == 4:
                    return 0.077286832
            if state == 2:
                return 0.0873880461
    elif num_booster == 53:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7879486)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.1845016)  else 4)
                if state == 3:
                    return -0.0691094324
                if state == 4:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<0.0460126996)  else 10)
                    if state == 9:
                        return -0.0837469697
                    if state == 10:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.1719513)  else 18)
                        if state == 17:
                            state = (23 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.2335014)  else 24)
                            if state == 23:
                                return 0.107788451
                            if state == 24:
                                return -0.0794242769
                        if state == 18:
                            return 0.13495551
            if state == 2:
                return -0.0501456372
    elif num_booster == 54:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8599434)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0238991)  else 4)
                if state == 3:
                    return -0.0707474574
                if state == 4:
                    return 0.0987016484
            if state == 2:
                return -0.0925305262
    elif num_booster == 55:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<7.17403793)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<18.8882828)  else 4)
                if state == 3:
                    return 0.0719487742
                if state == 4:
                    return -0.115491018
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0311160497)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00870833546)  else 12)
                    if state == 11:
                        state = (21 if x['maggaia_med']<19.9814205 else 22)
                        if state == 21:
                            return 0.10961853
                        if state == 22:
                            return -0.0890565068
                    if state == 12:
                        return -0.091291599
                if state == 6:
                    return 0.107282095
    elif num_booster == 56:
        return  -0.00602590153
    elif num_booster == 57:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967999995)  else 2)
            if state == 1:
                return -0.0389312394
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0955009)  else 6)
                if state == 5:
                    return 0.120595738
                if state == 6:
                    return -0.0705319792
    elif num_booster == 58:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<19.4717751)  else 2)
            if state == 1:
                return -0.0858616233
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0509606525)  else 6)
                if state == 5:
                    return -0.115422145
                if state == 6:
                    return 0.0857581049
    elif num_booster == 59:
        return  0.0211715233
    elif num_booster == 60:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.2880001)  else 2)
            if state == 1:
                return 0.0743256956
            if state == 2:
                state = (5 if x['col_det']<1.33747005 else 6)
                if state == 5:
                    state = (11 if x['maggaia_med']<17.1895065 else 12)
                    if state == 11:
                        return 0.0459694564
                    if state == 12:
                        return -0.208425909
                if state == 6:
                    return 0.0339834318
    elif num_booster == 61:
        return  0.0285121556
    elif num_booster == 62:
        return  -0.00867379177
    elif num_booster == 63:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<18.9446125)  else 2)
            if state == 1:
                return 0.0484436192
            if state == 2:
                return -0.0641063973
    elif num_booster == 64:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.2574062)  else 2)
            if state == 1:
                return -0.0604616702
            if state == 2:
                return 0.0638728142
    elif num_booster == 65:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<2.99916077)  else 2)
            if state == 1:
                return 0.0398670435
            if state == 2:
                return -0.0774047002
    elif num_booster == 66:
        return  -0.0341530517
    elif num_booster == 67:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.191660494)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0412291996)  else 4)
                if state == 3:
                    return -0.0109182084
                if state == 4:
                    return -0.172221377
            if state == 2:
                return 0.0478592999
    elif num_booster == 68:
        return  -0.005979056
    elif num_booster == 69:
        return  0.0446165167
    elif num_booster == 70:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.0506711)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0238991)  else 4)
                if state == 3:
                    return -0.0920381621
                if state == 4:
                    return 0.0633914918
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.0415001)  else 6)
                if state == 5:
                    return -0.166958645
                if state == 6:
                    return 0.00460184645
    elif num_booster == 71:
        return  0.0132566271
    elif num_booster == 72:
        return  -0.0512443967
    elif num_booster == 73:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.22003818)  else 2)
            if state == 1:
                return 0.0617942847
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.8058472)  else 6)
                if state == 5:
                    return -0.115068041
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.85198498)  else 12)
                    if state == 11:
                        return -0.080567576
                    if state == 12:
                        return 0.0981564745
    elif num_booster == 74:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.723500013)  else 2)
            if state == 1:
                return 0.0872657895
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.1582012)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<5.55685043)  else 10)
                    if state == 9:
                        return 0.0831787437
                    if state == 10:
                        return -0.0971427038
                if state == 6:
                    return -0.0613005236
    elif num_booster == 75:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.502604008)  else 2)
            if state == 1:
                return 0.0312818848
            if state == 2:
                return -0.116516739
    elif num_booster == 76:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.01630211)  else 2)
            if state == 1:
                return -0.0423961654
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.1654778)  else 6)
                if state == 5:
                    return 0.10131339
                if state == 6:
                    state = (13 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.3085327)  else 14)
                    if state == 13:
                        return -0.103176907
                    if state == 14:
                        return 0.0943199173
    elif num_booster == 77:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1758614)  else 2)
            if state == 1:
                return 0.0500904024
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<20.6126995)  else 6)
                if state == 5:
                    return -0.103290401
                if state == 6:
                    return 0.0892500058
    elif num_booster == 78:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.6408997 else 2)
            if state == 1:
                return -0.0479737855
            if state == 2:
                return 0.057702966
    elif num_booster == 79:
        return  0.0179466922
    elif num_booster == 80:
        return  -0.0157403778
    elif num_booster == 81:
        state = 0
        if state == 0:
            state = (1 if x['col_det']<0.494688988 else 2)
            if state == 1:
                return 0.0612632893
            if state == 2:
                return -0.0600244626
    elif num_booster == 82:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.855000019)  else 2)
            if state == 1:
                return -0.0740442127
            if state == 2:
                return 0.0803846121
    elif num_booster == 83:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.914499998)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.7330017)  else 4)
                if state == 3:
                    return -0.116652012
                if state == 4:
                    return 0.0695277601
            if state == 2:
                return 0.0470522195
    elif num_booster == 84:
        return  -0.0237847082
    elif num_booster == 85:
        return  -0.0107851094
    elif num_booster == 86:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.3016701)  else 2)
            if state == 1:
                return 0.0757053718
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<20.15905)  else 6)
                if state == 5:
                    return -0.130925715
                if state == 6:
                    return 0.0211310349
    elif num_booster == 87:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.81153941)  else 2)
            if state == 1:
                return 0.0824790448
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.99379539)  else 6)
                if state == 5:
                    return 0.00899840798
                if state == 6:
                    return -0.155694947
    elif num_booster == 88:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<18.4264412)  else 2)
            if state == 1:
                return -0.0549718626
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<2.99599552)  else 6)
                if state == 5:
                    return 0.10005074
                if state == 6:
                    state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<18.941124)  else 14)
                    if state == 13:
                        return 0.104633555
                    if state == 14:
                        return -0.0563359074
    elif num_booster == 89:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.3055763)  else 2)
            if state == 1:
                return -0.071779266
            if state == 2:
                return 0.0561837442
    elif num_booster == 90:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<2.97645831)  else 2)
            if state == 1:
                return 0.0736144483
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.1654778)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<18.5402489)  else 12)
                    if state == 11:
                        return -0.0700007379
                    if state == 12:
                        return 0.114192404
                if state == 6:
                    return -0.107267193
    elif num_booster == 91:
        return  0.0192480311
    elif num_booster == 92:
        return  0.0123694856
    elif num_booster == 93:
        return  0.0132344719
    elif num_booster == 94:
        return  0.0373514965
    elif num_booster == 95:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.102493852 else 2)
            if state == 1:
                return 0.0475344658
            if state == 2:
                return -0.0751495212
    elif num_booster == 96:
        return  -0.0451379642
    elif num_booster == 97:
        return  -0.0259046517
    elif num_booster == 98:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<-0.0485024452)  else 2)
            if state == 1:
                return 0.0406284854
            if state == 2:
                return -0.0841086432
    elif num_booster == 99:
        return  0.00245346664



def xgb_tree_4(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.935249984)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<55.0134239)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<19.7944489)  else 14)
                        if state == 13:
                            state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<19.7535496)  else 24)
                            if state == 23:
                                return -0.0533333346
                            if state == 24:
                                return 0.0269944146
                        if state == 14:
                            return -0.132173911
                    if state == 8:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.873750031)  else 16)
                        if state == 15:
                            state = (25 if x['sgscore1_med']<0.0617156662 else 26)
                            if state == 25:
                                return -0.0533333346
                            if state == 26:
                                return 0.0540296733
                        if state == 16:
                            state = (27 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.76760387)  else 28)
                            if state == 27:
                                return -0.0902457982
                            if state == 28:
                                return 0.0269944146
                if state == 4:
                    return 0.0605513752
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.1286011)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<19.0564346)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<16.2791004)  else 18)
                        if state == 17:
                            state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<16.0924187)  else 30)
                            if state == 29:
                                return -0.0320000015
                            if state == 30:
                                return 0.0269944146
                        if state == 18:
                            return -0.0960000008
                    if state == 10:
                        return 0.0461950302
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.37139833)  else 12)
                    if state == 11:
                        state = (19 if x['neargaia_med']<0.158616394 else 20)
                        if state == 19:
                            return 0.0605513752
                        if state == 20:
                            state = (31 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<25.8837776)  else 32)
                            if state == 31:
                                return -0.088888891
                            if state == 32:
                                return 0.0269944146
                    if state == 12:
                        state = (21 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.991145968)  else 22)
                        if state == 21:
                            state = (33 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.953499973)  else 34)
                            if state == 33:
                                return 0.0252173916
                            if state == 34:
                                return 0.131279677
                        if state == 22:
                            return -0.0320000015
    elif num_booster == 1:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8599606)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6241493)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.984250069)  else 6)
                    if state == 5:
                        return -0.120376565
                    if state == 6:
                        state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<16.0924187)  else 10)
                        if state == 9:
                            return -0.0524845496
                        if state == 10:
                            return 0.0576969087
                if state == 4:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.773720503)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.2062492)  else 12)
                        if state == 11:
                            state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<18.0251999)  else 16)
                            if state == 15:
                                return 0.0261814352
                            if state == 16:
                                return -0.0790896043
                        if state == 12:
                            state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.8456001)  else 18)
                            if state == 17:
                                return 0.0986726135
                            if state == 18:
                                return -0.0360363461
                    if state == 8:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.5476322)  else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.989750028)  else 20)
                            if state == 19:
                                return 0.139489949
                            if state == 20:
                                return -0.00846112892
                        if state == 14:
                            state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<2.55810189)  else 22)
                            if state == 21:
                                return 0.0574278533
                            if state == 22:
                                return -0.029328635
            if state == 2:
                return -0.133606255
    elif num_booster == 2:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8427505)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<15.5517893 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.1172504)  else 8)
                    if state == 7:
                        return -0.0831610486
                    if state == 8:
                        return -0.00524472306
                if state == 4:
                    state = (9 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.523373544)  else 10)
                    if state == 9:
                        state = (15 if x['col_det']<0.683629096 else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.230069846)  else 26)
                            if state == 25:
                                return 0.0873615071
                            if state == 26:
                                return -0.0251469612
                        if state == 16:
                            state = (27 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.3587494)  else 28)
                            if state == 27:
                                return 0.026751928
                            if state == 28:
                                return -0.0805444494
                    if state == 10:
                        state = (17 if np.isnan(x['col_det']) or (x['col_det']<0.579547882)  else 18)
                        if state == 17:
                            state = (29 if x['distpsnr1_med']<7.07243967 else 30)
                            if state == 29:
                                return 0.109218083
                            if state == 30:
                                return 0.0096986508
                        if state == 18:
                            return -0.00582497148
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.92862606)  else 6)
                if state == 5:
                    state = (11 if x['col_det']<-0.192979813 else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<6.02862263)  else 20)
                        if state == 19:
                            return 0.0559721887
                        if state == 20:
                            return -0.0286178887
                    if state == 12:
                        state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.0649986)  else 22)
                        if state == 21:
                            state = (31 if np.isnan(x['t_lc']) or (x['t_lc']<4.4594965)  else 32)
                            if state == 31:
                                return 0.0410738885
                            if state == 32:
                                return -0.0278696623
                        if state == 22:
                            state = (33 if np.isnan(x['t_lc']) or (x['t_lc']<6.09059048)  else 34)
                            if state == 33:
                                return -0.0980206728
                            if state == 34:
                                return 0.0268473886
                if state == 6:
                    state = (13 if x['col_det']<0.0665830001 else 14)
                    if state == 13:
                        state = (23 if x['maggaia_med']<39.3187485 else 24)
                        if state == 23:
                            return -0.0471649915
                        if state == 24:
                            return 0.0410738885
                    if state == 14:
                        return 0.0839940161
    elif num_booster == 3:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<1.32730019)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.9292488)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<18.8325996)  else 8)
                    if state == 7:
                        state = (15 if x['neargaia_med']<24.6568375 else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<18.6674004)  else 28)
                            if state == 27:
                                return -0.0936668292
                            if state == 28:
                                return -0.00452763075
                        if state == 16:
                            state = (29 if x['distpsnr1_med']<0.280983627 else 30)
                            if state == 29:
                                return -0.0517468527
                            if state == 30:
                                return 0.0672434121
                    if state == 8:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.0119791)  else 18)
                        if state == 17:
                            return -0.0249780435
                        if state == 18:
                            return 0.0930879489
                if state == 4:
                    state = (9 if x['neargaia_med']<0.173155561 else 10)
                    if state == 9:
                        return 0.0277541243
                    if state == 10:
                        return -0.118599996
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<35.7347679)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<6.99131298 else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.4916496)  else 20)
                        if state == 19:
                            return -0.0338394381
                        if state == 20:
                            return 0.0418392234
                    if state == 12:
                        state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<5.99248266)  else 22)
                        if state == 21:
                            state = (35 if x['distpsnr1_med']<2.16816545 else 36)
                            if state == 35:
                                return 0.0237673596
                            if state == 36:
                                return 0.112460643
                        if state == 22:
                            state = (37 if np.isnan(x['t_lc']) or (x['t_lc']<5.99584484)  else 38)
                            if state == 37:
                                return -0.045313701
                            if state == 38:
                                return 0.0549792722
                if state == 6:
                    state = (13 if x['neargaia_med']<41.8831558 else 14)
                    if state == 13:
                        return -0.056000419
                    if state == 14:
                        state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.97372699)  else 26)
                        if state == 25:
                            return -0.00319623202
                        if state == 26:
                            return 0.0702970549
    elif num_booster == 4:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5919151)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.1327171)  else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<1.34613085 else 8)
                    if state == 7:
                        return -0.108372808
                    if state == 8:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5970001)  else 14)
                        if state == 13:
                            state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<19.2363358)  else 18)
                            if state == 17:
                                return 0.100932337
                            if state == 18:
                                return -0.0341560096
                        if state == 14:
                            return -0.0622697994
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.7425003)  else 10)
                    if state == 9:
                        return 0.118342102
                    if state == 10:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.073349)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.6224995)  else 22)
                            if state == 21:
                                return -0.0604983047
                            if state == 22:
                                return 0.0379300937
                        if state == 16:
                            return 0.0716860592
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.3132515)  else 6)
                if state == 5:
                    return -0.123278007
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<20.6019001)  else 12)
                    if state == 11:
                        return 0.0390459262
                    if state == 12:
                        return -0.0275111627
    elif num_booster == 5:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8252144)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.588625014)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.5919151)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<16.4072189)  else 12)
                        if state == 11:
                            return -0.044076588
                        if state == 12:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.73150003)  else 20)
                            if state == 19:
                                return -0.026153693
                            if state == 20:
                                return 0.103228144
                    if state == 8:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.55810189)  else 14)
                        if state == 13:
                            return 0.0512824766
                        if state == 14:
                            state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<19.7978439)  else 22)
                            if state == 21:
                                return -0.075243257
                            if state == 22:
                                return 0.0295909233
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<18.7116299)  else 10)
                    if state == 9:
                        state = (15 if x['sgscore1_med']<0.707957983 else 16)
                        if state == 15:
                            return -0.00249410211
                        if state == 16:
                            state = (23 if np.isnan(x['t_lc']) or (x['t_lc']<5.99273729)  else 24)
                            if state == 23:
                                return -0.10525728
                            if state == 24:
                                return -0.000667079235
                    if state == 10:
                        state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.731000006)  else 18)
                        if state == 17:
                            return -0.0250382982
                        if state == 18:
                            return 0.0366731472
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<2.93741322)  else 6)
                if state == 5:
                    return 0.00560901733
                if state == 6:
                    return -0.115477428
    elif num_booster == 6:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8252144)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<17.6564751)  else 4)
                if state == 3:
                    return -0.0949623212
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.511013)  else 8)
                    if state == 7:
                        state = (9 if x['maggaia_med']<15.8999462 else 10)
                        if state == 9:
                            return -0.0272644721
                        if state == 10:
                            state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.5655003)  else 14)
                            if state == 13:
                                return 0.11568401
                            if state == 14:
                                return 0.0406048112
                    if state == 8:
                        state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.3356342)  else 12)
                        if state == 11:
                            return 0.0684992075
                        if state == 12:
                            state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<19.9814987)  else 16)
                            if state == 15:
                                return -0.0953085423
                            if state == 16:
                                return 0.0162665453
            if state == 2:
                state = (5 if x['col_det']<-0.167057514 else 6)
                if state == 5:
                    return 0.00122714671
                if state == 6:
                    return -0.110000178
    elif num_booster == 7:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8673592)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.1327171)  else 4)
                if state == 3:
                    state = (5 if x['neargaia_med']<17.6644573 else 6)
                    if state == 5:
                        state = (9 if x['neargaia_med']<0.610419869 else 10)
                        if state == 9:
                            return -0.00248043821
                        if state == 10:
                            return -0.0793422908
                    if state == 6:
                        state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.0157013)  else 12)
                        if state == 11:
                            return 0.0873629525
                        if state == 12:
                            return -0.0393083766
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.5265446)  else 8)
                    if state == 7:
                        return 0.111825943
                    if state == 8:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<19.97225)  else 14)
                        if state == 13:
                            return -0.0700848028
                        if state == 14:
                            state = (15 if x['neargaia_med']<83.288887 else 16)
                            if state == 15:
                                return 0.0757448897
                            if state == 16:
                                return -0.00442239735
            if state == 2:
                return -0.106792592
    elif num_booster == 8:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7388859)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.2439003)  else 4)
                if state == 3:
                    state = (7 if x['col_det']<-0.276728153 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.1063881)  else 14)
                        if state == 13:
                            return 0.0406594202
                        if state == 14:
                            return -0.0421048477
                    if state == 8:
                        return -0.0999264196
                if state == 4:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.623383999)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['mag_last']) or (x['mag_last']<19.511013)  else 16)
                        if state == 15:
                            state = (19 if x['maggaia_med']<17.3315735 else 20)
                            if state == 19:
                                return 0.0413739495
                            if state == 20:
                                return 0.109722584
                        if state == 16:
                            state = (21 if x['col_det']<0.233263969 else 22)
                            if state == 21:
                                return -0.0678408295
                            if state == 22:
                                return 0.0509123988
                    if state == 10:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.8985996)  else 18)
                        if state == 17:
                            state = (23 if np.isnan(x['mag_last']) or (x['mag_last']<18.1566219)  else 24)
                            if state == 23:
                                return 0.000303218054
                            if state == 24:
                                return -0.0881472304
                        if state == 18:
                            return 0.0433898047
            if state == 2:
                state = (5 if x['col_det']<-0.259850502 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.7102013)  else 12)
                    if state == 11:
                        return -0.0262517855
                    if state == 12:
                        return 0.0288971607
                if state == 6:
                    return -0.10205546
    elif num_booster == 9:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.7352505)  else 2)
            if state == 1:
                return -0.0818214417
            if state == 2:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.9937496)  else 4)
                if state == 3:
                    state = (5 if x['neargaia_med']<53.1112862 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<2.49625587)  else 10)
                        if state == 9:
                            return -0.040923886
                        if state == 10:
                            state = (15 if x['neargaia_med']<41.6930161 else 16)
                            if state == 15:
                                return 0.048266802
                            if state == 16:
                                return -0.0212191455
                    if state == 6:
                        return 0.0825420171
                if state == 4:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9237499)  else 8)
                    if state == 7:
                        state = (11 if x['col_det']<0.00243282318 else 12)
                        if state == 11:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<4.53545713)  else 18)
                            if state == 17:
                                return -0.0894488469
                            if state == 18:
                                return 0.00926622748
                        if state == 12:
                            state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.3727493)  else 20)
                            if state == 19:
                                return -0.0448784567
                            if state == 20:
                                return 0.0271325558
                    if state == 8:
                        return 0.0461234003
    elif num_booster == 10:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.584166467)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<3.01997113)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<0.0694386512)  else 8)
                    if state == 7:
                        return -0.0218207575
                    if state == 8:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.298333406)  else 16)
                        if state == 15:
                            return -0.0198317207
                        if state == 16:
                            return 0.0679439753
                if state == 4:
                    state = (9 if x['col_det']<-0.196491241 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<6.02295113)  else 18)
                        if state == 17:
                            return 0.0445297807
                        if state == 18:
                            return -0.026664637
                    if state == 10:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0314930491)  else 20)
                        if state == 19:
                            state = (29 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.00934604928)  else 30)
                            if state == 29:
                                return -0.0192411356
                            if state == 30:
                                return 0.0292648766
                        if state == 20:
                            return -0.104619272
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.654992104)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<3.03766203)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98660874)  else 22)
                        if state == 21:
                            state = (31 if np.isnan(x['col_det']) or (x['col_det']<0.257889748)  else 32)
                            if state == 31:
                                return 0.058946766
                            if state == 32:
                                return -0.00179084728
                        if state == 22:
                            return -0.0205838848
                    if state == 12:
                        state = (23 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.211897925)  else 24)
                        if state == 23:
                            state = (33 if np.isnan(x['t_lc']) or (x['t_lc']<4.48007536)  else 34)
                            if state == 33:
                                return -0.02035073
                            if state == 34:
                                return 0.0314819366
                        if state == 24:
                            return -0.0668307468
                if state == 6:
                    state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.99187899)  else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['rb_med']) or (x['rb_med']<0.692023754)  else 26)
                        if state == 25:
                            state = (35 if np.isnan(x['rb_med']) or (x['rb_med']<0.667500257)  else 36)
                            if state == 35:
                                return 0.0404193215
                            if state == 36:
                                return -0.0484972075
                        if state == 26:
                            state = (37 if np.isnan(x['t_lc']) or (x['t_lc']<2.00549769)  else 38)
                            if state == 37:
                                return -0.00359338243
                            if state == 38:
                                return 0.0782679617
                    if state == 14:
                        state = (27 if np.isnan(x['distnr_med']) or (x['distnr_med']<8.62724876)  else 28)
                        if state == 27:
                            return -0.0644488335
                        if state == 28:
                            state = (39 if np.isnan(x['t_lc']) or (x['t_lc']<3.03653359)  else 40)
                            if state == 39:
                                return -0.0271252785
                            if state == 40:
                                return 0.028227346
    elif num_booster == 11:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.912499964)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.1026344)  else 4)
                if state == 3:
                    return -0.0956073329
                if state == 4:
                    state = (7 if x['maggaia_med']<18.9810524 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3662491)  else 14)
                        if state == 13:
                            state = (23 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.386496186)  else 24)
                            if state == 23:
                                return -0.0200592652
                            if state == 24:
                                return 0.0726247877
                        if state == 14:
                            state = (25 if np.isnan(x['mag_det']) or (x['mag_det']<20.7280006)  else 26)
                            if state == 25:
                                return -0.0504273511
                            if state == 26:
                                return 0.00177625509
                    if state == 8:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.65625)  else 16)
                        if state == 15:
                            return -0.0835031793
                        if state == 16:
                            state = (27 if np.isnan(x['mag_det']) or (x['mag_det']<20.3066502)  else 28)
                            if state == 27:
                                return -0.0203335546
                            if state == 28:
                                return 0.0343297645
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6882515)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<18.1236496)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.8348808)  else 18)
                        if state == 17:
                            return -0.0781025887
                        if state == 18:
                            return 0.0365880802
                    if state == 10:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.8827515)  else 20)
                        if state == 19:
                            state = (29 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1805)  else 30)
                            if state == 29:
                                return 0.099368073
                            if state == 30:
                                return 0.0256342292
                        if state == 20:
                            state = (31 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.958000004)  else 32)
                            if state == 31:
                                return -0.0533349253
                            if state == 32:
                                return 0.0388866663
                if state == 6:
                    state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.7422485)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.95174998)  else 22)
                        if state == 21:
                            return -0.0041488586
                        if state == 22:
                            return -0.105643779
                    if state == 12:
                        return 0.0435559116
    elif num_booster == 12:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.3949852)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.3214989)  else 4)
                if state == 3:
                    return -0.0826107785
                if state == 4:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0577507)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3440018)  else 14)
                        if state == 13:
                            state = (21 if x['maggaia_med']<16.0115185 else 22)
                            if state == 21:
                                return -0.00999055989
                            if state == 22:
                                return 0.102814898
                        if state == 14:
                            state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00310183)  else 24)
                            if state == 23:
                                return 0.0405680984
                            if state == 24:
                                return -0.0290799197
                    if state == 8:
                        state = (15 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01569462)  else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6337509)  else 26)
                            if state == 25:
                                return 0.00611978816
                            if state == 26:
                                return -0.0818332881
                        if state == 16:
                            return 0.0419880636
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.969249964)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<20.6430473)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.999279)  else 18)
                        if state == 17:
                            return -0.100287512
                        if state == 18:
                            state = (27 if np.isnan(x['mag_last']) or (x['mag_last']<20.0647736)  else 28)
                            if state == 27:
                                return 0.0291353054
                            if state == 28:
                                return -0.0511682592
                    if state == 10:
                        state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.641749978)  else 20)
                        if state == 19:
                            return -0.041059494
                        if state == 20:
                            return 0.0155654829
                if state == 6:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96270275)  else 12)
                    if state == 11:
                        return 0.0623858534
                    if state == 12:
                        return -0.0660959035
    elif num_booster == 13:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<18.9440269)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01982069)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.847619057)  else 8)
                    if state == 7:
                        return -0.0935880542
                    if state == 8:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<16.9869766)  else 14)
                        if state == 13:
                            return -0.0229454301
                        if state == 14:
                            return 0.037772309
                if state == 4:
                    return 0.0355545878
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.8675995)  else 6)
                if state == 5:
                    state = (9 if x['neargaia_med']<17.9731522 else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.18013358)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<19.8115997)  else 24)
                            if state == 23:
                                return 0.0640616417
                            if state == 24:
                                return -0.00830770843
                        if state == 16:
                            state = (25 if np.isnan(x['mag_det']) or (x['mag_det']<19.6765499)  else 26)
                            if state == 25:
                                return -0.0570559166
                            if state == 26:
                                return 0.0276015773
                    if state == 10:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0569213033)  else 18)
                        if state == 17:
                            return -0.0178432111
                        if state == 18:
                            return 0.0896688551
                if state == 6:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.714404821)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.54169607)  else 20)
                        if state == 19:
                            return -0.0833758712
                        if state == 20:
                            state = (27 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.77873707)  else 28)
                            if state == 27:
                                return 0.0646229908
                            if state == 28:
                                return -0.0485658236
                    if state == 12:
                        state = (21 if x['neargaia_med']<45.5790253 else 22)
                        if state == 21:
                            state = (29 if x['neargaia_med']<4.2717557 else 30)
                            if state == 29:
                                return -0.0291743297
                            if state == 30:
                                return 0.0633650348
                        if state == 22:
                            return -0.0530527644
    elif num_booster == 14:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6331635)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.7002487)  else 4)
                if state == 3:
                    return -0.0801455006
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5842514)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.7396183)  else 16)
                        if state == 15:
                            state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0457002521)  else 20)
                            if state == 19:
                                return -0.000072
                            if state == 20:
                                return 0.0921110138
                        if state == 16:
                            return -0.0360762626
                    if state == 10:
                        state = (17 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.66674662)  else 18)
                        if state == 17:
                            state = (21 if x['col_det']<-0.0750719681 else 22)
                            if state == 21:
                                return -0.0700434893
                            if state == 22:
                                return -0.000489263621
                        if state == 18:
                            return 0.0469377078
            if state == 2:
                state = (5 if x['col_det']<-0.259850502 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.7646866)  else 12)
                    if state == 11:
                        return -0.0291554444
                    if state == 12:
                        return 0.0278656166
                if state == 6:
                    state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.785656)  else 14)
                    if state == 13:
                        return -0.00674173702
                    if state == 14:
                        return -0.099955529
    elif num_booster == 15:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.77275002)  else 2)
            if state == 1:
                return -0.0891266316
            if state == 2:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0177498)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.68575)  else 6)
                    if state == 5:
                        return -0.0593296364
                    if state == 6:
                        state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.9174004)  else 10)
                        if state == 9:
                            return 0.0943527892
                        if state == 10:
                            state = (13 if x['col_det']<0.194000244 else 14)
                            if state == 13:
                                return -0.037859939
                            if state == 14:
                                return 0.057127919
                if state == 4:
                    state = (7 if x['distpsnr1_med']<8.26984787 else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.916749954)  else 12)
                        if state == 11:
                            return -0.0118237333
                        if state == 12:
                            state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.073349)  else 16)
                            if state == 15:
                                return -0.104883775
                            if state == 16:
                                return -0.0110717081
                    if state == 8:
                        return 0.0740026012
    elif num_booster == 16:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.698948979)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<18.9883709)  else 4)
                if state == 3:
                    state = (5 if x['col_det']<0.154500008 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<10.7521629)  else 10)
                        if state == 9:
                            state = (17 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.31950599)  else 18)
                            if state == 17:
                                return 0.0692156032
                            if state == 18:
                                return 0.00933047011
                        if state == 10:
                            state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.96739006)  else 20)
                            if state == 19:
                                return 0.0280020069
                            if state == 20:
                                return -0.0421840474
                    if state == 6:
                        state = (11 if np.isnan(x['col_det']) or (x['col_det']<0.382063866)  else 12)
                        if state == 11:
                            state = (21 if x['sgscore1_med']<0.00395833515 else 22)
                            if state == 21:
                                return 0.0210075341
                            if state == 22:
                                return -0.0541612953
                        if state == 12:
                            state = (23 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.1341476)  else 24)
                            if state == 23:
                                return -0.0351876654
                            if state == 24:
                                return 0.0579659827
                if state == 4:
                    state = (7 if x['col_det']<-0.110546112 else 8)
                    if state == 7:
                        state = (13 if x['col_det']<-0.231370926 else 14)
                        if state == 13:
                            return 0.0210331585
                        if state == 14:
                            return -0.0415257551
                    if state == 8:
                        state = (15 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.062494196)  else 16)
                        if state == 15:
                            state = (25 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0417882502)  else 26)
                            if state == 25:
                                return 0.0522127189
                            if state == 26:
                                return -0.0536391437
                        if state == 16:
                            state = (27 if np.isnan(x['col_det']) or (x['col_det']<0.316198349)  else 28)
                            if state == 27:
                                return 0.0856634676
                            if state == 28:
                                return 0.00373713276
            if state == 2:
                return -0.0747085437
    elif num_booster == 17:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 2)
            if state == 1:
                return -0.0855978578
            if state == 2:
                state = (3 if x['neargaia_med']<29.0058823 else 4)
                if state == 3:
                    state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9469676)  else 6)
                    if state == 5:
                        state = (9 if x['maggaia_med']<15.5045052 else 10)
                        if state == 9:
                            return -0.0446804985
                        if state == 10:
                            state = (15 if x['neargaia_med']<27.9597359 else 16)
                            if state == 15:
                                return 0.0429881103
                            if state == 16:
                                return -0.0336438976
                    if state == 6:
                        state = (11 if x['neargaia_med']<1.42693305 else 12)
                        if state == 11:
                            return 0.0323158987
                        if state == 12:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.986750007)  else 20)
                            if state == 19:
                                return -0.0647671521
                            if state == 20:
                                return 0.0226293933
                if state == 4:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91495943)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.963)  else 14)
                        if state == 13:
                            state = (21 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<35.6781235)  else 22)
                            if state == 21:
                                return -0.0541480035
                            if state == 22:
                                return 0.0199218448
                        if state == 14:
                            state = (23 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.90313101)  else 24)
                            if state == 23:
                                return 0.0492951348
                            if state == 24:
                                return -0.00997664779
                    if state == 8:
                        return 0.0696815923
    elif num_booster == 18:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.595927)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.705000043)  else 4)
                if state == 3:
                    return -0.0834467933
                if state == 4:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.4438782)  else 8)
                    if state == 7:
                        state = (11 if x['maggaia_med']<17.6160126 else 12)
                        if state == 11:
                            state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.497500062)  else 16)
                            if state == 15:
                                return 0.0422882661
                            if state == 16:
                                return -0.0379066803
                        if state == 12:
                            state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.506666541)  else 18)
                            if state == 17:
                                return -0.00501302397
                            if state == 18:
                                return 0.0730196163
                    if state == 8:
                        state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0850266516)  else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.799000025)  else 20)
                            if state == 19:
                                return -0.0412503034
                            if state == 20:
                                return 0.0457000956
                        if state == 14:
                            state = (21 if x['maggaia_med']<20.1196842 else 22)
                            if state == 21:
                                return -0.0937750861
                            if state == 22:
                                return -0.00188112061
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.831428468)  else 6)
                if state == 5:
                    return -0.0943186656
                if state == 6:
                    state = (9 if x['sgscore1_med']<0.849580526 else 10)
                    if state == 9:
                        return -0.028042648
                    if state == 10:
                        return 0.0342421457
    elif num_booster == 19:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.342268)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.991484582)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.735000014)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.34830147)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.69083339)  else 22)
                            if state == 21:
                                return -0.0264853276
                            if state == 22:
                                return 0.0350396
                        if state == 16:
                            return -0.0732992589
                    if state == 8:
                        return 0.0518596768
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<18.5269699)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.59578705)  else 18)
                        if state == 17:
                            state = (23 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<15.3787851)  else 24)
                            if state == 23:
                                return 0.0104196761
                            if state == 24:
                                return -0.0472560674
                        if state == 18:
                            state = (25 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.63459587)  else 26)
                            if state == 25:
                                return 0.0650075376
                            if state == 26:
                                return -0.0246029515
                    if state == 10:
                        return 0.0837767497
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.00994778)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.68452406)  else 12)
                    if state == 11:
                        return 0.0477556661
                    if state == 12:
                        return -0.0556464978
                if state == 6:
                    state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.913214326)  else 14)
                    if state == 13:
                        return -0.0986033827
                    if state == 14:
                        return -0.000496848894
    elif num_booster == 20:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.896749973)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.77974999)  else 4)
                if state == 3:
                    return -0.0871895775
                if state == 4:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.791999996)  else 8)
                    if state == 7:
                        return 0.0370404273
                    if state == 8:
                        state = (11 if x['neargaia_med']<9.51260567 else 12)
                        if state == 11:
                            state = (17 if x['sgscore1_med']<0.190556347 else 18)
                            if state == 17:
                                return 0.024666518
                            if state == 18:
                                return -0.0187691022
                        if state == 12:
                            state = (19 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<41.1075363)  else 20)
                            if state == 19:
                                return -0.0653413981
                            if state == 20:
                                return 0.000177803056
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.595927)  else 6)
                if state == 5:
                    state = (9 if x['maggaia_med']<16.455162 else 10)
                    if state == 9:
                        state = (13 if x['maggaia_med']<15.4198256 else 14)
                        if state == 13:
                            return 0.0255443919
                        if state == 14:
                            return -0.0646032616
                    if state == 10:
                        state = (15 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.2958965)  else 16)
                        if state == 15:
                            return 0.0886843726
                        if state == 16:
                            state = (23 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.85146451)  else 24)
                            if state == 23:
                                return 0.033054661
                            if state == 24:
                                return -0.0215357076
                if state == 6:
                    return -0.0821295604
    elif num_booster == 21:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.898499966)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<23.0779457)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.94351482)  else 8)
                    if state == 7:
                        return -0.084708482
                    if state == 8:
                        return 0.00415166467
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8852501)  else 10)
                    if state == 9:
                        state = (13 if x['sgscore1_med']<0.0897561461 else 14)
                        if state == 13:
                            return -0.00331176445
                        if state == 14:
                            return 0.0525165126
                    if state == 10:
                        return -0.0556731373
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.635178506)  else 6)
                if state == 5:
                    state = (11 if x['neargaia_med']<15.6657181 else 12)
                    if state == 11:
                        state = (15 if x['neargaia_med']<9.79543877 else 16)
                        if state == 15:
                            state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<14.7897491)  else 20)
                            if state == 19:
                                return -0.0340515338
                            if state == 20:
                                return 0.0524283499
                        if state == 16:
                            state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.6862488)  else 22)
                            if state == 21:
                                return -0.00510176271
                            if state == 22:
                                return -0.0718929693
                    if state == 12:
                        state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<46.0309906)  else 18)
                        if state == 17:
                            return 0.0801049992
                        if state == 18:
                            state = (23 if x['sgscore1_med']<0.32515201 else 24)
                            if state == 23:
                                return 0.0243988745
                            if state == 24:
                                return -0.0426985063
                if state == 6:
                    return -0.0692782998
    elif num_booster == 22:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.675827)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.646502972)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<19.0471992)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0835841522)  else 12)
                        if state == 11:
                            state = (15 if x['sgscore1_med']<0.017229151 else 16)
                            if state == 15:
                                return -0.00871447567
                            if state == 16:
                                return 0.057303451
                        if state == 12:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<5.97096062)  else 18)
                            if state == 17:
                                return -0.045712769
                            if state == 18:
                                return 0.0269826669
                    if state == 8:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.3769989)  else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<19.2999535)  else 20)
                            if state == 19:
                                return 0.0559122227
                            if state == 20:
                                return -0.0515151285
                        if state == 14:
                            return 0.0864411443
                if state == 4:
                    return -0.0723908097
            if state == 2:
                state = (5 if x['sgscore1_med']<0.00339583494 else 6)
                if state == 5:
                    return -0.000151947097
                if state == 6:
                    return -0.0875877067
    elif num_booster == 23:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.969249964)  else 2)
            if state == 1:
                state = (3 if x['col_det']<0.204384804 else 4)
                if state == 3:
                    state = (7 if x['col_det']<-0.18052578 else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.613666534)  else 16)
                        if state == 15:
                            return 0.0383084826
                        if state == 16:
                            return -0.0262610912
                    if state == 8:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.07377315)  else 18)
                        if state == 17:
                            return -0.0926239118
                        if state == 18:
                            state = (25 if np.isnan(x['t_lc']) or (x['t_lc']<3.59109378)  else 26)
                            if state == 25:
                                return 0.0241784565
                            if state == 26:
                                return -0.0189955011
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.78275001)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.786666751)  else 20)
                        if state == 19:
                            return -0.0596482679
                        if state == 20:
                            return 0.00893297512
                    if state == 10:
                        state = (21 if x['sgscore1_med']<0.966089487 else 22)
                        if state == 21:
                            state = (27 if np.isnan(x['rb_med']) or (x['rb_med']<0.562500119)  else 28)
                            if state == 27:
                                return -0.00120302557
                            if state == 28:
                                return 0.0630659983
                        if state == 22:
                            return -0.0346294306
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.525833368)  else 6)
                if state == 5:
                    state = (11 if x['col_det']<0.119606972 else 12)
                    if state == 11:
                        return 0.0262697693
                    if state == 12:
                        return -0.0928092152
                if state == 6:
                    state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.869202018)  else 14)
                    if state == 13:
                        state = (23 if x['col_det']<-0.467707634 else 24)
                        if state == 23:
                            return -0.0138396937
                        if state == 24:
                            state = (29 if np.isnan(x['t_lc']) or (x['t_lc']<6.05178261)  else 30)
                            if state == 29:
                                return 0.0805074945
                            if state == 30:
                                return -0.00904167537
                    if state == 14:
                        return -0.0366343409
    elif num_booster == 24:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.969249964)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.186650276 else 4)
                if state == 3:
                    return 0.0246021766
                if state == 4:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<3.0126214)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<2.0302546)  else 16)
                        if state == 15:
                            return -0.0465334356
                        if state == 16:
                            return 0.0451659709
                    if state == 10:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.8449993)  else 18)
                        if state == 17:
                            state = (25 if np.isnan(x['col_det']) or (x['col_det']<0.124790192)  else 26)
                            if state == 25:
                                return -0.0759700313
                            if state == 26:
                                return -0.0235957038
                        if state == 18:
                            return 0.00693499483
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.70825)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1612892)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.5844994)  else 20)
                        if state == 19:
                            return -0.0277572833
                        if state == 20:
                            return 0.081339173
                    if state == 12:
                        state = (21 if x['col_det']<0.0767822266 else 22)
                        if state == 21:
                            state = (27 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.1054993)  else 28)
                            if state == 27:
                                return -0.0661382601
                            if state == 28:
                                return 0.0218189713
                        if state == 22:
                            return 0.0517093614
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5305004)  else 14)
                    if state == 13:
                        return -0.0933133736
                    if state == 14:
                        return 0.0461052656
    elif num_booster == 25:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.774999976)  else 2)
            if state == 1:
                return -0.0782162622
            if state == 2:
                state = (3 if x['distpsnr1_med']<0.0951836109 else 4)
                if state == 3:
                    return -0.0712041631
                if state == 4:
                    state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.971249998)  else 6)
                    if state == 5:
                        state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<20.3501015)  else 8)
                        if state == 7:
                            state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.8515511)  else 12)
                            if state == 11:
                                return 0.0248554349
                            if state == 12:
                                return -0.0725169852
                        if state == 8:
                            state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.43873978)  else 14)
                            if state == 13:
                                return 0.0714289695
                            if state == 14:
                                return -0.00518508861
                    if state == 6:
                        state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<18.137001)  else 10)
                        if state == 9:
                            state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.47713375)  else 16)
                            if state == 15:
                                return 0.0190626886
                            if state == 16:
                                return -0.0513227209
                        if state == 10:
                            state = (17 if x['col_det']<-1.31582832 else 18)
                            if state == 17:
                                return -0.0222515929
                            if state == 18:
                                return 0.0825740546
    elif num_booster == 26:
        state = 0
        if state == 0:
            state = (1 if x['col_det']<0.182310104 else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<3.02237272)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<59.728096 else 8)
                    if state == 7:
                        return -0.0778597146
                    if state == 8:
                        return 0.00311029702
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.669881105)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.491666585)  else 16)
                        if state == 15:
                            return 0.0297684465
                        if state == 16:
                            state = (25 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<26.3756847)  else 26)
                            if state == 25:
                                return -0.0594406985
                            if state == 26:
                                return 0.00409035059
                    if state == 10:
                        state = (17 if x['col_det']<-0.000733375549 else 18)
                        if state == 17:
                            state = (27 if np.isnan(x['t_lc']) or (x['t_lc']<6.02448463)  else 28)
                            if state == 27:
                                return 0.0565849729
                            if state == 28:
                                return -0.00253203465
                        if state == 18:
                            state = (29 if x['col_det']<0.11384201 else 30)
                            if state == 29:
                                return -0.0212385897
                            if state == 30:
                                return 0.0176087748
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.536428571)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0674479455)  else 12)
                    if state == 11:
                        return 0.00103371381
                    if state == 12:
                        return -0.0660156012
                if state == 6:
                    state = (13 if x['neargaia_med']<10.1311321 else 14)
                    if state == 13:
                        state = (19 if np.isnan(x['rb_med']) or (x['rb_med']<0.708333254)  else 20)
                        if state == 19:
                            return -0.0462574698
                        if state == 20:
                            state = (31 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0386342481)  else 32)
                            if state == 31:
                                return -0.0107650878
                            if state == 32:
                                return 0.0429269597
                    if state == 14:
                        state = (21 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<60.8982315)  else 22)
                        if state == 21:
                            state = (33 if np.isnan(x['rb_med']) or (x['rb_med']<0.55571425)  else 34)
                            if state == 33:
                                return 0.000306166941
                            if state == 34:
                                return 0.0758457929
                        if state == 22:
                            return -0.00678923633
    elif num_booster == 27:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.0514984)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<16.470068)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<13.8682022 else 8)
                    if state == 7:
                        return -0.0571655445
                    if state == 8:
                        state = (15 if x['distpsnr1_med']<0.551347733 else 16)
                        if state == 15:
                            return -0.0254926719
                        if state == 16:
                            state = (27 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.8732491)  else 28)
                            if state == 27:
                                return 0.0498516485
                            if state == 28:
                                return -0.0145566147
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.561049104 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.96141768)  else 18)
                        if state == 17:
                            return 0.0355082639
                        if state == 18:
                            return -0.032550063
                    if state == 10:
                        return 0.0811161771
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<18.5806904)  else 6)
                if state == 5:
                    state = (11 if x['distpsnr1_med']<8.24716759 else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01104164)  else 20)
                        if state == 19:
                            return -0.0824961662
                        if state == 20:
                            state = (31 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.03695583)  else 32)
                            if state == 31:
                                return 0.028730873
                            if state == 32:
                                return -0.0450516939
                    if state == 12:
                        state = (21 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.4157505)  else 22)
                        if state == 21:
                            return 0.0238685906
                        if state == 22:
                            return -0.0191116147
                if state == 6:
                    state = (13 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92039919)  else 14)
                    if state == 13:
                        state = (23 if x['maggaia_med']<18.8607559 else 24)
                        if state == 23:
                            state = (35 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.043750003)  else 36)
                            if state == 35:
                                return 0.00453912327
                            if state == 36:
                                return -0.0536689609
                        if state == 24:
                            return 0.0162853058
                    if state == 14:
                        state = (25 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.7577496)  else 26)
                        if state == 25:
                            return 0.069521673
                        if state == 26:
                            state = (39 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.8867493)  else 40)
                            if state == 39:
                                return -0.0444044992
                            if state == 40:
                                return 0.0217890684
    elif num_booster == 28:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.7397499)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<3.03145266)  else 8)
                    if state == 7:
                        return 0.0240536127
                    if state == 8:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.2102509)  else 16)
                        if state == 15:
                            return -0.0680424199
                        if state == 16:
                            return 0.0136205601
                if state == 4:
                    state = (9 if x['maggaia_med']<17.3760796 else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.8859997)  else 18)
                        if state == 17:
                            state = (27 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.9295006)  else 28)
                            if state == 27:
                                return -0.0241830554
                            if state == 28:
                                return 0.0510343909
                        if state == 18:
                            return -0.045024354
                    if state == 10:
                        state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<5.98175335)  else 20)
                        if state == 19:
                            return 0.0698642284
                        if state == 20:
                            state = (31 if np.isnan(x['t_lc']) or (x['t_lc']<5.98648167)  else 32)
                            if state == 31:
                                return -0.0451114513
                            if state == 32:
                                return 0.0300986674
            if state == 2:
                state = (5 if x['maggaia_med']<20.3039112 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.816071391)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<5.88322353)  else 22)
                        if state == 21:
                            state = (33 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.0714989)  else 34)
                            if state == 33:
                                return -0.0184653345
                            if state == 34:
                                return -0.0859656185
                        if state == 22:
                            state = (35 if np.isnan(x['t_lc']) or (x['t_lc']<6.00076389)  else 36)
                            if state == 35:
                                return 0.0163206272
                            if state == 36:
                                return -0.0394863226
                    if state == 12:
                        state = (23 if np.isnan(x['rb_med']) or (x['rb_med']<0.93107152)  else 24)
                        if state == 23:
                            return 0.0397826433
                        if state == 24:
                            return -0.0189764332
                if state == 6:
                    state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<5.97904491)  else 14)
                    if state == 13:
                        state = (25 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.984250009)  else 26)
                        if state == 25:
                            state = (37 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.974249959)  else 38)
                            if state == 37:
                                return -0.00775098242
                            if state == 38:
                                return 0.0550674461
                        if state == 26:
                            return -0.0198864918
                    if state == 14:
                        return -0.0410503671
    elif num_booster == 29:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<1.25276625 else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<0.41447562 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<20.2851486)  else 8)
                    if state == 7:
                        return 0.0380042531
                    if state == 8:
                        return -0.0190776754
                if state == 4:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<55.0134239)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['col_det']) or (x['col_det']<0.289577484)  else 14)
                        if state == 13:
                            return -0.0715463832
                        if state == 14:
                            return 0.012082953
                    if state == 10:
                        return 0.0290425532
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<17.6564751)  else 6)
                if state == 5:
                    return -0.0441612862
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<20.4316483)  else 12)
                    if state == 11:
                        state = (15 if x['distpsnr1_med']<2.11146188 else 16)
                        if state == 15:
                            state = (21 if x['col_det']<-0.0551856346 else 22)
                            if state == 21:
                                return -0.0394159891
                            if state == 22:
                                return 0.0232913941
                        if state == 16:
                            state = (23 if np.isnan(x['col_det']) or (x['col_det']<0.169850349)  else 24)
                            if state == 23:
                                return 0.0676871538
                            if state == 24:
                                return -0.000666223757
                    if state == 12:
                        state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<18.9835567)  else 18)
                        if state == 17:
                            return -0.0476654768
                        if state == 18:
                            state = (25 if np.isnan(x['mag_det']) or (x['mag_det']<20.58395)  else 26)
                            if state == 25:
                                return -0.0228853989
                            if state == 26:
                                return 0.0324863717
    elif num_booster == 30:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5919151)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.4622498)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<18.9820824)  else 8)
                    if state == 7:
                        return -0.0607945323
                    if state == 8:
                        return 0.0118601155
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.1172485)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<2.48501158)  else 14)
                        if state == 13:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<1.98324656)  else 18)
                            if state == 17:
                                return 0.0314598791
                            if state == 18:
                                return -0.0387453698
                        if state == 14:
                            return 0.08546298
                    if state == 10:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<3.47063065)  else 16)
                        if state == 15:
                            state = (19 if x['distpsnr1_med']<13.864563 else 20)
                            if state == 19:
                                return -0.0746313781
                            if state == 20:
                                return 0.0241067503
                        if state == 16:
                            state = (21 if np.isnan(x['mag_last']) or (x['mag_last']<17.319931)  else 22)
                            if state == 21:
                                return -0.00539514283
                            if state == 22:
                                return 0.0651106462
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<2.49837399)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.9796295)  else 12)
                    if state == 11:
                        return 0.0291175973
                    if state == 12:
                        return -0.0346009172
                if state == 6:
                    return -0.0886074901
    elif num_booster == 31:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<7.35167456 else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<5.98759842)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<3.02767944)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.963500023)  else 16)
                        if state == 15:
                            return 0.0214788914
                        if state == 16:
                            return -0.0265574381
                    if state == 8:
                        return -0.0722103193
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.1620007)  else 10)
                    if state == 9:
                        return 0.0266625155
                    if state == 10:
                        return -0.0236824118
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.2172508)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.969249964)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.705500007)  else 18)
                        if state == 17:
                            return -0.0473538302
                        if state == 18:
                            state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.873250008)  else 24)
                            if state == 23:
                                return 0.0381906256
                            if state == 24:
                                return -0.0207932629
                    if state == 12:
                        state = (19 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<44.583744)  else 20)
                        if state == 19:
                            return 0.0768126622
                        if state == 20:
                            return -0.0300118849
                if state == 6:
                    state = (13 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<34.1575165)  else 14)
                    if state == 13:
                        state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<2.9689815)  else 22)
                        if state == 21:
                            return 0.0257741325
                        if state == 22:
                            return -0.0659723654
                    if state == 14:
                        return 0.0435276367
    elif num_booster == 32:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<-0.128979683)  else 2)
            if state == 1:
                state = (3 if x['sgscore1_med']<0.0502291508 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.188343)  else 8)
                    if state == 7:
                        return 0.0689270273
                    if state == 8:
                        return -0.015792802
                if state == 4:
                    state = (9 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<29.3721104)  else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['col_det']) or (x['col_det']<-0.235022545)  else 20)
                        if state == 19:
                            state = (31 if x['sgscore1_med']<0.199092001 else 32)
                            if state == 31:
                                return -0.00311149773
                            if state == 32:
                                return -0.0608173944
                        if state == 20:
                            return 0.016231617
                    if state == 10:
                        state = (21 if x['neargaia_med']<54.6856689 else 22)
                        if state == 21:
                            return 0.0582993776
                        if state == 22:
                            return -0.00907900836
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<37.7223015)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00208333135)  else 12)
                    if state == 11:
                        return 0.0106165018
                    if state == 12:
                        state = (25 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.65974498)  else 26)
                        if state == 25:
                            state = (33 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.08669972)  else 34)
                            if state == 33:
                                return -0.0423604064
                            if state == 34:
                                return 0.0100176344
                        if state == 26:
                            return -0.0865957439
                if state == 6:
                    state = (13 if x['sgscore1_med']<0.280372024 else 14)
                    if state == 13:
                        state = (27 if x['sgscore1_med']<0.0218333155 else 28)
                        if state == 27:
                            return -0.00979452021
                        if state == 28:
                            return 0.0351053551
                    if state == 14:
                        return -0.0221326966
    elif num_booster == 33:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.664720297)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.638313293)  else 4)
                if state == 3:
                    return -0.0700182542
                if state == 4:
                    return 0.0023168996
            if state == 2:
                state = (5 if x['col_det']<0.194000244 else 6)
                if state == 5:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.6779251)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.618071496)  else 12)
                        if state == 11:
                            state = (19 if x['col_det']<0.0699329376 else 20)
                            if state == 19:
                                return 0.0562803671
                            if state == 20:
                                return -0.0226747934
                        if state == 12:
                            return -0.0321138948
                    if state == 8:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.34409142)  else 14)
                        if state == 13:
                            state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.81069541)  else 22)
                            if state == 21:
                                return -0.0371900536
                            if state == 22:
                                return 0.0139945541
                        if state == 14:
                            state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.93175)  else 24)
                            if state == 23:
                                return 0.00397946686
                            if state == 24:
                                return -0.0902163684
                if state == 6:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.1026344)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.57487869)  else 16)
                        if state == 15:
                            state = (25 if x['sgscore1_med']<0.0171874855 else 26)
                            if state == 25:
                                return 0.0258792266
                            if state == 26:
                                return -0.074560903
                        if state == 16:
                            state = (27 if x['col_det']<0.324761391 else 28)
                            if state == 27:
                                return -0.0293203164
                            if state == 28:
                                return 0.0429996178
                    if state == 10:
                        state = (17 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.35700893)  else 18)
                        if state == 17:
                            return 0.0638660789
                        if state == 18:
                            state = (29 if np.isnan(x['distnr_med']) or (x['distnr_med']<5.62652969)  else 30)
                            if state == 29:
                                return -0.0193530787
                            if state == 30:
                                return 0.0241871122
    elif num_booster == 34:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.775749981)  else 2)
            if state == 1:
                return -0.0699469224
            if state == 2:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.2672997)  else 4)
                if state == 3:
                    state = (5 if x['neargaia_med']<37.5809135 else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98570609)  else 10)
                        if state == 9:
                            return -0.0783319622
                        if state == 10:
                            state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<17.6970501)  else 18)
                            if state == 17:
                                return -0.0190839805
                            if state == 18:
                                return 0.0208606906
                    if state == 6:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.956499994)  else 12)
                        if state == 11:
                            return -0.0308941063
                        if state == 12:
                            return 0.0465365537
                if state == 4:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97260427)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.594178498)  else 14)
                        if state == 13:
                            state = (19 if x['sgscore1_med']<0.00889583491 else 20)
                            if state == 19:
                                return 0.00404808251
                            if state == 20:
                                return 0.0781648979
                        if state == 14:
                            return -0.0180949047
                    if state == 8:
                        state = (15 if x['sgscore1_med']<0.0987591445 else 16)
                        if state == 15:
                            return 0.0377094373
                        if state == 16:
                            return -0.0416422412
    elif num_booster == 35:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.527322352 else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<42.4055023)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<0.215192646 else 8)
                    if state == 7:
                        return 0.00885210279
                    if state == 8:
                        return -0.0696675256
                if state == 4:
                    return 0.0259416867
            if state == 2:
                state = (5 if np.isnan(x['col_det']) or (x['col_det']<-0.133877754)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.662871957)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.6080513)  else 16)
                        if state == 15:
                            state = (23 if x['sgscore1_med']<0.00300000003 else 24)
                            if state == 23:
                                return -0.00364630576
                            if state == 24:
                                return 0.0839892775
                        if state == 16:
                            return -0.0211037006
                    if state == 10:
                        return -0.0349454917
                if state == 6:
                    state = (11 if x['col_det']<0.00978469849 else 12)
                    if state == 11:
                        state = (19 if x['neargaia_med']<11.8189907 else 20)
                        if state == 19:
                            return 0.00160771888
                        if state == 20:
                            return -0.0655332804
                    if state == 12:
                        state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<18.7939491)  else 22)
                        if state == 21:
                            return -0.0463017896
                        if state == 22:
                            state = (27 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0205832999)  else 28)
                            if state == 27:
                                return -0.0158326849
                            if state == 28:
                                return 0.0678629577
    elif num_booster == 36:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<2.06142569 else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.912999988)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.876071393)  else 8)
                    if state == 7:
                        return -0.060389813
                    if state == 8:
                        return 0.00223637535
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.160719007 else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.8922501)  else 14)
                        if state == 13:
                            return 0.0245225225
                        if state == 14:
                            return -0.0707001165
                    if state == 10:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.3315001)  else 16)
                        if state == 15:
                            return -0.024349751
                        if state == 16:
                            state = (19 if x['distpsnr1_med']<1.49658179 else 20)
                            if state == 19:
                                return 0.0661981404
                            if state == 20:
                                return 0.00406999746
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.760500014)  else 6)
                if state == 5:
                    return -0.0471840948
                if state == 6:
                    state = (11 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<15.6583652)  else 12)
                    if state == 11:
                        return 0.0771265849
                    if state == 12:
                        return -0.00756739965
    elif num_booster == 37:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.897249997)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.0924901962)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<6.01501179)  else 8)
                    if state == 7:
                        return -0.0682616383
                    if state == 8:
                        return -0.00296573085
                if state == 4:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.698571503)  else 10)
                    if state == 9:
                        return -0.0313043483
                    if state == 10:
                        return 0.0369549207
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.6685009)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<5.90786457)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.920000017)  else 18)
                        if state == 17:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.689166546)  else 22)
                            if state == 21:
                                return -0.0088202972
                            if state == 22:
                                return -0.0598284565
                        if state == 18:
                            return 0.0341702402
                    if state == 12:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<17.9264259)  else 20)
                        if state == 19:
                            return -0.00732823974
                        if state == 20:
                            return 0.048478879
                if state == 6:
                    return 0.0659166649
    elif num_booster == 38:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.540593863 else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<0.225907996 else 4)
                if state == 3:
                    return 0.0244837236
                if state == 4:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<26.1113663)  else 8)
                    if state == 7:
                        return -0.0760282949
                    if state == 8:
                        return 0.00890156813
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.29315615)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.74995375)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.955478907)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.673115611)  else 24)
                            if state == 23:
                                return -0.0261575077
                            if state == 24:
                                return 0.056636598
                        if state == 16:
                            state = (25 if x['neargaia_med']<35.8311882 else 26)
                            if state == 25:
                                return -0.055802349
                            if state == 26:
                                return 0.013440487
                    if state == 10:
                        state = (17 if x['neargaia_med']<10.1527023 else 18)
                        if state == 17:
                            state = (27 if x['distpsnr1_med']<2.72651196 else 28)
                            if state == 27:
                                return 0.0220548157
                            if state == 28:
                                return -0.0285739508
                        if state == 18:
                            return 0.0610486828
                if state == 6:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00546288)  else 12)
                    if state == 11:
                        state = (19 if x['neargaia_med']<40.2368164 else 20)
                        if state == 19:
                            return -0.0626654923
                        if state == 20:
                            return 0.0134659559
                    if state == 12:
                        return 0.0262974929
    elif num_booster == 39:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5176125)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.8146)  else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<7.62608957 else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.9799995)  else 14)
                        if state == 13:
                            state = (21 if x['distpsnr1_med']<1.37964988 else 22)
                            if state == 21:
                                return -0.0322928429
                            if state == 22:
                                return 0.0272341594
                        if state == 14:
                            return -0.0622173548
                    if state == 8:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.809)  else 16)
                        if state == 15:
                            return 0.0270623099
                        if state == 16:
                            return -0.023572024
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6350002)  else 10)
                    if state == 9:
                        state = (17 if x['distpsnr1_med']<0.25751704 else 18)
                        if state == 17:
                            state = (23 if np.isnan(x['mag_det']) or (x['mag_det']<19.7693996)  else 24)
                            if state == 23:
                                return 0.0219627488
                            if state == 24:
                                return -0.0198962986
                        if state == 18:
                            return 0.0809819847
                    if state == 10:
                        state = (19 if x['distpsnr1_med']<11.2860069 else 20)
                        if state == 19:
                            return -0.0425204858
                        if state == 20:
                            return 0.0300342403
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.95431328)  else 6)
                if state == 5:
                    return -0.0949078798
                if state == 6:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.7462425)  else 12)
                    if state == 11:
                        return 0.0384595543
                    if state == 12:
                        return -0.0304905735
    elif num_booster == 40:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.13579035)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.6732712)  else 8)
                    if state == 7:
                        return -0.0621187165
                    if state == 8:
                        state = (13 if x['maggaia_med']<19.371273 else 14)
                        if state == 13:
                            return 0.0393751077
                        if state == 14:
                            return -0.0314789452
                if state == 4:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.595927)  else 10)
                    if state == 9:
                        state = (15 if x['maggaia_med']<17.3711052 else 16)
                        if state == 15:
                            state = (21 if x['neargaia_med']<31.6950607 else 22)
                            if state == 21:
                                return -0.0301651154
                            if state == 22:
                                return 0.015308572
                        if state == 16:
                            state = (23 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.16763306)  else 24)
                            if state == 23:
                                return 0.060398072
                            if state == 24:
                                return -0.0135039575
                    if state == 10:
                        state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<12.8971672)  else 18)
                        if state == 17:
                            return -0.05065028
                        if state == 18:
                            state = (25 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.637426376)  else 26)
                            if state == 25:
                                return -0.0177781451
                            if state == 26:
                                return 0.0223978274
            if state == 2:
                state = (5 if x['sgscore1_med']<0.0409583524 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.957249999)  else 12)
                    if state == 11:
                        return -0.0235258806
                    if state == 12:
                        return 0.0250441898
                if state == 6:
                    return -0.0827554315
    elif num_booster == 41:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<3.04123259)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<3.04048038)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<25.1105022)  else 14)
                        if state == 13:
                            return -0.0393639356
                        if state == 14:
                            return 0.0082928529
                    if state == 8:
                        return 0.0264276899
                if state == 4:
                    return -0.0565315187
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6467476)  else 6)
                if state == 5:
                    state = (9 if x['neargaia_med']<6.9923172 else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.97724998)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.3752518)  else 24)
                            if state == 23:
                                return 0.00654723728
                            if state == 24:
                                return -0.04667034
                        if state == 16:
                            return 0.029095985
                    if state == 10:
                        state = (17 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.635414481)  else 18)
                        if state == 17:
                            state = (27 if x['neargaia_med']<25.6365089 else 28)
                            if state == 27:
                                return -0.0238659084
                            if state == 28:
                                return 0.0287154652
                        if state == 18:
                            state = (29 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<27.4741096)  else 30)
                            if state == 29:
                                return 0.0670225248
                            if state == 30:
                                return 0.0128718251
                if state == 6:
                    state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<10.2602558)  else 12)
                    if state == 11:
                        return 0.0235708468
                    if state == 12:
                        state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.3325541)  else 22)
                        if state == 21:
                            return -0.050210841
                        if state == 22:
                            return 0.00485702511
    elif num_booster == 42:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5919151)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.3045006)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.3214989)  else 8)
                    if state == 7:
                        return -0.0423922241
                    if state == 8:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.981250048)  else 14)
                        if state == 13:
                            return 0.0733400211
                        if state == 14:
                            state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.7757492)  else 18)
                            if state == 17:
                                return 0.0456722528
                            if state == 18:
                                return -0.0230951216
                if state == 4:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00193286)  else 10)
                    if state == 9:
                        return -0.0506249033
                    if state == 10:
                        return 0.0179115534
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.00994778)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.760500014)  else 12)
                    if state == 11:
                        return -0.0223615952
                    if state == 12:
                        return 0.0400605239
                if state == 6:
                    return -0.0750272945
    elif num_booster == 43:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6509857)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.554510474)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<18.2046623)  else 8)
                    if state == 7:
                        state = (9 if x['sgscore1_med']<0.380916476 else 10)
                        if state == 9:
                            state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<3.08743644)  else 14)
                            if state == 13:
                                return -0.0429023691
                            if state == 14:
                                return 0.0171389766
                        if state == 10:
                            return 0.0376547016
                    if state == 8:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.769249976)  else 12)
                        if state == 11:
                            return -0.00208379468
                        if state == 12:
                            return 0.0710624978
                if state == 4:
                    return -0.0638230965
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.619455993)  else 6)
                if state == 5:
                    return 0.0265852436
                if state == 6:
                    return -0.070366554
    elif num_booster == 44:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6089268)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<2.47495961)  else 4)
                if state == 3:
                    return -0.0409100913
                if state == 4:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.669193029)  else 10)
                    if state == 9:
                        state = (11 if x['neargaia_med']<1.39869297 else 12)
                        if state == 11:
                            state = (15 if x['maggaia_med']<17.3315735 else 16)
                            if state == 15:
                                return -0.0229316205
                            if state == 16:
                                return 0.0390194654
                        if state == 12:
                            return 0.066413112
                    if state == 10:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<3.08267355)  else 14)
                        if state == 13:
                            return 0.00957628805
                        if state == 14:
                            return -0.0490304716
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<0.581747711)  else 6)
                if state == 5:
                    return -0.00327916467
                if state == 6:
                    return -0.0752557591
    elif num_booster == 45:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8400002)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.5022507)  else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<3.04839945 else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['col_det']) or (x['col_det']<0.306591988)  else 16)
                        if state == 15:
                            state = (27 if np.isnan(x['t_lc']) or (x['t_lc']<5.97449064)  else 28)
                            if state == 27:
                                return -0.0510149039
                            if state == 28:
                                return 0.00906604063
                        if state == 16:
                            return 0.00603237841
                    if state == 8:
                        return 0.0352331065
                if state == 4:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<5.19899559)  else 10)
                    if state == 9:
                        return 0.0582998991
                    if state == 10:
                        return -0.0151657481
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.66882801)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<2.98511004)  else 12)
                    if state == 11:
                        return 0.0087366458
                    if state == 12:
                        state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<5.97697926)  else 22)
                        if state == 21:
                            return -0.0605759732
                        if state == 22:
                            state = (33 if np.isnan(x['t_lc']) or (x['t_lc']<6.01729727)  else 34)
                            if state == 33:
                                return 0.0168395117
                            if state == 34:
                                return -0.0312132109
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.0812492)  else 14)
                    if state == 13:
                        return 0.0351128653
                    if state == 14:
                        state = (25 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9344997)  else 26)
                        if state == 25:
                            return -0.0400535055
                        if state == 26:
                            return 0.0231890921
    elif num_booster == 46:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.796547651)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.3610001)  else 4)
                if state == 3:
                    return -0.037955299
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.7397499)  else 10)
                    if state == 9:
                        return 0.0586068146
                    if state == 10:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9127502)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.994751)  else 24)
                            if state == 23:
                                return 0.00719609903
                            if state == 24:
                                return -0.0392977819
                        if state == 16:
                            return 0.0370436907
            if state == 2:
                state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.948214173)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.2457504)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.52243638)  else 18)
                        if state == 17:
                            return 0.00293032709
                        if state == 18:
                            return -0.0879879147
                    if state == 12:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97844911)  else 20)
                        if state == 19:
                            return -0.0211279336
                        if state == 20:
                            return 0.0376026779
                if state == 6:
                    return 0.0327331796
    elif num_booster == 47:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.1499996)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<5.97335625)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['col_det']) or (x['col_det']<0.420744896)  else 8)
                    if state == 7:
                        return -0.0748393163
                    if state == 8:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<3.13845491)  else 16)
                        if state == 15:
                            return -0.0236490034
                        if state == 16:
                            return 0.0190639254
                if state == 4:
                    return 0.0378148928
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.8746986)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<9.16888237)  else 10)
                    if state == 9:
                        state = (17 if x['col_det']<-0.25304985 else 18)
                        if state == 17:
                            return -0.00446737325
                        if state == 18:
                            return 0.0538971871
                    if state == 10:
                        return -0.0379867293
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.97225)  else 12)
                    if state == 11:
                        return -0.0808294863
                    if state == 12:
                        state = (19 if np.isnan(x['col_det']) or (x['col_det']<0.377364159)  else 20)
                        if state == 19:
                            state = (23 if np.isnan(x['col_det']) or (x['col_det']<-0.182621002)  else 24)
                            if state == 23:
                                return 0.0152726686
                            if state == 24:
                                return -0.0330135897
                        if state == 20:
                            return 0.039411664
    elif num_booster == 48:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.100562349)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.494642973)  else 4)
                if state == 3:
                    return -0.0404116102
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.685500026)  else 10)
                    if state == 9:
                        return -0.0180605892
                    if state == 10:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.911071539)  else 16)
                        if state == 15:
                            state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0616377518)  else 22)
                            if state == 21:
                                return 0.00566547457
                            if state == 22:
                                return 0.0605601072
                        if state == 16:
                            state = (23 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.970999956)  else 24)
                            if state == 23:
                                return -0.028588213
                            if state == 24:
                                return 0.0299015939
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.53171825)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.758333206)  else 12)
                    if state == 11:
                        return -0.0700303838
                    if state == 12:
                        return 0.00119062478
                if state == 6:
                    state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.19795036)  else 14)
                    if state == 13:
                        state = (19 if x['sgscore1_med']<0.172418743 else 20)
                        if state == 19:
                            return -0.00407722173
                        if state == 20:
                            return 0.0569004864
                    if state == 14:
                        return -0.0538584217
    elif num_booster == 49:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5742683)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<17.3315735 else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<1.41102707 else 8)
                    if state == 7:
                        return -0.0555162691
                    if state == 8:
                        return 0.0133905457
                if state == 4:
                    state = (9 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.73937988)  else 10)
                    if state == 9:
                        state = (13 if x['distpsnr1_med']<0.0906085819 else 14)
                        if state == 13:
                            return -0.0265223347
                        if state == 14:
                            return 0.0623719096
                    if state == 10:
                        state = (15 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<18.7727661)  else 16)
                        if state == 15:
                            state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<19.421524)  else 20)
                            if state == 19:
                                return 0.0491062477
                            if state == 20:
                                return -0.0196667947
                        if state == 16:
                            state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92534733)  else 22)
                            if state == 21:
                                return 0.00774162216
                            if state == 22:
                                return -0.0493827425
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.39267933)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.564681709)  else 12)
                    if state == 11:
                        return -0.0295959767
                    if state == 12:
                        return 0.0368112661
                if state == 6:
                    return -0.0742325708
    elif num_booster == 50:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.46034801)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<15.8921165)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.817500234)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<20.4304619)  else 12)
                        if state == 11:
                            return -0.0649907961
                        if state == 12:
                            state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<20.6469994)  else 18)
                            if state == 17:
                                return 0.0220807288
                            if state == 18:
                                return -0.0192092992
                    if state == 8:
                        return 0.00921222661
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.00438690465 else 10)
                    if state == 9:
                        return -0.0266205035
                    if state == 10:
                        state = (15 if x['distpsnr1_med']<0.25751704 else 16)
                        if state == 15:
                            state = (19 if x['maggaia_med']<18.8798599 else 20)
                            if state == 19:
                                return 0.0146119809
                            if state == 20:
                                return -0.0330800861
                        if state == 16:
                            state = (21 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.127726495)  else 22)
                            if state == 21:
                                return 0.0588289201
                            if state == 22:
                                return 0.00550588407
            if state == 2:
                state = (5 if x['maggaia_med']<20.1981621 else 6)
                if state == 5:
                    return -0.0799997523
                if state == 6:
                    return 0.0343746319
    elif num_booster == 51:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<0.176815987)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<4.92926741)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.53812885)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8427505)  else 12)
                        if state == 11:
                            state = (19 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.0830002)  else 20)
                            if state == 19:
                                return -0.0186947007
                            if state == 20:
                                return 0.0399557725
                        if state == 12:
                            state = (21 if np.isnan(x['rb_med']) or (x['rb_med']<0.582618892)  else 22)
                            if state == 21:
                                return 0.0173313189
                            if state == 22:
                                return -0.0350134782
                    if state == 8:
                        state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.690952301)  else 14)
                        if state == 13:
                            return 0.0102355154
                        if state == 14:
                            return -0.0720167533
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.0812492)  else 10)
                    if state == 9:
                        return 0.0583267473
                    if state == 10:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9127502)  else 18)
                        if state == 17:
                            return -0.0325834379
                        if state == 18:
                            return 0.0355287902
            if state == 2:
                return -0.056965135
    elif num_booster == 52:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976750016)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0273784511)  else 4)
                if state == 3:
                    return 0.0415727161
                if state == 4:
                    state = (7 if x['col_det']<-0.0398607254 else 8)
                    if state == 7:
                        state = (11 if x['col_det']<-0.263000011 else 12)
                        if state == 11:
                            return -0.021254573
                        if state == 12:
                            return 0.0276648141
                    if state == 8:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<20.7317009)  else 14)
                        if state == 13:
                            state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<2.99115181)  else 20)
                            if state == 19:
                                return -0.00349018537
                            if state == 20:
                                return -0.0689613596
                        if state == 14:
                            state = (21 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.728250027)  else 22)
                            if state == 21:
                                return -0.0212386101
                            if state == 22:
                                return 0.0279189851
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.06264472)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<18.1286011)  else 10)
                    if state == 9:
                        state = (15 if np.isnan(x['col_det']) or (x['col_det']<-0.295884609)  else 16)
                        if state == 15:
                            return -0.02527426
                        if state == 16:
                            return 0.0253995061
                    if state == 10:
                        return 0.059273798
                if state == 6:
                    return -0.0470099673
    elif num_booster == 53:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.740799)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.31632948)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.45814812)  else 6)
                    if state == 5:
                        return -0.0568618029
                    if state == 6:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<18.1323738)  else 12)
                        if state == 11:
                            return -0.0190139953
                        if state == 12:
                            state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.877250016)  else 18)
                            if state == 17:
                                return -0.00772535894
                            if state == 18:
                                return 0.0433758013
                if state == 4:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.975250006)  else 8)
                    if state == 7:
                        return 0.0748013332
                    if state == 8:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.57868671)  else 14)
                        if state == 13:
                            return 0.0488936417
                        if state == 14:
                            state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.985249996)  else 20)
                            if state == 19:
                                return -0.0451778658
                            if state == 20:
                                return 0.034427397
            if state == 2:
                return -0.0663745105
    elif num_booster == 54:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.844944)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<17.8401489)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91608214)  else 6)
                    if state == 5:
                        return 0.0150289787
                    if state == 6:
                        return -0.0429055877
                if state == 4:
                    state = (7 if x['maggaia_med']<15.8921165 else 8)
                    if state == 7:
                        state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.1364937)  else 10)
                        if state == 9:
                            return -0.0510486029
                        if state == 10:
                            return 0.0317514762
                    if state == 8:
                        state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.1063714)  else 12)
                        if state == 11:
                            state = (13 if np.isnan(x['col_det']) or (x['col_det']<0.579547882)  else 14)
                            if state == 13:
                                return 0.0576655231
                            if state == 14:
                                return -0.0132167321
                        if state == 12:
                            return -0.0257183425
            if state == 2:
                return -0.060561154
    elif num_booster == 55:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.7136904)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0788002)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<5.94351864)  else 8)
                    if state == 7:
                        return -0.0685531721
                    if state == 8:
                        return 0.0145126432
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.1028996)  else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['mag_det']) or (x['mag_det']<19.5755081)  else 14)
                        if state == 13:
                            state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.20868397)  else 22)
                            if state == 21:
                                return 0.0244450513
                            if state == 22:
                                return -0.026424069
                        if state == 14:
                            return 0.0416613631
                    if state == 10:
                        state = (15 if x['neargaia_med']<9.3370533 else 16)
                        if state == 15:
                            return 0.0316833258
                        if state == 16:
                            state = (25 if x['neargaia_med']<59.0798683 else 26)
                            if state == 25:
                                return -0.0392087325
                            if state == 26:
                                return 0.00240196893
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.00751162)  else 6)
                if state == 5:
                    return 0.0658626705
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.9729004)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<3.03065395)  else 18)
                        if state == 17:
                            return -0.00714772567
                        if state == 18:
                            return 0.0455519147
                    if state == 12:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.5001488)  else 20)
                        if state == 19:
                            return -0.0415340327
                        if state == 20:
                            return 0.020614326
    elif num_booster == 56:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<2.06142569 else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<54.5914001)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<0.197839886 else 8)
                    if state == 7:
                        return 0.00283292891
                    if state == 8:
                        state = (13 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.2148666)  else 14)
                        if state == 13:
                            return -0.0730554089
                        if state == 14:
                            return -0.00100100832
                if state == 4:
                    return 0.00843847357
            if state == 2:
                state = (5 if x['maggaia_med']<19.4438782 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.0774994)  else 10)
                    if state == 9:
                        state = (15 if x['col_det']<-0.247120857 else 16)
                        if state == 15:
                            return 0.022556508
                        if state == 16:
                            return -0.0308950171
                    if state == 10:
                        state = (17 if x['neargaia_med']<47.0292664 else 18)
                        if state == 17:
                            return 0.0611385629
                        if state == 18:
                            return -0.0162732545
                if state == 6:
                    state = (11 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.35421658)  else 12)
                    if state == 11:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.1516628)  else 20)
                        if state == 19:
                            return 0.0281363409
                        if state == 20:
                            return -0.0198017657
                    if state == 12:
                        state = (21 if x['distpsnr1_med']<7.77214432 else 22)
                        if state == 21:
                            return -0.0617874712
                        if state == 22:
                            return 0.00531804841
    elif num_booster == 57:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.25751704 else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.594496489)  else 4)
                if state == 3:
                    return 0.00456483755
                if state == 4:
                    return -0.049669452
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.692250013)  else 6)
                if state == 5:
                    return -0.0375162996
                if state == 6:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.955776989)  else 10)
                    if state == 9:
                        state = (11 if np.isnan(x['col_det']) or (x['col_det']<-0.125032425)  else 12)
                        if state == 11:
                            return 0.0632562935
                        if state == 12:
                            state = (15 if x['sgscore1_med']<0.00931250025 else 16)
                            if state == 15:
                                return -0.0387210064
                            if state == 16:
                                return 0.0320177674
                    if state == 10:
                        return -0.0370180868
    elif num_booster == 58:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.2434654 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.915357232)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<38.4298553 else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<18.7401619)  else 12)
                        if state == 11:
                            state = (17 if x['neargaia_med']<16.4778595 else 18)
                            if state == 17:
                                return -0.0242505912
                            if state == 18:
                                return 0.0262446273
                        if state == 12:
                            state = (19 if x['maggaia_med']<15.3532276 else 20)
                            if state == 19:
                                return 0.00612633629
                            if state == 20:
                                return -0.080353789
                    if state == 8:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.8496437)  else 14)
                        if state == 13:
                            return 0.0266011395
                        if state == 14:
                            return -0.0176050812
                if state == 4:
                    return 0.0427116081
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.7425117)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.73731518)  else 10)
                    if state == 9:
                        return 0.06864281
                    if state == 10:
                        return -0.0191599205
                if state == 6:
                    return -0.0321913362
    elif num_booster == 59:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<5.99584484)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.202489927)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.455833256)  else 8)
                    if state == 7:
                        return -0.025985539
                    if state == 8:
                        return 0.0433278009
                if state == 4:
                    state = (9 if x['neargaia_med']<35.9335899 else 10)
                    if state == 9:
                        state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.434523523)  else 14)
                        if state == 13:
                            return 0.00950899627
                        if state == 14:
                            return -0.0456118807
                    if state == 10:
                        return 0.0119546875
            if state == 2:
                state = (5 if x['neargaia_med']<54.5220413 else 6)
                if state == 5:
                    return 0.0462094955
                if state == 6:
                    return -0.00312706223
    elif num_booster == 60:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.740799)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<17.7785263 else 4)
                if state == 3:
                    state = (5 if np.isnan(x['rb_med']) or (x['rb_med']<0.738333344)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.1609058)  else 10)
                        if state == 9:
                            state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.50000006)  else 18)
                            if state == 17:
                                return 0.00175488449
                            if state == 18:
                                return -0.0817850381
                        if state == 10:
                            return 0.0270333905
                    if state == 6:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.3912888)  else 12)
                        if state == 11:
                            return 0.0422123894
                        if state == 12:
                            return -0.0405251011
                if state == 4:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.909832)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.221755996)  else 14)
                        if state == 13:
                            return -0.0140305953
                        if state == 14:
                            state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<6.04255199)  else 20)
                            if state == 19:
                                return 0.0613176525
                            if state == 20:
                                return -0.00842323899
                    if state == 8:
                        state = (15 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.2518845)  else 16)
                        if state == 15:
                            return 0.0388776585
                        if state == 16:
                            return -0.038804844
            if state == 2:
                return -0.0568186902
    elif num_booster == 61:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.0366249979 else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<-0.0502796173)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_det']) or (x['mag_det']<20.5493011)  else 8)
                    if state == 7:
                        return 0.0551626682
                    if state == 8:
                        return -0.000790613296
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.7712498)  else 10)
                    if state == 9:
                        return 0.0203824937
                    if state == 10:
                        return -0.0219492503
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.24282312)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.53171825)  else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['mag_det']) or (x['mag_det']<19.2629013)  else 18)
                        if state == 17:
                            return -0.0503665581
                        if state == 18:
                            state = (25 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.743149042)  else 26)
                            if state == 25:
                                return -0.0343738794
                            if state == 26:
                                return 0.029642975
                    if state == 12:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.0747604)  else 20)
                        if state == 19:
                            state = (27 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.3190968)  else 28)
                            if state == 27:
                                return 0.0500673503
                            if state == 28:
                                return -0.000633295043
                        if state == 20:
                            state = (29 if np.isnan(x['mag_det']) or (x['mag_det']<20.3405628)  else 30)
                            if state == 29:
                                return -0.0297593772
                            if state == 30:
                                return 0.0143548911
                if state == 6:
                    state = (13 if x['sgscore1_med']<0.804780006 else 14)
                    if state == 13:
                        return -0.0968422666
                    if state == 14:
                        state = (21 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.90398252)  else 22)
                        if state == 21:
                            return 0.0215411857
                        if state == 22:
                            return -0.0334207267
    elif num_booster == 62:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97054982)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.91377902)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.041979149)  else 8)
                    if state == 7:
                        return 0.0290720053
                    if state == 8:
                        state = (17 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0146666504)  else 18)
                        if state == 17:
                            state = (25 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<37.1749191)  else 26)
                            if state == 25:
                                return 0.0244758651
                            if state == 26:
                                return -0.0215939451
                        if state == 18:
                            return -0.0502760075
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.554510474 else 10)
                    if state == 9:
                        return 0.0635000542
                    if state == 10:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.93515635)  else 20)
                        if state == 19:
                            return 0.0230873097
                        if state == 20:
                            return -0.0328381211
            if state == 2:
                state = (5 if x['maggaia_med']<17.4557076 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.00608333526)  else 12)
                    if state == 11:
                        return -0.0160480924
                    if state == 12:
                        return 0.0330470949
                if state == 6:
                    state = (13 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.7747726)  else 14)
                    if state == 13:
                        state = (21 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<1.78636336)  else 22)
                        if state == 21:
                            state = (29 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97987843)  else 30)
                            if state == 29:
                                return -0.0349221788
                            if state == 30:
                                return 0.0230213758
                        if state == 22:
                            return -0.0794493258
                    if state == 14:
                        return 0.00431021443
    elif num_booster == 63:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.1473503)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.92793417)  else 4)
                if state == 3:
                    return -0.0669286698
                if state == 4:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<44.0109863)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.3267498)  else 12)
                        if state == 11:
                            state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.7002487)  else 16)
                            if state == 15:
                                return -0.0101219593
                            if state == 16:
                                return 0.0486842915
                        if state == 12:
                            return -0.015813956
                    if state == 8:
                        return -0.0452729501
            if state == 2:
                state = (5 if x['sgscore1_med']<0.989062488 else 6)
                if state == 5:
                    state = (9 if x['neargaia_med']<5.03945971 else 10)
                    if state == 9:
                        return -0.00833601225
                    if state == 10:
                        return 0.0411666669
                if state == 6:
                    return -0.0334202014
    elif num_booster == 64:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.70649767)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<1.90092158 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.970999956)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.290936053)  else 14)
                        if state == 13:
                            return 0.00755418837
                        if state == 14:
                            state = (23 if np.isnan(x['col_det']) or (x['col_det']<0.106790066)  else 24)
                            if state == 23:
                                return -0.0596279129
                            if state == 24:
                                return 0.00856967643
                    if state == 8:
                        state = (15 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.983250022)  else 16)
                        if state == 15:
                            return 0.0399318002
                        if state == 16:
                            return -0.0328272469
                if state == 4:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.9877472)  else 10)
                    if state == 9:
                        state = (17 if x['distpsnr1_med']<24.6093864 else 18)
                        if state == 17:
                            return 0.0487451106
                        if state == 18:
                            return -0.00679808343
                    if state == 10:
                        state = (19 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.978250027)  else 20)
                        if state == 19:
                            return -0.0260882042
                        if state == 20:
                            return 0.0211880673
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<8.01439953)  else 6)
                if state == 5:
                    return -0.0827728137
                if state == 6:
                    state = (11 if x['distpsnr1_med']<8.82945633 else 12)
                    if state == 11:
                        return 0.0371429808
                    if state == 12:
                        return -0.0158943366
    elif num_booster == 65:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<5.23551655)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<11.4434614)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.50956106)  else 8)
                    if state == 7:
                        state = (11 if x['neargaia_med']<0.215192646 else 12)
                        if state == 11:
                            return 0.0122204851
                        if state == 12:
                            return -0.0405426435
                    if state == 8:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.51801729)  else 14)
                        if state == 13:
                            return 0.044595588
                        if state == 14:
                            state = (21 if np.isnan(x['t_lc']) or (x['t_lc']<3.01616335)  else 22)
                            if state == 21:
                                return -0.037790969
                            if state == 22:
                                return 0.0207093209
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<20.5493011)  else 10)
                    if state == 9:
                        return 0.0468488447
                    if state == 10:
                        return -0.0137256281
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.58917236)  else 6)
                if state == 5:
                    return -0.0645145625
                if state == 6:
                    return 0.00189128483
    elif num_booster == 66:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.03814507)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.97225)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.96255779)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.380298615)  else 10)
                        if state == 9:
                            return 0.0118158059
                        if state == 10:
                            return -0.0754247904
                    if state == 6:
                        state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.761940718)  else 12)
                        if state == 11:
                            return -0.0172645487
                        if state == 12:
                            return 0.025438739
                if state == 4:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<3.01093149)  else 8)
                    if state == 7:
                        return 0.0365965366
                    if state == 8:
                        state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.497500002)  else 14)
                        if state == 13:
                            return 0.017022226
                        if state == 14:
                            return -0.0289052259
            if state == 2:
                return 0.0318608433
    elif num_booster == 67:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5017433)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.141321495)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<35.0104523)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['rb_med']) or (x['rb_med']<0.900714159)  else 16)
                        if state == 15:
                            return 0.0635954216
                        if state == 16:
                            return -0.00478582038
                    if state == 8:
                        state = (17 if x['neargaia_med']<37.0518074 else 18)
                        if state == 17:
                            return -0.0376530588
                        if state == 18:
                            return 0.028793484
                if state == 4:
                    state = (9 if x['neargaia_med']<28.5065651 else 10)
                    if state == 9:
                        state = (19 if np.isnan(x['mag_last']) or (x['mag_last']<16.2623215)  else 20)
                        if state == 19:
                            return 0.0076726377
                        if state == 20:
                            state = (25 if x['neargaia_med']<6.42273617 else 26)
                            if state == 25:
                                return -0.00753996475
                            if state == 26:
                                return -0.0622940846
                    if state == 10:
                        state = (21 if x['distpsnr1_med']<1.07735133 else 22)
                        if state == 21:
                            return -0.0194774605
                        if state == 22:
                            return 0.0353763588
            if state == 2:
                state = (5 if x['distpsnr1_med']<7.41306114 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<36.4083328)  else 12)
                    if state == 11:
                        return -0.0756205618
                    if state == 12:
                        return -0.00621518958
                if state == 6:
                    state = (13 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<9.79686928)  else 14)
                    if state == 13:
                        return 0.027154984
                    if state == 14:
                        return -0.0236958656
    elif num_booster == 68:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.04274321)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.0947495)  else 4)
                if state == 3:
                    return 0.0222168099
                if state == 4:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5909996)  else 8)
                    if state == 7:
                        state = (13 if x['col_det']<-0.168275833 else 14)
                        if state == 13:
                            return 0.00717901159
                        if state == 14:
                            return -0.0682203025
                    if state == 8:
                        return 0.0166577119
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.53171825)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<3.045434)  else 10)
                    if state == 9:
                        return 0.0245858189
                    if state == 10:
                        return -0.0382872373
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.79718781)  else 12)
                    if state == 11:
                        return 0.0578855313
                    if state == 12:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.01434612)  else 18)
                        if state == 17:
                            return -0.0259055123
                        if state == 18:
                            return 0.0224388018
    elif num_booster == 69:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.1507244)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976500034)  else 4)
                if state == 3:
                    return -0.0649801418
                if state == 4:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.982749999)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<6.19732761)  else 14)
                        if state == 13:
                            return 0.0296680126
                        if state == 14:
                            return -0.0167286582
                    if state == 8:
                        return -0.0359389856
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.949000001)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.878977299)  else 10)
                    if state == 9:
                        state = (17 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.722061276)  else 18)
                        if state == 17:
                            return -0.0197119806
                        if state == 18:
                            return 0.0592691489
                    if state == 10:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.7712517)  else 20)
                        if state == 19:
                            return -0.0485975221
                        if state == 20:
                            return 0.00696480274
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.35124779)  else 12)
                    if state == 11:
                        state = (21 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.24931622)  else 22)
                        if state == 21:
                            return 0.034409523
                        if state == 22:
                            return -0.0291996989
                    if state == 12:
                        return 0.0542622283
    elif num_booster == 70:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7425117)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0335999)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<17.7322216)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8877487)  else 10)
                        if state == 9:
                            state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<15.7012501)  else 16)
                            if state == 15:
                                return -0.0216350406
                            if state == 16:
                                return 0.0210214872
                        if state == 10:
                            return -0.0646778643
                    if state == 6:
                        return 0.0171103105
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<18.2000618)  else 8)
                    if state == 7:
                        state = (11 if x['neargaia_med']<19.1574688 else 12)
                        if state == 11:
                            return -0.0298123304
                        if state == 12:
                            return 0.0161186438
                    if state == 8:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.6089268)  else 14)
                        if state == 13:
                            return 0.066492185
                        if state == 14:
                            state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<19.6618557)  else 18)
                            if state == 17:
                                return -0.0231584907
                            if state == 18:
                                return 0.027530428
            if state == 2:
                return -0.0540103503
    elif num_booster == 71:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5176125)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<17.3107491)  else 4)
                if state == 3:
                    return -0.0370348915
                if state == 4:
                    state = (7 if x['neargaia_med']<6.99131298 else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<18.7776985)  else 12)
                        if state == 11:
                            return -0.0288506169
                        if state == 12:
                            return 0.0107877143
                    if state == 8:
                        return 0.0690493062
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5267487)  else 6)
                if state == 5:
                    return -0.0554335974
                if state == 6:
                    return 0.00691743428
    elif num_booster == 72:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.0973331481 else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<29.7798843)  else 4)
                if state == 3:
                    state = (7 if x['neargaia_med']<0.540806413 else 8)
                    if state == 7:
                        return -0.014966663
                    if state == 8:
                        state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.5255508)  else 16)
                        if state == 15:
                            return 0.0690991879
                        if state == 16:
                            return -0.00455655111
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.00417857524 else 10)
                    if state == 9:
                        return 0.0234204382
                    if state == 10:
                        return -0.0447244048
            if state == 2:
                state = (5 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<18.309433)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.7398987)  else 12)
                    if state == 11:
                        state = (17 if x['neargaia_med']<4.51670456 else 18)
                        if state == 17:
                            return 0.00489531038
                        if state == 18:
                            return -0.0697232038
                    if state == 12:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<19.9973507)  else 20)
                        if state == 19:
                            return 0.0204801466
                        if state == 20:
                            state = (25 if x['sgscore1_med']<0.180335 else 26)
                            if state == 25:
                                return 0.0150115965
                            if state == 26:
                                return -0.0321684442
                if state == 6:
                    state = (13 if np.isnan(x['t_predetect']) or (x['t_predetect']<1.11543989)  else 14)
                    if state == 13:
                        return -0.0129078198
                    if state == 14:
                        state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00234365)  else 22)
                        if state == 21:
                            return 0.046476081
                        if state == 22:
                            return -0.0089249583
    elif num_booster == 73:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.554510474)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.782000005)  else 4)
                if state == 3:
                    return -0.0365412608
                if state == 4:
                    state = (7 if x['maggaia_med']<15.6930904 else 8)
                    if state == 7:
                        return -0.0162043106
                    if state == 8:
                        state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.453928322)  else 12)
                        if state == 11:
                            state = (13 if np.isnan(x['rb_med']) or (x['rb_med']<0.417856991)  else 14)
                            if state == 13:
                                return 0.0167944413
                            if state == 14:
                                return -0.028096227
                        if state == 12:
                            state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<6.04528904)  else 16)
                            if state == 15:
                                return 0.0560991168
                            if state == 16:
                                return -0.00468291435
            if state == 2:
                state = (5 if x['maggaia_med']<18.1494026 else 6)
                if state == 5:
                    return 0.0114530027
                if state == 6:
                    return -0.0447941348
    elif num_booster == 74:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<27.0345192)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.540593863 else 4)
                if state == 3:
                    return -0.051251512
                if state == 4:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.790250003)  else 8)
                    if state == 7:
                        return -0.0377819575
                    if state == 8:
                        state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.983749986)  else 14)
                        if state == 13:
                            state = (17 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.564535499)  else 18)
                            if state == 17:
                                return 0.058775004
                            if state == 18:
                                return -0.00560765248
                        if state == 14:
                            state = (19 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<10.8004208)  else 20)
                            if state == 19:
                                return 0.014253133
                            if state == 20:
                                return -0.0396804214
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.866317749 else 6)
                if state == 5:
                    state = (9 if x['sgscore1_med']<0.00481249997 else 10)
                    if state == 9:
                        return 0.0301866662
                    if state == 10:
                        return -0.0168793984
                if state == 6:
                    return -0.0765615404
    elif num_booster == 75:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.381388485)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.9019699)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<1.43571091)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.4592495)  else 14)
                        if state == 13:
                            return -0.0309650507
                        if state == 14:
                            return 0.0225393884
                    if state == 8:
                        return 0.0653982833
                if state == 4:
                    state = (9 if x['col_det']<-0.224200726 else 10)
                    if state == 9:
                        return 0.0181564167
                    if state == 10:
                        return -0.045722995
            if state == 2:
                state = (5 if x['neargaia_med']<14.0211868 else 6)
                if state == 5:
                    return -0.0736175627
                if state == 6:
                    state = (11 if x['col_det']<0.377419472 else 12)
                    if state == 11:
                        state = (17 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5979996)  else 18)
                        if state == 17:
                            return -0.0456521064
                        if state == 18:
                            return 0.0145670706
                    if state == 12:
                        return 0.0409367159
    elif num_booster == 76:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<2.07957172)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.2107716)  else 4)
                if state == 3:
                    return -0.0199154355
                if state == 4:
                    return 0.054164052
            if state == 2:
                state = (5 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9865222)  else 6)
                if state == 5:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95852447)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<35.4490509)  else 12)
                        if state == 11:
                            state = (17 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.976999998)  else 18)
                            if state == 17:
                                return -0.0541887432
                            if state == 18:
                                return 0.00346618076
                        if state == 12:
                            state = (19 if np.isnan(x['t_lc']) or (x['t_lc']<4.52956009)  else 20)
                            if state == 19:
                                return 0.0277832318
                            if state == 20:
                                return -0.0100178896
                    if state == 8:
                        return 0.030594226
                if state == 6:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00176525)  else 10)
                    if state == 9:
                        return -0.0709984675
                    if state == 10:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<2.96891785)  else 16)
                        if state == 15:
                            return -0.0401601195
                        if state == 16:
                            state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<19.8959007)  else 22)
                            if state == 21:
                                return 0.0340848118
                            if state == 22:
                                return -0.0134860761
    elif num_booster == 77:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<3.02903771 else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.9818916)  else 4)
                if state == 3:
                    state = (7 if x['maggaia_med']<19.3796501 else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.9712486)  else 16)
                        if state == 15:
                            return -0.04358951
                        if state == 16:
                            state = (21 if np.isnan(x['mag_det']) or (x['mag_det']<19.8257751)  else 22)
                            if state == 21:
                                return 0.0371822268
                            if state == 22:
                                return -0.0268206447
                    if state == 8:
                        return -0.070929423
                if state == 4:
                    return 0.0125093032
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.0774994)  else 6)
                if state == 5:
                    state = (11 if x['maggaia_med']<19.4049454 else 12)
                    if state == 11:
                        return -0.027980648
                    if state == 12:
                        return 0.0132417101
                if state == 6:
                    state = (13 if x['maggaia_med']<14.9078999 else 14)
                    if state == 13:
                        return -0.010295623
                    if state == 14:
                        state = (19 if np.isnan(x['mag_det']) or (x['mag_det']<20.5398006)  else 20)
                        if state == 19:
                            return 0.0608872846
                        if state == 20:
                            return -0.0056247185
    elif num_booster == 78:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.25184655)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.0223312)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.138275445)  else 8)
                    if state == 7:
                        return -0.0145916045
                    if state == 8:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.422795862)  else 16)
                        if state == 15:
                            return -0.0065445439
                        if state == 16:
                            return 0.0474035032
                if state == 4:
                    state = (9 if x['maggaia_med']<19.8980904 else 10)
                    if state == 9:
                        return -0.0361290462
                    if state == 10:
                        state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.9821353)  else 18)
                        if state == 17:
                            return 0.0271079913
                        if state == 18:
                            return -0.0161740948
            if state == 2:
                return -0.0697310045
    elif num_booster == 79:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.592701)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<4.03782415)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<0.495296508)  else 8)
                    if state == 7:
                        return 0.0133029157
                    if state == 8:
                        return -0.055453077
                if state == 4:
                    state = (9 if x['maggaia_med']<18.5034637 else 10)
                    if state == 9:
                        return -0.0125568593
                    if state == 10:
                        return 0.0280332845
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.98236704)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<20.6723995)  else 12)
                    if state == 11:
                        return 0.0587696955
                    if state == 12:
                        return -0.00347743277
                if state == 6:
                    return -0.0447065756
    elif num_booster == 80:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<18.8066826 else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.979154229)  else 4)
                if state == 3:
                    return -0.0259104762
                if state == 4:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<7.20519066)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0156874992)  else 14)
                        if state == 13:
                            return -0.0033943865
                        if state == 14:
                            return 0.0514802076
                    if state == 8:
                        return -0.0172332954
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.38816488)  else 6)
                if state == 5:
                    return -0.00307244621
                if state == 6:
                    state = (11 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.94443297)  else 12)
                    if state == 11:
                        return 0.00050427852
                    if state == 12:
                        state = (21 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.98144102)  else 22)
                        if state == 21:
                            return -0.0544550642
                        if state == 22:
                            state = (27 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.215125054)  else 28)
                            if state == 27:
                                return 0.0200822391
                            if state == 28:
                                return -0.0287231393
    elif num_booster == 81:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<4.63255072)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<1.33154464 else 4)
                if state == 3:
                    state = (7 if np.isnan(x['col_det']) or (x['col_det']<0.0742740631)  else 8)
                    if state == 7:
                        return -0.0559662245
                    if state == 8:
                        return 0.00390074938
                if state == 4:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.1612892)  else 10)
                    if state == 9:
                        state = (15 if x['distpsnr1_med']<23.8271675 else 16)
                        if state == 15:
                            return 0.0484694988
                        if state == 16:
                            return -0.00630083121
                    if state == 10:
                        state = (17 if x['maggaia_med']<19.7812519 else 18)
                        if state == 17:
                            return -0.0494279526
                        if state == 18:
                            return 0.0187728219
            if state == 2:
                return -0.0738718286
    elif num_booster == 82:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5265446)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.7755013)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<5.98659706)  else 8)
                    if state == 7:
                        return -0.0445526391
                    if state == 8:
                        return 0.0238171946
                if state == 4:
                    return 0.073463127
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.98666239)  else 6)
                if state == 5:
                    return -0.0575278364
                if state == 6:
                    state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<19.7287388)  else 12)
                    if state == 11:
                        return 0.0359866619
                    if state == 12:
                        return -0.028293021
    elif num_booster == 83:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.100562349)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.968500018)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.967000008)  else 8)
                    if state == 7:
                        state = (11 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.80825001)  else 12)
                        if state == 11:
                            state = (17 if x['sgscore1_med']<0.0672916993 else 18)
                            if state == 17:
                                return -0.0303798672
                            if state == 18:
                                return 0.00861286838
                        if state == 12:
                            return 0.0263616238
                    if state == 8:
                        return -0.0372814946
                if state == 4:
                    return 0.0416039042
            if state == 2:
                state = (5 if x['distpsnr1_med']<8.24716759 else 6)
                if state == 5:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.84535718)  else 10)
                    if state == 9:
                        return -0.0608649068
                    if state == 10:
                        return 0.00972744729
                if state == 6:
                    return 0.0279334188
    elif num_booster == 84:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.945714355)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.0742740631)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<18.9554996)  else 6)
                    if state == 5:
                        state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<17.9562988)  else 10)
                        if state == 9:
                            return 0.00796592422
                        if state == 10:
                            state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.8424988)  else 14)
                            if state == 13:
                                return -0.00419693021
                            if state == 14:
                                return -0.0818449706
                    if state == 6:
                        state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.8400002)  else 12)
                        if state == 11:
                            return 0.0346556045
                        if state == 12:
                            state = (15 if np.isnan(x['mag_det']) or (x['mag_det']<20.6869507)  else 16)
                            if state == 15:
                                return -0.0452062897
                            if state == 16:
                                return 0.00626806822
                if state == 4:
                    return 0.0172545612
            if state == 2:
                return 0.0266958401
    elif num_booster == 85:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.09987259)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.977899253)  else 4)
                if state == 3:
                    return 0.0253899824
                if state == 4:
                    state = (7 if np.isnan(x['t_lc']) or (x['t_lc']<2.95704865)  else 8)
                    if state == 7:
                        return -0.0546801761
                    if state == 8:
                        state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<3.01360512)  else 12)
                        if state == 11:
                            return 0.0288535897
                        if state == 12:
                            state = (17 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00151634)  else 18)
                            if state == 17:
                                return -0.0282913633
                            if state == 18:
                                return 0.0127384774
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<6.02367496)  else 6)
                if state == 5:
                    return 0.0404419713
                if state == 6:
                    return -0.00809597038
    elif num_booster == 86:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.04723978)  else 2)
            if state == 1:
                state = (3 if x['neargaia_med']<11.0867825 else 4)
                if state == 3:
                    return -0.0166078135
                if state == 4:
                    return 0.0498570018
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<4.06462955)  else 6)
                if state == 5:
                    return -0.0502885766
                if state == 6:
                    state = (13 if x['sgscore1_med']<0.558104038 else 14)
                    if state == 13:
                        return 0.0307011977
                    if state == 14:
                        return -0.0385392122
    elif num_booster == 87:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.96961856)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.711214542)  else 4)
                if state == 3:
                    return -0.0114893746
                if state == 4:
                    return 0.047037635
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.15697908)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<17.3014812)  else 12)
                    if state == 11:
                        return 0.00254730973
                    if state == 12:
                        return -0.0740669072
                if state == 6:
                    return 0.0280949641
    elif num_booster == 88:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8252144)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0645504)  else 4)
                if state == 3:
                    state = (5 if x['col_det']<-0.13114357 else 6)
                    if state == 5:
                        return 0.0230365675
                    if state == 6:
                        return -0.043046739
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.6370144)  else 8)
                    if state == 7:
                        return 0.0600405857
                    if state == 8:
                        state = (13 if np.isnan(x['t_lc']) or (x['t_lc']<3.04718161)  else 14)
                        if state == 13:
                            return 0.0233663172
                        if state == 14:
                            return -0.029607011
            if state == 2:
                return -0.0518098809
    elif num_booster == 89:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.2458496)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.684999824)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3772507)  else 8)
                    if state == 7:
                        return 0.026015928
                    if state == 8:
                        return -0.0248230398
                if state == 4:
                    return -0.0442656092
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.8316002)  else 6)
                if state == 5:
                    return 0.0387019999
                if state == 6:
                    state = (11 if np.isnan(x['mag_det']) or (x['mag_det']<19.9281006)  else 12)
                    if state == 11:
                        return -0.0396697409
                    if state == 12:
                        state = (15 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0714166462)  else 16)
                        if state == 15:
                            state = (17 if np.isnan(x['rb_med']) or (x['rb_med']<0.715833306)  else 18)
                            if state == 17:
                                return -0.0251267403
                            if state == 18:
                                return 0.0177729893
                        if state == 16:
                            return 0.0368683413
    elif num_booster == 90:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.46034801)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<2.89367938)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.48232317)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.430788994)  else 16)
                        if state == 15:
                            state = (23 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.139837831)  else 24)
                            if state == 23:
                                return 0.0177595355
                            if state == 24:
                                return -0.0332591794
                        if state == 16:
                            return 0.0248855725
                    if state == 8:
                        return -0.0573716238
                if state == 4:
                    state = (9 if x['sgscore1_med']<0.00318749994 else 10)
                    if state == 9:
                        return -0.0167295765
                    if state == 10:
                        return 0.0452513695
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.25184655)  else 6)
                if state == 5:
                    state = (11 if x['sgscore1_med']<0.554510474 else 12)
                    if state == 11:
                        return 0.0100699645
                    if state == 12:
                        return -0.034701772
                if state == 6:
                    return -0.0739012212
    elif num_booster == 91:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4928131)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0366249979)  else 4)
                if state == 3:
                    return 0.0501150787
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<18.6644325)  else 8)
                    if state == 7:
                        state = (11 if x['sgscore1_med']<0.834416509 else 12)
                        if state == 11:
                            state = (15 if x['sgscore1_med']<0.194077 else 16)
                            if state == 15:
                                return -0.0038549325
                            if state == 16:
                                return 0.0454245508
                        if state == 12:
                            return -0.0154404696
                    if state == 8:
                        state = (13 if np.isnan(x['mag_last']) or (x['mag_last']<19.0137138)  else 14)
                        if state == 13:
                            return -0.0497492887
                        if state == 14:
                            state = (17 if np.isnan(x['mag_last']) or (x['mag_last']<19.2774315)  else 18)
                            if state == 17:
                                return 0.0236029588
                            if state == 18:
                                return -0.0279220603
            if state == 2:
                state = (5 if x['sgscore1_med']<0.00266666501 else 6)
                if state == 5:
                    return 0.00761566637
                if state == 6:
                    return -0.0544503629
    elif num_booster == 92:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<3.00577545)  else 2)
            if state == 1:
                return 0.0499373153
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.5919151)  else 6)
                if state == 5:
                    state = (9 if np.isnan(x['rb_med']) or (x['rb_med']<0.704999804)  else 10)
                    if state == 9:
                        state = (11 if np.isnan(x['mag_last']) or (x['mag_last']<18.8709278)  else 12)
                        if state == 11:
                            state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<6.05531216)  else 16)
                            if state == 15:
                                return -0.0449611358
                            if state == 16:
                                return 0.0262100808
                        if state == 12:
                            state = (17 if np.isnan(x['t_lc']) or (x['t_lc']<5.00785303)  else 18)
                            if state == 17:
                                return 0.0357256569
                            if state == 18:
                                return -0.0104061766
                    if state == 10:
                        return 0.0413658544
                if state == 6:
                    return -0.0619233362
    elif num_booster == 93:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<-0.300900459)  else 2)
            if state == 1:
                state = (3 if x['maggaia_med']<16.412178 else 4)
                if state == 3:
                    return -0.0140969604
                if state == 4:
                    state = (7 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<20.0536766)  else 8)
                    if state == 7:
                        return 0.0331969149
                    if state == 8:
                        return -0.0122361323
            if state == 2:
                state = (5 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.9223099)  else 6)
                if state == 5:
                    state = (9 if x['maggaia_med']<16.8467484 else 10)
                    if state == 9:
                        return 0.0030878731
                    if state == 10:
                        return -0.0668363348
                if state == 6:
                    return 0.0116134081
    elif num_booster == 94:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<-0.547867775)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<3.01983213)  else 4)
                if state == 3:
                    return 0.00656612078
                if state == 4:
                    state = (9 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.97874999)  else 10)
                    if state == 9:
                        return -0.0567684956
                    if state == 10:
                        return 0.00428973557
            if state == 2:
                state = (5 if x['neargaia_med']<10.3445396 else 6)
                if state == 5:
                    return -0.028108865
                if state == 6:
                    state = (13 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.687999964)  else 14)
                    if state == 13:
                        return -0.0207415186
                    if state == 14:
                        state = (17 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<43.7015533)  else 18)
                        if state == 17:
                            return 0.0451814495
                        if state == 18:
                            return -0.00717822369
    elif num_booster == 95:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.1377487)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97758102)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.21715283)  else 8)
                    if state == 7:
                        state = (13 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.266271234)  else 14)
                        if state == 13:
                            return 0.0211370867
                        if state == 14:
                            return -0.0168043058
                    if state == 8:
                        return 0.0549931042
                if state == 4:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.79408216)  else 10)
                    if state == 9:
                        return 0.0159507785
                    if state == 10:
                        return -0.0371911116
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9237499)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6702499)  else 12)
                    if state == 11:
                        state = (15 if x['sgscore1_med']<0.581967473 else 16)
                        if state == 15:
                            return 0.0123727601
                        if state == 16:
                            return -0.0275294408
                    if state == 12:
                        return -0.0533795208
                if state == 6:
                    return 0.0223127007
    elif num_booster == 96:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<18.956295)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.7800007)  else 4)
                if state == 3:
                    state = (7 if x['distpsnr1_med']<0.090156436 else 8)
                    if state == 7:
                        return -0.0187829137
                    if state == 8:
                        state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5662498)  else 14)
                        if state == 13:
                            return -0.007979705
                        if state == 14:
                            return 0.0528178103
                if state == 4:
                    return -0.0426064469
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.9354992)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.30057979)  else 12)
                    if state == 11:
                        state = (15 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.561861396)  else 16)
                        if state == 15:
                            return -0.0192312431
                        if state == 16:
                            return 0.0185241178
                    if state == 12:
                        state = (17 if x['distpsnr1_med']<8.6641407 else 18)
                        if state == 17:
                            return -0.0717218816
                        if state == 18:
                            return 0.00472225575
                if state == 6:
                    return 0.0187539887
    elif num_booster == 97:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<6.82107115 else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<20.4356995)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<18.0857086)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<2.55864596)  else 16)
                        if state == 15:
                            return -0.0232891124
                        if state == 16:
                            return 0.01573967
                    if state == 8:
                        return -0.0538195819
                if state == 4:
                    state = (9 if np.isnan(x['mag_last']) or (x['mag_last']<19.7306519)  else 10)
                    if state == 9:
                        return 0.0397810303
                    if state == 10:
                        return -0.0326278396
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<2.96818876)  else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<2.49697351)  else 12)
                    if state == 11:
                        return 0.0148652904
                    if state == 12:
                        return -0.0320518836
                if state == 6:
                    return 0.0317879394
    elif num_booster == 98:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.9058151 else 2)
            if state == 1:
                state = (3 if np.isnan(x['col_det']) or (x['col_det']<0.119239807)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<3.00176525)  else 8)
                    if state == 7:
                        state = (13 if x['neargaia_med']<47.2691078 else 14)
                        if state == 13:
                            state = (17 if x['maggaia_med']<15.7893572 else 18)
                            if state == 17:
                                return -0.00393828331
                            if state == 18:
                                return -0.0670370385
                        if state == 14:
                            return 0.012113533
                    if state == 8:
                        return 0.00886385702
                if state == 4:
                    state = (9 if x['maggaia_med']<17.3772469 else 10)
                    if state == 9:
                        return -0.0176491458
                    if state == 10:
                        return 0.0374940336
            if state == 2:
                state = (5 if np.isnan(x['col_det']) or (x['col_det']<-1.22711658)  else 6)
                if state == 5:
                    return -0.00704222266
                if state == 6:
                    return 0.0430396609
    elif num_booster == 99:
        state = 0
        if state == 0:
            state = (1 if x['maggaia_med']<19.4237633 else 2)
            if state == 1:
                state = (3 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.620527923)  else 4)
                if state == 3:
                    return -0.0115861055
                if state == 4:
                    state = (9 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.97936916)  else 10)
                    if state == 9:
                        return 0.0373165533
                    if state == 10:
                        return -0.00374992215
            if state == 2:
                state = (5 if x['col_det']<-0.318695068 else 6)
                if state == 5:
                    return 0.00537678599
                if state == 6:
                    state = (11 if np.isnan(x['distnr_med']) or (x['distnr_med']<1.37620234)  else 12)
                    if state == 11:
                        return -0.000314992038
                    if state == 12:
                        state = (19 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.88531828)  else 20)
                        if state == 19:
                            return 0.00114398834
                        if state == 20:
                            return -0.0655479431



def xgb_tree_5(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.96449995)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_lc']) or (x['t_lc']<2.9844327)  else 4)
                if state == 3:
                    return 0.0651697367
                if state == 4:
                    return -0.142300591
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<18.3803997)  else 6)
                if state == 5:
                    return -0.116247855
                if state == 6:
                    return 0.135288715
    elif num_booster == 1:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4891624)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.581894517)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.0839996)  else 8)
                    if state == 7:
                        return -0.0536556318
                    if state == 8:
                        return 0.147601694
                if state == 4:
                    state = (9 if np.isnan(x['col_det']) or (x['col_det']<0.178128093)  else 10)
                    if state == 9:
                        return -0.125332713
                    if state == 10:
                        return 0.0760487244
            if state == 2:
                return -0.151927382
    elif num_booster == 2:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.558070302)  else 2)
            if state == 1:
                return -0.126421392
            if state == 2:
                state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.961499989)  else 6)
                if state == 5:
                    state = (11 if x['col_det']<0.569972992 else 12)
                    if state == 11:
                        return 0.0115520004
                    if state == 12:
                        return -0.13452284
                if state == 6:
                    state = (13 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.712363005)  else 14)
                    if state == 13:
                        return 0.136421144
                    if state == 14:
                        return -0.103614427
    elif num_booster == 3:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.966500044)  else 2)
            if state == 1:
                return -0.109120183
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.150603831 else 6)
                if state == 5:
                    return -0.116290443
                if state == 6:
                    state = (11 if np.isnan(x['rb_med']) or (x['rb_med']<0.464999825)  else 12)
                    if state == 11:
                        return -0.0484573729
                    if state == 12:
                        return 0.12874262
    elif num_booster == 4:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1329155)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.396801)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<17.6403618)  else 8)
                    if state == 7:
                        return 0.0700382814
                    if state == 8:
                        return -0.133932263
                if state == 4:
                    return 0.133503184
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.95669556)  else 6)
                if state == 5:
                    return 0.0270685088
                if state == 6:
                    return -0.129142359
    elif num_booster == 5:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6124992)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.96449995)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<22.6038666)  else 8)
                    if state == 7:
                        return -0.0986008719
                    if state == 8:
                        return 0.0215356089
                if state == 4:
                    state = (9 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.551373482)  else 10)
                    if state == 9:
                        return 0.127693146
                    if state == 10:
                        return -0.0547450855
            if state == 2:
                return -0.109902926
    elif num_booster == 6:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6131096)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.0955009)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.0325012)  else 8)
                    if state == 7:
                        return -0.0166470278
                    if state == 8:
                        return 0.13232477
                if state == 4:
                    state = (9 if x['distpsnr1_med']<6.38270855 else 10)
                    if state == 9:
                        return -0.133153558
                    if state == 10:
                        return 0.0404631011
            if state == 2:
                return -0.129137933
    elif num_booster == 7:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.950500011)  else 2)
            if state == 1:
                return -0.0985110924
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.518345058 else 6)
                if state == 5:
                    return -0.0740070641
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5634995)  else 14)
                    if state == 13:
                        return 0.104366139
                    if state == 14:
                        return -0.0243030284
    elif num_booster == 8:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.557975292)  else 2)
            if state == 1:
                return -0.0929355621
            if state == 2:
                state = (5 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.958092511)  else 6)
                if state == 5:
                    return 0.0561008304
                if state == 6:
                    return -0.105033062
    elif num_booster == 9:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.948500037)  else 2)
            if state == 1:
                return -0.0893436
            if state == 2:
                state = (5 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.6625004)  else 6)
                if state == 5:
                    return 0.0926467776
                if state == 6:
                    return -0.0362189002
    elif num_booster == 10:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6989975)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.4130001)  else 4)
                if state == 3:
                    return -0.0849138796
                if state == 4:
                    return 0.110551633
            if state == 2:
                return -0.122006267
    elif num_booster == 11:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6989975)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.0664315522)  else 4)
                if state == 3:
                    return 0.113366552
                if state == 4:
                    return -0.0194200445
            if state == 2:
                return -0.12387725
    elif num_booster == 12:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.950999975)  else 2)
            if state == 1:
                return -0.0886675194
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.518345058 else 6)
                if state == 5:
                    return -0.0833819434
                if state == 6:
                    state = (13 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.1365013)  else 14)
                    if state == 13:
                        return 0.0984439924
                    if state == 14:
                        return -0.0699566975
    elif num_booster == 13:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.8676834)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6391487)  else 4)
                if state == 3:
                    return -0.0831130818
                if state == 4:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<19.0440121)  else 8)
                    if state == 7:
                        return 0.0908405632
                    if state == 8:
                        return -0.0145121496
            if state == 2:
                return -0.112819791
    elif num_booster == 14:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4572525)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.592790008)  else 4)
                if state == 3:
                    return 0.0676382631
                if state == 4:
                    return -0.0818464234
            if state == 2:
                return -0.0862690434
    elif num_booster == 15:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6300011)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.96449995)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<36.3773804)  else 8)
                    if state == 7:
                        return -0.0725828633
                    if state == 8:
                        return 0.0876189768
                if state == 4:
                    return 0.071096614
            if state == 2:
                return -0.0894400328
    elif num_booster == 16:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4603462)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.558070302 else 4)
                if state == 3:
                    return -0.059043061
                if state == 4:
                    return 0.0675380901
            if state == 2:
                return -0.0942251086
    elif num_booster == 17:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4603462)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.113627434 else 4)
                if state == 3:
                    return -0.0526724309
                if state == 4:
                    state = (9 if x['distpsnr1_med']<0.559864759 else 10)
                    if state == 9:
                        return -0.0234441254
                    if state == 10:
                        return 0.103655055
            if state == 2:
                return -0.0880610943
    elif num_booster == 18:
        state = 0
        if state == 0:
            state = (1 if x['distpsnr1_med']<0.663554788 else 2)
            if state == 1:
                return -0.0602431111
            if state == 2:
                return 0.044594802
    elif num_booster == 19:
        return  -0.00798542239
    elif num_booster == 20:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.0251579)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5594997)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5514984)  else 8)
                    if state == 7:
                        return -0.0788872018
                    if state == 8:
                        return 0.0846453756
                if state == 4:
                    return -0.049375657
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.95751143)  else 6)
                if state == 5:
                    return 0.0437248312
                if state == 6:
                    return -0.102135539
    elif num_booster == 21:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['col_det']) or (x['col_det']<-0.219305992)  else 2)
            if state == 1:
                return -0.038545046
            if state == 2:
                return 0.0473859943
    elif num_booster == 22:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5885353)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6300011)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.7244987)  else 8)
                    if state == 7:
                        return -0.0405115671
                    if state == 8:
                        return 0.0975272208
                if state == 4:
                    return -0.0487495214
            if state == 2:
                return -0.087670967
    elif num_booster == 23:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6989975)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6707001)  else 4)
                if state == 3:
                    return -0.0603543036
                if state == 4:
                    return 0.0765775219
            if state == 2:
                return -0.0851880163
    elif num_booster == 24:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4572525)  else 2)
            if state == 1:
                return 0.0289560724
            if state == 2:
                return -0.0864620507
    elif num_booster == 25:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5965843)  else 2)
            if state == 1:
                return 0.0383316018
            if state == 2:
                return -0.0871782601
    elif num_booster == 26:
        return  0.00376298488
    elif num_booster == 27:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.0440121)  else 2)
            if state == 1:
                return 0.0445533134
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.99805546)  else 6)
                if state == 5:
                    return 0.0245943274
                if state == 6:
                    return -0.113317981
    elif num_booster == 28:
        return  -0.00797367468
    elif num_booster == 29:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3080006)  else 2)
            if state == 1:
                return 0.0312157422
            if state == 2:
                return -0.0655558407
    elif num_booster == 30:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6131096)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.4111004)  else 4)
                if state == 3:
                    return -0.0505213663
                if state == 4:
                    return 0.0601334684
            if state == 2:
                return -0.092268981
    elif num_booster == 31:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.5419998)  else 2)
            if state == 1:
                return 0.042823825
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.7719994)  else 6)
                if state == 5:
                    return -0.114564389
                if state == 6:
                    return 0.0367061011
    elif num_booster == 32:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<20.8607178 else 2)
            if state == 1:
                return -0.0483790524
            if state == 2:
                return 0.0387703218
    elif num_booster == 33:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.592790008)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.8676834)  else 4)
                if state == 3:
                    return 0.0391783267
                if state == 4:
                    return -0.08062426
            if state == 2:
                return -0.0911832005
    elif num_booster == 34:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.4603462)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<16.1098213)  else 4)
                if state == 3:
                    return -0.0352346934
                if state == 4:
                    return 0.0786282346
            if state == 2:
                return -0.0748637393
    elif num_booster == 35:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.0440121)  else 2)
            if state == 1:
                return 0.0426297411
            if state == 2:
                return -0.0616884008
    elif num_booster == 36:
        return  -0.0102496147
    elif num_booster == 37:
        return  -0.00452727592
    elif num_booster == 38:
        return  -0.00714477105
    elif num_booster == 39:
        return  -0.00385377812
    elif num_booster == 40:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.432251)  else 2)
            if state == 1:
                return -0.0612713285
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.8546333)  else 6)
                if state == 5:
                    return 0.0662767813
                if state == 6:
                    return -0.072279267
    elif num_booster == 41:
        return  -0.00254667015
    elif num_booster == 42:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.559864759)  else 2)
            if state == 1:
                return -0.0754910707
            if state == 2:
                state = (5 if np.isnan(x['mag_det']) or (x['mag_det']<19.7378502)  else 6)
                if state == 5:
                    return -0.0240812376
                if state == 6:
                    return 0.08901117
    elif num_booster == 43:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<18.3803997)  else 2)
            if state == 1:
                return -0.0856672078
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.6989975)  else 6)
                if state == 5:
                    return 0.0463102572
                if state == 6:
                    return -0.0804303586
    elif num_booster == 44:
        return  -0.000929037342
    elif num_booster == 45:
        return  0.00179992686
    elif num_booster == 46:
        return  -0.00902916119
    elif num_booster == 47:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1229591)  else 2)
            if state == 1:
                return 0.0358196348
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<5.98107052)  else 6)
                if state == 5:
                    return 0.0457966924
                if state == 6:
                    return -0.102421455
    elif num_booster == 48:
        return  -0.00296659814
    elif num_booster == 49:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.2595005)  else 2)
            if state == 1:
                return 0.0416271389
            if state == 2:
                return -0.0524076037
    elif num_booster == 50:
        return  -0.00116707175
    elif num_booster == 51:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.0396252)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6357498)  else 4)
                if state == 3:
                    return -0.0602464452
                if state == 4:
                    return 0.0763392448
            if state == 2:
                return -0.0618480407
    elif num_booster == 52:
        return  0.0110316658
    elif num_booster == 53:
        return  0.00239605061
    elif num_booster == 54:
        return  0.00484522711
    elif num_booster == 55:
        return  0.00382902636
    elif num_booster == 56:
        return  -0.00550113386
    elif num_booster == 57:
        return  -0.0102518918
    elif num_booster == 58:
        return  0.00949648023
    elif num_booster == 59:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5965843)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.6628456)  else 4)
                if state == 3:
                    return -0.0357944518
                if state == 4:
                    return 0.0810425654
            if state == 2:
                return -0.083692722
    elif num_booster == 60:
        return  -0.0129194204
    elif num_booster == 61:
        return  0.00450024335
    elif num_booster == 62:
        return  -0.00364363636
    elif num_booster == 63:
        return  -0.00249904348
    elif num_booster == 64:
        return  0.00901014637
    elif num_booster == 65:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.581894517)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.8546333)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.5909996)  else 8)
                    if state == 7:
                        return -0.0442666635
                    if state == 8:
                        return 0.0883783624
                if state == 4:
                    return -0.0696710646
            if state == 2:
                return -0.0821272358
    elif num_booster == 66:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.694907546 else 2)
            if state == 1:
                return 0.0399776734
            if state == 2:
                return -0.0944480598
    elif num_booster == 67:
        return  -0.00355870207
    elif num_booster == 68:
        return  0.0102090733
    elif num_booster == 69:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.7378502)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6300011)  else 4)
                if state == 3:
                    return 0.00838955306
                if state == 4:
                    return -0.124353044
            if state == 2:
                return 0.0361783989
    elif num_booster == 70:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<3.60880518)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.969500005)  else 4)
                if state == 3:
                    return -0.0566272847
                if state == 4:
                    return 0.0594542883
            if state == 2:
                return -0.0674635023
    elif num_booster == 71:
        return  0.00101508456
    elif num_booster == 72:
        return  -0.00835336372
    elif num_booster == 73:
        return  -0.00388330431
    elif num_booster == 74:
        return  0.00372876064
    elif num_booster == 75:
        return  -0.0229102559
    elif num_booster == 76:
        return  -0.00761121884
    elif num_booster == 77:
        return  0.000625280023
    elif num_booster == 78:
        return  0.0293479133
    elif num_booster == 79:
        return  -0.00160821236
    elif num_booster == 80:
        return  -0.00674609793
    elif num_booster == 81:
        return  0.00408967584
    elif num_booster == 82:
        return  0.00225300738
    elif num_booster == 83:
        return  0.00895153731
    elif num_booster == 84:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.123661)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<16.5514984)  else 4)
                if state == 3:
                    return -0.0848776698
                if state == 4:
                    return 0.0652463064
            if state == 2:
                return -0.0534815527
    elif num_booster == 85:
        return  -0.0063914177
    elif num_booster == 86:
        return  0.00699905772
    elif num_booster == 87:
        return  0.00526861334
    elif num_booster == 88:
        return  -0.0135363303
    elif num_booster == 89:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.7378502)  else 2)
            if state == 1:
                return -0.0464114733
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.820507)  else 6)
                if state == 5:
                    return 0.0944278091
                if state == 6:
                    return -0.0642760694
    elif num_booster == 90:
        return  0.00449450687
    elif num_booster == 91:
        return  0.00845856778
    elif num_booster == 92:
        return  -0.00380213722
    elif num_booster == 93:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.4099998)  else 2)
            if state == 1:
                return 0.0371621773
            if state == 2:
                return -0.0944893882
    elif num_booster == 94:
        return  -0.0252280049
    elif num_booster == 95:
        return  0.0108787492
    elif num_booster == 96:
        return  -0.00940213911
    elif num_booster == 97:
        return  -0.00276811863
    elif num_booster == 98:
        return  0.00522190612
    elif num_booster == 99:
        return  -0.00886895228



def xgb_tree_6(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.2905006)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<20.5546989)  else 4)
                if state == 3:
                    return 0.269924372
                if state == 4:
                    return -0.0538417846
            if state == 2:
                state = (5 if x['sgscore1_med']<0.196327001 else 6)
                if state == 5:
                    state = (11 if np.isnan(x['t_lc']) or (x['t_lc']<9.01804924)  else 12)
                    if state == 11:
                        return 0.147576466
                    if state == 12:
                        return -0.112000003
                if state == 6:
                    return -0.183182701
    elif num_booster == 1:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.680069)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.9635506)  else 4)
                if state == 3:
                    state = (5 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.983250022)  else 6)
                    if state == 5:
                        return -0.135921791
                    if state == 6:
                        return 0.0682295188
                if state == 4:
                    return 0.237486452
            if state == 2:
                return -0.28277728
    elif num_booster == 2:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.3388634)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.3045006)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.0223900005)  else 8)
                    if state == 7:
                        return -0.0717599913
                    if state == 8:
                        return 0.237809107
                if state == 4:
                    state = (9 if np.isnan(x['mag_det']) or (x['mag_det']<19.1280708)  else 10)
                    if state == 9:
                        return -0.21623072
                    if state == 10:
                        return 0.0962165147
            if state == 2:
                return -0.204130337
    elif num_booster == 3:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3564987)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.846000016)  else 4)
                if state == 3:
                    return -0.138272285
                if state == 4:
                    return 0.171681136
            if state == 2:
                state = (5 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<9.49050236)  else 6)
                if state == 5:
                    return -0.20659861
                if state == 6:
                    return 0.0298757516
    elif num_booster == 4:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1568947)  else 2)
            if state == 1:
                state = (3 if x['distpsnr1_med']<0.26211834 else 4)
                if state == 3:
                    return -0.0994315073
                if state == 4:
                    state = (9 if np.isnan(x['maggaia_med']) or (x['maggaia_med']<19.646656)  else 10)
                    if state == 9:
                        return 0.210591406
                    if state == 10:
                        return -0.0309014432
            if state == 2:
                return -0.171347752
    elif num_booster == 5:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1678238)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<17.3101997)  else 4)
                if state == 3:
                    return -0.0652310997
                if state == 4:
                    return 0.166431665
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.06449652)  else 6)
                if state == 5:
                    return 0.0660126284
                if state == 6:
                    return -0.169108465
    elif num_booster == 6:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6807938)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6517487)  else 4)
                if state == 3:
                    return -0.158821777
                if state == 4:
                    state = (9 if np.isnan(x['t_lc']) or (x['t_lc']<8.97694397)  else 10)
                    if state == 9:
                        return 0.187467858
                    if state == 10:
                        return -0.0115162497
            if state == 2:
                return -0.169545934
    elif num_booster == 7:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5434341)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.6517487)  else 4)
                if state == 3:
                    return -0.136162087
                if state == 4:
                    return 0.181715518
            if state == 2:
                return -0.15367192
    elif num_booster == 8:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1155777)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.2869987)  else 4)
                if state == 3:
                    return 0.1424357
                if state == 4:
                    state = (9 if np.isnan(x['magnr_med']) or (x['magnr_med']<22.5750008)  else 10)
                    if state == 9:
                        return -0.14382717
                    if state == 10:
                        return 0.0901303291
            if state == 2:
                state = (5 if np.isnan(x['t_lc']) or (x['t_lc']<3.0521934)  else 6)
                if state == 5:
                    return 0.0682429224
                if state == 6:
                    return -0.178667411
    elif num_booster == 9:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1179466)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.4130001)  else 4)
                if state == 3:
                    return -0.118060142
                if state == 4:
                    return 0.151949048
            if state == 2:
                return -0.115059353
    elif num_booster == 10:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1179466)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<18.5052795)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['mag_last']) or (x['mag_last']<17.3182087)  else 8)
                    if state == 7:
                        return 0.0872673094
                    if state == 8:
                        return -0.150047168
                if state == 4:
                    return 0.130866781
            if state == 2:
                return -0.0953470394
    elif num_booster == 11:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.5304394)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.294500351 else 4)
                if state == 3:
                    return -0.114100941
                if state == 4:
                    return 0.072401613
            if state == 2:
                return -0.125672489
    elif num_booster == 12:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6925507)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.5548573)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.4432507)  else 8)
                    if state == 7:
                        return 0.0676068217
                    if state == 8:
                        return -0.159255803
                if state == 4:
                    return 0.17138733
            if state == 2:
                return -0.125575066
    elif num_booster == 13:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.3402061)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<19.0102501)  else 4)
                if state == 3:
                    return -0.115080282
                if state == 4:
                    return 0.146271825
            if state == 2:
                return -0.113143481
    elif num_booster == 14:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.95888901)  else 2)
            if state == 1:
                return -0.0525405742
            if state == 2:
                return 0.108652093
    elif num_booster == 15:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.6469994)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.6378059)  else 4)
                if state == 3:
                    return 0.118016064
                if state == 4:
                    return -0.0734183565
            if state == 2:
                return -0.128470913
    elif num_booster == 16:
        return  -0.0164706204
    elif num_booster == 17:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distnr_med']) or (x['distnr_med']<0.69119674)  else 2)
            if state == 1:
                return -0.117413253
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.82120371)  else 6)
                if state == 5:
                    return 0.105085164
                if state == 6:
                    return -0.0790800229
    elif num_booster == 18:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['rb_med']) or (x['rb_med']<0.714881003)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<17.9785824)  else 4)
                if state == 3:
                    return 0.0978270099
                if state == 4:
                    return -0.120131887
            if state == 2:
                return 0.0852219164
    elif num_booster == 19:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3439999)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_det']) or (x['mag_det']<20.0947285)  else 4)
                if state == 3:
                    return 0.129002005
                if state == 4:
                    return -0.081948638
            if state == 2:
                return -0.119610563
    elif num_booster == 20:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<0.80899632)  else 2)
            if state == 1:
                return -0.105627738
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<9.35255814)  else 6)
                if state == 5:
                    return 0.140956685
                if state == 6:
                    return -0.0810006335
    elif num_booster == 21:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<17.6617317 else 2)
            if state == 1:
                return -0.0958292186
            if state == 2:
                return 0.0745636225
    elif num_booster == 22:
        return  -0.00591739081
    elif num_booster == 23:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.5548573)  else 2)
            if state == 1:
                return -0.0855949
            if state == 2:
                state = (5 if np.isnan(x['mag_last']) or (x['mag_last']<19.683815)  else 6)
                if state == 5:
                    return 0.150001749
                if state == 6:
                    return -0.071314007
    elif num_booster == 24:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<21.3137493)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['mag_last']) or (x['mag_last']<19.683815)  else 4)
                if state == 3:
                    return 0.147300124
                if state == 4:
                    return -0.0966665894
            if state == 2:
                return -0.0942993388
    elif num_booster == 25:
        return  -0.0610839389
    elif num_booster == 26:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.3564987)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['t_predetect']) or (x['t_predetect']<0.033605352)  else 4)
                if state == 3:
                    return -0.118259139
                if state == 4:
                    return 0.112541407
            if state == 2:
                return -0.082437247
    elif num_booster == 27:
        return  0.0173840486
    elif num_booster == 28:
        return  -0.0137669342
    elif num_booster == 29:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.796000004)  else 2)
            if state == 1:
                return -0.112494506
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.5174222)  else 6)
                if state == 5:
                    return 0.108820528
                if state == 6:
                    return -0.0481212921
    elif num_booster == 30:
        return  -0.0299332403
    elif num_booster == 31:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<20.110199)  else 2)
            if state == 1:
                return -0.0463110656
            if state == 2:
                return 0.121581234
    elif num_booster == 32:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.6925507)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.364562035 else 4)
                if state == 3:
                    return -0.0916763395
                if state == 4:
                    state = (5 if x['sgscore1_med']<0.00197916501 else 6)
                    if state == 5:
                        return -0.0888242945
                    if state == 6:
                        return 0.145433575
            if state == 2:
                return -0.120618418
    elif num_booster == 33:
        return  -0.0226008538
    elif num_booster == 34:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_det']) or (x['mag_det']<19.7165985)  else 2)
            if state == 1:
                return -0.109628566
            if state == 2:
                return 0.0619295761
    elif num_booster == 35:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<5.86610603)  else 2)
            if state == 1:
                return -0.0615650937
            if state == 2:
                return 0.103803232
    elif num_booster == 36:
        return  -0.0111932009
    elif num_booster == 37:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<17.9812202)  else 2)
            if state == 1:
                return -0.0752962306
            if state == 2:
                return 0.0835058391
    elif num_booster == 38:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['magnr_med']) or (x['magnr_med']<20.5655003)  else 2)
            if state == 1:
                return 0.0880023539
            if state == 2:
                return -0.0864682272
    elif num_booster == 39:
        return  0.0598164871
    elif num_booster == 40:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<17.6617317 else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.823571384)  else 4)
                if state == 3:
                    return -0.116279088
                if state == 4:
                    return 0.0976522416
            if state == 2:
                return 0.073854588
    elif num_booster == 41:
        return  -0.0162062403
    elif num_booster == 42:
        return  -0.0137762707
    elif num_booster == 43:
        return  0.00121934025
    elif num_booster == 44:
        return  -0.00781527162
    elif num_booster == 45:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_predetect']) or (x['t_predetect']<2.89681149)  else 2)
            if state == 1:
                return -0.10126812
            if state == 2:
                state = (5 if x['distpsnr1_med']<0.281283259 else 6)
                if state == 5:
                    return -0.106973276
                if state == 6:
                    return 0.08381062
    elif num_booster == 46:
        return  -0.0273006279
    elif num_booster == 47:
        return  0.0154025238
    elif num_booster == 48:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<6.06312466)  else 2)
            if state == 1:
                return 0.0887083337
            if state == 2:
                state = (5 if x['maggaia_med']<19.4579659 else 6)
                if state == 5:
                    return 0.0582580976
                if state == 6:
                    return -0.137891144
    elif num_booster == 49:
        return  0.0187371876
    elif num_booster == 50:
        state = 0
        if state == 0:
            state = (1 if x['neargaia_med']<18.3722324 else 2)
            if state == 1:
                return -0.0892078429
            if state == 2:
                return 0.0857759342
    elif num_booster == 51:
        return  -0.0183906984
    elif num_booster == 52:
        return  -0.00790819526
    elif num_booster == 53:
        return  0.0053420458
    elif num_booster == 54:
        return  -0.0334258154
    elif num_booster == 55:
        return  -0.0418654829
    elif num_booster == 56:
        return  -0.0126272487
    elif num_booster == 57:
        return  0.0254097022
    elif num_booster == 58:
        return  0.052768968
    elif num_booster == 59:
        return  0.00478773797
    elif num_booster == 60:
        state = 0
        if state == 0:
            state = (1 if x['sgscore1_med']<0.141321495 else 2)
            if state == 1:
                return 0.0696159154
            if state == 2:
                return -0.10070093
    elif num_booster == 61:
        return  -0.00433511147
    elif num_booster == 62:
        return  0.0696593672
    elif num_booster == 63:
        return  0.00535036903
    elif num_booster == 64:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.884249985)  else 2)
            if state == 1:
                return -0.114180125
            if state == 2:
                state = (5 if np.isnan(x['distnr_med']) or (x['distnr_med']<9.13675213)  else 6)
                if state == 5:
                    return 0.0848845616
                if state == 6:
                    return -0.1126706
    elif num_booster == 65:
        return  -0.0371376164
    elif num_booster == 66:
        return  -0.0289328676
    elif num_booster == 67:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<18.2437363)  else 2)
            if state == 1:
                return -0.106977642
            if state == 2:
                return 0.0889995694
    elif num_booster == 68:
        return  -0.015534902
    elif num_booster == 69:
        return  0.0385794826
    elif num_booster == 70:
        return  0.00562887173
    elif num_booster == 71:
        return  -0.0132018793
    elif num_booster == 72:
        return  -0.0165516511
    elif num_booster == 73:
        return  -0.0183648802
    elif num_booster == 74:
        return  0.0246146973
    elif num_booster == 75:
        return  -0.00319018355
    elif num_booster == 76:
        return  -0.00840744376
    elif num_booster == 77:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['distpsnr1_med']) or (x['distpsnr1_med']<6.38250256)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['classtar_med']) or (x['classtar_med']<0.958999991)  else 4)
                if state == 3:
                    return -0.117832452
                if state == 4:
                    state = (9 if np.isnan(x['distnr_med']) or (x['distnr_med']<2.82120371)  else 10)
                    if state == 9:
                        return 0.103965797
                    if state == 10:
                        return -0.107943788
            if state == 2:
                return 0.0910205171
    elif num_booster == 78:
        return  0.0615085922
    elif num_booster == 79:
        return  -0.0108953509
    elif num_booster == 80:
        return  -0.0014861424
    elif num_booster == 81:
        return  -0.0251574721
    elif num_booster == 82:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.7382317)  else 2)
            if state == 1:
                state = (3 if x['col_det']<-0.296922296 else 4)
                if state == 3:
                    return -0.0875169188
                if state == 4:
                    return 0.114642978
            if state == 2:
                return -0.097974889
    elif num_booster == 83:
        return  0.00828569289
    elif num_booster == 84:
        return  -0.0270721875
    elif num_booster == 85:
        return  -0.0456252508
    elif num_booster == 86:
        return  -0.00779013149
    elif num_booster == 87:
        return  0.0295684133
    elif num_booster == 88:
        return  -0.0266155079
    elif num_booster == 89:
        return  -0.00752876047
    elif num_booster == 90:
        return  -0.0330437124
    elif num_booster == 91:
        return  0.0006165331
    elif num_booster == 92:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['mag_last']) or (x['mag_last']<19.1022987)  else 2)
            if state == 1:
                return 0.0560696907
            if state == 2:
                return -0.111052789
    elif num_booster == 93:
        return  0.00936372299
    elif num_booster == 94:
        return  -0.0329455435
    elif num_booster == 95:
        return  0.00690229516
    elif num_booster == 96:
        return  -0.0096888775
    elif num_booster == 97:
        return  0.0261620712
    elif num_booster == 98:
        return  0.0131703401
    elif num_booster == 99:
        return  -0.0126535939



def xgb_tree_100(x, num_booster):
    if num_booster == 0:
        state = 0
        if state == 0:
            state = (1 if np.isnan(x['t_lc']) or (x['t_lc']<57.0089569)  else 2)
            if state == 1:
                state = (3 if np.isnan(x['rb_med']) or (x['rb_med']<0.921428561)  else 4)
                if state == 3:
                    state = (7 if np.isnan(x['rb_med']) or (x['rb_med']<0.396666765)  else 8)
                    if state == 7:
                        state = (15 if np.isnan(x['t_lc']) or (x['t_lc']<48.907814)  else 16)
                        if state == 15:
                            state = (31 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.9549999)  else 32)
                            if state == 31:
                                state = (61 if np.isnan(x['sgscore1_med']) or (x['sgscore1_med']<0.560709774)  else 62)
                                if state == 61:
                                    state = (119 if np.isnan(x['mag_det']) or (x['mag_det']<19.1404495)  else 120)
                                    if state == 119:
                                        state = (211 if np.isnan(x['magnr_med']) or (x['magnr_med']<17.4029999)  else 212)
                                        if state == 211:
                                            state = (339 if np.isnan(x['mag_last']) or (x['mag_last']<17.6315651)  else 340)
                                            if state == 339:
                                                return -0.629999995
                                            if state == 340:
                                                return -0.18703945
                                        if state == 212:
                                            return 0.683968604
                                    if state == 120:
                                        state = (213 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.0839996)  else 214)
                                        if state == 213:
                                            state = (341 if np.isnan(x['mag_last']) or (x['mag_last']<19.2133331)  else 342)
                                            if state == 341:
                                                return 0.420859694
                                            if state == 342:
                                                return -0.604504466
                                        if state == 214:
                                            state = (343 if np.isnan(x['mag_last']) or (x['mag_last']<19.6306877)  else 344)
                                            if state == 343:
                                                return 0.688046098
                                            if state == 344:
                                                state = (495 if np.isnan(x['neargaia_med']) or (x['neargaia_med']<6.18797016)  else 496)
                                                if state == 495:
                                                    state = (669 if np.isnan(x['magnr_med']) or (x['magnr_med']<19.1365013)  else 670)
                                                    if state == 669:
                                                        return 0.289490968
                                                    if state == 670:
                                                        return -0.64394933
                                                if state == 496:
                                                    return 0.149760351
                                if state == 62