# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-02-04 18:25


from django.db import migrations


def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    from django.apps import apps
    Setting = apps.get_model('settings', 'Setting')
    FileField = apps.get_model('filefields', 'FileField')

    key = ''
    for key_file_type, value_file_type in FileField.FILE_TYPE:
        try:
            value = ''
            if key_file_type == 'P':
                value = 'https://cdn.aparnik.com/static/img/icon_pdf.png'
            elif key_file_type == 'M':
                value = 'https://cdn.aparnik.com/static/img/icon_movie.png'
            elif key_file_type == 'V':
                value = 'https://cdn.aparnik.com/static/img/icon_voice.png'
            elif key_file_type == 'I':
                value = 'https://cdn.aparnik.com/static/img/icon_image.png'
            elif key_file_type == 'L':
                value = 'https://cdn.aparnik.com/static/img/icon_image.png'
            else:
                continue

            key = 'FILE_TYPE_%s_ICON' % key_file_type
            Setting.objects.get(key=key)
        except Exception:
            Setting.objects.create(
                title='آیکن مربوط به فایل تایپ %s'% value_file_type,
                key=key,
                value=value,
                value_type='s',
                is_show=False,
                is_variable_in_home=False,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0015_auto_20190201_1930'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=migrations.RunPython.noop),
    ]
