# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-04-29 16:04


from django.db import migrations



def add_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')
    key = ''
    try:
        key = 'WALLET_CHARGING_MESSAGE'
        Setting.objects.get(key=key)
    except Exception:
        Setting.objects.create(
            title='پیام شارژ کیف پول',
            key=key,
            value='کیف پول شما شارژ ندارد. لطفا ابتدا کیف پول خود را شارژ بفرمایید.',
            value_type='s',
            is_show=False,
            is_variable_in_home=False,
        )


def remove_keys(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Setting = apps.get_model('settings', 'Setting')
    try:
        key = 'WALLET_CHARGING_MESSAGE'
        Setting.objects.get(key=key).delete()
    except Exception:
        pass


class Migration(migrations.Migration):

    dependencies = [
        ('settings', '0017_auto_20190428_0959'),
    ]

    operations = [
        migrations.RunPython(add_keys, reverse_code=remove_keys),
    ]
