"""empty message

Revision ID: edd060f35350
Revises: 
Create Date: 2020-12-08 13:18:21.785778

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'edd060f35350'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('appointments',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('date', sa.String(length=20), nullable=True),
    sa.Column('time', sa.String(length=20), nullable=True),
    sa.Column('active', sa.String(length=20), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('categories',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_table('contact',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_date', sa.DateTime(), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('email', sa.String(length=100), nullable=True),
    sa.Column('message', sa.String(length=1024), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('images',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('filename', sa.String(length=50), nullable=False),
    sa.Column('thumbnail', sa.String(length=50), nullable=False),
    sa.Column('file_size', sa.Integer(), nullable=False),
    sa.Column('file_width', sa.Integer(), nullable=False),
    sa.Column('file_height', sa.Integer(), nullable=False),
    sa.Column('create_date', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('pages',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('created_date', sa.DateTime(), nullable=True),
    sa.Column('title', sa.String(length=100), nullable=True),
    sa.Column('slug', sa.String(length=100), nullable=True),
    sa.Column('content', sa.String(length=1024), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('people',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('phone', sa.Integer(), nullable=True),
    sa.Column('mobile', sa.Integer(), nullable=True),
    sa.Column('email', sa.String(length=100), nullable=True),
    sa.Column('facebook', sa.String(length=128), nullable=True),
    sa.Column('twitter', sa.String(length=128), nullable=True),
    sa.Column('linkedin', sa.String(length=128), nullable=True),
    sa.Column('age', sa.Integer(), nullable=True),
    sa.Column('birthday', sa.String(length=100), nullable=True),
    sa.Column('notes', sa.String(length=100), nullable=True),
    sa.Column('is_manufacturer', sa.Boolean(), nullable=True),
    sa.Column('manufacturer_name', sa.String(length=100), nullable=True),
    sa.Column('manufacturer_phone', sa.Integer(), nullable=True),
    sa.Column('manufacturer_address', sa.String(length=200), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('roles',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('settings',
    sa.Column('setting', sa.String(length=100), nullable=False),
    sa.Column('value', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('setting')
    )
    op.create_table('transactions',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('chashier_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('users',
    sa.Column('id', sa.String(length=10), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('password', sa.String(length=128), nullable=False),
    sa.Column('first_name', sa.String(length=128), nullable=True),
    sa.Column('last_name', sa.String(length=128), nullable=True),
    sa.Column('is_admin', sa.Boolean(), nullable=True),
    sa.Column('email', sa.String(length=120), nullable=False),
    sa.Column('date_registered', sa.DateTime(), nullable=False),
    sa.Column('email_confirmed', sa.Boolean(), nullable=False),
    sa.Column('email_confirm_date', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('email'),
    sa.UniqueConstraint('username')
    )
    op.create_table('role_helpers',
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles.id'], ),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], )
    )
    op.create_table('subcategories',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('category_name', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['category_name'], ['categories.name'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('product',
    sa.Column('barcode', sa.String(length=100), nullable=False),
    sa.Column('price', sa.Float(), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('description', sa.String(length=300), nullable=True),
    sa.Column('date', sa.String(length=100), nullable=True),
    sa.Column('in_stock', sa.Integer(), nullable=True),
    sa.Column('discontinued', sa.Boolean(), nullable=True),
    sa.Column('selling_price', sa.Float(), nullable=True),
    sa.Column('subcategory_name', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['subcategory_name'], ['subcategories.name'], ),
    sa.PrimaryKeyConstraint('barcode')
    )
    op.create_table('resources',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('filename', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('category', sa.String(length=50), nullable=False),
    sa.Column('created_date', sa.DateTime(), nullable=False),
    sa.Column('product_barcode', sa.String(length=100), nullable=True),
    sa.Column('category_name', sa.String(length=100), nullable=True),
    sa.Column('subcategory_name', sa.String(length=100), nullable=True),
    sa.ForeignKeyConstraint(['category_name'], ['categories.name'], ),
    sa.ForeignKeyConstraint(['product_barcode'], ['product.barcode'], ),
    sa.ForeignKeyConstraint(['subcategory_name'], ['subcategories.name'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('transaction_helpers',
    sa.Column('product_barcode', sa.Integer(), nullable=True),
    sa.Column('transaction_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['product_barcode'], ['product.barcode'], ),
    sa.ForeignKeyConstraint(['transaction_id'], ['transactions.id'], )
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('transaction_helpers')
    op.drop_table('resources')
    op.drop_table('product')
    op.drop_table('subcategories')
    op.drop_table('role_helpers')
    op.drop_table('users')
    op.drop_table('transactions')
    op.drop_table('settings')
    op.drop_table('roles')
    op.drop_table('people')
    op.drop_table('pages')
    op.drop_table('images')
    op.drop_table('contact')
    op.drop_table('categories')
    op.drop_table('appointments')
    # ### end Alembic commands ###
