#!/usr/bin/python
#
# Copyright 2018-2021 Polyaxon, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Polyaxon SDKs and REST API specification.

    Polyaxon SDKs and REST API specification.  # noqa: E501

    The version of the OpenAPI document: 1.16.1
    Contact: contact@polyaxon.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from polyaxon_sdk.configuration import Configuration


class V1Agent(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'uuid': 'str',
        'name': 'str',
        'description': 'str',
        'tags': 'list[str]',
        'live_state': 'int',
        'namespace': 'str',
        'version_api': 'object',
        'version': 'str',
        'content': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'status': 'V1Statuses',
        'is_replica': 'bool',
        'is_ui_managed': 'bool',
        'settings': 'object'
    }

    attribute_map = {
        'uuid': 'uuid',
        'name': 'name',
        'description': 'description',
        'tags': 'tags',
        'live_state': 'live_state',
        'namespace': 'namespace',
        'version_api': 'version_api',
        'version': 'version',
        'content': 'content',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'status': 'status',
        'is_replica': 'is_replica',
        'is_ui_managed': 'is_ui_managed',
        'settings': 'settings'
    }

    def __init__(self, uuid=None, name=None, description=None, tags=None, live_state=None, namespace=None, version_api=None, version=None, content=None, created_at=None, updated_at=None, status=None, is_replica=None, is_ui_managed=None, settings=None, local_vars_configuration=None):  # noqa: E501
        """V1Agent - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._uuid = None
        self._name = None
        self._description = None
        self._tags = None
        self._live_state = None
        self._namespace = None
        self._version_api = None
        self._version = None
        self._content = None
        self._created_at = None
        self._updated_at = None
        self._status = None
        self._is_replica = None
        self._is_ui_managed = None
        self._settings = None
        self.discriminator = None

        if uuid is not None:
            self.uuid = uuid
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if tags is not None:
            self.tags = tags
        if live_state is not None:
            self.live_state = live_state
        if namespace is not None:
            self.namespace = namespace
        if version_api is not None:
            self.version_api = version_api
        if version is not None:
            self.version = version
        if content is not None:
            self.content = content
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if status is not None:
            self.status = status
        if is_replica is not None:
            self.is_replica = is_replica
        if is_ui_managed is not None:
            self.is_ui_managed = is_ui_managed
        if settings is not None:
            self.settings = settings

    @property
    def uuid(self):
        """Gets the uuid of this V1Agent.  # noqa: E501


        :return: The uuid of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this V1Agent.


        :param uuid: The uuid of this V1Agent.  # noqa: E501
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def name(self):
        """Gets the name of this V1Agent.  # noqa: E501


        :return: The name of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1Agent.


        :param name: The name of this V1Agent.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this V1Agent.  # noqa: E501


        :return: The description of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this V1Agent.


        :param description: The description of this V1Agent.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def tags(self):
        """Gets the tags of this V1Agent.  # noqa: E501


        :return: The tags of this V1Agent.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this V1Agent.


        :param tags: The tags of this V1Agent.  # noqa: E501
        :type tags: list[str]
        """

        self._tags = tags

    @property
    def live_state(self):
        """Gets the live_state of this V1Agent.  # noqa: E501


        :return: The live_state of this V1Agent.  # noqa: E501
        :rtype: int
        """
        return self._live_state

    @live_state.setter
    def live_state(self, live_state):
        """Sets the live_state of this V1Agent.


        :param live_state: The live_state of this V1Agent.  # noqa: E501
        :type live_state: int
        """

        self._live_state = live_state

    @property
    def namespace(self):
        """Gets the namespace of this V1Agent.  # noqa: E501


        :return: The namespace of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this V1Agent.


        :param namespace: The namespace of this V1Agent.  # noqa: E501
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def version_api(self):
        """Gets the version_api of this V1Agent.  # noqa: E501


        :return: The version_api of this V1Agent.  # noqa: E501
        :rtype: object
        """
        return self._version_api

    @version_api.setter
    def version_api(self, version_api):
        """Sets the version_api of this V1Agent.


        :param version_api: The version_api of this V1Agent.  # noqa: E501
        :type version_api: object
        """

        self._version_api = version_api

    @property
    def version(self):
        """Gets the version of this V1Agent.  # noqa: E501


        :return: The version of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this V1Agent.


        :param version: The version of this V1Agent.  # noqa: E501
        :type version: str
        """

        self._version = version

    @property
    def content(self):
        """Gets the content of this V1Agent.  # noqa: E501


        :return: The content of this V1Agent.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this V1Agent.


        :param content: The content of this V1Agent.  # noqa: E501
        :type content: str
        """

        self._content = content

    @property
    def created_at(self):
        """Gets the created_at of this V1Agent.  # noqa: E501


        :return: The created_at of this V1Agent.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this V1Agent.


        :param created_at: The created_at of this V1Agent.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this V1Agent.  # noqa: E501


        :return: The updated_at of this V1Agent.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this V1Agent.


        :param updated_at: The updated_at of this V1Agent.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def status(self):
        """Gets the status of this V1Agent.  # noqa: E501


        :return: The status of this V1Agent.  # noqa: E501
        :rtype: V1Statuses
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this V1Agent.


        :param status: The status of this V1Agent.  # noqa: E501
        :type status: V1Statuses
        """

        self._status = status

    @property
    def is_replica(self):
        """Gets the is_replica of this V1Agent.  # noqa: E501


        :return: The is_replica of this V1Agent.  # noqa: E501
        :rtype: bool
        """
        return self._is_replica

    @is_replica.setter
    def is_replica(self, is_replica):
        """Sets the is_replica of this V1Agent.


        :param is_replica: The is_replica of this V1Agent.  # noqa: E501
        :type is_replica: bool
        """

        self._is_replica = is_replica

    @property
    def is_ui_managed(self):
        """Gets the is_ui_managed of this V1Agent.  # noqa: E501


        :return: The is_ui_managed of this V1Agent.  # noqa: E501
        :rtype: bool
        """
        return self._is_ui_managed

    @is_ui_managed.setter
    def is_ui_managed(self, is_ui_managed):
        """Sets the is_ui_managed of this V1Agent.


        :param is_ui_managed: The is_ui_managed of this V1Agent.  # noqa: E501
        :type is_ui_managed: bool
        """

        self._is_ui_managed = is_ui_managed

    @property
    def settings(self):
        """Gets the settings of this V1Agent.  # noqa: E501


        :return: The settings of this V1Agent.  # noqa: E501
        :rtype: object
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this V1Agent.


        :param settings: The settings of this V1Agent.  # noqa: E501
        :type settings: object
        """

        self._settings = settings

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1Agent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1Agent):
            return True

        return self.to_dict() != other.to_dict()
