from distutils.core import setup
from pathlib import Path
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()



setup(
  name = 'django_arg_path',
  packages = ['django_arg_path'],
  version = '0.1.2.4',
  license='MIT',        # Chose a license from here: https://help.github.com/articles/licensing-a-repository
  description = 'We like writing short codes but we don"t want to think about logic. Here with django-arg-path package you can write short and clean code easily',
  long_description=long_description,
  long_description_content_type='text/markdown',
  author = 'Nuru Hasanov',                   # Type in your name
  author_email = 'nurhesen@gmail.com',      # Type in your E-Mail
  url = 'https://github.com/nurhesen',   # Provide either the link to your github or to your website
  download_url = 'https://github.com/user/reponame/archive/v_01.tar.gz',    # I explain this later on
  keywords = ['django', 'path', 'static', 'urls'],   # Keywords that define your package best
  install_requires=[            # I get to this in a second
          'django',
      ],
  classifiers=[
    'Development Status :: 5 - Production/Stable',      # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
    'Intended Audience :: Developers',      # Define that your audience are developers
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',   # Again, pick a license
    'Programming Language :: Python :: 3',      #Specify which pyhton versions that you want to support
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    'Programming Language :: Python :: 3.7',
    'Programming Language :: Python :: 3.8',
    'Programming Language :: Python :: 3.9',
  ],

  
  
)