import argparse
import sys

from . import cli

if __name__ == '__main__':
    parser = argparse.ArgumentParser(
        description='Microservice management',
        prog='shopcloud-microservice'
    )

    subparsers = parser.add_subparsers(help='commands', title='commands')
    parser.add_argument('--debug', '-d', help='Debug', action='store_true')
    parser.add_argument('--simulate', '-s', help='Simulate the process', action='store_true')
    parser.add_argument('--secrethub-token', help='Secrethub-Token', type=str)

    parser_security = subparsers.add_parser('security', help='security')
    parser_security.add_argument(
        'action',
        const='generate',
        nargs='?',
        choices=['merge-security-pull-requests', 'scan']
    )
    parser_security.add_argument('repo', const='generate', nargs='?')
    parser_security.set_defaults(which='security')

    args = parser.parse_args()
    if len(sys.argv) == 1:
        parser.print_help(sys.stderr)
        sys.exit(1)
    rc = cli.main(args)
    if rc != 0:
        sys.exit(rc)
