"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("../lib");
test('Correctly validate Docker image asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            dockerImages: {
                asset: {
                    source: {
                        directory: '.',
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            repositoryName: 'REPO',
                            imageTag: 'TAG',
                            imageUri: 'URI',
                        },
                    },
                },
            },
        });
    }).not.toThrow();
});
test('Throw on invalid Docker image asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            dockerImages: {
                asset: {
                    source: {},
                    destinations: {},
                },
            },
        });
    }).toThrow(/dockerImages: source: Expected key 'directory' missing/);
});
test('Correctly validate File asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            files: {
                asset: {
                    source: {
                        path: 'a/b/c',
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            bucketName: 'Bouquet',
                            objectKey: 'key',
                        }
                    },
                },
            },
        });
    }).not.toThrow();
});
test('Throw on invalid file asset', () => {
    expect(() => {
        lib_1.AssetManifestSchema.validate({
            version: lib_1.AssetManifestSchema.currentVersion(),
            files: {
                asset: {
                    source: {
                        path: 3,
                    },
                    destinations: {
                        dest: {
                            region: 'us-north-20',
                            bucketName: 'Bouquet',
                            objectKey: 'key',
                        }
                    },
                },
            },
        });
    }).toThrow(/Expected a string, got '3'/);
});
//# sourceMappingURL=data:application/json;base64,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