import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApproleAuthBackendRoleSecretIdConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the auth backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#backend ApproleAuthBackendRoleSecretId#backend}
    */
    readonly backend?: string;
    /**
    * List of CIDR blocks that can log in using the SecretID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#cidr_list ApproleAuthBackendRoleSecretId#cidr_list}
    */
    readonly cidrList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#id ApproleAuthBackendRoleSecretId#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * JSON-encoded secret data to write.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#metadata ApproleAuthBackendRoleSecretId#metadata}
    */
    readonly metadata?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#namespace ApproleAuthBackendRoleSecretId#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#role_name ApproleAuthBackendRoleSecretId#role_name}
    */
    readonly roleName: string;
    /**
    * The SecretID to be managed. If not specified, Vault auto-generates one.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#secret_id ApproleAuthBackendRoleSecretId#secret_id}
    */
    readonly secretId?: string;
    /**
    * Use the wrapped secret-id accessor as the id of this resource. If false, a fresh secret-id will be regenerated whenever the wrapping token is expired or invalidated through unwrapping.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#with_wrapped_accessor ApproleAuthBackendRoleSecretId#with_wrapped_accessor}
    */
    readonly withWrappedAccessor?: boolean | cdktf.IResolvable;
    /**
    * The TTL duration of the wrapped SecretID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id#wrapping_ttl ApproleAuthBackendRoleSecretId#wrapping_ttl}
    */
    readonly wrappingTtl?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id vault_approle_auth_backend_role_secret_id}
*/
export declare class ApproleAuthBackendRoleSecretId extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_approle_auth_backend_role_secret_id";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role_secret_id vault_approle_auth_backend_role_secret_id} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApproleAuthBackendRoleSecretIdConfig
    */
    constructor(scope: Construct, id: string, config: ApproleAuthBackendRoleSecretIdConfig);
    get accessor(): string;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _cidrList?;
    get cidrList(): string[];
    set cidrList(value: string[]);
    resetCidrList(): void;
    get cidrListInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    resetSecretId(): void;
    get secretIdInput(): string | undefined;
    private _withWrappedAccessor?;
    get withWrappedAccessor(): boolean | cdktf.IResolvable;
    set withWrappedAccessor(value: boolean | cdktf.IResolvable);
    resetWithWrappedAccessor(): void;
    get withWrappedAccessorInput(): boolean | cdktf.IResolvable | undefined;
    get wrappingAccessor(): string;
    get wrappingToken(): string;
    private _wrappingTtl?;
    get wrappingTtl(): string;
    set wrappingTtl(value: string);
    resetWrappingTtl(): void;
    get wrappingTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
