import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKvSecretsListV2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2#id DataVaultKvSecretsListV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Path where KV-V2 engine is mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2#mount DataVaultKvSecretsListV2#mount}
    */
    readonly mount: string;
    /**
    * Full named path of the secret. For a nested secret, the name is the nested path excluding the mount and data prefix. For example, for a secret at 'kvv2/data/foo/bar/baz', the name is 'foo/bar/baz'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2#name DataVaultKvSecretsListV2#name}
    */
    readonly name?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2#namespace DataVaultKvSecretsListV2#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2 vault_kv_secrets_list_v2}
*/
export declare class DataVaultKvSecretsListV2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kv_secrets_list_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kv_secrets_list_v2 vault_kv_secrets_list_v2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKvSecretsListV2Config
    */
    constructor(scope: Construct, id: string, config: DataVaultKvSecretsListV2Config);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mount?;
    get mount(): string;
    set mount(value: string);
    get mountInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get names(): string[];
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get path(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
