import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabaseSecretsMountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#audit_non_hmac_request_keys DatabaseSecretsMount#audit_non_hmac_request_keys}
    */
    readonly auditNonHmacRequestKeys?: string[];
    /**
    * Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#audit_non_hmac_response_keys DatabaseSecretsMount#audit_non_hmac_response_keys}
    */
    readonly auditNonHmacResponseKeys?: string[];
    /**
    * Default lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#default_lease_ttl_seconds DatabaseSecretsMount#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#description DatabaseSecretsMount#description}
    */
    readonly description?: string;
    /**
    * Enable the secrets engine to access Vault's external entropy source
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#external_entropy_access DatabaseSecretsMount#external_entropy_access}
    */
    readonly externalEntropyAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#id DatabaseSecretsMount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Local mount flag that can be explicitly set to true to enforce local mount in HA environment
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#local DatabaseSecretsMount#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum possible lease duration for tokens and secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_lease_ttl_seconds DatabaseSecretsMount#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#namespace DatabaseSecretsMount#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies mount type specific options that are passed to the backend
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#options DatabaseSecretsMount#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Where the secret backend will be mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#path DatabaseSecretsMount#path}
    */
    readonly path: string;
    /**
    * Enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#seal_wrap DatabaseSecretsMount#seal_wrap}
    */
    readonly sealWrap?: boolean | cdktf.IResolvable;
    /**
    * cassandra block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#cassandra DatabaseSecretsMount#cassandra}
    */
    readonly cassandra?: DatabaseSecretsMountCassandra[] | cdktf.IResolvable;
    /**
    * couchbase block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#couchbase DatabaseSecretsMount#couchbase}
    */
    readonly couchbase?: DatabaseSecretsMountCouchbase[] | cdktf.IResolvable;
    /**
    * elasticsearch block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#elasticsearch DatabaseSecretsMount#elasticsearch}
    */
    readonly elasticsearch?: DatabaseSecretsMountElasticsearch[] | cdktf.IResolvable;
    /**
    * hana block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#hana DatabaseSecretsMount#hana}
    */
    readonly hana?: DatabaseSecretsMountHana[] | cdktf.IResolvable;
    /**
    * influxdb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#influxdb DatabaseSecretsMount#influxdb}
    */
    readonly influxdb?: DatabaseSecretsMountInfluxdb[] | cdktf.IResolvable;
    /**
    * mongodb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mongodb DatabaseSecretsMount#mongodb}
    */
    readonly mongodb?: DatabaseSecretsMountMongodb[] | cdktf.IResolvable;
    /**
    * mongodbatlas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mongodbatlas DatabaseSecretsMount#mongodbatlas}
    */
    readonly mongodbatlas?: DatabaseSecretsMountMongodbatlas[] | cdktf.IResolvable;
    /**
    * mssql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mssql DatabaseSecretsMount#mssql}
    */
    readonly mssql?: DatabaseSecretsMountMssql[] | cdktf.IResolvable;
    /**
    * mysql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mysql DatabaseSecretsMount#mysql}
    */
    readonly mysql?: DatabaseSecretsMountMysql[] | cdktf.IResolvable;
    /**
    * mysql_aurora block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mysql_aurora DatabaseSecretsMount#mysql_aurora}
    */
    readonly mysqlAurora?: DatabaseSecretsMountMysqlAurora[] | cdktf.IResolvable;
    /**
    * mysql_legacy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mysql_legacy DatabaseSecretsMount#mysql_legacy}
    */
    readonly mysqlLegacy?: DatabaseSecretsMountMysqlLegacy[] | cdktf.IResolvable;
    /**
    * mysql_rds block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#mysql_rds DatabaseSecretsMount#mysql_rds}
    */
    readonly mysqlRds?: DatabaseSecretsMountMysqlRds[] | cdktf.IResolvable;
    /**
    * oracle block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#oracle DatabaseSecretsMount#oracle}
    */
    readonly oracle?: DatabaseSecretsMountOracle[] | cdktf.IResolvable;
    /**
    * postgresql block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#postgresql DatabaseSecretsMount#postgresql}
    */
    readonly postgresql?: DatabaseSecretsMountPostgresql[] | cdktf.IResolvable;
    /**
    * redshift block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#redshift DatabaseSecretsMount#redshift}
    */
    readonly redshift?: DatabaseSecretsMountRedshift[] | cdktf.IResolvable;
    /**
    * snowflake block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#snowflake DatabaseSecretsMount#snowflake}
    */
    readonly snowflake?: DatabaseSecretsMountSnowflake[] | cdktf.IResolvable;
}
export interface DatabaseSecretsMountCassandra {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * The number of seconds to use as a connection timeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connect_timeout DatabaseSecretsMount#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Cassandra hosts to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#hosts DatabaseSecretsMount#hosts}
    */
    readonly hosts?: string[];
    /**
    * Whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#insecure_tls DatabaseSecretsMount#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The password to use when authenticating with Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#pem_bundle DatabaseSecretsMount#pem_bundle}
    */
    readonly pemBundle?: string;
    /**
    * Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#pem_json DatabaseSecretsMount#pem_json}
    */
    readonly pemJson?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * The transport port to use to connect to Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#port DatabaseSecretsMount#port}
    */
    readonly port?: number;
    /**
    * The CQL protocol version to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#protocol_version DatabaseSecretsMount#protocol_version}
    */
    readonly protocolVersion?: number;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * Whether to use TLS when connecting to Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls DatabaseSecretsMount#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * The username to use when authenticating with Cassandra.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountCassandraToTerraform(struct?: DatabaseSecretsMountCassandra | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountCassandraOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountCassandra | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountCassandra | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    resetHosts(): void;
    get hostsInput(): string[] | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    resetPemBundle(): void;
    get pemBundleInput(): string | undefined;
    private _pemJson?;
    get pemJson(): string;
    set pemJson(value: string);
    resetPemJson(): void;
    get pemJsonInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _protocolVersion?;
    get protocolVersion(): number;
    set protocolVersion(value: number);
    resetProtocolVersion(): void;
    get protocolVersionInput(): number | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountCassandraList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountCassandra[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountCassandraOutputReference;
}
export interface DatabaseSecretsMountCouchbase {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Required if `tls` is `true`. Specifies the certificate authority of the Couchbase server, as a PEM certificate that has been base64 encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#base64_pem DatabaseSecretsMount#base64_pem}
    */
    readonly base64Pem?: string;
    /**
    * Required for Couchbase versions prior to 6.5.0. This is only used to verify vault's connection to the server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#bucket_name DatabaseSecretsMount#bucket_name}
    */
    readonly bucketName?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * A set of Couchbase URIs to connect to. Must use `couchbases://` scheme if `tls` is `true`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#hosts DatabaseSecretsMount#hosts}
    */
    readonly hosts: string[];
    /**
    *  Specifies whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#insecure_tls DatabaseSecretsMount#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * Specifies the password corresponding to the given username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * Specifies whether to use TLS when connecting to Couchbase.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls DatabaseSecretsMount#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the username for Vault to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountCouchbaseToTerraform(struct?: DatabaseSecretsMountCouchbase | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountCouchbaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountCouchbase | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountCouchbase | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _base64Pem?;
    get base64Pem(): string;
    set base64Pem(value: string);
    resetBase64Pem(): void;
    get base64PemInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    resetBucketName(): void;
    get bucketNameInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _hosts?;
    get hosts(): string[];
    set hosts(value: string[]);
    get hostsInput(): string[] | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountCouchbaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountCouchbase[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountCouchbaseOutputReference;
}
export interface DatabaseSecretsMountElasticsearch {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * The path to a PEM-encoded CA cert file to use to verify the Elasticsearch server's identity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#ca_cert DatabaseSecretsMount#ca_cert}
    */
    readonly caCert?: string;
    /**
    * The path to a directory of PEM-encoded CA cert files to use to verify the Elasticsearch server's identity
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#ca_path DatabaseSecretsMount#ca_path}
    */
    readonly caPath?: string;
    /**
    * The path to the certificate for the Elasticsearch client to present for communication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#client_cert DatabaseSecretsMount#client_cert}
    */
    readonly clientCert?: string;
    /**
    * The path to the key for the Elasticsearch client to use for communication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#client_key DatabaseSecretsMount#client_key}
    */
    readonly clientKey?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Whether to disable certificate verification
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#insecure DatabaseSecretsMount#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The password to be used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * This, if set, is used to set the SNI host when connecting via TLS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls_server_name DatabaseSecretsMount#tls_server_name}
    */
    readonly tlsServerName?: string;
    /**
    * The URL for Elasticsearch's API
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#url DatabaseSecretsMount#url}
    */
    readonly url: string;
    /**
    * The username to be used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountElasticsearchToTerraform(struct?: DatabaseSecretsMountElasticsearch | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountElasticsearchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountElasticsearch | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountElasticsearch | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _caCert?;
    get caCert(): string;
    set caCert(value: string);
    resetCaCert(): void;
    get caCertInput(): string | undefined;
    private _caPath?;
    get caPath(): string;
    set caPath(value: string);
    resetCaPath(): void;
    get caPathInput(): string | undefined;
    private _clientCert?;
    get clientCert(): string;
    set clientCert(value: string);
    resetClientCert(): void;
    get clientCertInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable;
    set insecure(value: boolean | cdktf.IResolvable);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _tlsServerName?;
    get tlsServerName(): string;
    set tlsServerName(value: string);
    resetTlsServerName(): void;
    get tlsServerNameInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountElasticsearchList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountElasticsearch[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountElasticsearchOutputReference;
}
export interface DatabaseSecretsMountHana {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#disable_escaping DatabaseSecretsMount#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountHanaToTerraform(struct?: DatabaseSecretsMountHana | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountHanaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountHana | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountHana | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountHanaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountHana[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountHanaOutputReference;
}
export interface DatabaseSecretsMountInfluxdb {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * The number of seconds to use as a connection timeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connect_timeout DatabaseSecretsMount#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Influxdb host to connect to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#host DatabaseSecretsMount#host}
    */
    readonly host: string;
    /**
    * Whether to skip verification of the server certificate when using TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#insecure_tls DatabaseSecretsMount#insecure_tls}
    */
    readonly insecureTls?: boolean | cdktf.IResolvable;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * Specifies the password corresponding to the given username.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password: string;
    /**
    * Concatenated PEM blocks containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#pem_bundle DatabaseSecretsMount#pem_bundle}
    */
    readonly pemBundle?: string;
    /**
    * Specifies JSON containing a certificate and private key; a certificate, private key, and issuing CA certificate; or just a CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#pem_json DatabaseSecretsMount#pem_json}
    */
    readonly pemJson?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * The transport port to use to connect to Influxdb.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#port DatabaseSecretsMount#port}
    */
    readonly port?: number;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * Whether to use TLS when connecting to Influxdb.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls DatabaseSecretsMount#tls}
    */
    readonly tls?: boolean | cdktf.IResolvable;
    /**
    * Specifies the username to use for superuser access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountInfluxdbToTerraform(struct?: DatabaseSecretsMountInfluxdb | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountInfluxdbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountInfluxdb | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountInfluxdb | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _insecureTls?;
    get insecureTls(): boolean | cdktf.IResolvable;
    set insecureTls(value: boolean | cdktf.IResolvable);
    resetInsecureTls(): void;
    get insecureTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _pemBundle?;
    get pemBundle(): string;
    set pemBundle(value: string);
    resetPemBundle(): void;
    get pemBundleInput(): string | undefined;
    private _pemJson?;
    get pemJson(): string;
    set pemJson(value: string);
    resetPemJson(): void;
    get pemJsonInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _tls?;
    get tls(): boolean | cdktf.IResolvable;
    set tls(value: boolean | cdktf.IResolvable);
    resetTls(): void;
    get tlsInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountInfluxdbList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountInfluxdb[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountInfluxdbOutputReference;
}
export interface DatabaseSecretsMountMongodb {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMongodbToTerraform(struct?: DatabaseSecretsMountMongodb | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMongodbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMongodb | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMongodb | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMongodbList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMongodb[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMongodbOutputReference;
}
export interface DatabaseSecretsMountMongodbatlas {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * The Private Programmatic API Key used to connect with MongoDB Atlas API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#private_key DatabaseSecretsMount#private_key}
    */
    readonly privateKey: string;
    /**
    * The Project ID the Database User should be created within.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#project_id DatabaseSecretsMount#project_id}
    */
    readonly projectId: string;
    /**
    * The Public Programmatic API Key used to authenticate with the MongoDB Atlas API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#public_key DatabaseSecretsMount#public_key}
    */
    readonly publicKey: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMongodbatlasToTerraform(struct?: DatabaseSecretsMountMongodbatlas | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMongodbatlasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMongodbatlas | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMongodbatlas | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    get privateKeyInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMongodbatlasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMongodbatlas[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMongodbatlasOutputReference;
}
export interface DatabaseSecretsMountMssql {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * Set to true when the target is a Contained Database, e.g. AzureSQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#contained_db DatabaseSecretsMount#contained_db}
    */
    readonly containedDb?: boolean | cdktf.IResolvable;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#disable_escaping DatabaseSecretsMount#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMssqlToTerraform(struct?: DatabaseSecretsMountMssql | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMssqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMssql | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMssql | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _containedDb?;
    get containedDb(): boolean | cdktf.IResolvable;
    set containedDb(value: boolean | cdktf.IResolvable);
    resetContainedDb(): void;
    get containedDbInput(): boolean | cdktf.IResolvable | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMssqlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMssql[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMssqlOutputReference;
}
export interface DatabaseSecretsMountMysql {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * x509 CA file for validating the certificate presented by the MySQL server. Must be PEM encoded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls_ca DatabaseSecretsMount#tls_ca}
    */
    readonly tlsCa?: string;
    /**
    * x509 certificate for connecting to the database. This must be a PEM encoded version of the private key and the certificate combined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#tls_certificate_key DatabaseSecretsMount#tls_certificate_key}
    */
    readonly tlsCertificateKey?: string;
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMysqlToTerraform(struct?: DatabaseSecretsMountMysql | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMysqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMysql | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMysql | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _tlsCa?;
    get tlsCa(): string;
    set tlsCa(value: string);
    resetTlsCa(): void;
    get tlsCaInput(): string | undefined;
    private _tlsCertificateKey?;
    get tlsCertificateKey(): string;
    set tlsCertificateKey(value: string);
    resetTlsCertificateKey(): void;
    get tlsCertificateKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMysqlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMysql[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMysqlOutputReference;
}
export interface DatabaseSecretsMountMysqlAurora {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMysqlAuroraToTerraform(struct?: DatabaseSecretsMountMysqlAurora | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMysqlAuroraOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMysqlAurora | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMysqlAurora | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMysqlAuroraList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMysqlAurora[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMysqlAuroraOutputReference;
}
export interface DatabaseSecretsMountMysqlLegacy {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMysqlLegacyToTerraform(struct?: DatabaseSecretsMountMysqlLegacy | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMysqlLegacyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMysqlLegacy | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMysqlLegacy | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMysqlLegacyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMysqlLegacy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMysqlLegacyOutputReference;
}
export interface DatabaseSecretsMountMysqlRds {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountMysqlRdsToTerraform(struct?: DatabaseSecretsMountMysqlRds | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountMysqlRdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountMysqlRds | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountMysqlRds | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountMysqlRdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountMysqlRds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountMysqlRdsOutputReference;
}
export interface DatabaseSecretsMountOracle {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountOracleToTerraform(struct?: DatabaseSecretsMountOracle | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountOracleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountOracle | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountOracle | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountOracleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountOracle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountOracleOutputReference;
}
export interface DatabaseSecretsMountPostgresql {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#disable_escaping DatabaseSecretsMount#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountPostgresqlToTerraform(struct?: DatabaseSecretsMountPostgresql | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountPostgresqlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountPostgresql | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountPostgresql | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountPostgresqlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountPostgresql[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountPostgresqlOutputReference;
}
export interface DatabaseSecretsMountRedshift {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Disable special character escaping in username and password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#disable_escaping DatabaseSecretsMount#disable_escaping}
    */
    readonly disableEscaping?: boolean | cdktf.IResolvable;
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountRedshiftToTerraform(struct?: DatabaseSecretsMountRedshift | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountRedshiftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountRedshift | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountRedshift | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _disableEscaping?;
    get disableEscaping(): boolean | cdktf.IResolvable;
    set disableEscaping(value: boolean | cdktf.IResolvable);
    resetDisableEscaping(): void;
    get disableEscapingInput(): boolean | cdktf.IResolvable | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountRedshiftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountRedshift[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountRedshiftOutputReference;
}
export interface DatabaseSecretsMountSnowflake {
    /**
    * A list of roles that are allowed to use this connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#allowed_roles DatabaseSecretsMount#allowed_roles}
    */
    readonly allowedRoles?: string[];
    /**
    * Connection string to use to connect to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#connection_url DatabaseSecretsMount#connection_url}
    */
    readonly connectionUrl?: string;
    /**
    * A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#data DatabaseSecretsMount#data}
    */
    readonly data?: {
        [key: string]: string;
    };
    /**
    * Maximum number of seconds a connection may be reused.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_connection_lifetime DatabaseSecretsMount#max_connection_lifetime}
    */
    readonly maxConnectionLifetime?: number;
    /**
    * Maximum number of idle connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_idle_connections DatabaseSecretsMount#max_idle_connections}
    */
    readonly maxIdleConnections?: number;
    /**
    * Maximum number of open connections to the database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#max_open_connections DatabaseSecretsMount#max_open_connections}
    */
    readonly maxOpenConnections?: number;
    /**
    * Name of the database connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#name DatabaseSecretsMount#name}
    */
    readonly name: string;
    /**
    * The root credential password used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#password DatabaseSecretsMount#password}
    */
    readonly password?: string;
    /**
    * Specifies the name of the plugin to use for this connection. Must be prefixed with the name of one of the supported database engine types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#plugin_name DatabaseSecretsMount#plugin_name}
    */
    readonly pluginName?: string;
    /**
    * A list of database statements to be executed to rotate the root user's credentials.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#root_rotation_statements DatabaseSecretsMount#root_rotation_statements}
    */
    readonly rootRotationStatements?: string[];
    /**
    * The root credential username used in the connection URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username DatabaseSecretsMount#username}
    */
    readonly username?: string;
    /**
    * Username generation template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#username_template DatabaseSecretsMount#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies if the connection is verified during initial configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount#verify_connection DatabaseSecretsMount#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
export declare function databaseSecretsMountSnowflakeToTerraform(struct?: DatabaseSecretsMountSnowflake | cdktf.IResolvable): any;
export declare class DatabaseSecretsMountSnowflakeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabaseSecretsMountSnowflake | cdktf.IResolvable | undefined;
    set internalValue(value: DatabaseSecretsMountSnowflake | cdktf.IResolvable | undefined);
    private _allowedRoles?;
    get allowedRoles(): string[];
    set allowedRoles(value: string[]);
    resetAllowedRoles(): void;
    get allowedRolesInput(): string[] | undefined;
    private _connectionUrl?;
    get connectionUrl(): string;
    set connectionUrl(value: string);
    resetConnectionUrl(): void;
    get connectionUrlInput(): string | undefined;
    private _data?;
    get data(): {
        [key: string]: string;
    };
    set data(value: {
        [key: string]: string;
    });
    resetData(): void;
    get dataInput(): {
        [key: string]: string;
    } | undefined;
    private _maxConnectionLifetime?;
    get maxConnectionLifetime(): number;
    set maxConnectionLifetime(value: number);
    resetMaxConnectionLifetime(): void;
    get maxConnectionLifetimeInput(): number | undefined;
    private _maxIdleConnections?;
    get maxIdleConnections(): number;
    set maxIdleConnections(value: number);
    resetMaxIdleConnections(): void;
    get maxIdleConnectionsInput(): number | undefined;
    private _maxOpenConnections?;
    get maxOpenConnections(): number;
    set maxOpenConnections(value: number);
    resetMaxOpenConnections(): void;
    get maxOpenConnectionsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pluginName?;
    get pluginName(): string;
    set pluginName(value: string);
    resetPluginName(): void;
    get pluginNameInput(): string | undefined;
    private _rootRotationStatements?;
    get rootRotationStatements(): string[];
    set rootRotationStatements(value: string[]);
    resetRootRotationStatements(): void;
    get rootRotationStatementsInput(): string[] | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class DatabaseSecretsMountSnowflakeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatabaseSecretsMountSnowflake[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabaseSecretsMountSnowflakeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount vault_database_secrets_mount}
*/
export declare class DatabaseSecretsMount extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_database_secrets_mount";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/database_secrets_mount vault_database_secrets_mount} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabaseSecretsMountConfig
    */
    constructor(scope: Construct, id: string, config: DatabaseSecretsMountConfig);
    get accessor(): string;
    private _auditNonHmacRequestKeys?;
    get auditNonHmacRequestKeys(): string[];
    set auditNonHmacRequestKeys(value: string[]);
    resetAuditNonHmacRequestKeys(): void;
    get auditNonHmacRequestKeysInput(): string[] | undefined;
    private _auditNonHmacResponseKeys?;
    get auditNonHmacResponseKeys(): string[];
    set auditNonHmacResponseKeys(value: string[]);
    resetAuditNonHmacResponseKeys(): void;
    get auditNonHmacResponseKeysInput(): string[] | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get engineCount(): number;
    private _externalEntropyAccess?;
    get externalEntropyAccess(): boolean | cdktf.IResolvable;
    set externalEntropyAccess(value: boolean | cdktf.IResolvable);
    resetExternalEntropyAccess(): void;
    get externalEntropyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _sealWrap?;
    get sealWrap(): boolean | cdktf.IResolvable;
    set sealWrap(value: boolean | cdktf.IResolvable);
    resetSealWrap(): void;
    get sealWrapInput(): boolean | cdktf.IResolvable | undefined;
    private _cassandra;
    get cassandra(): DatabaseSecretsMountCassandraList;
    putCassandra(value: DatabaseSecretsMountCassandra[] | cdktf.IResolvable): void;
    resetCassandra(): void;
    get cassandraInput(): cdktf.IResolvable | DatabaseSecretsMountCassandra[] | undefined;
    private _couchbase;
    get couchbase(): DatabaseSecretsMountCouchbaseList;
    putCouchbase(value: DatabaseSecretsMountCouchbase[] | cdktf.IResolvable): void;
    resetCouchbase(): void;
    get couchbaseInput(): cdktf.IResolvable | DatabaseSecretsMountCouchbase[] | undefined;
    private _elasticsearch;
    get elasticsearch(): DatabaseSecretsMountElasticsearchList;
    putElasticsearch(value: DatabaseSecretsMountElasticsearch[] | cdktf.IResolvable): void;
    resetElasticsearch(): void;
    get elasticsearchInput(): cdktf.IResolvable | DatabaseSecretsMountElasticsearch[] | undefined;
    private _hana;
    get hana(): DatabaseSecretsMountHanaList;
    putHana(value: DatabaseSecretsMountHana[] | cdktf.IResolvable): void;
    resetHana(): void;
    get hanaInput(): cdktf.IResolvable | DatabaseSecretsMountHana[] | undefined;
    private _influxdb;
    get influxdb(): DatabaseSecretsMountInfluxdbList;
    putInfluxdb(value: DatabaseSecretsMountInfluxdb[] | cdktf.IResolvable): void;
    resetInfluxdb(): void;
    get influxdbInput(): cdktf.IResolvable | DatabaseSecretsMountInfluxdb[] | undefined;
    private _mongodb;
    get mongodb(): DatabaseSecretsMountMongodbList;
    putMongodb(value: DatabaseSecretsMountMongodb[] | cdktf.IResolvable): void;
    resetMongodb(): void;
    get mongodbInput(): cdktf.IResolvable | DatabaseSecretsMountMongodb[] | undefined;
    private _mongodbatlas;
    get mongodbatlas(): DatabaseSecretsMountMongodbatlasList;
    putMongodbatlas(value: DatabaseSecretsMountMongodbatlas[] | cdktf.IResolvable): void;
    resetMongodbatlas(): void;
    get mongodbatlasInput(): cdktf.IResolvable | DatabaseSecretsMountMongodbatlas[] | undefined;
    private _mssql;
    get mssql(): DatabaseSecretsMountMssqlList;
    putMssql(value: DatabaseSecretsMountMssql[] | cdktf.IResolvable): void;
    resetMssql(): void;
    get mssqlInput(): cdktf.IResolvable | DatabaseSecretsMountMssql[] | undefined;
    private _mysql;
    get mysql(): DatabaseSecretsMountMysqlList;
    putMysql(value: DatabaseSecretsMountMysql[] | cdktf.IResolvable): void;
    resetMysql(): void;
    get mysqlInput(): cdktf.IResolvable | DatabaseSecretsMountMysql[] | undefined;
    private _mysqlAurora;
    get mysqlAurora(): DatabaseSecretsMountMysqlAuroraList;
    putMysqlAurora(value: DatabaseSecretsMountMysqlAurora[] | cdktf.IResolvable): void;
    resetMysqlAurora(): void;
    get mysqlAuroraInput(): cdktf.IResolvable | DatabaseSecretsMountMysqlAurora[] | undefined;
    private _mysqlLegacy;
    get mysqlLegacy(): DatabaseSecretsMountMysqlLegacyList;
    putMysqlLegacy(value: DatabaseSecretsMountMysqlLegacy[] | cdktf.IResolvable): void;
    resetMysqlLegacy(): void;
    get mysqlLegacyInput(): cdktf.IResolvable | DatabaseSecretsMountMysqlLegacy[] | undefined;
    private _mysqlRds;
    get mysqlRds(): DatabaseSecretsMountMysqlRdsList;
    putMysqlRds(value: DatabaseSecretsMountMysqlRds[] | cdktf.IResolvable): void;
    resetMysqlRds(): void;
    get mysqlRdsInput(): cdktf.IResolvable | DatabaseSecretsMountMysqlRds[] | undefined;
    private _oracle;
    get oracle(): DatabaseSecretsMountOracleList;
    putOracle(value: DatabaseSecretsMountOracle[] | cdktf.IResolvable): void;
    resetOracle(): void;
    get oracleInput(): cdktf.IResolvable | DatabaseSecretsMountOracle[] | undefined;
    private _postgresql;
    get postgresql(): DatabaseSecretsMountPostgresqlList;
    putPostgresql(value: DatabaseSecretsMountPostgresql[] | cdktf.IResolvable): void;
    resetPostgresql(): void;
    get postgresqlInput(): cdktf.IResolvable | DatabaseSecretsMountPostgresql[] | undefined;
    private _redshift;
    get redshift(): DatabaseSecretsMountRedshiftList;
    putRedshift(value: DatabaseSecretsMountRedshift[] | cdktf.IResolvable): void;
    resetRedshift(): void;
    get redshiftInput(): cdktf.IResolvable | DatabaseSecretsMountRedshift[] | undefined;
    private _snowflake;
    get snowflake(): DatabaseSecretsMountSnowflakeList;
    putSnowflake(value: DatabaseSecretsMountSnowflake[] | cdktf.IResolvable): void;
    resetSnowflake(): void;
    get snowflakeInput(): cdktf.IResolvable | DatabaseSecretsMountSnowflake[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
