import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PkiSecretBackendRootSignIntermediateConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of alternative names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#alt_names PkiSecretBackendRootSignIntermediate#alt_names}
    */
    readonly altNames?: string[];
    /**
    * The PKI secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#backend PkiSecretBackendRootSignIntermediate#backend}
    */
    readonly backend: string;
    /**
    * CN of intermediate to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#common_name PkiSecretBackendRootSignIntermediate#common_name}
    */
    readonly commonName: string;
    /**
    * The country.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#country PkiSecretBackendRootSignIntermediate#country}
    */
    readonly country?: string;
    /**
    * The CSR.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#csr PkiSecretBackendRootSignIntermediate#csr}
    */
    readonly csr: string;
    /**
    * Flag to exclude CN from SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#exclude_cn_from_sans PkiSecretBackendRootSignIntermediate#exclude_cn_from_sans}
    */
    readonly excludeCnFromSans?: boolean | cdktf.IResolvable;
    /**
    * The format of data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#format PkiSecretBackendRootSignIntermediate#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#id PkiSecretBackendRootSignIntermediate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of alternative IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#ip_sans PkiSecretBackendRootSignIntermediate#ip_sans}
    */
    readonly ipSans?: string[];
    /**
    * The locality.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#locality PkiSecretBackendRootSignIntermediate#locality}
    */
    readonly locality?: string;
    /**
    * The maximum path length to encode in the generated certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#max_path_length PkiSecretBackendRootSignIntermediate#max_path_length}
    */
    readonly maxPathLength?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#namespace PkiSecretBackendRootSignIntermediate#namespace}
    */
    readonly namespace?: string;
    /**
    * The organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#organization PkiSecretBackendRootSignIntermediate#organization}
    */
    readonly organization?: string;
    /**
    * List of other SANs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#other_sans PkiSecretBackendRootSignIntermediate#other_sans}
    */
    readonly otherSans?: string[];
    /**
    * The organization unit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#ou PkiSecretBackendRootSignIntermediate#ou}
    */
    readonly ou?: string;
    /**
    * List of domains for which certificates are allowed to be issued.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#permitted_dns_domains PkiSecretBackendRootSignIntermediate#permitted_dns_domains}
    */
    readonly permittedDnsDomains?: string[];
    /**
    * The postal code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#postal_code PkiSecretBackendRootSignIntermediate#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The province.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#province PkiSecretBackendRootSignIntermediate#province}
    */
    readonly province?: string;
    /**
    * Revoke the certificate upon resource destruction.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#revoke PkiSecretBackendRootSignIntermediate#revoke}
    */
    readonly revoke?: boolean | cdktf.IResolvable;
    /**
    * The street address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#street_address PkiSecretBackendRootSignIntermediate#street_address}
    */
    readonly streetAddress?: string;
    /**
    * Time to live.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#ttl PkiSecretBackendRootSignIntermediate#ttl}
    */
    readonly ttl?: string;
    /**
    * List of alternative URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#uri_sans PkiSecretBackendRootSignIntermediate#uri_sans}
    */
    readonly uriSans?: string[];
    /**
    * Preserve CSR values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate#use_csr_values PkiSecretBackendRootSignIntermediate#use_csr_values}
    */
    readonly useCsrValues?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate vault_pki_secret_backend_root_sign_intermediate}
*/
export declare class PkiSecretBackendRootSignIntermediate extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_pki_secret_backend_root_sign_intermediate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/pki_secret_backend_root_sign_intermediate vault_pki_secret_backend_root_sign_intermediate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PkiSecretBackendRootSignIntermediateConfig
    */
    constructor(scope: Construct, id: string, config: PkiSecretBackendRootSignIntermediateConfig);
    private _altNames?;
    get altNames(): string[];
    set altNames(value: string[]);
    resetAltNames(): void;
    get altNamesInput(): string[] | undefined;
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    get caChain(): string[];
    get certificate(): string;
    get certificateBundle(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _csr?;
    get csr(): string;
    set csr(value: string);
    get csrInput(): string | undefined;
    private _excludeCnFromSans?;
    get excludeCnFromSans(): boolean | cdktf.IResolvable;
    set excludeCnFromSans(value: boolean | cdktf.IResolvable);
    resetExcludeCnFromSans(): void;
    get excludeCnFromSansInput(): boolean | cdktf.IResolvable | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipSans?;
    get ipSans(): string[];
    set ipSans(value: string[]);
    resetIpSans(): void;
    get ipSansInput(): string[] | undefined;
    get issuingCa(): string;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _maxPathLength?;
    get maxPathLength(): number;
    set maxPathLength(value: number);
    resetMaxPathLength(): void;
    get maxPathLengthInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _otherSans?;
    get otherSans(): string[];
    set otherSans(value: string[]);
    resetOtherSans(): void;
    get otherSansInput(): string[] | undefined;
    private _ou?;
    get ou(): string;
    set ou(value: string);
    resetOu(): void;
    get ouInput(): string | undefined;
    private _permittedDnsDomains?;
    get permittedDnsDomains(): string[];
    set permittedDnsDomains(value: string[]);
    resetPermittedDnsDomains(): void;
    get permittedDnsDomainsInput(): string[] | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _revoke?;
    get revoke(): boolean | cdktf.IResolvable;
    set revoke(value: boolean | cdktf.IResolvable);
    resetRevoke(): void;
    get revokeInput(): boolean | cdktf.IResolvable | undefined;
    get serial(): string;
    get serialNumber(): string;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string[];
    set uriSans(value: string[]);
    resetUriSans(): void;
    get uriSansInput(): string[] | undefined;
    private _useCsrValues?;
    get useCsrValues(): boolean | cdktf.IResolvable;
    set useCsrValues(value: boolean | cdktf.IResolvable);
    resetUseCsrValues(): void;
    get useCsrValuesInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
