import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TerraformCloudSecretRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Terraform Cloud Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#backend TerraformCloudSecretRole#backend}
    */
    readonly backend?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#id TerraformCloudSecretRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum allowed lease for generated credentials. If not set or set to 0, will use system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#max_ttl TerraformCloudSecretRole#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * The name of an existing role against which to create this Terraform Cloud credential
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#name TerraformCloudSecretRole#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#namespace TerraformCloudSecretRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Name of the Terraform Cloud or Enterprise organization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#organization TerraformCloudSecretRole#organization}
    */
    readonly organization?: string;
    /**
    * ID of the Terraform Cloud or Enterprise team under organization (e.g., settings/teams/team-xxxxxxxxxxxxx)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#team_id TerraformCloudSecretRole#team_id}
    */
    readonly teamId?: string;
    /**
    * Default lease for generated credentials. If not set or set to 0, will use system default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#ttl TerraformCloudSecretRole#ttl}
    */
    readonly ttl?: number;
    /**
    * ID of the Terraform Cloud or Enterprise user (e.g., user-xxxxxxxxxxxxxxxx)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role#user_id TerraformCloudSecretRole#user_id}
    */
    readonly userId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role vault_terraform_cloud_secret_role}
*/
export declare class TerraformCloudSecretRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_terraform_cloud_secret_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/terraform_cloud_secret_role vault_terraform_cloud_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TerraformCloudSecretRoleConfig
    */
    constructor(scope: Construct, id: string, config: TerraformCloudSecretRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    resetTeamId(): void;
    get teamIdInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
