import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * The display name of the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#display_name Token#display_name}
    */
    readonly displayName?: string;
    /**
    * The explicit max TTL of the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#explicit_max_ttl Token#explicit_max_ttl}
    */
    readonly explicitMaxTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#id Token#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata to be associated with the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#metadata Token#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#namespace Token#namespace}
    */
    readonly namespace?: string;
    /**
    * Flag to disable the default policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#no_default_policy Token#no_default_policy}
    */
    readonly noDefaultPolicy?: boolean | cdktf.IResolvable;
    /**
    * Flag to create a token without parent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#no_parent Token#no_parent}
    */
    readonly noParent?: boolean | cdktf.IResolvable;
    /**
    * The number of allowed uses of the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#num_uses Token#num_uses}
    */
    readonly numUses?: number;
    /**
    * The period of the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#period Token#period}
    */
    readonly period?: string;
    /**
    * List of policies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#policies Token#policies}
    */
    readonly policies?: string[];
    /**
    * The renew increment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#renew_increment Token#renew_increment}
    */
    readonly renewIncrement?: number;
    /**
    * The minimum lease to renew token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#renew_min_lease Token#renew_min_lease}
    */
    readonly renewMinLease?: number;
    /**
    * Flag to allow the token to be renewed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#renewable Token#renewable}
    */
    readonly renewable?: boolean | cdktf.IResolvable;
    /**
    * The token role name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#role_name Token#role_name}
    */
    readonly roleName?: string;
    /**
    * The TTL period of the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#ttl Token#ttl}
    */
    readonly ttl?: string;
    /**
    * The TTL period of the wrapped token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/token#wrapping_ttl Token#wrapping_ttl}
    */
    readonly wrappingTtl?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/token vault_token}
*/
export declare class Token extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/token vault_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TokenConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TokenConfig);
    get clientToken(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _explicitMaxTtl?;
    get explicitMaxTtl(): string;
    set explicitMaxTtl(value: string);
    resetExplicitMaxTtl(): void;
    get explicitMaxTtlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get leaseDuration(): number;
    get leaseStarted(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _noDefaultPolicy?;
    get noDefaultPolicy(): boolean | cdktf.IResolvable;
    set noDefaultPolicy(value: boolean | cdktf.IResolvable);
    resetNoDefaultPolicy(): void;
    get noDefaultPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _noParent?;
    get noParent(): boolean | cdktf.IResolvable;
    set noParent(value: boolean | cdktf.IResolvable);
    resetNoParent(): void;
    get noParentInput(): boolean | cdktf.IResolvable | undefined;
    private _numUses?;
    get numUses(): number;
    set numUses(value: number);
    resetNumUses(): void;
    get numUsesInput(): number | undefined;
    private _period?;
    get period(): string;
    set period(value: string);
    resetPeriod(): void;
    get periodInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _renewIncrement?;
    get renewIncrement(): number;
    set renewIncrement(value: number);
    resetRenewIncrement(): void;
    get renewIncrementInput(): number | undefined;
    private _renewMinLease?;
    get renewMinLease(): number;
    set renewMinLease(value: number);
    resetRenewMinLease(): void;
    get renewMinLeaseInput(): number | undefined;
    private _renewable?;
    get renewable(): boolean | cdktf.IResolvable;
    set renewable(value: boolean | cdktf.IResolvable);
    resetRenewable(): void;
    get renewableInput(): boolean | cdktf.IResolvable | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    resetRoleName(): void;
    get roleNameInput(): string | undefined;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    get wrappedToken(): string;
    get wrappingAccessor(): string;
    private _wrappingTtl?;
    get wrappingTtl(): string;
    set wrappingTtl(value: string);
    resetWrappingTtl(): void;
    get wrappingTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
