# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lgw']

package_data = \
{'': ['*']}

install_requires = \
['boto3>=1.10,<2.0',
 'docker>=4.1,<5.0',
 'docopt>=0.6.2,<0.7.0',
 'everett>=1.0,<2.0',
 'python-dotenv>=0.10.3,<0.11.0']

entry_points = \
{'console_scripts': ['lgw = lgw.main:main']}

setup_kwargs = {
    'name': 'lgw',
    'version': '1.1.0',
    'description': 'Configure an AWS Gateway in front of a Lambda function.',
    'long_description': '[![PyPi License](https://img.shields.io/pypi/l/lgw?color=blue)](https://github.com/ebridges/lgw/blob/master/LICENSE)\n[![PyPi](https://img.shields.io/pypi/v/lgw.svg?style=flat-square)](https://pypi.org/project/lgw/)\n\n# Lambda Gateway\n\nConfigure an AWS Gateway in front of a Lambda function.\n\n## Usage\n\n```\nLambda Gateway.\n\nUsage:\n  lgw gw-deploy [--verbose] --config-file=<cfg>\n  lgw gw-undeploy [--verbose] --config-file=<cfg>\n  lgw domain-add [--verbose] --config-file=<cfg>\n  lgw domain-remove [--verbose] --config-file=<cfg>\n  lgw lambda-deploy [--verbose] --config-file=<cfg> --lambda-file=<zip>\n  lgw lambda-invoke [--verbose] --lambda-name=<name> [--payload=<json>]\n  lgw lambda-delete [--verbose] --lambda-name=<name>\n  lgw lambda-archive [--verbose] --config-file=<cfg>\n\nOptions:\n  -h --help             Show this screen.\n  --version             Show version.\n  --verbose             Enable DEBUG-level logging.\n  --config-file=<cfg>   Override defaults with these settings.\n  --lambda-file=<zip>   Path to zip file with executable lambda code.\n  --lambda-name=<name>  Name of the lambda to invoke or delete.\n  --payload=<json>      Path to a file of type json with data to send with the lambda invocation.\n```\n\n## Configuration Parameters\n\nConfiguration params are read in the following order, with the first read of it overriding subsequent configs:\n\n1. Read from environment.\n2. Read from `.env` file in current folder.\n3. Read from flat file named via `--config-file` CLI param.\n4. Read from `lgw.settings.defaults()`\n\nDefaults are configured in `lgw.settings`.\n\n<table>\n<tr>\n<th>Related Task(s)</th>\n<th>Key</th>\n<th>Description</th>\n<th>Default</th>\n</tr>\n<tr>\n<td><ul><li>All</li></ul></td>\n<td><code>AWS_REGION</code></td>\n<td>AWS region.</td>\n<td><tt>us-east-1</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n  <li><tt>gw-undeploy</tt></li>\n  <li><tt>domain-add</tt></li>\n  <li><tt>domain-remove</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_NAME</code></td>\n<td>Name for the created API gateway.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_DESCRIPTION</code></td>\n<td>Description of the created API gateway.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_RESOURCE_PATH</code></td>\n<td>Resource path for the API. By default it\'s a greedy path to proxy all requests.</td>\n<td><tt>{proxy+}</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_DEPLOY_STAGE</code></td>\n<td>Name for the stage that the API gets deployed to. E.g. "production"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_BINARY_TYPES</code></td>\n<td>Listing of binary media types to configure the gateway as handling.  Example: <tt>image/jpeg,image/png</tt></td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_RESPONSE_MODELS</code></td>\n<td>Response content-type: model mapping of the response body.  Typically used for mapping binary content-types.  For binary types specify: <tt>image/*=Empty</tt></td>\n<td><tt>application/json=Empty</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_LAMBDA_INTEGRATION_ROLE</code></td>\n<td>ARN of a role that grants permission to the API gateway to invoke a lambda.  Should have <tt>AmazonAPIGatewayPushToCloudWatchLogs</tt> and <tt>AWSLambdaRole</tt> managed roles as permissions, and <tt>apigateway.amazonaws.com</tt> as a trusted entity.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>domain-add</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_DOMAIN_NAME</code></td>\n<td>A domain name configured in Route 53 that the API gateway can be mapped to.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>domain-add</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_BASE_PATH</code></td>\n<td>Base path mapping to connect the domain name\'s CF distribution to the gateway.</td>\n<td><tt>(none)</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>domain-add</tt></li>\n</ul>\n</td>\n<td><code>AWS_API_DOMAIN_WAIT_UNTIL_AVAILABLE</code></td>\n<td>Waits until the custom domain name has been created.</td>\n<td>true, set to undefined to disable.</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>domain-add</tt></li>\n</ul>\n</td>\n<td><code>AWS_ACM_CERTIFICATE_ARN</code></td>\n<td>ARN of an HTTPS certificate to use for securing API requests.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>gw-deploy</tt></li>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_NAME</code></td>\n<td>Name for the created Lambda.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_DESCRIPTION</code></td>\n<td>Description for the created Lambda</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_HANDLER</code></td>\n<td>Name of the handler function. e.g. "module.function"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_RUNTIME</code></td>\n<td>Lambda runtime environment.</td>\n<td><tt>python3.7</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_CONNECTION_TIMEOUT</code></td>\n<td>Connection timeout in seconds.</td>\n<td><tt>30</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_MEMORY_SIZE</code></td>\n<td>Amount of memory to allocate to the Lambda.</td>\n<td><tt>3000</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_BUCKET</code></td>\n<td>S3 bucket to store lambda if zip file exceeds maximum upload size.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_KEY</code></td>\n<td>Key of the lambda archive in the configured bucket.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_EXECUTION_ROLE_ARN</code></td>\n<td>ARN of a role with permissions to execute the Lambda.  Should have <tt>AWSXrayWriteOnlyAccess</tt> and <tt>AWSLambdaBasicExecutionRole</tt> managed roles as permissions, and <tt>lambda.amazonaws.com</tt> as a trusted entity.</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_VPC_SUBNETS</code></td>\n<td>List of subnets that the Lambda should run in. Format: "subnetA,subnetB,subnetC,...</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_VPC_SECURITY_GROUPS</code></td>\n<td>List of security groups that control the Lambda\'s access. Format: "<tt>secgrpA,secgrpB,secgrpC,...</tt>"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ENVIRONMENT</code></td>\n<td>Variables to inject into the Lambda\'s environment.  Format: "<tt>varA=valA;varB=valB;...</tt>"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-deploy</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_TAGS</code></td>\n<td>List of tags to categorize this Lambda.  Format: "<tt>tagA=valA;tagB=valB;...</tt>"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-archive</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_CONTEXT_DIR</code></td>\n<td>Root directory of the project that will provide files to be copied into the Docker image.  If the directory ends with a trailing slash, then the root of the context will be the contents of the directory; otherwise the leaf directory will be at the root of the context.</td>\n<td><tt>.</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-archive</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_BUNDLE_DIR</code></td>\n<td>Destination directory to write Lambda archive zipfile. </td>\n<td><tt>./build</tt></td>\n</tr>\n<tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-archive</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_BUNDLE_NAME</code></td>\n<td>Filename of Lambda archive zipfile. </td>\n<td><tt>lambda-bundle.zip</tt></td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-archive</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_ADDL_FILES</code></td>\n<td>List of 2-tuples of files to copy into the context directory from the local computer. Format: "<tt>srcA,desA;srcB,desB;srcC,desC;...</tt>"</td>\n<td>N/A</td>\n</tr>\n<tr>\n<td>\n<ul>\n  <li><tt>lambda-archive</tt></li>\n</ul>\n</td>\n<td><code>AWS_LAMBDA_ARCHIVE_ADDL_PACKAGES</code></td>\n<td>List of <tt>yum</tt> packages to install in the Docker image.  Format: "<tt>packageA,packageB,packageC,...</tt>"</td>\n<td>\nDefault installed by this script:\n<ul>\n<li><tt>gcc</tt></li>\n<li><tt>openssl-devel</tt></li>\n<li><tt>bzip2-devel</tt></li>\n<li><tt>libffi-devel</tt></li>\n<li><tt>python37-pip</tt></li>\n</ul>\n</td>\n</tr>\n</table>\n\n\n## Releasing\n\n```\ngit flow release start x.y.z\n# bump version\nvi pyproject.toml lgw/version.py\ngit add pyproject.toml lgw/version.py\ngit commit -m \'bump version\'\ndephell deps convert\npoetry publish --build\ngit flow release finish x.y.z\n```\n',
    'author': 'Edward Q. Bridges',
    'author_email': 'ebridges@roja.cc',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ebridges/lgw',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
