# DREEM Demultiplexing Module
Contributor: Scott Grote, Yves Martin

## Purpose
Group the reads by barcode. 

Splits each pair of fastq by constructs. The constructs are identified using the barcodes provided in the library. The output is one pair of fastq files per construct, in a directory named after the fastq pair prefix. The fasts prefixes must match.

## Interface

### Input Files
- [≥1] ```{sample_k}_R1.fastq```. Forward primer sequence alignment file(s) generated by the sequencer. There must be one file for each sample, and its name must be ```{sample_k}_R1.fastq```.  
- [≥1] ```{sample_k}_R2.fastq```. Forward primer sequence alignment file(s) generated by the sequencer. There must be one file for each sample, and its name must be ```{sample_k}_R2.fastq```.  
- [=1] ```library.csv```. A CSV file with the following columns: 
```
- construct: name of the constructs (matching the ones of the fasta file).
- barcode_start: a 0-index of the beginning of the barcode sequence.
- barcode_end: a 0-index of the end of the barcode sequence (this index being non-included).
- barcode: a string of A C G T forming the barcode.
```
### Output files
- `{sample_k}` is the prefix of the fastq files. `{construct_k}` comes from the library.
```bash
{out_dir}:= path/to/{sample_1}/
  |- {construct_1}_R1.fastq # Sequence alignment file(s) containing reads from `{sample_1}_R1.fastq` with `barcode` of row `construct_1` as a barcode.
  |- {construct_1}_R2.fastq
  |- {construct_2}_R1.fastq
  |- {construct_2}_R2.fastq
  |- ...
  |- report.txt
{out_dir}:= path/to/{sample_2}/
{out_dir}:= path/to/{sample_3}/
...
```

- `report.txt` contains the following informations:
```
- count of perfect matches.
- count of 1 mutated barcodes.
- count of barcode position shifts (binned).
- count of lost reads.
```

### Command-line usage

```dreem-demultiplexing —-fastq1 [file] --fastq2 [file] —-library [file] --out_dir [path]```

- ```dreem-demultiplexing```: Wrapper for ```run``` function in ```dreem/demultiplexing/run.py```. 
- [≥1] `-fq1 / --fastq1`: ```{sample_k}_R1.fastq```
- [≥1] `-fq2 / --fastq2`: ```{sample_k}_R2.fastq```
- [=1] `-l / --library` : ```library.csv```
- [≤1] `-o / --out_dir`: Name of the output directory. Last directory of the path must be the sample name.
- [≤1] `-bs / --barcode_start`: Start position of the barcode in the read (uncompatible with library)
- [≤1] `-be / --barcode_end`: End position of the barcode in the read (uncompatible with library)
