# pylint: disable=duplicate-code

""" The InstanceList of allowed GCP InstanceTypes """
from mcli.submit.platforms_future.instance_type import GPUType, InstanceList, InstanceType

ALLOWED_INSTANCES = [
    InstanceType(
        name='e2-standard-2',
        cpu_count=2,
        gpu_count=0,
        desc='Lightweight VM',
    ),
    InstanceType(
        name='n1-standard-16',
        cpu_count=16,
        gpu_count=0,
        desc='Middleweight VM',
    ),
    InstanceType(
        name='n1-standard-32',
        cpu_count=32,
        gpu_count=0,
        desc='Heavyweight VM',
    ),
    InstanceType(
        name='n2d-standard-96',
        cpu_count=96,
        gpu_count=0,
        desc='Heavyweight VM',
    ),
    InstanceType(
        name='n1-standard-4-k80-1',
        cpu_count=4,
        gpu_count=1,
        gpu_type=GPUType.K80,
        gpu_memory=12,
        desc='1x K80 GPU',
    ),
    InstanceType(
        name='n1-standard-16-k80-4',
        cpu_count=16,
        gpu_count=4,
        gpu_type=GPUType.K80,
        gpu_memory=12,
        desc='4x K80 GPU',
    ),
    InstanceType(
        name='n1-standard-32-k80-8',
        cpu_count=32,
        gpu_count=8,
        gpu_type=GPUType.K80,
        gpu_memory=12,
        desc='8x K80 GPU',
    ),
    InstanceType(
        name='n1-standard-4-v100-1',
        cpu_count=4,
        gpu_count=1,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='1x V100 GPU',
    ),
    InstanceType(
        name='n1-standard-16-v100-4',
        cpu_count=16,
        gpu_count=4,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='4x V100 GPU',
    ),
    InstanceType(
        name='n1-standard-48-v100-4',
        cpu_count=48,
        gpu_count=4,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='4x V100 GPU',
    ),
    InstanceType(
        name='n1-standard-32-v100-8',
        cpu_count=32,
        gpu_count=8,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='8x V100 GPU',
    ),
    InstanceType(
        name='n1-standard-96-v100-8',
        cpu_count=96,
        gpu_count=8,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='8x V100 GPU',
    ),
    InstanceType(
        name='n1-highmem-64-v100-8',
        cpu_count=64,
        gpu_count=8,
        gpu_type=GPUType.V100,
        gpu_memory=16,
        desc='8x V100 GPU',
    ),
    InstanceType(
        name='n1-standard-48-t4-4',
        cpu_count=48,
        gpu_count=4,
        gpu_type=GPUType.T4,
        gpu_memory=16,
        desc='4x T4 GPU',
    ),
    InstanceType(
        name='n1-standard-16-t4-4',
        cpu_count=16,
        gpu_count=4,
        gpu_type=GPUType.T4,
        gpu_memory=16,
        desc='4x T4 GPU',
    ),
    InstanceType(
        name='n1-standard-4-t4-1',
        cpu_count=4,
        gpu_count=1,
        gpu_type=GPUType.T4,
        gpu_memory=16,
        desc='1x T4 GPU',
    ),
    InstanceType(
        name='a2-highgpu-1g-a100-1',
        cpu_count=12,
        gpu_count=1,
        gpu_type=GPUType.A100,
        gpu_memory=40,
        desc='1x A100 GPU',
    ),
    InstanceType(
        name='a2-highgpu-4g-a100-4',
        cpu_count=48,
        gpu_count=4,
        gpu_type=GPUType.A100,
        gpu_memory=40,
        desc='4x A100 GPU',
    ),
    InstanceType(
        name='a2-highgpu-8g-a100-8',
        cpu_count=96,
        gpu_count=8,
        gpu_type=GPUType.A100,
        gpu_memory=40,
        desc='8x A100 GPU',
    ),
    InstanceType(
        name='n1-standard-16-tpu2-8',
        cpu_count=16,
        gpu_count=0,
        gpu_type=GPUType.TPUv2,
        desc='8x TPUv2',
        extras={'node_class': 'n1-standard-16'},
    ),
    InstanceType(
        name='n1-standard-16-tpu3-8',
        cpu_count=16,
        gpu_count=0,
        gpu_type=GPUType.TPUv3,
        desc='8x TPUv3',
        extras={'node_class': 'n1-standard-16'},
    ),
    InstanceType(
        name='n1-standard-32-tpu2-8',
        cpu_count=32,
        gpu_count=0,
        gpu_type=GPUType.TPUv2,
        desc='8x TPUv2',
        extras={'node_class': 'n1-standard-32'},
    ),
    InstanceType(
        name='n1-standard-32-tpu3-8',
        cpu_count=32,
        gpu_count=0,
        gpu_type=GPUType.TPUv3,
        desc='8x TPUv3',
        extras={'node_class': 'n1-standard-32'},
    ),
    InstanceType(
        name='a2-megagpu-16g-a100-16',
        cpu_count=96,
        gpu_count=16,
        gpu_memory=40,
        gpu_type=GPUType.A100,
        desc='16x A100 GPU',
    ),
]
GCP_INSTANCE_LIST = InstanceList(instances=ALLOWED_INSTANCES)
