def get_template_ProteCCT_input_sheet():
    '''
        Define the template for the input sheet of a ProteCCT input file
    '''

    template_ProteCCT_input_sheet = [
    [None, None, 'ProteCCT v1.1'],  # title row
    [None, None, None],  # empty line
    ['magnetIdentifier', None, 'Magnet identifier. Here \" should be placed in front of the name.'],  # entry
    [None, None, None],
    [None, None, 'Magnet properties'],
    ['totalConductorLength', None, 'Total strand length in [m], for both inner and outer former.'],
    ['numTurnsPerStrandTotal', None, 'Total number of windings on a single former.'],
    ['CuFraction', None, 'Copper fraction of the Nb-Ti/Cu conductor.'],
    ['RRRStrand', None,
     'RRR of the copper. Note that the considered reference temperature is 295 K. The literature reference curve is NIST, which includes temperature- and magnetic-field-dependence.'],
    ['BMaxAtNominal', None, 'Peak field on conductor at nominal current in [T].'],
    ['BMinAtNominal', None, 'Lowest field on conductor at nominal current in [T].'],
    ['INominal', None,
     'Nominal current in [A], used as reference for calculating magnetic field profile over the conductor.'],
    ['fieldPeriodicity', None, 'Field periodicity (2 for a dipole, 4 for a quadrupole, etc).'],
    ['magneticLength', None, 'Magnetic Length in [m].'],
    ['thFormerInsul', None,
     'Insulation thickness between formers in [m]. This insulation is considered a mixture of polyimide and epoxy, and the ratio between the two is given by \'polyimideEpoxyRatio\'.'],
    ['wStrandSlot', None, 'Size of the strand slot in [m]'],
    ['DStrand', None, 'Strand diameter in [m]'],
    ['numRowStrands', None, 'The number of rows of strands'],
    ['numColumnStrands', None, 'The number of columns of strands'],
    ['IcFactor', None, 'Ic multiplier, to allow for heat-treatment-induced degradation of Ic. Note that the reference curve considers temperature- and field-dependence and is based on the MB inner-layer Nb-Ti/Cu strand, see for instance EMDS 2110653. This is adjusted to 0.93 for WST wire to match Ic of 776A at 7T, 1.9K with the Jc scaling inside ProteCCT'],
    ['polyimideToEpoxyRatio', None, 'Ratio of polyimide to G10 in insulation. For thermal purposes, the two materials are assumed in series'],
    ['windingOrder', None, 'Gives the electrical ordering of the turns. Note that the indexing in the simulation takes 1 as the bottom-left of the inner former, 2 above 1, 3 directly above 2, 6 is bottom-right, 11 as the bottom-left of the outer former, and 16 the bottom-right, etc.'],
    [None, None, None],
    [None, None, 'Former related properties'],
    ['M', None, 'Inductance matrix in units of [H/m]. Must have dimensions (Numformers+2 * Numformers+2)'],
    [None, None, None],
    ['innerRadiusFormers', None, 'Inner radius of the formers in [m]'],
    ['formerThicknessUnderneathCoil', None, 'Thickness of the former underneath the slot holding the strands in [m]'],
    ['innerRadiusOuterCylinder', None, 'Inner radius of the outer cylinder in [m]'],
    ['thicknessOuterCylinder', None, 'thickness of the outer cylinder in [m]'],
    ['RRRFormer', None, 'RRR of the former, assuming aluminum. Note that the considered reference temperature is 295 K.'],
    ['RRROuterCylinder', None, 'RRR of the outer cylinder, assuming aluminum. Note that the considered reference temperature is 295 K.'],
    [None, None, None],
    [None, None, 'Extra stuff'],
    ['coolingToHeliumBath', None, 'Determines whether inner surface of inner former and outer surface of outer support cylinder are in contact with the helium bath'],
    ['tMaxStopCondition', None, 'Maximum evaluation time in [s] after which simulation is stopped'],
    ['tempMaxStopCondition', None, 'Maximum allowed hotspot temperature in [K] after which simulation is stopped'],
    ['IOpFractionStopCondition', None, 'Once the operating current drops below IOpFractionStopCondition * the initial current, the simulation is stopped'],
    [None, None, None],
    [None, None, 'Sweepable parameters (this means that you may put more than one value and the simulation will run for these multiple values)'],
    ['fLoopLength', None, 'The simulation model assumes cos-theta current distribution in the formers, but the reality is more complicated with spiralling current. This empirical factor corrects for the longer pathlength given by the spiralling current.'],
    ['TOp', None, 'Bath temperature in [K]'],
    ['IOpInitial', None, 'Initial operating current in [A]'],
    ['RCrowbar', None, 'Crowbar resistance in Ohm'],
    ['RDumpPreconstant', None, 'Constants describing the dump resistance. R(I)=RdumpPreconstant*(abs(I)^RdumpPower)'],
    ['RDumpPower', None, 'Constants describing the dump resistance. R(I)=RdumpPreconstant*(abs(I)^RdumpPower)'],
    ['addedHeCpFrac', None, 'Extra helium heat capacity that is added to the formers. This number is the fraction of the former volume that is assigned to be helium, assuming a back-ground pressure of 0.13 MPa.'],
    ['addedHeCoolingFrac', None, 'Fraction of regular cooling to the helium bath that the other formers besides the inner-most former sees'],
    ['tSwitchDelay', None, 'Time required to open the switch after protection triggering in [s]'],
    ['coolingToHeliumBath', None, 'For (0), cooling to the bath is not considered. For (1), the inner surface of the inner former and the outer surface of the outer support cylinder are in direct contact to the helium bath, through interface-temperature-dependent Kapitza + film-boiling cooling for 1.9 K, and nuclear boiling + film boiling cooling for 4.5 K.'],
    [None, None, None],
    [None, None, 'Solver configuration options'],
    ['fracCurrentChangeMax', None, 'Maximum dI/I for a given iteration (applies to both the coil and the formers). This parameter is used for adaptive time stepping'],
    ['resultsAtTimeStep', None, 'The simulation time step in [s] at which the simulation notifies the user of the current variable state. The solver is forced to calculate this time step.'],
    ['deltaTMaxAllowed', None, 'Maximum change in temperature in [K] between subsequent solver iterations. This parameter is used for adaptive time-stepping'],
    ['minTimeStep', None, 'Absolute minimum time step size in [s]'],
    ['turnLengthElements', None, 'Amount of elements for given turn.'],
    [None, None, None],
    [None, None, 'Graphics options'],
    ['withPlots', None, 'If withPlots is set to 1 then for every timeStep, the voltage-to-ground distribution is plotted'],
    ['plotPauseTime', None, 'if withPlots is set to 1, then some pause time is needed to render the graphs. Furthermore, for convenience, the user might add more'],
    [None, None, None],
    [None, None, 'postProcessing'],
    ['withVoltageEvaluation', None, 'If this option is set to 1, then for selected turns (see voltageToGroundOutputSelection), the voltage-to-ground of that turn is calculated and included in the results.'],
    ['voltageToGroundOutputSelection', None, 'Selected turns for voltage-to-ground-evaluation (see above option). Here the indexes consider the winding order.'],
    [None, None, None],
    [None, None, 'Options used for co-simulation'],
    ['externalWaveform', None, 'Option to use either internal circuit (0) or externally supplied current waveform (1)'],
    ['saveStateAtEnd', None, 'Saves the workspace at the end of the simulation, 0 = no save, 1 = save to \'workspace, t0 = %last time interval%.mat\''],
    ['restoreStateAtStart', None, 'Loads the workspace at the start of the simulation, 0 = no load, 1 = load from \'workspace, t0 = %first time interval%.mat\''],
    ['silentRun', None, 'If this option is enabled then output during the simulation is minimal.'],
    ]

    return template_ProteCCT_input_sheet