"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const service_deployment_1 = require("./service-deployment");
class Redis extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        const primary = new service_deployment_1.ServiceDeployment(this, 'primary', {
            image: 'k8s.gcr.io/redis:e2e',
            containerPort: 6379,
            externalPort: 6379,
            containerName: 'primary',
            env: { GET_HOSTS_FROM: 'dns' },
            labels: {
                app: 'redis',
                role: 'primary',
                ...options.labels,
            },
        });
        this.primaryHost = primary.host;
        const replicas = options.replicas ?? 2;
        if (replicas > 0) {
            const replica = new service_deployment_1.ServiceDeployment(this, 'replica', {
                image: 'gcr.io/google_samples/gb-redisslave:v1',
                containerName: 'replica',
                containerPort: 6379,
                externalPort: 6379,
                env: { GET_HOSTS_FROM: 'env', REDIS_MASTER_SERVICE_HOST: this.primaryHost },
                replicas: replicas,
                labels: {
                    app: 'redis',
                    role: 'replica',
                    ...options.labels,
                },
            });
            this.replicaHost = replica.host;
        }
        else {
            // if we have no slave, then use the same host as the primary
            this.replicaHost = primary.host;
        }
    }
}
exports.Redis = Redis;
_a = JSII_RTTI_SYMBOL_1;
Redis[_a] = { fqn: "cdk8s-redis.Redis", version: "0.1.446" };
//# sourceMappingURL=data:application/json;base64,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