import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleSpannerInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the instance's configuration (similar but not quite the same as a region) which defines the geographic placement and replication of your databases in this instance.
     *
     * It determines where your data
     * is stored. Values are typically of the form 'regional-europe-west1' , 'us-central' etc.
     * In order to obtain a valid list please consult the
     * [Configuration section of the docs](https://cloud.google.com/spanner/docs/instances).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#config DataGoogleSpannerInstance#config}
     *
     * @stability stable
     */
    readonly config?: string;
    /**
     * The descriptive name for this instance as it appears in UIs.
     *
     * Must be
     * unique per project and between 4 and 30 characters in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#display_name DataGoogleSpannerInstance#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#force_destroy DataGoogleSpannerInstance#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#labels DataGoogleSpannerInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A unique identifier for the instance, which cannot be changed after the instance is created.
     *
     * The name must be between 6 and 30 characters
     * in length.
     *
     *
     * If not provided, a random string starting with 'tf-' will be selected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#name DataGoogleSpannerInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The number of nodes allocated to this instance.
     *
     * At most one of either node_count or processing_units
     * can be present in terraform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#num_nodes DataGoogleSpannerInstance#num_nodes}
     *
     * @stability stable
     */
    readonly numNodes?: number;
    /**
     * The number of processing units allocated to this instance.
     *
     * At most one of processing_units
     * or node_count can be present in terraform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#processing_units DataGoogleSpannerInstance#processing_units}
     *
     * @stability stable
     */
    readonly processingUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html#project DataGoogleSpannerInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html google_spanner_instance}.
 *
 * @stability stable
 */
export declare class DataGoogleSpannerInstance extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/spanner_instance.html google_spanner_instance} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleSpannerInstanceConfig);
    private _config?;
    /**
     * @stability stable
     */
    get config(): string | undefined;
    /**
     * @stability stable
     */
    set config(value: string | undefined);
    /**
     * @stability stable
     */
    resetConfig(): void;
    /**
     * @stability stable
     */
    get configInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _numNodes?;
    /**
     * @stability stable
     */
    get numNodes(): number | undefined;
    /**
     * @stability stable
     */
    set numNodes(value: number | undefined);
    /**
     * @stability stable
     */
    resetNumNodes(): void;
    /**
     * @stability stable
     */
    get numNodesInput(): number | undefined;
    private _processingUnits?;
    /**
     * @stability stable
     */
    get processingUnits(): number | undefined;
    /**
     * @stability stable
     */
    set processingUnits(value: number | undefined);
    /**
     * @stability stable
     */
    resetProcessingUnits(): void;
    /**
     * @stability stable
     */
    get processingUnitsInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
