import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#ca_pool PrivatecaCaPoolIamMember#ca_pool}.
     *
     * @stability stable
     */
    readonly caPool: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#location PrivatecaCaPoolIamMember#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#member PrivatecaCaPoolIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#project PrivatecaCaPoolIamMember#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#role PrivatecaCaPoolIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#condition PrivatecaCaPoolIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: PrivatecaCaPoolIamMemberCondition;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#description PrivatecaCaPoolIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#expression PrivatecaCaPoolIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html#title PrivatecaCaPoolIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html google_privateca_ca_pool_iam_member}.
 *
 * @stability stable
 */
export declare class PrivatecaCaPoolIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_member.html google_privateca_ca_pool_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolIamMemberConfig);
    private _caPool?;
    /**
     * @stability stable
     */
    get caPool(): string;
    /**
     * @stability stable
     */
    set caPool(value: string);
    /**
     * @stability stable
     */
    get caPoolInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    /**
     * @stability stable
     */
    get condition(): PrivatecaCaPoolIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: PrivatecaCaPoolIamMemberCondition | undefined): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): PrivatecaCaPoolIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
