import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 */
export interface CfnChannelProps {
    /**
     * `AWS::MediaLive::Channel.CdiInputSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification
     * @external
     */
    readonly cdiInputSpecification?: CfnChannel.CdiInputSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.ChannelClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     * @external
     */
    readonly channelClass?: string;
    /**
     * `AWS::MediaLive::Channel.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     * @external
     */
    readonly destinations?: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     * @external
     */
    readonly encoderSettings?: CfnChannel.EncoderSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     * @external
     */
    readonly inputAttachments?: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     * @external
     */
    readonly inputSpecification?: CfnChannel.InputSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Channel.LogLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     * @external
     */
    readonly logLevel?: string;
    /**
     * `AWS::MediaLive::Channel.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Channel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Channel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     * @external
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Channel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnChannel;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Inputs
     */
    readonly attrInputs: string[];
    /**
     * `AWS::MediaLive::Channel.CdiInputSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-cdiinputspecification
     * @external
     */
    cdiInputSpecification: CfnChannel.CdiInputSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.ChannelClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-channelclass
     * @external
     */
    channelClass: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-destinations
     * @external
     */
    destinations: Array<CfnChannel.OutputDestinationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.EncoderSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-encodersettings
     * @external
     */
    encoderSettings: CfnChannel.EncoderSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputAttachments`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputattachments
     * @external
     */
    inputAttachments: Array<CfnChannel.InputAttachmentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.InputSpecification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-inputspecification
     * @external
     */
    inputSpecification: CfnChannel.InputSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Channel.LogLevel`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-loglevel
     * @external
     */
    logLevel: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Channel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Channel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html#cfn-medialive-channel-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaLive::Channel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html
     * @external
     */
    interface AacSettingsProperty {
        /**
         * `CfnChannel.AacSettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.AacSettingsProperty.CodingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-codingmode
         * @external
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.AacSettingsProperty.InputType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-inputtype
         * @external
         */
        readonly inputType?: string;
        /**
         * `CfnChannel.AacSettingsProperty.Profile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-profile
         * @external
         */
        readonly profile?: string;
        /**
         * `CfnChannel.AacSettingsProperty.RateControlMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-ratecontrolmode
         * @external
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.AacSettingsProperty.RawFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-rawformat
         * @external
         */
        readonly rawFormat?: string;
        /**
         * `CfnChannel.AacSettingsProperty.SampleRate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-samplerate
         * @external
         */
        readonly sampleRate?: number;
        /**
         * `CfnChannel.AacSettingsProperty.Spec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-spec
         * @external
         */
        readonly spec?: string;
        /**
         * `CfnChannel.AacSettingsProperty.VbrQuality`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aacsettings.html#cfn-medialive-channel-aacsettings-vbrquality
         * @external
         */
        readonly vbrQuality?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html
     * @external
     */
    interface Ac3SettingsProperty {
        /**
         * `CfnChannel.Ac3SettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Ac3SettingsProperty.BitstreamMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-bitstreammode
         * @external
         */
        readonly bitstreamMode?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.CodingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-codingmode
         * @external
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.Dialnorm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-dialnorm
         * @external
         */
        readonly dialnorm?: number;
        /**
         * `CfnChannel.Ac3SettingsProperty.DrcProfile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-drcprofile
         * @external
         */
        readonly drcProfile?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.LfeFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-lfefilter
         * @external
         */
        readonly lfeFilter?: string;
        /**
         * `CfnChannel.Ac3SettingsProperty.MetadataControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ac3settings.html#cfn-medialive-channel-ac3settings-metadatacontrol
         * @external
         */
        readonly metadataControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html
     * @external
     */
    interface AncillarySourceSettingsProperty {
        /**
         * `CfnChannel.AncillarySourceSettingsProperty.SourceAncillaryChannelNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ancillarysourcesettings.html#cfn-medialive-channel-ancillarysourcesettings-sourceancillarychannelnumber
         * @external
         */
        readonly sourceAncillaryChannelNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html
     * @external
     */
    interface ArchiveContainerSettingsProperty {
        /**
         * `CfnChannel.ArchiveContainerSettingsProperty.M2tsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-m2tssettings
         * @external
         */
        readonly m2TsSettings?: CfnChannel.M2tsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveContainerSettingsProperty.RawSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivecontainersettings.html#cfn-medialive-channel-archivecontainersettings-rawsettings
         * @external
         */
        readonly rawSettings?: CfnChannel.RawSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html
     * @external
     */
    interface ArchiveGroupSettingsProperty {
        /**
         * `CfnChannel.ArchiveGroupSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveGroupSettingsProperty.RolloverInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archivegroupsettings.html#cfn-medialive-channel-archivegroupsettings-rolloverinterval
         * @external
         */
        readonly rolloverInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html
     * @external
     */
    interface ArchiveOutputSettingsProperty {
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.ContainerSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-containersettings
         * @external
         */
        readonly containerSettings?: CfnChannel.ArchiveContainerSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.Extension`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-extension
         * @external
         */
        readonly extension?: string;
        /**
         * `CfnChannel.ArchiveOutputSettingsProperty.NameModifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-archiveoutputsettings.html#cfn-medialive-channel-archiveoutputsettings-namemodifier
         * @external
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribdestinationsettings.html
     * @external
     */
    interface AribDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-aribsourcesettings.html
     * @external
     */
    interface AribSourceSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html
     * @external
     */
    interface AudioChannelMappingProperty {
        /**
         * `CfnChannel.AudioChannelMappingProperty.InputChannelLevels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-inputchannellevels
         * @external
         */
        readonly inputChannelLevels?: Array<CfnChannel.InputChannelLevelProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.AudioChannelMappingProperty.OutputChannel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiochannelmapping.html#cfn-medialive-channel-audiochannelmapping-outputchannel
         * @external
         */
        readonly outputChannel?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html
     * @external
     */
    interface AudioCodecSettingsProperty {
        /**
         * `CfnChannel.AudioCodecSettingsProperty.AacSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-aacsettings
         * @external
         */
        readonly aacSettings?: CfnChannel.AacSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Ac3Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-ac3settings
         * @external
         */
        readonly ac3Settings?: CfnChannel.Ac3SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Eac3Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-eac3settings
         * @external
         */
        readonly eac3Settings?: CfnChannel.Eac3SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.Mp2Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-mp2settings
         * @external
         */
        readonly mp2Settings?: CfnChannel.Mp2SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.PassThroughSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-passthroughsettings
         * @external
         */
        readonly passThroughSettings?: CfnChannel.PassThroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioCodecSettingsProperty.WavSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiocodecsettings.html#cfn-medialive-channel-audiocodecsettings-wavsettings
         * @external
         */
        readonly wavSettings?: CfnChannel.WavSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html
     * @external
     */
    interface AudioDescriptionProperty {
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioNormalizationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audionormalizationsettings
         * @external
         */
        readonly audioNormalizationSettings?: CfnChannel.AudioNormalizationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioSelectorName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audioselectorname
         * @external
         */
        readonly audioSelectorName?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotype
         * @external
         */
        readonly audioType?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.AudioTypeControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-audiotypecontrol
         * @external
         */
        readonly audioTypeControl?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.CodecSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-codecsettings
         * @external
         */
        readonly codecSettings?: CfnChannel.AudioCodecSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.LanguageCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecode
         * @external
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.LanguageCodeControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-languagecodecontrol
         * @external
         */
        readonly languageCodeControl?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnChannel.AudioDescriptionProperty.RemixSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-remixsettings
         * @external
         */
        readonly remixSettings?: CfnChannel.RemixSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioDescriptionProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiodescription.html#cfn-medialive-channel-audiodescription-streamname
         * @external
         */
        readonly streamName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html
     * @external
     */
    interface AudioLanguageSelectionProperty {
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languagecode
         * @external
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.AudioLanguageSelectionProperty.LanguageSelectionPolicy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiolanguageselection.html#cfn-medialive-channel-audiolanguageselection-languageselectionpolicy
         * @external
         */
        readonly languageSelectionPolicy?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html
     * @external
     */
    interface AudioNormalizationSettingsProperty {
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.Algorithm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithm
         * @external
         */
        readonly algorithm?: string;
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.AlgorithmControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-algorithmcontrol
         * @external
         */
        readonly algorithmControl?: string;
        /**
         * `CfnChannel.AudioNormalizationSettingsProperty.TargetLkfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audionormalizationsettings.html#cfn-medialive-channel-audionormalizationsettings-targetlkfs
         * @external
         */
        readonly targetLkfs?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html
     * @external
     */
    interface AudioOnlyHlsSettingsProperty {
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioGroupId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiogroupid
         * @external
         */
        readonly audioGroupId?: string;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioOnlyImage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audioonlyimage
         * @external
         */
        readonly audioOnlyImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.AudioTrackType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-audiotracktype
         * @external
         */
        readonly audioTrackType?: string;
        /**
         * `CfnChannel.AudioOnlyHlsSettingsProperty.SegmentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioonlyhlssettings.html#cfn-medialive-channel-audioonlyhlssettings-segmenttype
         * @external
         */
        readonly segmentType?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html
     * @external
     */
    interface AudioPidSelectionProperty {
        /**
         * `CfnChannel.AudioPidSelectionProperty.Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiopidselection.html#cfn-medialive-channel-audiopidselection-pid
         * @external
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html
     * @external
     */
    interface AudioSelectorProperty {
        /**
         * `CfnChannel.AudioSelectorProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnChannel.AudioSelectorProperty.SelectorSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselector.html#cfn-medialive-channel-audioselector-selectorsettings
         * @external
         */
        readonly selectorSettings?: CfnChannel.AudioSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html
     * @external
     */
    interface AudioSelectorSettingsProperty {
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioLanguageSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiolanguageselection
         * @external
         */
        readonly audioLanguageSelection?: CfnChannel.AudioLanguageSelectionProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioPidSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiopidselection
         * @external
         */
        readonly audioPidSelection?: CfnChannel.AudioPidSelectionProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AudioSelectorSettingsProperty.AudioTrackSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audioselectorsettings.html#cfn-medialive-channel-audioselectorsettings-audiotrackselection
         * @external
         */
        readonly audioTrackSelection?: CfnChannel.AudioTrackSelectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html
     * @external
     */
    interface AudioSilenceFailoverSettingsProperty {
        /**
         * `CfnChannel.AudioSilenceFailoverSettingsProperty.AudioSelectorName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audioselectorname
         * @external
         */
        readonly audioSelectorName?: string;
        /**
         * `CfnChannel.AudioSilenceFailoverSettingsProperty.AudioSilenceThresholdMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiosilencefailoversettings.html#cfn-medialive-channel-audiosilencefailoversettings-audiosilencethresholdmsec
         * @external
         */
        readonly audioSilenceThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html
     * @external
     */
    interface AudioTrackProperty {
        /**
         * `CfnChannel.AudioTrackProperty.Track`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrack.html#cfn-medialive-channel-audiotrack-track
         * @external
         */
        readonly track?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html
     * @external
     */
    interface AudioTrackSelectionProperty {
        /**
         * `CfnChannel.AudioTrackSelectionProperty.Tracks`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-audiotrackselection.html#cfn-medialive-channel-audiotrackselection-tracks
         * @external
         */
        readonly tracks?: Array<CfnChannel.AudioTrackProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html
     * @external
     */
    interface AutomaticInputFailoverSettingsProperty {
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.ErrorClearTimeMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-errorcleartimemsec
         * @external
         */
        readonly errorClearTimeMsec?: number;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.FailoverConditions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-failoverconditions
         * @external
         */
        readonly failoverConditions?: Array<CfnChannel.FailoverConditionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.InputPreference`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-inputpreference
         * @external
         */
        readonly inputPreference?: string;
        /**
         * `CfnChannel.AutomaticInputFailoverSettingsProperty.SecondaryInputId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-automaticinputfailoversettings.html#cfn-medialive-channel-automaticinputfailoversettings-secondaryinputid
         * @external
         */
        readonly secondaryInputId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html
     * @external
     */
    interface AvailBlankingProperty {
        /**
         * `CfnChannel.AvailBlankingProperty.AvailBlankingImage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-availblankingimage
         * @external
         */
        readonly availBlankingImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AvailBlankingProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availblanking.html#cfn-medialive-channel-availblanking-state
         * @external
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html
     * @external
     */
    interface AvailConfigurationProperty {
        /**
         * `CfnChannel.AvailConfigurationProperty.AvailSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availconfiguration.html#cfn-medialive-channel-availconfiguration-availsettings
         * @external
         */
        readonly availSettings?: CfnChannel.AvailSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html
     * @external
     */
    interface AvailSettingsProperty {
        /**
         * `CfnChannel.AvailSettingsProperty.Scte35SpliceInsert`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35spliceinsert
         * @external
         */
        readonly scte35SpliceInsert?: CfnChannel.Scte35SpliceInsertProperty | cdk.IResolvable;
        /**
         * `CfnChannel.AvailSettingsProperty.Scte35TimeSignalApos`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-availsettings.html#cfn-medialive-channel-availsettings-scte35timesignalapos
         * @external
         */
        readonly scte35TimeSignalApos?: CfnChannel.Scte35TimeSignalAposProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html
     * @external
     */
    interface BlackoutSlateProperty {
        /**
         * `CfnChannel.BlackoutSlateProperty.BlackoutSlateImage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-blackoutslateimage
         * @external
         */
        readonly blackoutSlateImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkEndBlackout`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackout
         * @external
         */
        readonly networkEndBlackout?: string;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkEndBlackoutImage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkendblackoutimage
         * @external
         */
        readonly networkEndBlackoutImage?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BlackoutSlateProperty.NetworkId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-networkid
         * @external
         */
        readonly networkId?: string;
        /**
         * `CfnChannel.BlackoutSlateProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-blackoutslate.html#cfn-medialive-channel-blackoutslate-state
         * @external
         */
        readonly state?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html
     * @external
     */
    interface BurnInDestinationSettingsProperty {
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.Alignment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-alignment
         * @external
         */
        readonly alignment?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.BackgroundColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundcolor
         * @external
         */
        readonly backgroundColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.BackgroundOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-backgroundopacity
         * @external
         */
        readonly backgroundOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.Font`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-font
         * @external
         */
        readonly font?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontcolor
         * @external
         */
        readonly fontColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontopacity
         * @external
         */
        readonly fontOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontResolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontresolution
         * @external
         */
        readonly fontResolution?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.FontSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-fontsize
         * @external
         */
        readonly fontSize?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.OutlineColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinecolor
         * @external
         */
        readonly outlineColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.OutlineSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-outlinesize
         * @external
         */
        readonly outlineSize?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowcolor
         * @external
         */
        readonly shadowColor?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowopacity
         * @external
         */
        readonly shadowOpacity?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowXOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowxoffset
         * @external
         */
        readonly shadowXOffset?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.ShadowYOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-shadowyoffset
         * @external
         */
        readonly shadowYOffset?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.TeletextGridControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-teletextgridcontrol
         * @external
         */
        readonly teletextGridControl?: string;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.XPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-xposition
         * @external
         */
        readonly xPosition?: number;
        /**
         * `CfnChannel.BurnInDestinationSettingsProperty.YPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-burnindestinationsettings.html#cfn-medialive-channel-burnindestinationsettings-yposition
         * @external
         */
        readonly yPosition?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html
     * @external
     */
    interface CaptionDescriptionProperty {
        /**
         * `CfnChannel.CaptionDescriptionProperty.CaptionSelectorName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-captionselectorname
         * @external
         */
        readonly captionSelectorName?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.DestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-destinationsettings
         * @external
         */
        readonly destinationSettings?: CfnChannel.CaptionDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDescriptionProperty.LanguageCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagecode
         * @external
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.LanguageDescription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-languagedescription
         * @external
         */
        readonly languageDescription?: string;
        /**
         * `CfnChannel.CaptionDescriptionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondescription.html#cfn-medialive-channel-captiondescription-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html
     * @external
     */
    interface CaptionDestinationSettingsProperty {
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.AribDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-aribdestinationsettings
         * @external
         */
        readonly aribDestinationSettings?: CfnChannel.AribDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.BurnInDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-burnindestinationsettings
         * @external
         */
        readonly burnInDestinationSettings?: CfnChannel.BurnInDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.DvbSubDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-dvbsubdestinationsettings
         * @external
         */
        readonly dvbSubDestinationSettings?: CfnChannel.DvbSubDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EbuTtDDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ebuttddestinationsettings
         * @external
         */
        readonly ebuTtDDestinationSettings?: CfnChannel.EbuTtDDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EmbeddedDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddeddestinationsettings
         * @external
         */
        readonly embeddedDestinationSettings?: CfnChannel.EmbeddedDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.EmbeddedPlusScte20DestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-embeddedplusscte20destinationsettings
         * @external
         */
        readonly embeddedPlusScte20DestinationSettings?: CfnChannel.EmbeddedPlusScte20DestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.RtmpCaptionInfoDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-rtmpcaptioninfodestinationsettings
         * @external
         */
        readonly rtmpCaptionInfoDestinationSettings?: CfnChannel.RtmpCaptionInfoDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.Scte20PlusEmbeddedDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte20plusembeddeddestinationsettings
         * @external
         */
        readonly scte20PlusEmbeddedDestinationSettings?: CfnChannel.Scte20PlusEmbeddedDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.Scte27DestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-scte27destinationsettings
         * @external
         */
        readonly scte27DestinationSettings?: CfnChannel.Scte27DestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.SmpteTtDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-smptettdestinationsettings
         * @external
         */
        readonly smpteTtDestinationSettings?: CfnChannel.SmpteTtDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.TeletextDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-teletextdestinationsettings
         * @external
         */
        readonly teletextDestinationSettings?: CfnChannel.TeletextDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.TtmlDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-ttmldestinationsettings
         * @external
         */
        readonly ttmlDestinationSettings?: CfnChannel.TtmlDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionDestinationSettingsProperty.WebvttDestinationSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captiondestinationsettings.html#cfn-medialive-channel-captiondestinationsettings-webvttdestinationsettings
         * @external
         */
        readonly webvttDestinationSettings?: CfnChannel.WebvttDestinationSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html
     * @external
     */
    interface CaptionLanguageMappingProperty {
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.CaptionChannel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-captionchannel
         * @external
         */
        readonly captionChannel?: number;
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.LanguageCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagecode
         * @external
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionLanguageMappingProperty.LanguageDescription`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionlanguagemapping.html#cfn-medialive-channel-captionlanguagemapping-languagedescription
         * @external
         */
        readonly languageDescription?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html
     * @external
     */
    interface CaptionSelectorProperty {
        /**
         * `CfnChannel.CaptionSelectorProperty.LanguageCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-languagecode
         * @external
         */
        readonly languageCode?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnChannel.CaptionSelectorProperty.SelectorSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselector.html#cfn-medialive-channel-captionselector-selectorsettings
         * @external
         */
        readonly selectorSettings?: CfnChannel.CaptionSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html
     * @external
     */
    interface CaptionSelectorSettingsProperty {
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.AncillarySourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-ancillarysourcesettings
         * @external
         */
        readonly ancillarySourceSettings?: CfnChannel.AncillarySourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.AribSourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-aribsourcesettings
         * @external
         */
        readonly aribSourceSettings?: CfnChannel.AribSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.DvbSubSourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-dvbsubsourcesettings
         * @external
         */
        readonly dvbSubSourceSettings?: CfnChannel.DvbSubSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.EmbeddedSourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-embeddedsourcesettings
         * @external
         */
        readonly embeddedSourceSettings?: CfnChannel.EmbeddedSourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte20SourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte20sourcesettings
         * @external
         */
        readonly scte20SourceSettings?: CfnChannel.Scte20SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.Scte27SourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-scte27sourcesettings
         * @external
         */
        readonly scte27SourceSettings?: CfnChannel.Scte27SourceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.CaptionSelectorSettingsProperty.TeletextSourceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-captionselectorsettings.html#cfn-medialive-channel-captionselectorsettings-teletextsourcesettings
         * @external
         */
        readonly teletextSourceSettings?: CfnChannel.TeletextSourceSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html
     * @external
     */
    interface CdiInputSpecificationProperty {
        /**
         * `CfnChannel.CdiInputSpecificationProperty.Resolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-cdiinputspecification.html#cfn-medialive-channel-cdiinputspecification-resolution
         * @external
         */
        readonly resolution?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-colorspacepassthroughsettings.html
     * @external
     */
    interface ColorSpacePassthroughSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html
     * @external
     */
    interface DvbNitSettingsProperty {
        /**
         * `CfnChannel.DvbNitSettingsProperty.NetworkId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkid
         * @external
         */
        readonly networkId?: number;
        /**
         * `CfnChannel.DvbNitSettingsProperty.NetworkName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-networkname
         * @external
         */
        readonly networkName?: string;
        /**
         * `CfnChannel.DvbNitSettingsProperty.RepInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbnitsettings.html#cfn-medialive-channel-dvbnitsettings-repinterval
         * @external
         */
        readonly repInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html
     * @external
     */
    interface DvbSdtSettingsProperty {
        /**
         * `CfnChannel.DvbSdtSettingsProperty.OutputSdt`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-outputsdt
         * @external
         */
        readonly outputSdt?: string;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.RepInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-repinterval
         * @external
         */
        readonly repInterval?: number;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.ServiceName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-servicename
         * @external
         */
        readonly serviceName?: string;
        /**
         * `CfnChannel.DvbSdtSettingsProperty.ServiceProviderName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsdtsettings.html#cfn-medialive-channel-dvbsdtsettings-serviceprovidername
         * @external
         */
        readonly serviceProviderName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html
     * @external
     */
    interface DvbSubDestinationSettingsProperty {
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.Alignment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-alignment
         * @external
         */
        readonly alignment?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.BackgroundColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundcolor
         * @external
         */
        readonly backgroundColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.BackgroundOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-backgroundopacity
         * @external
         */
        readonly backgroundOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.Font`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-font
         * @external
         */
        readonly font?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontcolor
         * @external
         */
        readonly fontColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontopacity
         * @external
         */
        readonly fontOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontResolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontresolution
         * @external
         */
        readonly fontResolution?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.FontSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-fontsize
         * @external
         */
        readonly fontSize?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.OutlineColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinecolor
         * @external
         */
        readonly outlineColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.OutlineSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-outlinesize
         * @external
         */
        readonly outlineSize?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowcolor
         * @external
         */
        readonly shadowColor?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowOpacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowopacity
         * @external
         */
        readonly shadowOpacity?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowXOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowxoffset
         * @external
         */
        readonly shadowXOffset?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.ShadowYOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-shadowyoffset
         * @external
         */
        readonly shadowYOffset?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.TeletextGridControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-teletextgridcontrol
         * @external
         */
        readonly teletextGridControl?: string;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.XPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-xposition
         * @external
         */
        readonly xPosition?: number;
        /**
         * `CfnChannel.DvbSubDestinationSettingsProperty.YPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubdestinationsettings.html#cfn-medialive-channel-dvbsubdestinationsettings-yposition
         * @external
         */
        readonly yPosition?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html
     * @external
     */
    interface DvbSubSourceSettingsProperty {
        /**
         * `CfnChannel.DvbSubSourceSettingsProperty.Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbsubsourcesettings.html#cfn-medialive-channel-dvbsubsourcesettings-pid
         * @external
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html
     * @external
     */
    interface DvbTdtSettingsProperty {
        /**
         * `CfnChannel.DvbTdtSettingsProperty.RepInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-dvbtdtsettings.html#cfn-medialive-channel-dvbtdtsettings-repinterval
         * @external
         */
        readonly repInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html
     * @external
     */
    interface Eac3SettingsProperty {
        /**
         * `CfnChannel.Eac3SettingsProperty.AttenuationControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-attenuationcontrol
         * @external
         */
        readonly attenuationControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.BitstreamMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-bitstreammode
         * @external
         */
        readonly bitstreamMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.CodingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-codingmode
         * @external
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.DcFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dcfilter
         * @external
         */
        readonly dcFilter?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.Dialnorm`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-dialnorm
         * @external
         */
        readonly dialnorm?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.DrcLine`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcline
         * @external
         */
        readonly drcLine?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.DrcRf`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-drcrf
         * @external
         */
        readonly drcRf?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LfeControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfecontrol
         * @external
         */
        readonly lfeControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LfeFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lfefilter
         * @external
         */
        readonly lfeFilter?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.LoRoCenterMixLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorocentermixlevel
         * @external
         */
        readonly loRoCenterMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LoRoSurroundMixLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-lorosurroundmixlevel
         * @external
         */
        readonly loRoSurroundMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LtRtCenterMixLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtcentermixlevel
         * @external
         */
        readonly ltRtCenterMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.LtRtSurroundMixLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-ltrtsurroundmixlevel
         * @external
         */
        readonly ltRtSurroundMixLevel?: number;
        /**
         * `CfnChannel.Eac3SettingsProperty.MetadataControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-metadatacontrol
         * @external
         */
        readonly metadataControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.PassthroughControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-passthroughcontrol
         * @external
         */
        readonly passthroughControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.PhaseControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-phasecontrol
         * @external
         */
        readonly phaseControl?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.StereoDownmix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-stereodownmix
         * @external
         */
        readonly stereoDownmix?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.SurroundExMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundexmode
         * @external
         */
        readonly surroundExMode?: string;
        /**
         * `CfnChannel.Eac3SettingsProperty.SurroundMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-eac3settings.html#cfn-medialive-channel-eac3settings-surroundmode
         * @external
         */
        readonly surroundMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html
     * @external
     */
    interface EbuTtDDestinationSettingsProperty {
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.FillLineGap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-filllinegap
         * @external
         */
        readonly fillLineGap?: string;
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.FontFamily`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-fontfamily
         * @external
         */
        readonly fontFamily?: string;
        /**
         * `CfnChannel.EbuTtDDestinationSettingsProperty.StyleControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ebuttddestinationsettings.html#cfn-medialive-channel-ebuttddestinationsettings-stylecontrol
         * @external
         */
        readonly styleControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddeddestinationsettings.html
     * @external
     */
    interface EmbeddedDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedplusscte20destinationsettings.html
     * @external
     */
    interface EmbeddedPlusScte20DestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html
     * @external
     */
    interface EmbeddedSourceSettingsProperty {
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Convert608To708`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-convert608to708
         * @external
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Scte20Detection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-scte20detection
         * @external
         */
        readonly scte20Detection?: string;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608ChannelNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608channelnumber
         * @external
         */
        readonly source608ChannelNumber?: number;
        /**
         * `CfnChannel.EmbeddedSourceSettingsProperty.Source608TrackNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-embeddedsourcesettings.html#cfn-medialive-channel-embeddedsourcesettings-source608tracknumber
         * @external
         */
        readonly source608TrackNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html
     * @external
     */
    interface EncoderSettingsProperty {
        /**
         * `CfnChannel.EncoderSettingsProperty.AudioDescriptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-audiodescriptions
         * @external
         */
        readonly audioDescriptions?: Array<CfnChannel.AudioDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.AvailBlanking`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availblanking
         * @external
         */
        readonly availBlanking?: CfnChannel.AvailBlankingProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.AvailConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-availconfiguration
         * @external
         */
        readonly availConfiguration?: CfnChannel.AvailConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.BlackoutSlate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-blackoutslate
         * @external
         */
        readonly blackoutSlate?: CfnChannel.BlackoutSlateProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.CaptionDescriptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-captiondescriptions
         * @external
         */
        readonly captionDescriptions?: Array<CfnChannel.CaptionDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.FeatureActivations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-featureactivations
         * @external
         */
        readonly featureActivations?: CfnChannel.FeatureActivationsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.GlobalConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-globalconfiguration
         * @external
         */
        readonly globalConfiguration?: CfnChannel.GlobalConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.NielsenConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-nielsenconfiguration
         * @external
         */
        readonly nielsenConfiguration?: CfnChannel.NielsenConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.OutputGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-outputgroups
         * @external
         */
        readonly outputGroups?: Array<CfnChannel.OutputGroupProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.TimecodeConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-timecodeconfig
         * @external
         */
        readonly timecodeConfig?: CfnChannel.TimecodeConfigProperty | cdk.IResolvable;
        /**
         * `CfnChannel.EncoderSettingsProperty.VideoDescriptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-encodersettings.html#cfn-medialive-channel-encodersettings-videodescriptions
         * @external
         */
        readonly videoDescriptions?: Array<CfnChannel.VideoDescriptionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html
     * @external
     */
    interface FailoverConditionProperty {
        /**
         * `CfnChannel.FailoverConditionProperty.FailoverConditionSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failovercondition.html#cfn-medialive-channel-failovercondition-failoverconditionsettings
         * @external
         */
        readonly failoverConditionSettings?: CfnChannel.FailoverConditionSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html
     * @external
     */
    interface FailoverConditionSettingsProperty {
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.AudioSilenceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-audiosilencesettings
         * @external
         */
        readonly audioSilenceSettings?: CfnChannel.AudioSilenceFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.InputLossSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-inputlosssettings
         * @external
         */
        readonly inputLossSettings?: CfnChannel.InputLossFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.FailoverConditionSettingsProperty.VideoBlackSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-failoverconditionsettings.html#cfn-medialive-channel-failoverconditionsettings-videoblacksettings
         * @external
         */
        readonly videoBlackSettings?: CfnChannel.VideoBlackFailoverSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html
     * @external
     */
    interface FeatureActivationsProperty {
        /**
         * `CfnChannel.FeatureActivationsProperty.InputPrepareScheduleActions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-featureactivations.html#cfn-medialive-channel-featureactivations-inputpreparescheduleactions
         * @external
         */
        readonly inputPrepareScheduleActions?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html
     * @external
     */
    interface FecOutputSettingsProperty {
        /**
         * `CfnChannel.FecOutputSettingsProperty.ColumnDepth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-columndepth
         * @external
         */
        readonly columnDepth?: number;
        /**
         * `CfnChannel.FecOutputSettingsProperty.IncludeFec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-includefec
         * @external
         */
        readonly includeFec?: string;
        /**
         * `CfnChannel.FecOutputSettingsProperty.RowLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fecoutputsettings.html#cfn-medialive-channel-fecoutputsettings-rowlength
         * @external
         */
        readonly rowLength?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html
     * @external
     */
    interface Fmp4HlsSettingsProperty {
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.AudioRenditionSets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-audiorenditionsets
         * @external
         */
        readonly audioRenditionSets?: string;
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.NielsenId3Behavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-nielsenid3behavior
         * @external
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.Fmp4HlsSettingsProperty.TimedMetadataBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-fmp4hlssettings.html#cfn-medialive-channel-fmp4hlssettings-timedmetadatabehavior
         * @external
         */
        readonly timedMetadataBehavior?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html
     * @external
     */
    interface FrameCaptureGroupSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureGroupSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturegroupsettings.html#cfn-medialive-channel-framecapturegroupsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html
     * @external
     */
    interface FrameCaptureOutputSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureOutputSettingsProperty.NameModifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecaptureoutputsettings.html#cfn-medialive-channel-framecaptureoutputsettings-namemodifier
         * @external
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html
     * @external
     */
    interface FrameCaptureSettingsProperty {
        /**
         * `CfnChannel.FrameCaptureSettingsProperty.CaptureInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureinterval
         * @external
         */
        readonly captureInterval?: number;
        /**
         * `CfnChannel.FrameCaptureSettingsProperty.CaptureIntervalUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-framecapturesettings.html#cfn-medialive-channel-framecapturesettings-captureintervalunits
         * @external
         */
        readonly captureIntervalUnits?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html
     * @external
     */
    interface GlobalConfigurationProperty {
        /**
         * `CfnChannel.GlobalConfigurationProperty.InitialAudioGain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-initialaudiogain
         * @external
         */
        readonly initialAudioGain?: number;
        /**
         * `CfnChannel.GlobalConfigurationProperty.InputEndAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputendaction
         * @external
         */
        readonly inputEndAction?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.InputLossBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-inputlossbehavior
         * @external
         */
        readonly inputLossBehavior?: CfnChannel.InputLossBehaviorProperty | cdk.IResolvable;
        /**
         * `CfnChannel.GlobalConfigurationProperty.OutputLockingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputlockingmode
         * @external
         */
        readonly outputLockingMode?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.OutputTimingSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-outputtimingsource
         * @external
         */
        readonly outputTimingSource?: string;
        /**
         * `CfnChannel.GlobalConfigurationProperty.SupportLowFramerateInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-globalconfiguration.html#cfn-medialive-channel-globalconfiguration-supportlowframerateinputs
         * @external
         */
        readonly supportLowFramerateInputs?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html
     * @external
     */
    interface H264ColorSpaceSettingsProperty {
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.ColorSpacePassthroughSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-colorspacepassthroughsettings
         * @external
         */
        readonly colorSpacePassthroughSettings?: CfnChannel.ColorSpacePassthroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.Rec601Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec601settings
         * @external
         */
        readonly rec601Settings?: CfnChannel.Rec601SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264ColorSpaceSettingsProperty.Rec709Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264colorspacesettings.html#cfn-medialive-channel-h264colorspacesettings-rec709settings
         * @external
         */
        readonly rec709Settings?: CfnChannel.Rec709SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html
     * @external
     */
    interface H264FilterSettingsProperty {
        /**
         * `CfnChannel.H264FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264filtersettings.html#cfn-medialive-channel-h264filtersettings-temporalfiltersettings
         * @external
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html
     * @external
     */
    interface H264SettingsProperty {
        /**
         * `CfnChannel.H264SettingsProperty.AdaptiveQuantization`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-adaptivequantization
         * @external
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.H264SettingsProperty.AfdSignaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-afdsignaling
         * @external
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.H264SettingsProperty.BufFillPct`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-buffillpct
         * @external
         */
        readonly bufFillPct?: number;
        /**
         * `CfnChannel.H264SettingsProperty.BufSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-bufsize
         * @external
         */
        readonly bufSize?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ColorMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colormetadata
         * @external
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ColorSpaceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-colorspacesettings
         * @external
         */
        readonly colorSpaceSettings?: CfnChannel.H264ColorSpaceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264SettingsProperty.EntropyEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-entropyencoding
         * @external
         */
        readonly entropyEncoding?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-filtersettings
         * @external
         */
        readonly filterSettings?: CfnChannel.H264FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H264SettingsProperty.FixedAfd`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-fixedafd
         * @external
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FlickerAq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-flickeraq
         * @external
         */
        readonly flickerAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ForceFieldPictures`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-forcefieldpictures
         * @external
         */
        readonly forceFieldPictures?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratecontrol
         * @external
         */
        readonly framerateControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateDenominator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratedenominator
         * @external
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.FramerateNumerator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-frameratenumerator
         * @external
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopBReference`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopbreference
         * @external
         */
        readonly gopBReference?: string;
        /**
         * `CfnChannel.H264SettingsProperty.GopClosedCadence`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopclosedcadence
         * @external
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopNumBFrames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopnumbframes
         * @external
         */
        readonly gopNumBFrames?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsize
         * @external
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.H264SettingsProperty.GopSizeUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-gopsizeunits
         * @external
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Level`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-level
         * @external
         */
        readonly level?: string;
        /**
         * `CfnChannel.H264SettingsProperty.LookAheadRateControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-lookaheadratecontrol
         * @external
         */
        readonly lookAheadRateControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.MaxBitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-maxbitrate
         * @external
         */
        readonly maxBitrate?: number;
        /**
         * `CfnChannel.H264SettingsProperty.MinIInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-miniinterval
         * @external
         */
        readonly minIInterval?: number;
        /**
         * `CfnChannel.H264SettingsProperty.NumRefFrames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-numrefframes
         * @external
         */
        readonly numRefFrames?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ParControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parcontrol
         * @external
         */
        readonly parControl?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ParDenominator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-pardenominator
         * @external
         */
        readonly parDenominator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.ParNumerator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-parnumerator
         * @external
         */
        readonly parNumerator?: number;
        /**
         * `CfnChannel.H264SettingsProperty.Profile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-profile
         * @external
         */
        readonly profile?: string;
        /**
         * `CfnChannel.H264SettingsProperty.QualityLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qualitylevel
         * @external
         */
        readonly qualityLevel?: string;
        /**
         * `CfnChannel.H264SettingsProperty.QvbrQualityLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-qvbrqualitylevel
         * @external
         */
        readonly qvbrQualityLevel?: number;
        /**
         * `CfnChannel.H264SettingsProperty.RateControlMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-ratecontrolmode
         * @external
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.H264SettingsProperty.ScanType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scantype
         * @external
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.H264SettingsProperty.SceneChangeDetect`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-scenechangedetect
         * @external
         */
        readonly sceneChangeDetect?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Slices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-slices
         * @external
         */
        readonly slices?: number;
        /**
         * `CfnChannel.H264SettingsProperty.Softness`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-softness
         * @external
         */
        readonly softness?: number;
        /**
         * `CfnChannel.H264SettingsProperty.SpatialAq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-spatialaq
         * @external
         */
        readonly spatialAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.SubgopLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-subgoplength
         * @external
         */
        readonly subgopLength?: string;
        /**
         * `CfnChannel.H264SettingsProperty.Syntax`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-syntax
         * @external
         */
        readonly syntax?: string;
        /**
         * `CfnChannel.H264SettingsProperty.TemporalAq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-temporalaq
         * @external
         */
        readonly temporalAq?: string;
        /**
         * `CfnChannel.H264SettingsProperty.TimecodeInsertion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h264settings.html#cfn-medialive-channel-h264settings-timecodeinsertion
         * @external
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html
     * @external
     */
    interface H265ColorSpaceSettingsProperty {
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.ColorSpacePassthroughSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-colorspacepassthroughsettings
         * @external
         */
        readonly colorSpacePassthroughSettings?: CfnChannel.ColorSpacePassthroughSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Hdr10Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-hdr10settings
         * @external
         */
        readonly hdr10Settings?: CfnChannel.Hdr10SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Rec601Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec601settings
         * @external
         */
        readonly rec601Settings?: CfnChannel.Rec601SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265ColorSpaceSettingsProperty.Rec709Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265colorspacesettings.html#cfn-medialive-channel-h265colorspacesettings-rec709settings
         * @external
         */
        readonly rec709Settings?: CfnChannel.Rec709SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html
     * @external
     */
    interface H265FilterSettingsProperty {
        /**
         * `CfnChannel.H265FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265filtersettings.html#cfn-medialive-channel-h265filtersettings-temporalfiltersettings
         * @external
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html
     * @external
     */
    interface H265SettingsProperty {
        /**
         * `CfnChannel.H265SettingsProperty.AdaptiveQuantization`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-adaptivequantization
         * @external
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.H265SettingsProperty.AfdSignaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-afdsignaling
         * @external
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.H265SettingsProperty.AlternativeTransferFunction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-alternativetransferfunction
         * @external
         */
        readonly alternativeTransferFunction?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.H265SettingsProperty.BufSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-bufsize
         * @external
         */
        readonly bufSize?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ColorMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colormetadata
         * @external
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.H265SettingsProperty.ColorSpaceSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-colorspacesettings
         * @external
         */
        readonly colorSpaceSettings?: CfnChannel.H265ColorSpaceSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265SettingsProperty.FilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-filtersettings
         * @external
         */
        readonly filterSettings?: CfnChannel.H265FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.H265SettingsProperty.FixedAfd`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-fixedafd
         * @external
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.H265SettingsProperty.FlickerAq`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-flickeraq
         * @external
         */
        readonly flickerAq?: string;
        /**
         * `CfnChannel.H265SettingsProperty.FramerateDenominator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratedenominator
         * @external
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.FramerateNumerator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-frameratenumerator
         * @external
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopClosedCadence`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopclosedcadence
         * @external
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsize
         * @external
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.H265SettingsProperty.GopSizeUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-gopsizeunits
         * @external
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Level`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-level
         * @external
         */
        readonly level?: string;
        /**
         * `CfnChannel.H265SettingsProperty.LookAheadRateControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-lookaheadratecontrol
         * @external
         */
        readonly lookAheadRateControl?: string;
        /**
         * `CfnChannel.H265SettingsProperty.MaxBitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-maxbitrate
         * @external
         */
        readonly maxBitrate?: number;
        /**
         * `CfnChannel.H265SettingsProperty.MinIInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-miniinterval
         * @external
         */
        readonly minIInterval?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ParDenominator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-pardenominator
         * @external
         */
        readonly parDenominator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.ParNumerator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-parnumerator
         * @external
         */
        readonly parNumerator?: number;
        /**
         * `CfnChannel.H265SettingsProperty.Profile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-profile
         * @external
         */
        readonly profile?: string;
        /**
         * `CfnChannel.H265SettingsProperty.QvbrQualityLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-qvbrqualitylevel
         * @external
         */
        readonly qvbrQualityLevel?: number;
        /**
         * `CfnChannel.H265SettingsProperty.RateControlMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-ratecontrolmode
         * @external
         */
        readonly rateControlMode?: string;
        /**
         * `CfnChannel.H265SettingsProperty.ScanType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scantype
         * @external
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.H265SettingsProperty.SceneChangeDetect`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-scenechangedetect
         * @external
         */
        readonly sceneChangeDetect?: string;
        /**
         * `CfnChannel.H265SettingsProperty.Slices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-slices
         * @external
         */
        readonly slices?: number;
        /**
         * `CfnChannel.H265SettingsProperty.Tier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-tier
         * @external
         */
        readonly tier?: string;
        /**
         * `CfnChannel.H265SettingsProperty.TimecodeInsertion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-h265settings.html#cfn-medialive-channel-h265settings-timecodeinsertion
         * @external
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html
     * @external
     */
    interface Hdr10SettingsProperty {
        /**
         * `CfnChannel.Hdr10SettingsProperty.MaxCll`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxcll
         * @external
         */
        readonly maxCll?: number;
        /**
         * `CfnChannel.Hdr10SettingsProperty.MaxFall`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hdr10settings.html#cfn-medialive-channel-hdr10settings-maxfall
         * @external
         */
        readonly maxFall?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html
     * @external
     */
    interface HlsAkamaiSettingsProperty {
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.FilecacheDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-filecacheduration
         * @external
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.HttpTransferMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-httptransfermode
         * @external
         */
        readonly httpTransferMode?: string;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-numretries
         * @external
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.Salt`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-salt
         * @external
         */
        readonly salt?: string;
        /**
         * `CfnChannel.HlsAkamaiSettingsProperty.Token`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsakamaisettings.html#cfn-medialive-channel-hlsakamaisettings-token
         * @external
         */
        readonly token?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html
     * @external
     */
    interface HlsBasicPutSettingsProperty {
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.FilecacheDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-filecacheduration
         * @external
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-numretries
         * @external
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsBasicPutSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsbasicputsettings.html#cfn-medialive-channel-hlsbasicputsettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html
     * @external
     */
    interface HlsCdnSettingsProperty {
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsAkamaiSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsakamaisettings
         * @external
         */
        readonly hlsAkamaiSettings?: CfnChannel.HlsAkamaiSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsBasicPutSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsbasicputsettings
         * @external
         */
        readonly hlsBasicPutSettings?: CfnChannel.HlsBasicPutSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsMediaStoreSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlsmediastoresettings
         * @external
         */
        readonly hlsMediaStoreSettings?: CfnChannel.HlsMediaStoreSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsCdnSettingsProperty.HlsWebdavSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlscdnsettings.html#cfn-medialive-channel-hlscdnsettings-hlswebdavsettings
         * @external
         */
        readonly hlsWebdavSettings?: CfnChannel.HlsWebdavSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html
     * @external
     */
    interface HlsGroupSettingsProperty {
        /**
         * `CfnChannel.HlsGroupSettingsProperty.AdMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-admarkers
         * @external
         */
        readonly adMarkers?: string[];
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlContent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent
         * @external
         */
        readonly baseUrlContent?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlContent1`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlcontent1
         * @external
         */
        readonly baseUrlContent1?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlManifest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest
         * @external
         */
        readonly baseUrlManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.BaseUrlManifest1`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-baseurlmanifest1
         * @external
         */
        readonly baseUrlManifest1?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CaptionLanguageMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagemappings
         * @external
         */
        readonly captionLanguageMappings?: Array<CfnChannel.CaptionLanguageMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CaptionLanguageSetting`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-captionlanguagesetting
         * @external
         */
        readonly captionLanguageSetting?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ClientCache`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-clientcache
         * @external
         */
        readonly clientCache?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.CodecSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-codecspecification
         * @external
         */
        readonly codecSpecification?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ConstantIv`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-constantiv
         * @external
         */
        readonly constantIv?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.DirectoryStructure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-directorystructure
         * @external
         */
        readonly directoryStructure?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.DiscontinuityTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-discontinuitytags
         * @external
         */
        readonly discontinuityTags?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.EncryptionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-encryptiontype
         * @external
         */
        readonly encryptionType?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.HlsCdnSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlscdnsettings
         * @external
         */
        readonly hlsCdnSettings?: CfnChannel.HlsCdnSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.HlsId3SegmentTagging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-hlsid3segmenttagging
         * @external
         */
        readonly hlsId3SegmentTagging?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IFrameOnlyPlaylists`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-iframeonlyplaylists
         * @external
         */
        readonly iFrameOnlyPlaylists?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IncompleteSegmentBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-incompletesegmentbehavior
         * @external
         */
        readonly incompleteSegmentBehavior?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IndexNSegments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-indexnsegments
         * @external
         */
        readonly indexNSegments?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.InputLossAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-inputlossaction
         * @external
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IvInManifest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivinmanifest
         * @external
         */
        readonly ivInManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.IvSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-ivsource
         * @external
         */
        readonly ivSource?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeepSegments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keepsegments
         * @external
         */
        readonly keepSegments?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformat
         * @external
         */
        readonly keyFormat?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyFormatVersions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyformatversions
         * @external
         */
        readonly keyFormatVersions?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.KeyProviderSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-keyprovidersettings
         * @external
         */
        readonly keyProviderSettings?: CfnChannel.KeyProviderSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ManifestCompression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestcompression
         * @external
         */
        readonly manifestCompression?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ManifestDurationFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-manifestdurationformat
         * @external
         */
        readonly manifestDurationFormat?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.MinSegmentLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-minsegmentlength
         * @external
         */
        readonly minSegmentLength?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-mode
         * @external
         */
        readonly mode?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.OutputSelection`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-outputselection
         * @external
         */
        readonly outputSelection?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ProgramDateTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetime
         * @external
         */
        readonly programDateTime?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.ProgramDateTimePeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-programdatetimeperiod
         * @external
         */
        readonly programDateTimePeriod?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.RedundantManifest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-redundantmanifest
         * @external
         */
        readonly redundantManifest?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentlength
         * @external
         */
        readonly segmentLength?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentationmode
         * @external
         */
        readonly segmentationMode?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.SegmentsPerSubdirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-segmentspersubdirectory
         * @external
         */
        readonly segmentsPerSubdirectory?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.StreamInfResolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-streaminfresolution
         * @external
         */
        readonly streamInfResolution?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimedMetadataId3Frame`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3frame
         * @external
         */
        readonly timedMetadataId3Frame?: string;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimedMetadataId3Period`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timedmetadataid3period
         * @external
         */
        readonly timedMetadataId3Period?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TimestampDeltaMilliseconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-timestampdeltamilliseconds
         * @external
         */
        readonly timestampDeltaMilliseconds?: number;
        /**
         * `CfnChannel.HlsGroupSettingsProperty.TsFileMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsgroupsettings.html#cfn-medialive-channel-hlsgroupsettings-tsfilemode
         * @external
         */
        readonly tsFileMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html
     * @external
     */
    interface HlsInputSettingsProperty {
        /**
         * `CfnChannel.HlsInputSettingsProperty.Bandwidth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-bandwidth
         * @external
         */
        readonly bandwidth?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.BufferSegments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-buffersegments
         * @external
         */
        readonly bufferSegments?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.Retries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retries
         * @external
         */
        readonly retries?: number;
        /**
         * `CfnChannel.HlsInputSettingsProperty.RetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsinputsettings.html#cfn-medialive-channel-hlsinputsettings-retryinterval
         * @external
         */
        readonly retryInterval?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html
     * @external
     */
    interface HlsMediaStoreSettingsProperty {
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.FilecacheDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-filecacheduration
         * @external
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.MediaStoreStorageClass`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-mediastorestorageclass
         * @external
         */
        readonly mediaStoreStorageClass?: string;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-numretries
         * @external
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsMediaStoreSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsmediastoresettings.html#cfn-medialive-channel-hlsmediastoresettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html
     * @external
     */
    interface HlsOutputSettingsProperty {
        /**
         * `CfnChannel.HlsOutputSettingsProperty.H265PackagingType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-h265packagingtype
         * @external
         */
        readonly h265PackagingType?: string;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.HlsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-hlssettings
         * @external
         */
        readonly hlsSettings?: CfnChannel.HlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.NameModifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-namemodifier
         * @external
         */
        readonly nameModifier?: string;
        /**
         * `CfnChannel.HlsOutputSettingsProperty.SegmentModifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlsoutputsettings.html#cfn-medialive-channel-hlsoutputsettings-segmentmodifier
         * @external
         */
        readonly segmentModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html
     * @external
     */
    interface HlsSettingsProperty {
        /**
         * `CfnChannel.HlsSettingsProperty.AudioOnlyHlsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-audioonlyhlssettings
         * @external
         */
        readonly audioOnlyHlsSettings?: CfnChannel.AudioOnlyHlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsSettingsProperty.Fmp4HlsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-fmp4hlssettings
         * @external
         */
        readonly fmp4HlsSettings?: CfnChannel.Fmp4HlsSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.HlsSettingsProperty.StandardHlsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlssettings.html#cfn-medialive-channel-hlssettings-standardhlssettings
         * @external
         */
        readonly standardHlsSettings?: CfnChannel.StandardHlsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html
     * @external
     */
    interface HlsWebdavSettingsProperty {
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.FilecacheDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-filecacheduration
         * @external
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.HttpTransferMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-httptransfermode
         * @external
         */
        readonly httpTransferMode?: string;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-numretries
         * @external
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.HlsWebdavSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-hlswebdavsettings.html#cfn-medialive-channel-hlswebdavsettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html
     * @external
     */
    interface InputAttachmentProperty {
        /**
         * `CfnChannel.InputAttachmentProperty.AutomaticInputFailoverSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-automaticinputfailoversettings
         * @external
         */
        readonly automaticInputFailoverSettings?: CfnChannel.AutomaticInputFailoverSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputAttachmentProperty.InputAttachmentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputattachmentname
         * @external
         */
        readonly inputAttachmentName?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputid
         * @external
         */
        readonly inputId?: string;
        /**
         * `CfnChannel.InputAttachmentProperty.InputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputattachment.html#cfn-medialive-channel-inputattachment-inputsettings
         * @external
         */
        readonly inputSettings?: CfnChannel.InputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html
     * @external
     */
    interface InputChannelLevelProperty {
        /**
         * `CfnChannel.InputChannelLevelProperty.Gain`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-gain
         * @external
         */
        readonly gain?: number;
        /**
         * `CfnChannel.InputChannelLevelProperty.InputChannel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputchannellevel.html#cfn-medialive-channel-inputchannellevel-inputchannel
         * @external
         */
        readonly inputChannel?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html
     * @external
     */
    interface InputLocationProperty {
        /**
         * `CfnChannel.InputLocationProperty.PasswordParam`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-passwordparam
         * @external
         */
        readonly passwordParam?: string;
        /**
         * `CfnChannel.InputLocationProperty.Uri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-uri
         * @external
         */
        readonly uri?: string;
        /**
         * `CfnChannel.InputLocationProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlocation.html#cfn-medialive-channel-inputlocation-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html
     * @external
     */
    interface InputLossBehaviorProperty {
        /**
         * `CfnChannel.InputLossBehaviorProperty.BlackFrameMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-blackframemsec
         * @external
         */
        readonly blackFrameMsec?: number;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageColor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagecolor
         * @external
         */
        readonly inputLossImageColor?: string;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageSlate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimageslate
         * @external
         */
        readonly inputLossImageSlate?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputLossBehaviorProperty.InputLossImageType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-inputlossimagetype
         * @external
         */
        readonly inputLossImageType?: string;
        /**
         * `CfnChannel.InputLossBehaviorProperty.RepeatFrameMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossbehavior.html#cfn-medialive-channel-inputlossbehavior-repeatframemsec
         * @external
         */
        readonly repeatFrameMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html
     * @external
     */
    interface InputLossFailoverSettingsProperty {
        /**
         * `CfnChannel.InputLossFailoverSettingsProperty.InputLossThresholdMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputlossfailoversettings.html#cfn-medialive-channel-inputlossfailoversettings-inputlossthresholdmsec
         * @external
         */
        readonly inputLossThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html
     * @external
     */
    interface InputSettingsProperty {
        /**
         * `CfnChannel.InputSettingsProperty.AudioSelectors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-audioselectors
         * @external
         */
        readonly audioSelectors?: Array<CfnChannel.AudioSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.CaptionSelectors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-captionselectors
         * @external
         */
        readonly captionSelectors?: Array<CfnChannel.CaptionSelectorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.DeblockFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-deblockfilter
         * @external
         */
        readonly deblockFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.DenoiseFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-denoisefilter
         * @external
         */
        readonly denoiseFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.FilterStrength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-filterstrength
         * @external
         */
        readonly filterStrength?: number;
        /**
         * `CfnChannel.InputSettingsProperty.InputFilter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-inputfilter
         * @external
         */
        readonly inputFilter?: string;
        /**
         * `CfnChannel.InputSettingsProperty.NetworkInputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-networkinputsettings
         * @external
         */
        readonly networkInputSettings?: CfnChannel.NetworkInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.InputSettingsProperty.Smpte2038DataPreference`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-smpte2038datapreference
         * @external
         */
        readonly smpte2038DataPreference?: string;
        /**
         * `CfnChannel.InputSettingsProperty.SourceEndBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-sourceendbehavior
         * @external
         */
        readonly sourceEndBehavior?: string;
        /**
         * `CfnChannel.InputSettingsProperty.VideoSelector`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputsettings.html#cfn-medialive-channel-inputsettings-videoselector
         * @external
         */
        readonly videoSelector?: CfnChannel.VideoSelectorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html
     * @external
     */
    interface InputSpecificationProperty {
        /**
         * `CfnChannel.InputSpecificationProperty.Codec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-codec
         * @external
         */
        readonly codec?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.MaximumBitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-maximumbitrate
         * @external
         */
        readonly maximumBitrate?: string;
        /**
         * `CfnChannel.InputSpecificationProperty.Resolution`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-inputspecification.html#cfn-medialive-channel-inputspecification-resolution
         * @external
         */
        readonly resolution?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html
     * @external
     */
    interface KeyProviderSettingsProperty {
        /**
         * `CfnChannel.KeyProviderSettingsProperty.StaticKeySettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-keyprovidersettings.html#cfn-medialive-channel-keyprovidersettings-statickeysettings
         * @external
         */
        readonly staticKeySettings?: CfnChannel.StaticKeySettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html
     * @external
     */
    interface M2tsSettingsProperty {
        /**
         * `CfnChannel.M2tsSettingsProperty.AbsentInputAudioBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-absentinputaudiobehavior
         * @external
         */
        readonly absentInputAudioBehavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Arib`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-arib
         * @external
         */
        readonly arib?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AribCaptionsPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspid
         * @external
         */
        readonly aribCaptionsPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AribCaptionsPidControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-aribcaptionspidcontrol
         * @external
         */
        readonly aribCaptionsPidControl?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioBufferModel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiobuffermodel
         * @external
         */
        readonly audioBufferModel?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioFramesPerPes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audioframesperpes
         * @external
         */
        readonly audioFramesPerPes?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioPids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiopids
         * @external
         */
        readonly audioPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.AudioStreamType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-audiostreamtype
         * @external
         */
        readonly audioStreamType?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.BufferModel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-buffermodel
         * @external
         */
        readonly bufferModel?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.CcDescriptor`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ccdescriptor
         * @external
         */
        readonly ccDescriptor?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbNitSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbnitsettings
         * @external
         */
        readonly dvbNitSettings?: CfnChannel.DvbNitSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbSdtSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsdtsettings
         * @external
         */
        readonly dvbSdtSettings?: CfnChannel.DvbSdtSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbSubPids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbsubpids
         * @external
         */
        readonly dvbSubPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbTdtSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbtdtsettings
         * @external
         */
        readonly dvbTdtSettings?: CfnChannel.DvbTdtSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.M2tsSettingsProperty.DvbTeletextPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-dvbteletextpid
         * @external
         */
        readonly dvbTeletextPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Ebif`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebif
         * @external
         */
        readonly ebif?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpAudioInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpaudiointerval
         * @external
         */
        readonly ebpAudioInterval?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpLookaheadMs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebplookaheadms
         * @external
         */
        readonly ebpLookaheadMs?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.EbpPlacement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ebpplacement
         * @external
         */
        readonly ebpPlacement?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EcmPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ecmpid
         * @external
         */
        readonly ecmPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EsRateInPes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-esrateinpes
         * @external
         */
        readonly esRateInPes?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EtvPlatformPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvplatformpid
         * @external
         */
        readonly etvPlatformPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.EtvSignalPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-etvsignalpid
         * @external
         */
        readonly etvSignalPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.FragmentTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-fragmenttime
         * @external
         */
        readonly fragmentTime?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.Klv`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klv
         * @external
         */
        readonly klv?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.KlvDataPids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-klvdatapids
         * @external
         */
        readonly klvDataPids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.NielsenId3Behavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nielsenid3behavior
         * @external
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.NullPacketBitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-nullpacketbitrate
         * @external
         */
        readonly nullPacketBitrate?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PatInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-patinterval
         * @external
         */
        readonly patInterval?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrcontrol
         * @external
         */
        readonly pcrControl?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrperiod
         * @external
         */
        readonly pcrPeriod?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PcrPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pcrpid
         * @external
         */
        readonly pcrPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.PmtInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtinterval
         * @external
         */
        readonly pmtInterval?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.PmtPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-pmtpid
         * @external
         */
        readonly pmtPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.ProgramNum`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-programnum
         * @external
         */
        readonly programNum?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.RateMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-ratemode
         * @external
         */
        readonly rateMode?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte27Pids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte27pids
         * @external
         */
        readonly scte27Pids?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte35Control`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35control
         * @external
         */
        readonly scte35Control?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.Scte35Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-scte35pid
         * @external
         */
        readonly scte35Pid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationmarkers
         * @external
         */
        readonly segmentationMarkers?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationStyle`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationstyle
         * @external
         */
        readonly segmentationStyle?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.SegmentationTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-segmentationtime
         * @external
         */
        readonly segmentationTime?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.TimedMetadataBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatabehavior
         * @external
         */
        readonly timedMetadataBehavior?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.TimedMetadataPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-timedmetadatapid
         * @external
         */
        readonly timedMetadataPid?: string;
        /**
         * `CfnChannel.M2tsSettingsProperty.TransportStreamId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-transportstreamid
         * @external
         */
        readonly transportStreamId?: number;
        /**
         * `CfnChannel.M2tsSettingsProperty.VideoPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m2tssettings.html#cfn-medialive-channel-m2tssettings-videopid
         * @external
         */
        readonly videoPid?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html
     * @external
     */
    interface M3u8SettingsProperty {
        /**
         * `CfnChannel.M3u8SettingsProperty.AudioFramesPerPes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audioframesperpes
         * @external
         */
        readonly audioFramesPerPes?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.AudioPids`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-audiopids
         * @external
         */
        readonly audioPids?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.EcmPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-ecmpid
         * @external
         */
        readonly ecmPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.NielsenId3Behavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-nielsenid3behavior
         * @external
         */
        readonly nielsenId3Behavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PatInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-patinterval
         * @external
         */
        readonly patInterval?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrcontrol
         * @external
         */
        readonly pcrControl?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrperiod
         * @external
         */
        readonly pcrPeriod?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PcrPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pcrpid
         * @external
         */
        readonly pcrPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.PmtInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtinterval
         * @external
         */
        readonly pmtInterval?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.PmtPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-pmtpid
         * @external
         */
        readonly pmtPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.ProgramNum`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-programnum
         * @external
         */
        readonly programNum?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.Scte35Behavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35behavior
         * @external
         */
        readonly scte35Behavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.Scte35Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-scte35pid
         * @external
         */
        readonly scte35Pid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TimedMetadataBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatabehavior
         * @external
         */
        readonly timedMetadataBehavior?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TimedMetadataPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-timedmetadatapid
         * @external
         */
        readonly timedMetadataPid?: string;
        /**
         * `CfnChannel.M3u8SettingsProperty.TransportStreamId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-transportstreamid
         * @external
         */
        readonly transportStreamId?: number;
        /**
         * `CfnChannel.M3u8SettingsProperty.VideoPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-m3u8settings.html#cfn-medialive-channel-m3u8settings-videopid
         * @external
         */
        readonly videoPid?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html
     * @external
     */
    interface MediaPackageGroupSettingsProperty {
        /**
         * `CfnChannel.MediaPackageGroupSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackagegroupsettings.html#cfn-medialive-channel-mediapackagegroupsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html
     * @external
     */
    interface MediaPackageOutputDestinationSettingsProperty {
        /**
         * `CfnChannel.MediaPackageOutputDestinationSettingsProperty.ChannelId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputdestinationsettings.html#cfn-medialive-channel-mediapackageoutputdestinationsettings-channelid
         * @external
         */
        readonly channelId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mediapackageoutputsettings.html
     * @external
     */
    interface MediaPackageOutputSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html
     * @external
     */
    interface Mp2SettingsProperty {
        /**
         * `CfnChannel.Mp2SettingsProperty.Bitrate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-bitrate
         * @external
         */
        readonly bitrate?: number;
        /**
         * `CfnChannel.Mp2SettingsProperty.CodingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-codingmode
         * @external
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.Mp2SettingsProperty.SampleRate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mp2settings.html#cfn-medialive-channel-mp2settings-samplerate
         * @external
         */
        readonly sampleRate?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html
     * @external
     */
    interface Mpeg2FilterSettingsProperty {
        /**
         * `CfnChannel.Mpeg2FilterSettingsProperty.TemporalFilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2filtersettings.html#cfn-medialive-channel-mpeg2filtersettings-temporalfiltersettings
         * @external
         */
        readonly temporalFilterSettings?: CfnChannel.TemporalFilterSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html
     * @external
     */
    interface Mpeg2SettingsProperty {
        /**
         * `CfnChannel.Mpeg2SettingsProperty.AdaptiveQuantization`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-adaptivequantization
         * @external
         */
        readonly adaptiveQuantization?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.AfdSignaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-afdsignaling
         * @external
         */
        readonly afdSignaling?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ColorMetadata`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colormetadata
         * @external
         */
        readonly colorMetadata?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ColorSpace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-colorspace
         * @external
         */
        readonly colorSpace?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.DisplayAspectRatio`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-displayaspectratio
         * @external
         */
        readonly displayAspectRatio?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FilterSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-filtersettings
         * @external
         */
        readonly filterSettings?: CfnChannel.Mpeg2FilterSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FixedAfd`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-fixedafd
         * @external
         */
        readonly fixedAfd?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FramerateDenominator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratedenominator
         * @external
         */
        readonly framerateDenominator?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.FramerateNumerator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-frameratenumerator
         * @external
         */
        readonly framerateNumerator?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopClosedCadence`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopclosedcadence
         * @external
         */
        readonly gopClosedCadence?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopNumBFrames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopnumbframes
         * @external
         */
        readonly gopNumBFrames?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsize
         * @external
         */
        readonly gopSize?: number;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.GopSizeUnits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-gopsizeunits
         * @external
         */
        readonly gopSizeUnits?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.ScanType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-scantype
         * @external
         */
        readonly scanType?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.SubgopLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-subgoplength
         * @external
         */
        readonly subgopLength?: string;
        /**
         * `CfnChannel.Mpeg2SettingsProperty.TimecodeInsertion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mpeg2settings.html#cfn-medialive-channel-mpeg2settings-timecodeinsertion
         * @external
         */
        readonly timecodeInsertion?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html
     * @external
     */
    interface MsSmoothGroupSettingsProperty {
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.AcquisitionPointId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-acquisitionpointid
         * @external
         */
        readonly acquisitionPointId?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.AudioOnlyTimecodeControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-audioonlytimecodecontrol
         * @external
         */
        readonly audioOnlyTimecodeControl?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.CertificateMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-certificatemode
         * @external
         */
        readonly certificateMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventid
         * @external
         */
        readonly eventId?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventIdMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventidmode
         * @external
         */
        readonly eventIdMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.EventStopBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-eventstopbehavior
         * @external
         */
        readonly eventStopBehavior?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.FilecacheDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-filecacheduration
         * @external
         */
        readonly filecacheDuration?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.FragmentLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-fragmentlength
         * @external
         */
        readonly fragmentLength?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.InputLossAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-inputlossaction
         * @external
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-numretries
         * @external
         */
        readonly numRetries?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SegmentationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-segmentationmode
         * @external
         */
        readonly segmentationMode?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SendDelayMs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-senddelayms
         * @external
         */
        readonly sendDelayMs?: number;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.SparseTrackType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-sparsetracktype
         * @external
         */
        readonly sparseTrackType?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.StreamManifestBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-streammanifestbehavior
         * @external
         */
        readonly streamManifestBehavior?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.TimestampOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffset
         * @external
         */
        readonly timestampOffset?: string;
        /**
         * `CfnChannel.MsSmoothGroupSettingsProperty.TimestampOffsetMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothgroupsettings.html#cfn-medialive-channel-mssmoothgroupsettings-timestampoffsetmode
         * @external
         */
        readonly timestampOffsetMode?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html
     * @external
     */
    interface MsSmoothOutputSettingsProperty {
        /**
         * `CfnChannel.MsSmoothOutputSettingsProperty.H265PackagingType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-h265packagingtype
         * @external
         */
        readonly h265PackagingType?: string;
        /**
         * `CfnChannel.MsSmoothOutputSettingsProperty.NameModifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-mssmoothoutputsettings.html#cfn-medialive-channel-mssmoothoutputsettings-namemodifier
         * @external
         */
        readonly nameModifier?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexgroupsettings.html
     * @external
     */
    interface MultiplexGroupSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html
     * @external
     */
    interface MultiplexOutputSettingsProperty {
        /**
         * `CfnChannel.MultiplexOutputSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexoutputsettings.html#cfn-medialive-channel-multiplexoutputsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html
     * @external
     */
    interface MultiplexProgramChannelDestinationSettingsProperty {
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.MultiplexId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-multiplexid
         * @external
         */
        readonly multiplexId?: string;
        /**
         * `CfnChannel.MultiplexProgramChannelDestinationSettingsProperty.ProgramName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-multiplexprogramchanneldestinationsettings.html#cfn-medialive-channel-multiplexprogramchanneldestinationsettings-programname
         * @external
         */
        readonly programName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html
     * @external
     */
    interface NetworkInputSettingsProperty {
        /**
         * `CfnChannel.NetworkInputSettingsProperty.HlsInputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-hlsinputsettings
         * @external
         */
        readonly hlsInputSettings?: CfnChannel.HlsInputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.NetworkInputSettingsProperty.ServerValidation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-networkinputsettings.html#cfn-medialive-channel-networkinputsettings-servervalidation
         * @external
         */
        readonly serverValidation?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html
     * @external
     */
    interface NielsenConfigurationProperty {
        /**
         * `CfnChannel.NielsenConfigurationProperty.DistributorId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-distributorid
         * @external
         */
        readonly distributorId?: string;
        /**
         * `CfnChannel.NielsenConfigurationProperty.NielsenPcmToId3Tagging`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-nielsenconfiguration.html#cfn-medialive-channel-nielsenconfiguration-nielsenpcmtoid3tagging
         * @external
         */
        readonly nielsenPcmToId3Tagging?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html
     * @external
     */
    interface OutputProperty {
        /**
         * `CfnChannel.OutputProperty.AudioDescriptionNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-audiodescriptionnames
         * @external
         */
        readonly audioDescriptionNames?: string[];
        /**
         * `CfnChannel.OutputProperty.CaptionDescriptionNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-captiondescriptionnames
         * @external
         */
        readonly captionDescriptionNames?: string[];
        /**
         * `CfnChannel.OutputProperty.OutputName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-outputname
         * @external
         */
        readonly outputName?: string;
        /**
         * `CfnChannel.OutputProperty.OutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-outputsettings
         * @external
         */
        readonly outputSettings?: CfnChannel.OutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputProperty.VideoDescriptionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-output.html#cfn-medialive-channel-output-videodescriptionname
         * @external
         */
        readonly videoDescriptionName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html
     * @external
     */
    interface OutputDestinationProperty {
        /**
         * `CfnChannel.OutputDestinationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnChannel.OutputDestinationProperty.MediaPackageSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-mediapackagesettings
         * @external
         */
        readonly mediaPackageSettings?: Array<CfnChannel.MediaPackageOutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.MultiplexSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-multiplexsettings
         * @external
         */
        readonly multiplexSettings?: CfnChannel.MultiplexProgramChannelDestinationSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputDestinationProperty.Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestination.html#cfn-medialive-channel-outputdestination-settings
         * @external
         */
        readonly settings?: Array<CfnChannel.OutputDestinationSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html
     * @external
     */
    interface OutputDestinationSettingsProperty {
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.PasswordParam`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-passwordparam
         * @external
         */
        readonly passwordParam?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-streamname
         * @external
         */
        readonly streamName?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnChannel.OutputDestinationSettingsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputdestinationsettings.html#cfn-medialive-channel-outputdestinationsettings-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html
     * @external
     */
    interface OutputGroupProperty {
        /**
         * `CfnChannel.OutputGroupProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnChannel.OutputGroupProperty.OutputGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputgroupsettings
         * @external
         */
        readonly outputGroupSettings?: CfnChannel.OutputGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupProperty.Outputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html#cfn-medialive-channel-outputgroup-outputs
         * @external
         */
        readonly outputs?: Array<CfnChannel.OutputProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html
     * @external
     */
    interface OutputGroupSettingsProperty {
        /**
         * `CfnChannel.OutputGroupSettingsProperty.ArchiveGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-archivegroupsettings
         * @external
         */
        readonly archiveGroupSettings?: CfnChannel.ArchiveGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.FrameCaptureGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-framecapturegroupsettings
         * @external
         */
        readonly frameCaptureGroupSettings?: CfnChannel.FrameCaptureGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.HlsGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-hlsgroupsettings
         * @external
         */
        readonly hlsGroupSettings?: CfnChannel.HlsGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MediaPackageGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-mediapackagegroupsettings
         * @external
         */
        readonly mediaPackageGroupSettings?: CfnChannel.MediaPackageGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MsSmoothGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-mssmoothgroupsettings
         * @external
         */
        readonly msSmoothGroupSettings?: CfnChannel.MsSmoothGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.MultiplexGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-multiplexgroupsettings
         * @external
         */
        readonly multiplexGroupSettings?: CfnChannel.MultiplexGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.RtmpGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-rtmpgroupsettings
         * @external
         */
        readonly rtmpGroupSettings?: CfnChannel.RtmpGroupSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputGroupSettingsProperty.UdpGroupSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroupsettings.html#cfn-medialive-channel-outputgroupsettings-udpgroupsettings
         * @external
         */
        readonly udpGroupSettings?: CfnChannel.UdpGroupSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputlocationref.html
     * @external
     */
    interface OutputLocationRefProperty {
        /**
         * `CfnChannel.OutputLocationRefProperty.DestinationRefId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputlocationref.html#cfn-medialive-channel-outputlocationref-destinationrefid
         * @external
         */
        readonly destinationRefId?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html
     * @external
     */
    interface OutputSettingsProperty {
        /**
         * `CfnChannel.OutputSettingsProperty.ArchiveOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-archiveoutputsettings
         * @external
         */
        readonly archiveOutputSettings?: CfnChannel.ArchiveOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.FrameCaptureOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-framecaptureoutputsettings
         * @external
         */
        readonly frameCaptureOutputSettings?: CfnChannel.FrameCaptureOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.HlsOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-hlsoutputsettings
         * @external
         */
        readonly hlsOutputSettings?: CfnChannel.HlsOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MediaPackageOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-mediapackageoutputsettings
         * @external
         */
        readonly mediaPackageOutputSettings?: CfnChannel.MediaPackageOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MsSmoothOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-mssmoothoutputsettings
         * @external
         */
        readonly msSmoothOutputSettings?: CfnChannel.MsSmoothOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.MultiplexOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-multiplexoutputsettings
         * @external
         */
        readonly multiplexOutputSettings?: CfnChannel.MultiplexOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.RtmpOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-rtmpoutputsettings
         * @external
         */
        readonly rtmpOutputSettings?: CfnChannel.RtmpOutputSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.OutputSettingsProperty.UdpOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputsettings.html#cfn-medialive-channel-outputsettings-udpoutputsettings
         * @external
         */
        readonly udpOutputSettings?: CfnChannel.UdpOutputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-passthroughsettings.html
     * @external
     */
    interface PassThroughSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rawsettings.html
     * @external
     */
    interface RawSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rec601settings.html
     * @external
     */
    interface Rec601SettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rec709settings.html
     * @external
     */
    interface Rec709SettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html
     * @external
     */
    interface RemixSettingsProperty {
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelmappings
         * @external
         */
        readonly channelMappings?: Array<CfnChannel.AudioChannelMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelsIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelsin
         * @external
         */
        readonly channelsIn?: number;
        /**
         * `CfnChannel.RemixSettingsProperty.ChannelsOut`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-remixsettings.html#cfn-medialive-channel-remixsettings-channelsout
         * @external
         */
        readonly channelsOut?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpcaptioninfodestinationsettings.html
     * @external
     */
    interface RtmpCaptionInfoDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html
     * @external
     */
    interface RtmpGroupSettingsProperty {
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.AdMarkers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-admarkers
         * @external
         */
        readonly adMarkers?: string[];
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.AuthenticationScheme`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-authenticationscheme
         * @external
         */
        readonly authenticationScheme?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CacheFullBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-cachefullbehavior
         * @external
         */
        readonly cacheFullBehavior?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CacheLength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-cachelength
         * @external
         */
        readonly cacheLength?: number;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.CaptionData`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-captiondata
         * @external
         */
        readonly captionData?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.InputLossAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-inputlossaction
         * @external
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.RtmpGroupSettingsProperty.RestartDelay`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpgroupsettings.html#cfn-medialive-channel-rtmpgroupsettings-restartdelay
         * @external
         */
        readonly restartDelay?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html
     * @external
     */
    interface RtmpOutputSettingsProperty {
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.CertificateMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-certificatemode
         * @external
         */
        readonly certificateMode?: string;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.ConnectionRetryInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-connectionretryinterval
         * @external
         */
        readonly connectionRetryInterval?: number;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.RtmpOutputSettingsProperty.NumRetries`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-rtmpoutputsettings.html#cfn-medialive-channel-rtmpoutputsettings-numretries
         * @external
         */
        readonly numRetries?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20plusembeddeddestinationsettings.html
     * @external
     */
    interface Scte20PlusEmbeddedDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html
     * @external
     */
    interface Scte20SourceSettingsProperty {
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Convert608To708`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-convert608to708
         * @external
         */
        readonly convert608To708?: string;
        /**
         * `CfnChannel.Scte20SourceSettingsProperty.Source608ChannelNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte20sourcesettings.html#cfn-medialive-channel-scte20sourcesettings-source608channelnumber
         * @external
         */
        readonly source608ChannelNumber?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27destinationsettings.html
     * @external
     */
    interface Scte27DestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html
     * @external
     */
    interface Scte27SourceSettingsProperty {
        /**
         * `CfnChannel.Scte27SourceSettingsProperty.Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte27sourcesettings.html#cfn-medialive-channel-scte27sourcesettings-pid
         * @external
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html
     * @external
     */
    interface Scte35SpliceInsertProperty {
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.AdAvailOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-adavailoffset
         * @external
         */
        readonly adAvailOffset?: number;
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.NoRegionalBlackoutFlag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-noregionalblackoutflag
         * @external
         */
        readonly noRegionalBlackoutFlag?: string;
        /**
         * `CfnChannel.Scte35SpliceInsertProperty.WebDeliveryAllowedFlag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35spliceinsert.html#cfn-medialive-channel-scte35spliceinsert-webdeliveryallowedflag
         * @external
         */
        readonly webDeliveryAllowedFlag?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html
     * @external
     */
    interface Scte35TimeSignalAposProperty {
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.AdAvailOffset`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-adavailoffset
         * @external
         */
        readonly adAvailOffset?: number;
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.NoRegionalBlackoutFlag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-noregionalblackoutflag
         * @external
         */
        readonly noRegionalBlackoutFlag?: string;
        /**
         * `CfnChannel.Scte35TimeSignalAposProperty.WebDeliveryAllowedFlag`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-scte35timesignalapos.html#cfn-medialive-channel-scte35timesignalapos-webdeliveryallowedflag
         * @external
         */
        readonly webDeliveryAllowedFlag?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-smptettdestinationsettings.html
     * @external
     */
    interface SmpteTtDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html
     * @external
     */
    interface StandardHlsSettingsProperty {
        /**
         * `CfnChannel.StandardHlsSettingsProperty.AudioRenditionSets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html#cfn-medialive-channel-standardhlssettings-audiorenditionsets
         * @external
         */
        readonly audioRenditionSets?: string;
        /**
         * `CfnChannel.StandardHlsSettingsProperty.M3u8Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-standardhlssettings.html#cfn-medialive-channel-standardhlssettings-m3u8settings
         * @external
         */
        readonly m3U8Settings?: CfnChannel.M3u8SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html
     * @external
     */
    interface StaticKeySettingsProperty {
        /**
         * `CfnChannel.StaticKeySettingsProperty.KeyProviderServer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html#cfn-medialive-channel-statickeysettings-keyproviderserver
         * @external
         */
        readonly keyProviderServer?: CfnChannel.InputLocationProperty | cdk.IResolvable;
        /**
         * `CfnChannel.StaticKeySettingsProperty.StaticKeyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-statickeysettings.html#cfn-medialive-channel-statickeysettings-statickeyvalue
         * @external
         */
        readonly staticKeyValue?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextdestinationsettings.html
     * @external
     */
    interface TeletextDestinationSettingsProperty {
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html
     * @external
     */
    interface TeletextSourceSettingsProperty {
        /**
         * `CfnChannel.TeletextSourceSettingsProperty.PageNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-teletextsourcesettings.html#cfn-medialive-channel-teletextsourcesettings-pagenumber
         * @external
         */
        readonly pageNumber?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html
     * @external
     */
    interface TemporalFilterSettingsProperty {
        /**
         * `CfnChannel.TemporalFilterSettingsProperty.PostFilterSharpening`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html#cfn-medialive-channel-temporalfiltersettings-postfiltersharpening
         * @external
         */
        readonly postFilterSharpening?: string;
        /**
         * `CfnChannel.TemporalFilterSettingsProperty.Strength`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-temporalfiltersettings.html#cfn-medialive-channel-temporalfiltersettings-strength
         * @external
         */
        readonly strength?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html
     * @external
     */
    interface TimecodeConfigProperty {
        /**
         * `CfnChannel.TimecodeConfigProperty.Source`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html#cfn-medialive-channel-timecodeconfig-source
         * @external
         */
        readonly source?: string;
        /**
         * `CfnChannel.TimecodeConfigProperty.SyncThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-timecodeconfig.html#cfn-medialive-channel-timecodeconfig-syncthreshold
         * @external
         */
        readonly syncThreshold?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ttmldestinationsettings.html
     * @external
     */
    interface TtmlDestinationSettingsProperty {
        /**
         * `CfnChannel.TtmlDestinationSettingsProperty.StyleControl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-ttmldestinationsettings.html#cfn-medialive-channel-ttmldestinationsettings-stylecontrol
         * @external
         */
        readonly styleControl?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpcontainersettings.html
     * @external
     */
    interface UdpContainerSettingsProperty {
        /**
         * `CfnChannel.UdpContainerSettingsProperty.M2tsSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpcontainersettings.html#cfn-medialive-channel-udpcontainersettings-m2tssettings
         * @external
         */
        readonly m2TsSettings?: CfnChannel.M2tsSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html
     * @external
     */
    interface UdpGroupSettingsProperty {
        /**
         * `CfnChannel.UdpGroupSettingsProperty.InputLossAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-inputlossaction
         * @external
         */
        readonly inputLossAction?: string;
        /**
         * `CfnChannel.UdpGroupSettingsProperty.TimedMetadataId3Frame`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-timedmetadataid3frame
         * @external
         */
        readonly timedMetadataId3Frame?: string;
        /**
         * `CfnChannel.UdpGroupSettingsProperty.TimedMetadataId3Period`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpgroupsettings.html#cfn-medialive-channel-udpgroupsettings-timedmetadataid3period
         * @external
         */
        readonly timedMetadataId3Period?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html
     * @external
     */
    interface UdpOutputSettingsProperty {
        /**
         * `CfnChannel.UdpOutputSettingsProperty.BufferMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-buffermsec
         * @external
         */
        readonly bufferMsec?: number;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.ContainerSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-containersettings
         * @external
         */
        readonly containerSettings?: CfnChannel.UdpContainerSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-destination
         * @external
         */
        readonly destination?: CfnChannel.OutputLocationRefProperty | cdk.IResolvable;
        /**
         * `CfnChannel.UdpOutputSettingsProperty.FecOutputSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-udpoutputsettings.html#cfn-medialive-channel-udpoutputsettings-fecoutputsettings
         * @external
         */
        readonly fecOutputSettings?: CfnChannel.FecOutputSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html
     * @external
     */
    interface VideoBlackFailoverSettingsProperty {
        /**
         * `CfnChannel.VideoBlackFailoverSettingsProperty.BlackDetectThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html#cfn-medialive-channel-videoblackfailoversettings-blackdetectthreshold
         * @external
         */
        readonly blackDetectThreshold?: number;
        /**
         * `CfnChannel.VideoBlackFailoverSettingsProperty.VideoBlackThresholdMsec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoblackfailoversettings.html#cfn-medialive-channel-videoblackfailoversettings-videoblackthresholdmsec
         * @external
         */
        readonly videoBlackThresholdMsec?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html
     * @external
     */
    interface VideoCodecSettingsProperty {
        /**
         * `CfnChannel.VideoCodecSettingsProperty.FrameCaptureSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-framecapturesettings
         * @external
         */
        readonly frameCaptureSettings?: CfnChannel.FrameCaptureSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.H264Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-h264settings
         * @external
         */
        readonly h264Settings?: CfnChannel.H264SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.H265Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-h265settings
         * @external
         */
        readonly h265Settings?: CfnChannel.H265SettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoCodecSettingsProperty.Mpeg2Settings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videocodecsettings.html#cfn-medialive-channel-videocodecsettings-mpeg2settings
         * @external
         */
        readonly mpeg2Settings?: CfnChannel.Mpeg2SettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html
     * @external
     */
    interface VideoDescriptionProperty {
        /**
         * `CfnChannel.VideoDescriptionProperty.CodecSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-codecsettings
         * @external
         */
        readonly codecSettings?: CfnChannel.VideoCodecSettingsProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoDescriptionProperty.Height`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-height
         * @external
         */
        readonly height?: number;
        /**
         * `CfnChannel.VideoDescriptionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.RespondToAfd`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-respondtoafd
         * @external
         */
        readonly respondToAfd?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.ScalingBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-scalingbehavior
         * @external
         */
        readonly scalingBehavior?: string;
        /**
         * `CfnChannel.VideoDescriptionProperty.Sharpness`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-sharpness
         * @external
         */
        readonly sharpness?: number;
        /**
         * `CfnChannel.VideoDescriptionProperty.Width`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videodescription.html#cfn-medialive-channel-videodescription-width
         * @external
         */
        readonly width?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html
     * @external
     */
    interface VideoSelectorProperty {
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspace
         * @external
         */
        readonly colorSpace?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.ColorSpaceUsage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-colorspaceusage
         * @external
         */
        readonly colorSpaceUsage?: string;
        /**
         * `CfnChannel.VideoSelectorProperty.SelectorSettings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselector.html#cfn-medialive-channel-videoselector-selectorsettings
         * @external
         */
        readonly selectorSettings?: CfnChannel.VideoSelectorSettingsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html
     * @external
     */
    interface VideoSelectorPidProperty {
        /**
         * `CfnChannel.VideoSelectorPidProperty.Pid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorpid.html#cfn-medialive-channel-videoselectorpid-pid
         * @external
         */
        readonly pid?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html
     * @external
     */
    interface VideoSelectorProgramIdProperty {
        /**
         * `CfnChannel.VideoSelectorProgramIdProperty.ProgramId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorprogramid.html#cfn-medialive-channel-videoselectorprogramid-programid
         * @external
         */
        readonly programId?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html
     * @external
     */
    interface VideoSelectorSettingsProperty {
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorPid`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorpid
         * @external
         */
        readonly videoSelectorPid?: CfnChannel.VideoSelectorPidProperty | cdk.IResolvable;
        /**
         * `CfnChannel.VideoSelectorSettingsProperty.VideoSelectorProgramId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-videoselectorsettings.html#cfn-medialive-channel-videoselectorsettings-videoselectorprogramid
         * @external
         */
        readonly videoSelectorProgramId?: CfnChannel.VideoSelectorProgramIdProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html
     * @external
     */
    interface WavSettingsProperty {
        /**
         * `CfnChannel.WavSettingsProperty.BitDepth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-bitdepth
         * @external
         */
        readonly bitDepth?: number;
        /**
         * `CfnChannel.WavSettingsProperty.CodingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-codingmode
         * @external
         */
        readonly codingMode?: string;
        /**
         * `CfnChannel.WavSettingsProperty.SampleRate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-wavsettings.html#cfn-medialive-channel-wavsettings-samplerate
         * @external
         */
        readonly sampleRate?: number;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Channel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-channel.html
 * @external
 * @cloudformationResource AWS::MediaLive::Channel
 */
export declare namespace CfnChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-webvttdestinationsettings.html
     * @external
     */
    interface WebvttDestinationSettingsProperty {
    }
}
/**
 * Properties for defining a `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 */
export interface CfnInputProps {
    /**
     * `AWS::MediaLive::Input.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     * @external
     */
    readonly destinations?: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.InputDevices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices
     * @external
     */
    readonly inputDevices?: Array<CfnInput.InputDeviceSettingsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     * @external
     */
    readonly inputSecurityGroups?: string[];
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     * @external
     */
    readonly mediaConnectFlows?: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::MediaLive::Input.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::MediaLive::Input.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     * @external
     */
    readonly sources?: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaLive::Input.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::Input.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     * @external
     */
    readonly type?: string;
    /**
     * `AWS::MediaLive::Input.Vpc`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     * @external
     */
    readonly vpc?: CfnInput.InputVpcRequestProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::Input";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInput;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Destinations
     */
    readonly attrDestinations: string[];
    /**
     * @external
     * @cloudformationAttribute Sources
     */
    readonly attrSources: string[];
    /**
     * `AWS::MediaLive::Input.Destinations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-destinations
     * @external
     */
    destinations: Array<CfnInput.InputDestinationRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.InputDevices`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputdevices
     * @external
     */
    inputDevices: Array<CfnInput.InputDeviceSettingsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.InputSecurityGroups`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-inputsecuritygroups
     * @external
     */
    inputSecurityGroups: string[] | undefined;
    /**
     * `AWS::MediaLive::Input.MediaConnectFlows`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-mediaconnectflows
     * @external
     */
    mediaConnectFlows: Array<CfnInput.MediaConnectFlowRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::MediaLive::Input.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::MediaLive::Input.Sources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-sources
     * @external
     */
    sources: Array<CfnInput.InputSourceRequestProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaLive::Input.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::Input.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-type
     * @external
     */
    type: string | undefined;
    /**
     * `AWS::MediaLive::Input.Vpc`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html#cfn-medialive-input-vpc
     * @external
     */
    vpc: CfnInput.InputVpcRequestProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::Input`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html
     * @external
     */
    interface InputDestinationRequestProperty {
        /**
         * `CfnInput.InputDestinationRequestProperty.StreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdestinationrequest.html#cfn-medialive-input-inputdestinationrequest-streamname
         * @external
         */
        readonly streamName?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicerequest.html
     * @external
     */
    interface InputDeviceRequestProperty {
        /**
         * `CfnInput.InputDeviceRequestProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicerequest.html#cfn-medialive-input-inputdevicerequest-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicesettings.html
     * @external
     */
    interface InputDeviceSettingsProperty {
        /**
         * `CfnInput.InputDeviceSettingsProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputdevicesettings.html#cfn-medialive-input-inputdevicesettings-id
         * @external
         */
        readonly id?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html
     * @external
     */
    interface InputSourceRequestProperty {
        /**
         * `CfnInput.InputSourceRequestProperty.PasswordParam`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-passwordparam
         * @external
         */
        readonly passwordParam?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-url
         * @external
         */
        readonly url?: string;
        /**
         * `CfnInput.InputSourceRequestProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputsourcerequest.html#cfn-medialive-input-inputsourcerequest-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html
     * @external
     */
    interface InputVpcRequestProperty {
        /**
         * `CfnInput.InputVpcRequestProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnInput.InputVpcRequestProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-inputvpcrequest.html#cfn-medialive-input-inputvpcrequest-subnetids
         * @external
         */
        readonly subnetIds?: string[];
    }
}
/**
 * A CloudFormation `AWS::MediaLive::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-input.html
 * @external
 * @cloudformationResource AWS::MediaLive::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html
     * @external
     */
    interface MediaConnectFlowRequestProperty {
        /**
         * `CfnInput.MediaConnectFlowRequestProperty.FlowArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-input-mediaconnectflowrequest.html#cfn-medialive-input-mediaconnectflowrequest-flowarn
         * @external
         */
        readonly flowArn?: string;
    }
}
/**
 * Properties for defining a `AWS::MediaLive::InputSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 * @external
 */
export interface CfnInputSecurityGroupProps {
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     * @external
     */
    readonly whitelistRules?: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 * @external
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 */
export declare class CfnInputSecurityGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaLive::InputSecurityGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInputSecurityGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::MediaLive::InputSecurityGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::MediaLive::InputSecurityGroup.WhitelistRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html#cfn-medialive-inputsecuritygroup-whitelistrules
     * @external
     */
    whitelistRules: Array<CfnInputSecurityGroup.InputWhitelistRuleCidrProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::MediaLive::InputSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputSecurityGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::MediaLive::InputSecurityGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-inputsecuritygroup.html
 * @external
 * @cloudformationResource AWS::MediaLive::InputSecurityGroup
 */
export declare namespace CfnInputSecurityGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html
     * @external
     */
    interface InputWhitelistRuleCidrProperty {
        /**
         * `CfnInputSecurityGroup.InputWhitelistRuleCidrProperty.Cidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-inputsecuritygroup-inputwhitelistrulecidr.html#cfn-medialive-inputsecuritygroup-inputwhitelistrulecidr-cidr
         * @external
         */
        readonly cidr?: string;
    }
}
