<a id="mypy-boto3-codedeploy"></a>

# mypy-boto3-codedeploy

[![PyPI - mypy-boto3-codedeploy](https://img.shields.io/pypi/v/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-codedeploy?color=blue)](https://pypistats.org/packages/mypy-boto3-codedeploy)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeDeploy 1.18.1](https://boto3.amazonaws.com/v1/documentation/api/1.18.1/reference/services/codedeploy.html#CodeDeploy)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-codedeploy docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codedeploy/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codedeploy](#mypy-boto3-codedeploy)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `CodeDeploy` service.

```bash
python -m pip install boto3-stubs[codedeploy]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codedeploy]` in your environment:
  `python -m pip install 'boto3-stubs[codedeploy]'`

Both type checking and auto-complete should work for `CodeDeploy` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[codedeploy]` in your environment:
  `python -m pip install 'boto3-stubs[codedeploy]'`

Both type checking and auto-complete should work for `CodeDeploy` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codedeploy]` in your environment:
  `python -m pip install 'boto3-stubs[codedeploy]'`
- Run `mypy` as usual

Type checking should work for `CodeDeploy` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codedeploy]` in your environment:
  `python -m pip install 'boto3-stubs[codedeploy]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeDeploy` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`CodeDeployClient` provides annotations for `boto3.client("codedeploy")`.

```python
import boto3

from mypy_boto3_codedeploy import CodeDeployClient

client: CodeDeployClient = boto3.client("codedeploy")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeDeployClient = session.client("codedeploy")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_codedeploy.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_codedeploy import CodeDeployClient
from mypy_boto3_codedeploy.paginator import (
    ListApplicationRevisionsPaginator,
    ListApplicationsPaginator,
    ListDeploymentConfigsPaginator,
    ListDeploymentGroupsPaginator,
    ListDeploymentInstancesPaginator,
    ListDeploymentTargetsPaginator,
    ListDeploymentsPaginator,
    ListGitHubAccountTokenNamesPaginator,
    ListOnPremisesInstancesPaginator,
)

client: CodeDeployClient = boto3.client("codedeploy")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_application_revisions_paginator: ListApplicationRevisionsPaginator = client.get_paginator("list_application_revisions")
list_applications_paginator: ListApplicationsPaginator = client.get_paginator("list_applications")
list_deployment_configs_paginator: ListDeploymentConfigsPaginator = client.get_paginator("list_deployment_configs")
list_deployment_groups_paginator: ListDeploymentGroupsPaginator = client.get_paginator("list_deployment_groups")
list_deployment_instances_paginator: ListDeploymentInstancesPaginator = client.get_paginator("list_deployment_instances")
list_deployment_targets_paginator: ListDeploymentTargetsPaginator = client.get_paginator("list_deployment_targets")
list_deployments_paginator: ListDeploymentsPaginator = client.get_paginator("list_deployments")
list_git_hub_account_token_names_paginator: ListGitHubAccountTokenNamesPaginator = client.get_paginator("list_git_hub_account_token_names")
list_on_premises_instances_paginator: ListOnPremisesInstancesPaginator = client.get_paginator("list_on_premises_instances")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_codedeploy.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_codedeploy import CodeDeployClient
from mypy_boto3_codedeploy.waiter import (
    DeploymentSuccessfulWaiter,
)

client: CodeDeployClient = boto3.client("codedeploy")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
deployment_successful_waiter: DeploymentSuccessfulWaiter = client.get_waiter("deployment_successful")
```

<a id="literals"></a>

### Literals

`mypy_boto3_codedeploy.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_codedeploy.literals import (
    ApplicationRevisionSortByType,
    AutoRollbackEventType,
    BundleTypeType,
    ComputePlatformType,
    DeploymentCreatorType,
    DeploymentOptionType,
    DeploymentReadyActionType,
    DeploymentStatusType,
    DeploymentSuccessfulWaiterName,
    DeploymentTargetTypeType,
    DeploymentTypeType,
    DeploymentWaitTypeType,
    EC2TagFilterTypeType,
    ErrorCodeType,
    FileExistsBehaviorType,
    GreenFleetProvisioningActionType,
    InstanceActionType,
    InstanceStatusType,
    InstanceTypeType,
    LifecycleErrorCodeType,
    LifecycleEventStatusType,
    ListApplicationRevisionsPaginatorName,
    ListApplicationsPaginatorName,
    ListDeploymentConfigsPaginatorName,
    ListDeploymentGroupsPaginatorName,
    ListDeploymentInstancesPaginatorName,
    ListDeploymentTargetsPaginatorName,
    ListDeploymentsPaginatorName,
    ListGitHubAccountTokenNamesPaginatorName,
    ListOnPremisesInstancesPaginatorName,
    ListStateFilterActionType,
    MinimumHealthyHostsTypeType,
    OutdatedInstancesStrategyType,
    RegistrationStatusType,
    RevisionLocationTypeType,
    SortOrderType,
    StopStatusType,
    TagFilterTypeType,
    TargetFilterNameType,
    TargetLabelType,
    TargetStatusType,
    TrafficRoutingTypeType,
    TriggerEventTypeType,
)

def check_value(value: ApplicationRevisionSortByType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_codedeploy.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_codedeploy.type_defs import (
    AddTagsToOnPremisesInstancesInputRequestTypeDef,
    AlarmConfigurationTypeDef,
    AlarmTypeDef,
    AppSpecContentTypeDef,
    ApplicationInfoTypeDef,
    AutoRollbackConfigurationTypeDef,
    AutoScalingGroupTypeDef,
    BatchGetApplicationRevisionsInputRequestTypeDef,
    BatchGetApplicationRevisionsOutputTypeDef,
    BatchGetApplicationsInputRequestTypeDef,
    BatchGetApplicationsOutputTypeDef,
    BatchGetDeploymentGroupsInputRequestTypeDef,
    BatchGetDeploymentGroupsOutputTypeDef,
    BatchGetDeploymentInstancesInputRequestTypeDef,
    BatchGetDeploymentInstancesOutputTypeDef,
    BatchGetDeploymentTargetsInputRequestTypeDef,
    BatchGetDeploymentTargetsOutputTypeDef,
    BatchGetDeploymentsInputRequestTypeDef,
    BatchGetDeploymentsOutputTypeDef,
    BatchGetOnPremisesInstancesInputRequestTypeDef,
    BatchGetOnPremisesInstancesOutputTypeDef,
    BlueGreenDeploymentConfigurationTypeDef,
    BlueInstanceTerminationOptionTypeDef,
    CloudFormationTargetTypeDef,
    ContinueDeploymentInputRequestTypeDef,
    CreateApplicationInputRequestTypeDef,
    CreateApplicationOutputTypeDef,
    CreateDeploymentConfigInputRequestTypeDef,
    CreateDeploymentConfigOutputTypeDef,
    CreateDeploymentGroupInputRequestTypeDef,
    CreateDeploymentGroupOutputTypeDef,
    CreateDeploymentInputRequestTypeDef,
    CreateDeploymentOutputTypeDef,
    DeleteApplicationInputRequestTypeDef,
    DeleteDeploymentConfigInputRequestTypeDef,
    DeleteDeploymentGroupInputRequestTypeDef,
    DeleteDeploymentGroupOutputTypeDef,
    DeleteGitHubAccountTokenInputRequestTypeDef,
    DeleteGitHubAccountTokenOutputTypeDef,
    DeleteResourcesByExternalIdInputRequestTypeDef,
    DeploymentConfigInfoTypeDef,
    DeploymentGroupInfoTypeDef,
    DeploymentInfoTypeDef,
    DeploymentOverviewTypeDef,
    DeploymentReadyOptionTypeDef,
    DeploymentStyleTypeDef,
    DeploymentTargetTypeDef,
    DeregisterOnPremisesInstanceInputRequestTypeDef,
    DiagnosticsTypeDef,
    EC2TagFilterTypeDef,
    EC2TagSetTypeDef,
    ECSServiceTypeDef,
    ECSTargetTypeDef,
    ECSTaskSetTypeDef,
    ELBInfoTypeDef,
    ErrorInformationTypeDef,
    GenericRevisionInfoTypeDef,
    GetApplicationInputRequestTypeDef,
    GetApplicationOutputTypeDef,
    GetApplicationRevisionInputRequestTypeDef,
    GetApplicationRevisionOutputTypeDef,
    GetDeploymentConfigInputRequestTypeDef,
    GetDeploymentConfigOutputTypeDef,
    GetDeploymentGroupInputRequestTypeDef,
    GetDeploymentGroupOutputTypeDef,
    GetDeploymentInputRequestTypeDef,
    GetDeploymentInstanceInputRequestTypeDef,
    GetDeploymentInstanceOutputTypeDef,
    GetDeploymentOutputTypeDef,
    GetDeploymentTargetInputRequestTypeDef,
    GetDeploymentTargetOutputTypeDef,
    GetOnPremisesInstanceInputRequestTypeDef,
    GetOnPremisesInstanceOutputTypeDef,
    GitHubLocationTypeDef,
    GreenFleetProvisioningOptionTypeDef,
    InstanceInfoTypeDef,
    InstanceSummaryTypeDef,
    InstanceTargetTypeDef,
    LambdaFunctionInfoTypeDef,
    LambdaTargetTypeDef,
    LastDeploymentInfoTypeDef,
    LifecycleEventTypeDef,
    ListApplicationRevisionsInputRequestTypeDef,
    ListApplicationRevisionsOutputTypeDef,
    ListApplicationsInputRequestTypeDef,
    ListApplicationsOutputTypeDef,
    ListDeploymentConfigsInputRequestTypeDef,
    ListDeploymentConfigsOutputTypeDef,
    ListDeploymentGroupsInputRequestTypeDef,
    ListDeploymentGroupsOutputTypeDef,
    ListDeploymentInstancesInputRequestTypeDef,
    ListDeploymentInstancesOutputTypeDef,
    ListDeploymentTargetsInputRequestTypeDef,
    ListDeploymentTargetsOutputTypeDef,
    ListDeploymentsInputRequestTypeDef,
    ListDeploymentsOutputTypeDef,
    ListGitHubAccountTokenNamesInputRequestTypeDef,
    ListGitHubAccountTokenNamesOutputTypeDef,
    ListOnPremisesInstancesInputRequestTypeDef,
    ListOnPremisesInstancesOutputTypeDef,
    ListTagsForResourceInputRequestTypeDef,
    ListTagsForResourceOutputTypeDef,
    LoadBalancerInfoTypeDef,
    MinimumHealthyHostsTypeDef,
    OnPremisesTagSetTypeDef,
    PaginatorConfigTypeDef,
    PutLifecycleEventHookExecutionStatusInputRequestTypeDef,
    PutLifecycleEventHookExecutionStatusOutputTypeDef,
    RawStringTypeDef,
    RegisterApplicationRevisionInputRequestTypeDef,
    RegisterOnPremisesInstanceInputRequestTypeDef,
    RelatedDeploymentsTypeDef,
    RemoveTagsFromOnPremisesInstancesInputRequestTypeDef,
    ResponseMetadataTypeDef,
    RevisionInfoTypeDef,
    RevisionLocationTypeDef,
    RollbackInfoTypeDef,
    S3LocationTypeDef,
    SkipWaitTimeForInstanceTerminationInputRequestTypeDef,
    StopDeploymentInputRequestTypeDef,
    StopDeploymentOutputTypeDef,
    TagFilterTypeDef,
    TagResourceInputRequestTypeDef,
    TagTypeDef,
    TargetGroupInfoTypeDef,
    TargetGroupPairInfoTypeDef,
    TargetInstancesTypeDef,
    TimeBasedCanaryTypeDef,
    TimeBasedLinearTypeDef,
    TimeRangeTypeDef,
    TrafficRouteTypeDef,
    TrafficRoutingConfigTypeDef,
    TriggerConfigTypeDef,
    UntagResourceInputRequestTypeDef,
    UpdateApplicationInputRequestTypeDef,
    UpdateDeploymentGroupInputRequestTypeDef,
    UpdateDeploymentGroupOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddTagsToOnPremisesInstancesInputRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-codedeploy` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-codedeploy docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codedeploy/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
