import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/r/resource#triggers Resource#triggers}
    */
    readonly triggers?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/null/r/resource null_resource}
*/
export declare class Resource extends cdktf.TerraformResource {
    static readonly tfResourceType = "null_resource";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/null/r/resource null_resource} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: ResourceConfig);
    get id(): string;
    private _triggers?;
    get triggers(): {
        [key: string]: string;
    };
    set triggers(value: {
        [key: string]: string;
    });
    resetTriggers(): void;
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
