# AI Excelsior - A Bayesian Optimization Service

本接口是由`AI Excelsior`元学习引擎提供的远程异步自适应优化接口， 通过http请求帮助用户对其私有环境运行的机器学习模型、模拟器、 量化交易策略等实例进行参数/超参数的自动优化。在保证用户数据、 算法与实例私密性的同时，为用户提供高效的自适应优化服务。

我们为本接口提供两种服务模式：

* `RESTful`服务，其请求地址是: `http://207.246.97.250:7200`
* 图形用户界面：`http://207.246.97.250:3838` (请留意端口号的不同)

在如下的文档中，我们使用任务ID`CPbdA72Xv2outVk`作为例子展示`RESTful`接口，此ID应当被替换为用户在实际操作中所得到的任务ID。对于图形用户界面，用户只需阅读**创建搜索空间**一节来了解如何定制搜索任务。


## 创建搜索空间

向`http://207.246.97.250:7200`发出HTTP POST请求，其附带`JSON`数据字段, 例如:

```json
{
    "search_param" : {
        "continuous" : {          // 参数名称，用户可以自定义
            "type" : "r",         // 参数类型，共分为“r”实数型，“i”整数型，及“c”离散型
            "range" : [-5, 5],    // 该参数的取值范围
            "N" : 2,              // 类型、范围相同的参数个数
            "precison" : 2        // 该参数数值精度，其指示小数点后的位数
        },

        "ordinal" : {
            "type" : "i",
            "range" : [-100, 100],
            "N" : 1
        },

        "nominal" : {
            "type" : "c",
            "range" : ["OK", "A", "B", "C", "D", "E"],
            "N" : 1
        }
    },

    "bo_param" : {
        "n_job" : 3,              // 服务器上并行进程数
        "n_point" : 3,            // 每次迭代返回参数值个数
        "max_iter" : 20,          // 最大迭代次数
        "DoE_size" : 3,           // 初始(第一代)采样点个数，其一般与`n_point`相等
        "minimize" : true,        // 最大化目标值(false)，最小化目标值(true)
        "n_obj": 1                // 目标个数，当前版本仅支持单目标
    }
}
```

当新的优化任务工程创建后，服务器会通过如下的`JSON`回执返回任务ID

```json
{"job_id" : "CPbdA72Xv2outVk"}
```

在之后的请求中，用户将使用所返回的`job_id`.

## 请求一组新的解

发出`HTTP GET`请求:`http://207.246.97.250:7200?ask='null'&job_id=0r8FwcNmnXzRrPB`。
服务器会通过一个`JSON`数据字段来返回这组被请求的解，例如:

```json
{
    "job_id" : "CPbdA72Xv2outVk",
    "X" : [
        {    // 第一组参数
            'continuous_0' : 0.0,
            'continuous_1' : -3.33,
            ...
        },
        {   // 第二组参数
            'continuous_0' : 1.2,
            'continuous_1' : 3.33,
            ...
        }
    ]
}
```

## 将目标值提交至服务器

用户需执行在上一步中得到的这组解，并将运行后所得到的目标值加入到这个字段中，例如:

```json
{
    "job_id" : "CPbdA72Xv2outVk",   // 使用对应的任务 ID
    "X" : [
        ...                         // 上一步取回的解
    ],
    "y" : [10.0, 1.23, 13.33,...]   // 与这组参数对应的目标值
}
```

在这之后我们就可以向`http://207.246.97.250:7200`发出`HTTP POST`请求, 并附上这个`JSON`字段

## 终止一个任务

当用户不再想继续使用当前优化任务，或者需要创建新的优化任务时，该用户需要终止当前的优化任务，这可通过以下`HTTP GET`请求实现:
`http://207.246.97.250:7200?finalize='null'&job_id=CPbdA72Xv2outVk`