#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['sxm_player', 'sxm_player.debug', 'sxm_player.players', 'sxm_player.workers']

package_data = \
{'': ['*']}

install_requires = \
['coloredlogs',
 'httpx',
 'ipython',
 'psutil',
 'pydantic',
 'pyyaml',
 'sqlalchemy',
 'sxm>=0.2.7',
 'typer']

extras_require = \
{'dev': ['bandit',
         'black',
         'flake8-bugbear',
         'flake8-builtins',
         'flake8-commas',
         'flake8-comprehensions',
         'flake8',
         'flit',
         'isort',
         'mypy',
         'pip-tools',
         'pylint',
         'pyproject-flake8',
         'rstcheck',
         'sqlalchemy-stubs',
         'types-click',
         'types-psutil',
         'types-PyYAML',
         'typing-extensions~=3.7.4.1'],
 'doc': ['furo', 'snooty-lextudio', 'sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-socket',
          'pytest-sugar',
          'pytest-clarity',
          'tox',
          'coverage']}

entry_points = \
{'console_scripts': ['sxm-player = sxm_player.__main__:start']}

setup(name='sxm_player',
      version='0.2.4',
      description='Top-level package for sxm-player.',
      author='Christopher Bailey',
      author_email='cbailey@mort.is',
      url='https://github.com/AngellusMortis/sxm-player',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
