"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetType = exports.SslPolicy = exports.ApplicationProtocolVersion = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer.
 *
 * @stability stable
 */
var IpAddressType;
(function (IpAddressType) {
    IpAddressType["IPV4"] = "ipv4";
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks.
 *
 * @stability stable
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "HTTP";
    Protocol["HTTPS"] = "HTTPS";
    Protocol["TCP"] = "TCP";
    Protocol["TLS"] = "TLS";
    Protocol["UDP"] = "UDP";
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    ApplicationProtocol["HTTP"] = "HTTP";
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Load balancing protocol version for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocolVersion;
(function (ApplicationProtocolVersion) {
    ApplicationProtocolVersion["GRPC"] = "GRPC";
    ApplicationProtocolVersion["HTTP1"] = "HTTP1";
    ApplicationProtocolVersion["HTTP2"] = "HTTP2";
})(ApplicationProtocolVersion = exports.ApplicationProtocolVersion || (exports.ApplicationProtocolVersion = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @stability stable
 */
var SslPolicy;
(function (SslPolicy) {
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    SslPolicy["FORWARD_SECRECY_TLS12_RES_GCM"] = "ELBSecurityPolicy-FS-1-2-Res-2020-10";
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers.
 *
 * @stability stable
 */
var TargetType;
(function (TargetType) {
    TargetType["INSTANCE"] = "instance";
    TargetType["IP"] = "ip";
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
//# sourceMappingURL=data:application/json;base64,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