"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetGroupLoadBalancingAlgorithmType = exports.AlpnPolicy = exports.TargetType = exports.SslPolicy = exports.ApplicationProtocolVersion = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer.
 *
 * @stability stable
 */
var IpAddressType;
(function (IpAddressType) {
    IpAddressType["IPV4"] = "ipv4";
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks.
 *
 * @stability stable
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "HTTP";
    Protocol["HTTPS"] = "HTTPS";
    Protocol["TCP"] = "TCP";
    Protocol["TLS"] = "TLS";
    Protocol["UDP"] = "UDP";
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    ApplicationProtocol["HTTP"] = "HTTP";
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Load balancing protocol version for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocolVersion;
(function (ApplicationProtocolVersion) {
    ApplicationProtocolVersion["GRPC"] = "GRPC";
    ApplicationProtocolVersion["HTTP1"] = "HTTP1";
    ApplicationProtocolVersion["HTTP2"] = "HTTP2";
})(ApplicationProtocolVersion = exports.ApplicationProtocolVersion || (exports.ApplicationProtocolVersion = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @stability stable
 */
var SslPolicy;
(function (SslPolicy) {
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    SslPolicy["FORWARD_SECRECY_TLS12_RES_GCM"] = "ELBSecurityPolicy-FS-1-2-Res-2020-10";
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers.
 *
 * @stability stable
 */
var TargetType;
(function (TargetType) {
    TargetType["INSTANCE"] = "instance";
    TargetType["IP"] = "ip";
    TargetType["LAMBDA"] = "lambda";
    TargetType["ALB"] = "alb";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
/**
 * Application-Layer Protocol Negotiation Policies for network load balancers.
 *
 * Which protocols should be used over a secure connection.
 *
 * @stability stable
 */
var AlpnPolicy;
(function (AlpnPolicy) {
    AlpnPolicy["HTTP1_ONLY"] = "HTTP1Only";
    AlpnPolicy["HTTP2_ONLY"] = "HTTP2Only";
    AlpnPolicy["HTTP2_OPTIONAL"] = "HTTP2Optional";
    AlpnPolicy["HTTP2_PREFERRED"] = "HTTP2Preferred";
    AlpnPolicy["NONE"] = "None";
})(AlpnPolicy = exports.AlpnPolicy || (exports.AlpnPolicy = {}));
/**
 * Load balancing algorithmm type for target groups.
 *
 * @stability stable
 */
var TargetGroupLoadBalancingAlgorithmType;
(function (TargetGroupLoadBalancingAlgorithmType) {
    TargetGroupLoadBalancingAlgorithmType["ROUND_ROBIN"] = "round_robin";
    TargetGroupLoadBalancingAlgorithmType["LEAST_OUTSTANDING_REQUESTS"] = "least_outstanding_requests";
})(TargetGroupLoadBalancingAlgorithmType = exports.TargetGroupLoadBalancingAlgorithmType || (exports.TargetGroupLoadBalancingAlgorithmType = {}));
//# sourceMappingURL=data:application/json;base64,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